/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.VariableValueDto;

public class CompleteTaskDto {
    public static final String SERIALIZED_NAME_VARIABLES = "variables";
    @SerializedName(value="variables")
    private Map<String, VariableValueDto> variables = null;
    public static final String SERIALIZED_NAME_WITH_VARIABLES_IN_RETURN = "withVariablesInReturn";
    @SerializedName(value="withVariablesInReturn")
    private Boolean withVariablesInReturn = false;

    public CompleteTaskDto variables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
        return this;
    }

    public CompleteTaskDto putVariablesItem(String key, VariableValueDto variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, VariableValueDto>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON object containing variable key-value pairs.")
    public Map<String, VariableValueDto> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
    }

    public CompleteTaskDto withVariablesInReturn(Boolean withVariablesInReturn) {
        this.withVariablesInReturn = withVariablesInReturn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the response should contain the process variables or not. The default is `false` with a response code of `204`. If set to `true` the response contains the process variables and has a response code of `200`. If the task is not associated with a process instance (e.g. if it's part of a case instance) no variables will be returned.")
    public Boolean getWithVariablesInReturn() {
        return this.withVariablesInReturn;
    }

    public void setWithVariablesInReturn(Boolean withVariablesInReturn) {
        this.withVariablesInReturn = withVariablesInReturn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompleteTaskDto completeTaskDto = (CompleteTaskDto)o;
        return Objects.equals(this.variables, completeTaskDto.variables) && Objects.equals(this.withVariablesInReturn, completeTaskDto.withVariablesInReturn);
    }

    public int hashCode() {
        return Objects.hash(this.variables, this.withVariablesInReturn);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompleteTaskDto {\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    withVariablesInReturn: ").append(this.toIndentedString(this.withVariablesInReturn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

