/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.CreateIncidentDto;
import org.camunda.community.rest.client.dto.EventSubscriptionDto;
import org.camunda.community.rest.client.dto.ExecutionDto;
import org.camunda.community.rest.client.dto.ExecutionQueryDto;
import org.camunda.community.rest.client.dto.ExecutionTriggerDto;
import org.camunda.community.rest.client.dto.IncidentDto;
import org.camunda.community.rest.client.dto.PatchVariablesDto;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class ExecutionApi {
    private ApiClient localVarApiClient;

    public ExecutionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExecutionApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createIncidentCall(String id, CreateIncidentDto createIncidentDto, ApiCallback _callback) throws ApiException {
        CreateIncidentDto localVarPostBody = createIncidentDto;
        String localVarPath = "/execution/{id}/create-incident".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createIncidentValidateBeforeCall(String id, CreateIncidentDto createIncidentDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling createIncident(Async)");
        }
        Call localVarCall = this.createIncidentCall(id, createIncidentDto, _callback);
        return localVarCall;
    }

    public IncidentDto createIncident(String id, CreateIncidentDto createIncidentDto) throws ApiException {
        ApiResponse<IncidentDto> localVarResp = this.createIncidentWithHttpInfo(id, createIncidentDto);
        return localVarResp.getData();
    }

    public ApiResponse<IncidentDto> createIncidentWithHttpInfo(String id, CreateIncidentDto createIncidentDto) throws ApiException {
        Call localVarCall = this.createIncidentValidateBeforeCall(id, createIncidentDto, null);
        Type localVarReturnType = new TypeToken<IncidentDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createIncidentAsync(String id, CreateIncidentDto createIncidentDto, ApiCallback<IncidentDto> _callback) throws ApiException {
        Call localVarCall = this.createIncidentValidateBeforeCall(id, createIncidentDto, _callback);
        Type localVarReturnType = new TypeToken<IncidentDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteLocalExecutionVariableCall(String id, String varName, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/execution/{id}/localVariables/{varName}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.localVarApiClient.escapeString(varName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteLocalExecutionVariableValidateBeforeCall(String id, String varName, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteLocalExecutionVariable(Async)");
        }
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling deleteLocalExecutionVariable(Async)");
        }
        Call localVarCall = this.deleteLocalExecutionVariableCall(id, varName, _callback);
        return localVarCall;
    }

    public void deleteLocalExecutionVariable(String id, String varName) throws ApiException {
        this.deleteLocalExecutionVariableWithHttpInfo(id, varName);
    }

    public ApiResponse<Void> deleteLocalExecutionVariableWithHttpInfo(String id, String varName) throws ApiException {
        Call localVarCall = this.deleteLocalExecutionVariableValidateBeforeCall(id, varName, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteLocalExecutionVariableAsync(String id, String varName, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteLocalExecutionVariableValidateBeforeCall(id, varName, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getExecutionCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/execution/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExecutionValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getExecution(Async)");
        }
        Call localVarCall = this.getExecutionCall(id, _callback);
        return localVarCall;
    }

    public ExecutionDto getExecution(String id) throws ApiException {
        ApiResponse<ExecutionDto> localVarResp = this.getExecutionWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<ExecutionDto> getExecutionWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getExecutionValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ExecutionDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExecutionAsync(String id, ApiCallback<ExecutionDto> _callback) throws ApiException {
        Call localVarCall = this.getExecutionValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ExecutionDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExecutionsCall(String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String activityId, String signalEventSubscriptionName, String messageEventSubscriptionName, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, String variables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/execution";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (businessKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("businessKey", businessKey));
        }
        if (processDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }
        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }
        if (processInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }
        if (activityId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activityId", activityId));
        }
        if (signalEventSubscriptionName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("signalEventSubscriptionName", signalEventSubscriptionName));
        }
        if (messageEventSubscriptionName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("messageEventSubscriptionName", messageEventSubscriptionName));
        }
        if (active != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("active", active));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if (incidentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentId", incidentId));
        }
        if (incidentType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentType", incidentType));
        }
        if (incidentMessage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }
        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (variables != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variables", variables));
        }
        if (processVariables != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processVariables", processVariables));
        }
        if (variableNamesIgnoreCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        }
        if (variableValuesIgnoreCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExecutionsValidateBeforeCall(String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String activityId, String signalEventSubscriptionName, String messageEventSubscriptionName, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, String variables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getExecutionsCall(businessKey, processDefinitionId, processDefinitionKey, processInstanceId, activityId, signalEventSubscriptionName, messageEventSubscriptionName, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, variables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;
    }

    public List<ExecutionDto> getExecutions(String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String activityId, String signalEventSubscriptionName, String messageEventSubscriptionName, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, String variables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<ExecutionDto>> localVarResp = this.getExecutionsWithHttpInfo(businessKey, processDefinitionId, processDefinitionKey, processInstanceId, activityId, signalEventSubscriptionName, messageEventSubscriptionName, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, variables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    public ApiResponse<List<ExecutionDto>> getExecutionsWithHttpInfo(String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String activityId, String signalEventSubscriptionName, String messageEventSubscriptionName, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, String variables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        Call localVarCall = this.getExecutionsValidateBeforeCall(businessKey, processDefinitionId, processDefinitionKey, processInstanceId, activityId, signalEventSubscriptionName, messageEventSubscriptionName, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, variables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<ExecutionDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExecutionsAsync(String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String activityId, String signalEventSubscriptionName, String messageEventSubscriptionName, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, String variables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback<List<ExecutionDto>> _callback) throws ApiException {
        Call localVarCall = this.getExecutionsValidateBeforeCall(businessKey, processDefinitionId, processDefinitionKey, processInstanceId, activityId, signalEventSubscriptionName, messageEventSubscriptionName, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, variables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<ExecutionDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExecutionsCountCall(String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String activityId, String signalEventSubscriptionName, String messageEventSubscriptionName, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, String variables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/execution/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (businessKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("businessKey", businessKey));
        }
        if (processDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }
        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }
        if (processInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }
        if (activityId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activityId", activityId));
        }
        if (signalEventSubscriptionName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("signalEventSubscriptionName", signalEventSubscriptionName));
        }
        if (messageEventSubscriptionName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("messageEventSubscriptionName", messageEventSubscriptionName));
        }
        if (active != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("active", active));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if (incidentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentId", incidentId));
        }
        if (incidentType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentType", incidentType));
        }
        if (incidentMessage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }
        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (variables != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variables", variables));
        }
        if (processVariables != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processVariables", processVariables));
        }
        if (variableNamesIgnoreCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        }
        if (variableValuesIgnoreCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExecutionsCountValidateBeforeCall(String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String activityId, String signalEventSubscriptionName, String messageEventSubscriptionName, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, String variables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getExecutionsCountCall(businessKey, processDefinitionId, processDefinitionKey, processInstanceId, activityId, signalEventSubscriptionName, messageEventSubscriptionName, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, variables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, _callback);
        return localVarCall;
    }

    public CountResultDto getExecutionsCount(String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String activityId, String signalEventSubscriptionName, String messageEventSubscriptionName, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, String variables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getExecutionsCountWithHttpInfo(businessKey, processDefinitionId, processDefinitionKey, processInstanceId, activityId, signalEventSubscriptionName, messageEventSubscriptionName, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, variables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getExecutionsCountWithHttpInfo(String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String activityId, String signalEventSubscriptionName, String messageEventSubscriptionName, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, String variables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        Call localVarCall = this.getExecutionsCountValidateBeforeCall(businessKey, processDefinitionId, processDefinitionKey, processInstanceId, activityId, signalEventSubscriptionName, messageEventSubscriptionName, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, variables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExecutionsCountAsync(String businessKey, String processDefinitionId, String processDefinitionKey, String processInstanceId, String activityId, String signalEventSubscriptionName, String messageEventSubscriptionName, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, String variables, String processVariables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getExecutionsCountValidateBeforeCall(businessKey, processDefinitionId, processDefinitionKey, processInstanceId, activityId, signalEventSubscriptionName, messageEventSubscriptionName, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, variables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getLocalExecutionVariableCall(String id, String varName, Boolean deserializeValue, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/execution/{id}/localVariables/{varName}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.localVarApiClient.escapeString(varName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (deserializeValue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deserializeValue", deserializeValue));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLocalExecutionVariableValidateBeforeCall(String id, String varName, Boolean deserializeValue, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getLocalExecutionVariable(Async)");
        }
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling getLocalExecutionVariable(Async)");
        }
        Call localVarCall = this.getLocalExecutionVariableCall(id, varName, deserializeValue, _callback);
        return localVarCall;
    }

    public VariableValueDto getLocalExecutionVariable(String id, String varName, Boolean deserializeValue) throws ApiException {
        ApiResponse<VariableValueDto> localVarResp = this.getLocalExecutionVariableWithHttpInfo(id, varName, deserializeValue);
        return localVarResp.getData();
    }

    public ApiResponse<VariableValueDto> getLocalExecutionVariableWithHttpInfo(String id, String varName, Boolean deserializeValue) throws ApiException {
        Call localVarCall = this.getLocalExecutionVariableValidateBeforeCall(id, varName, deserializeValue, null);
        Type localVarReturnType = new TypeToken<VariableValueDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLocalExecutionVariableAsync(String id, String varName, Boolean deserializeValue, ApiCallback<VariableValueDto> _callback) throws ApiException {
        Call localVarCall = this.getLocalExecutionVariableValidateBeforeCall(id, varName, deserializeValue, _callback);
        Type localVarReturnType = new TypeToken<VariableValueDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getLocalExecutionVariableBinaryCall(String id, String varName, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/execution/{id}/localVariables/{varName}/data".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.localVarApiClient.escapeString(varName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream", "text/plain", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLocalExecutionVariableBinaryValidateBeforeCall(String id, String varName, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getLocalExecutionVariableBinary(Async)");
        }
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling getLocalExecutionVariableBinary(Async)");
        }
        Call localVarCall = this.getLocalExecutionVariableBinaryCall(id, varName, _callback);
        return localVarCall;
    }

    public File getLocalExecutionVariableBinary(String id, String varName) throws ApiException {
        ApiResponse<File> localVarResp = this.getLocalExecutionVariableBinaryWithHttpInfo(id, varName);
        return localVarResp.getData();
    }

    public ApiResponse<File> getLocalExecutionVariableBinaryWithHttpInfo(String id, String varName) throws ApiException {
        Call localVarCall = this.getLocalExecutionVariableBinaryValidateBeforeCall(id, varName, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLocalExecutionVariableBinaryAsync(String id, String varName, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getLocalExecutionVariableBinaryValidateBeforeCall(id, varName, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getLocalExecutionVariablesCall(String id, Boolean deserializeValues, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/execution/{id}/localVariables".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (deserializeValues != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deserializeValues", deserializeValues));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLocalExecutionVariablesValidateBeforeCall(String id, Boolean deserializeValues, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getLocalExecutionVariables(Async)");
        }
        Call localVarCall = this.getLocalExecutionVariablesCall(id, deserializeValues, _callback);
        return localVarCall;
    }

    public Map<String, VariableValueDto> getLocalExecutionVariables(String id, Boolean deserializeValues) throws ApiException {
        ApiResponse<Map<String, VariableValueDto>> localVarResp = this.getLocalExecutionVariablesWithHttpInfo(id, deserializeValues);
        return localVarResp.getData();
    }

    public ApiResponse<Map<String, VariableValueDto>> getLocalExecutionVariablesWithHttpInfo(String id, Boolean deserializeValues) throws ApiException {
        Call localVarCall = this.getLocalExecutionVariablesValidateBeforeCall(id, deserializeValues, null);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLocalExecutionVariablesAsync(String id, Boolean deserializeValues, ApiCallback<Map<String, VariableValueDto>> _callback) throws ApiException {
        Call localVarCall = this.getLocalExecutionVariablesValidateBeforeCall(id, deserializeValues, _callback);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMessageEventSubscriptionCall(String id, String messageName, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/execution/{id}/messageSubscriptions/{messageName}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{messageName\\}", this.localVarApiClient.escapeString(messageName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMessageEventSubscriptionValidateBeforeCall(String id, String messageName, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getMessageEventSubscription(Async)");
        }
        if (messageName == null) {
            throw new ApiException("Missing the required parameter 'messageName' when calling getMessageEventSubscription(Async)");
        }
        Call localVarCall = this.getMessageEventSubscriptionCall(id, messageName, _callback);
        return localVarCall;
    }

    public EventSubscriptionDto getMessageEventSubscription(String id, String messageName) throws ApiException {
        ApiResponse<EventSubscriptionDto> localVarResp = this.getMessageEventSubscriptionWithHttpInfo(id, messageName);
        return localVarResp.getData();
    }

    public ApiResponse<EventSubscriptionDto> getMessageEventSubscriptionWithHttpInfo(String id, String messageName) throws ApiException {
        Call localVarCall = this.getMessageEventSubscriptionValidateBeforeCall(id, messageName, null);
        Type localVarReturnType = new TypeToken<EventSubscriptionDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMessageEventSubscriptionAsync(String id, String messageName, ApiCallback<EventSubscriptionDto> _callback) throws ApiException {
        Call localVarCall = this.getMessageEventSubscriptionValidateBeforeCall(id, messageName, _callback);
        Type localVarReturnType = new TypeToken<EventSubscriptionDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call modifyLocalExecutionVariablesCall(String id, PatchVariablesDto patchVariablesDto, ApiCallback _callback) throws ApiException {
        PatchVariablesDto localVarPostBody = patchVariablesDto;
        String localVarPath = "/execution/{id}/localVariables".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call modifyLocalExecutionVariablesValidateBeforeCall(String id, PatchVariablesDto patchVariablesDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling modifyLocalExecutionVariables(Async)");
        }
        Call localVarCall = this.modifyLocalExecutionVariablesCall(id, patchVariablesDto, _callback);
        return localVarCall;
    }

    public void modifyLocalExecutionVariables(String id, PatchVariablesDto patchVariablesDto) throws ApiException {
        this.modifyLocalExecutionVariablesWithHttpInfo(id, patchVariablesDto);
    }

    public ApiResponse<Void> modifyLocalExecutionVariablesWithHttpInfo(String id, PatchVariablesDto patchVariablesDto) throws ApiException {
        Call localVarCall = this.modifyLocalExecutionVariablesValidateBeforeCall(id, patchVariablesDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call modifyLocalExecutionVariablesAsync(String id, PatchVariablesDto patchVariablesDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.modifyLocalExecutionVariablesValidateBeforeCall(id, patchVariablesDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call putLocalExecutionVariableCall(String id, String varName, VariableValueDto variableValueDto, ApiCallback _callback) throws ApiException {
        VariableValueDto localVarPostBody = variableValueDto;
        String localVarPath = "/execution/{id}/localVariables/{varName}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.localVarApiClient.escapeString(varName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call putLocalExecutionVariableValidateBeforeCall(String id, String varName, VariableValueDto variableValueDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling putLocalExecutionVariable(Async)");
        }
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling putLocalExecutionVariable(Async)");
        }
        Call localVarCall = this.putLocalExecutionVariableCall(id, varName, variableValueDto, _callback);
        return localVarCall;
    }

    public void putLocalExecutionVariable(String id, String varName, VariableValueDto variableValueDto) throws ApiException {
        this.putLocalExecutionVariableWithHttpInfo(id, varName, variableValueDto);
    }

    public ApiResponse<Void> putLocalExecutionVariableWithHttpInfo(String id, String varName, VariableValueDto variableValueDto) throws ApiException {
        Call localVarCall = this.putLocalExecutionVariableValidateBeforeCall(id, varName, variableValueDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call putLocalExecutionVariableAsync(String id, String varName, VariableValueDto variableValueDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.putLocalExecutionVariableValidateBeforeCall(id, varName, variableValueDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call queryExecutionsCall(Integer firstResult, Integer maxResults, ExecutionQueryDto executionQueryDto, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        ExecutionQueryDto localVarPostBody = executionQueryDto;
        String localVarPath = "/execution";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryExecutionsValidateBeforeCall(Integer firstResult, Integer maxResults, ExecutionQueryDto executionQueryDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.queryExecutionsCall(firstResult, maxResults, executionQueryDto, _callback);
        return localVarCall;
    }

    public List<ExecutionDto> queryExecutions(Integer firstResult, Integer maxResults, ExecutionQueryDto executionQueryDto) throws ApiException {
        ApiResponse<List<ExecutionDto>> localVarResp = this.queryExecutionsWithHttpInfo(firstResult, maxResults, executionQueryDto);
        return localVarResp.getData();
    }

    public ApiResponse<List<ExecutionDto>> queryExecutionsWithHttpInfo(Integer firstResult, Integer maxResults, ExecutionQueryDto executionQueryDto) throws ApiException {
        Call localVarCall = this.queryExecutionsValidateBeforeCall(firstResult, maxResults, executionQueryDto, null);
        Type localVarReturnType = new TypeToken<List<ExecutionDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call queryExecutionsAsync(Integer firstResult, Integer maxResults, ExecutionQueryDto executionQueryDto, ApiCallback<List<ExecutionDto>> _callback) throws ApiException {
        Call localVarCall = this.queryExecutionsValidateBeforeCall(firstResult, maxResults, executionQueryDto, _callback);
        Type localVarReturnType = new TypeToken<List<ExecutionDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryExecutionsCountCall(ExecutionQueryDto executionQueryDto, ApiCallback _callback) throws ApiException {
        ExecutionQueryDto localVarPostBody = executionQueryDto;
        String localVarPath = "/execution/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryExecutionsCountValidateBeforeCall(ExecutionQueryDto executionQueryDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.queryExecutionsCountCall(executionQueryDto, _callback);
        return localVarCall;
    }

    public CountResultDto queryExecutionsCount(ExecutionQueryDto executionQueryDto) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.queryExecutionsCountWithHttpInfo(executionQueryDto);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> queryExecutionsCountWithHttpInfo(ExecutionQueryDto executionQueryDto) throws ApiException {
        Call localVarCall = this.queryExecutionsCountValidateBeforeCall(executionQueryDto, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call queryExecutionsCountAsync(ExecutionQueryDto executionQueryDto, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.queryExecutionsCountValidateBeforeCall(executionQueryDto, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setLocalExecutionVariableBinaryCall(String id, String varName, File data, String valueType, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/execution/{id}/localVariables/{varName}/data".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.localVarApiClient.escapeString(varName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (data != null) {
            localVarFormParams.put("data", data);
        }
        if (valueType != null) {
            localVarFormParams.put("valueType", valueType);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setLocalExecutionVariableBinaryValidateBeforeCall(String id, String varName, File data, String valueType, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setLocalExecutionVariableBinary(Async)");
        }
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling setLocalExecutionVariableBinary(Async)");
        }
        Call localVarCall = this.setLocalExecutionVariableBinaryCall(id, varName, data, valueType, _callback);
        return localVarCall;
    }

    public void setLocalExecutionVariableBinary(String id, String varName, File data, String valueType) throws ApiException {
        this.setLocalExecutionVariableBinaryWithHttpInfo(id, varName, data, valueType);
    }

    public ApiResponse<Void> setLocalExecutionVariableBinaryWithHttpInfo(String id, String varName, File data, String valueType) throws ApiException {
        Call localVarCall = this.setLocalExecutionVariableBinaryValidateBeforeCall(id, varName, data, valueType, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setLocalExecutionVariableBinaryAsync(String id, String varName, File data, String valueType, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setLocalExecutionVariableBinaryValidateBeforeCall(id, varName, data, valueType, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call signalExecutionCall(String id, ExecutionTriggerDto executionTriggerDto, ApiCallback _callback) throws ApiException {
        ExecutionTriggerDto localVarPostBody = executionTriggerDto;
        String localVarPath = "/execution/{id}/signal".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call signalExecutionValidateBeforeCall(String id, ExecutionTriggerDto executionTriggerDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling signalExecution(Async)");
        }
        Call localVarCall = this.signalExecutionCall(id, executionTriggerDto, _callback);
        return localVarCall;
    }

    public void signalExecution(String id, ExecutionTriggerDto executionTriggerDto) throws ApiException {
        this.signalExecutionWithHttpInfo(id, executionTriggerDto);
    }

    public ApiResponse<Void> signalExecutionWithHttpInfo(String id, ExecutionTriggerDto executionTriggerDto) throws ApiException {
        Call localVarCall = this.signalExecutionValidateBeforeCall(id, executionTriggerDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call signalExecutionAsync(String id, ExecutionTriggerDto executionTriggerDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.signalExecutionValidateBeforeCall(id, executionTriggerDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call triggerEventCall(String id, String messageName, ExecutionTriggerDto executionTriggerDto, ApiCallback _callback) throws ApiException {
        ExecutionTriggerDto localVarPostBody = executionTriggerDto;
        String localVarPath = "/execution/{id}/messageSubscriptions/{messageName}/trigger".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{messageName\\}", this.localVarApiClient.escapeString(messageName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call triggerEventValidateBeforeCall(String id, String messageName, ExecutionTriggerDto executionTriggerDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling triggerEvent(Async)");
        }
        if (messageName == null) {
            throw new ApiException("Missing the required parameter 'messageName' when calling triggerEvent(Async)");
        }
        Call localVarCall = this.triggerEventCall(id, messageName, executionTriggerDto, _callback);
        return localVarCall;
    }

    public void triggerEvent(String id, String messageName, ExecutionTriggerDto executionTriggerDto) throws ApiException {
        this.triggerEventWithHttpInfo(id, messageName, executionTriggerDto);
    }

    public ApiResponse<Void> triggerEventWithHttpInfo(String id, String messageName, ExecutionTriggerDto executionTriggerDto) throws ApiException {
        Call localVarCall = this.triggerEventValidateBeforeCall(id, messageName, executionTriggerDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call triggerEventAsync(String id, String messageName, ExecutionTriggerDto executionTriggerDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.triggerEventValidateBeforeCall(id, messageName, executionTriggerDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

