/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.community.rest.client.dto.AbstractVendorVersionInformationDto;
import org.camunda.community.rest.client.dto.TelemetryCountDto;
import org.camunda.community.rest.client.dto.TelemetryLicenseKeyDto;

/**
 * TelemetryInternalsDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-15T09:20:26.494044Z[Etc/UTC]")
public class TelemetryInternalsDto {
  public static final String SERIALIZED_NAME_DATABASE = "database";
  @SerializedName(SERIALIZED_NAME_DATABASE)
  private Map<String, AbstractVendorVersionInformationDto> database = null;

  public static final String SERIALIZED_NAME_APPLICATION_SERVER = "application-server";
  @SerializedName(SERIALIZED_NAME_APPLICATION_SERVER)
  private Map<String, AbstractVendorVersionInformationDto> applicationServer = null;

  public static final String SERIALIZED_NAME_LICENSE_KEY = "license-key";
  @SerializedName(SERIALIZED_NAME_LICENSE_KEY)
  private Map<String, TelemetryLicenseKeyDto> licenseKey = null;

  public static final String SERIALIZED_NAME_CAMUNDA_INTEGRATION = "camunda-integration";
  @SerializedName(SERIALIZED_NAME_CAMUNDA_INTEGRATION)
  private List<String> camundaIntegration = null;

  public static final String SERIALIZED_NAME_COMMANDS = "commands";
  @SerializedName(SERIALIZED_NAME_COMMANDS)
  private Map<String, TelemetryCountDto> commands = null;

  public static final String SERIALIZED_NAME_METRICS = "metrics";
  @SerializedName(SERIALIZED_NAME_METRICS)
  private Map<String, TelemetryCountDto> metrics = null;

  public static final String SERIALIZED_NAME_WEBAPPS = "webapps";
  @SerializedName(SERIALIZED_NAME_WEBAPPS)
  private List<String> webapps = null;

  public static final String SERIALIZED_NAME_JDK = "jdk";
  @SerializedName(SERIALIZED_NAME_JDK)
  private Map<String, AbstractVendorVersionInformationDto> jdk = null;


  public TelemetryInternalsDto database(Map<String, AbstractVendorVersionInformationDto> database) {
    
    this.database = database;
    return this;
  }

  public TelemetryInternalsDto putDatabaseItem(String key, AbstractVendorVersionInformationDto databaseItem) {
    if (this.database == null) {
      this.database = new HashMap<String, AbstractVendorVersionInformationDto>();
    }
    this.database.put(key, databaseItem);
    return this;
  }

   /**
   * Vendor and version of the connected database.
   * @return database
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Vendor and version of the connected database.")

  public Map<String, AbstractVendorVersionInformationDto> getDatabase() {
    return database;
  }


  public void setDatabase(Map<String, AbstractVendorVersionInformationDto> database) {
    this.database = database;
  }


  public TelemetryInternalsDto applicationServer(Map<String, AbstractVendorVersionInformationDto> applicationServer) {
    
    this.applicationServer = applicationServer;
    return this;
  }

  public TelemetryInternalsDto putApplicationServerItem(String key, AbstractVendorVersionInformationDto applicationServerItem) {
    if (this.applicationServer == null) {
      this.applicationServer = new HashMap<String, AbstractVendorVersionInformationDto>();
    }
    this.applicationServer.put(key, applicationServerItem);
    return this;
  }

   /**
   * Vendor and version of the application server.
   * @return applicationServer
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Vendor and version of the application server.")

  public Map<String, AbstractVendorVersionInformationDto> getApplicationServer() {
    return applicationServer;
  }


  public void setApplicationServer(Map<String, AbstractVendorVersionInformationDto> applicationServer) {
    this.applicationServer = applicationServer;
  }


  public TelemetryInternalsDto licenseKey(Map<String, TelemetryLicenseKeyDto> licenseKey) {
    
    this.licenseKey = licenseKey;
    return this;
  }

  public TelemetryInternalsDto putLicenseKeyItem(String key, TelemetryLicenseKeyDto licenseKeyItem) {
    if (this.licenseKey == null) {
      this.licenseKey = new HashMap<String, TelemetryLicenseKeyDto>();
    }
    this.licenseKey.put(key, licenseKeyItem);
    return this;
  }

   /**
   * Information about the Camunda license key.
   * @return licenseKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Information about the Camunda license key.")

  public Map<String, TelemetryLicenseKeyDto> getLicenseKey() {
    return licenseKey;
  }


  public void setLicenseKey(Map<String, TelemetryLicenseKeyDto> licenseKey) {
    this.licenseKey = licenseKey;
  }


  public TelemetryInternalsDto camundaIntegration(List<String> camundaIntegration) {
    
    this.camundaIntegration = camundaIntegration;
    return this;
  }

  public TelemetryInternalsDto addCamundaIntegrationItem(String camundaIntegrationItem) {
    if (this.camundaIntegration == null) {
      this.camundaIntegration = new ArrayList<String>();
    }
    this.camundaIntegration.add(camundaIntegrationItem);
    return this;
  }

   /**
   * List of Camunda integrations used (e.g., Camunda Spring Boot Starter, Camunda Run, WildFly/JBoss subsystem, Camunda EJB).
   * @return camundaIntegration
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "List of Camunda integrations used (e.g., Camunda Spring Boot Starter, Camunda Run, WildFly/JBoss subsystem, Camunda EJB).")

  public List<String> getCamundaIntegration() {
    return camundaIntegration;
  }


  public void setCamundaIntegration(List<String> camundaIntegration) {
    this.camundaIntegration = camundaIntegration;
  }


  public TelemetryInternalsDto commands(Map<String, TelemetryCountDto> commands) {
    
    this.commands = commands;
    return this;
  }

  public TelemetryInternalsDto putCommandsItem(String key, TelemetryCountDto commandsItem) {
    if (this.commands == null) {
      this.commands = new HashMap<String, TelemetryCountDto>();
    }
    this.commands.put(key, commandsItem);
    return this;
  }

   /**
   * The count of executed commands after the last retrieved data.
   * @return commands
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The count of executed commands after the last retrieved data.")

  public Map<String, TelemetryCountDto> getCommands() {
    return commands;
  }


  public void setCommands(Map<String, TelemetryCountDto> commands) {
    this.commands = commands;
  }


  public TelemetryInternalsDto metrics(Map<String, TelemetryCountDto> metrics) {
    
    this.metrics = metrics;
    return this;
  }

  public TelemetryInternalsDto putMetricsItem(String key, TelemetryCountDto metricsItem) {
    if (this.metrics == null) {
      this.metrics = new HashMap<String, TelemetryCountDto>();
    }
    this.metrics.put(key, metricsItem);
    return this;
  }

   /**
   * The collected metrics are the number of root process instance executions started, the number of activity instances started or also known as flow node instances, and the number of executed decision instances and elements.
   * @return metrics
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The collected metrics are the number of root process instance executions started, the number of activity instances started or also known as flow node instances, and the number of executed decision instances and elements.")

  public Map<String, TelemetryCountDto> getMetrics() {
    return metrics;
  }


  public void setMetrics(Map<String, TelemetryCountDto> metrics) {
    this.metrics = metrics;
  }


  public TelemetryInternalsDto webapps(List<String> webapps) {
    
    this.webapps = webapps;
    return this;
  }

  public TelemetryInternalsDto addWebappsItem(String webappsItem) {
    if (this.webapps == null) {
      this.webapps = new ArrayList<String>();
    }
    this.webapps.add(webappsItem);
    return this;
  }

   /**
   * The webapps enabled in this installation of Camunda.
   * @return webapps
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The webapps enabled in this installation of Camunda.")

  public List<String> getWebapps() {
    return webapps;
  }


  public void setWebapps(List<String> webapps) {
    this.webapps = webapps;
  }


  public TelemetryInternalsDto jdk(Map<String, AbstractVendorVersionInformationDto> jdk) {
    
    this.jdk = jdk;
    return this;
  }

  public TelemetryInternalsDto putJdkItem(String key, AbstractVendorVersionInformationDto jdkItem) {
    if (this.jdk == null) {
      this.jdk = new HashMap<String, AbstractVendorVersionInformationDto>();
    }
    this.jdk.put(key, jdkItem);
    return this;
  }

   /**
   * Vendor and version of the installed JDK.
   * @return jdk
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Vendor and version of the installed JDK.")

  public Map<String, AbstractVendorVersionInformationDto> getJdk() {
    return jdk;
  }


  public void setJdk(Map<String, AbstractVendorVersionInformationDto> jdk) {
    this.jdk = jdk;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TelemetryInternalsDto telemetryInternalsDto = (TelemetryInternalsDto) o;
    return Objects.equals(this.database, telemetryInternalsDto.database) &&
        Objects.equals(this.applicationServer, telemetryInternalsDto.applicationServer) &&
        Objects.equals(this.licenseKey, telemetryInternalsDto.licenseKey) &&
        Objects.equals(this.camundaIntegration, telemetryInternalsDto.camundaIntegration) &&
        Objects.equals(this.commands, telemetryInternalsDto.commands) &&
        Objects.equals(this.metrics, telemetryInternalsDto.metrics) &&
        Objects.equals(this.webapps, telemetryInternalsDto.webapps) &&
        Objects.equals(this.jdk, telemetryInternalsDto.jdk);
  }

  @Override
  public int hashCode() {
    return Objects.hash(database, applicationServer, licenseKey, camundaIntegration, commands, metrics, webapps, jdk);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TelemetryInternalsDto {\n");
    sb.append("    database: ").append(toIndentedString(database)).append("\n");
    sb.append("    applicationServer: ").append(toIndentedString(applicationServer)).append("\n");
    sb.append("    licenseKey: ").append(toIndentedString(licenseKey)).append("\n");
    sb.append("    camundaIntegration: ").append(toIndentedString(camundaIntegration)).append("\n");
    sb.append("    commands: ").append(toIndentedString(commands)).append("\n");
    sb.append("    metrics: ").append(toIndentedString(metrics)).append("\n");
    sb.append("    webapps: ").append(toIndentedString(webapps)).append("\n");
    sb.append("    jdk: ").append(toIndentedString(jdk)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

