/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * A historic decision instance query which defines a list of historic decision instances
 */
@ApiModel(description = "A historic decision instance query which defines a list of historic decision instances")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-15T09:20:26.494044Z[Etc/UTC]")
public class HistoricDecisionInstanceQueryDto {
  public static final String SERIALIZED_NAME_DECISION_INSTANCE_ID = "decisionInstanceId";
  @SerializedName(SERIALIZED_NAME_DECISION_INSTANCE_ID)
  private String decisionInstanceId;

  public static final String SERIALIZED_NAME_DECISION_INSTANCE_ID_IN = "decisionInstanceIdIn";
  @SerializedName(SERIALIZED_NAME_DECISION_INSTANCE_ID_IN)
  private List<String> decisionInstanceIdIn = null;

  public static final String SERIALIZED_NAME_DECISION_DEFINITION_ID = "decisionDefinitionId";
  @SerializedName(SERIALIZED_NAME_DECISION_DEFINITION_ID)
  private String decisionDefinitionId;

  public static final String SERIALIZED_NAME_DECISION_DEFINITION_ID_IN = "decisionDefinitionIdIn";
  @SerializedName(SERIALIZED_NAME_DECISION_DEFINITION_ID_IN)
  private List<String> decisionDefinitionIdIn = null;

  public static final String SERIALIZED_NAME_DECISION_DEFINITION_KEY = "decisionDefinitionKey";
  @SerializedName(SERIALIZED_NAME_DECISION_DEFINITION_KEY)
  private String decisionDefinitionKey;

  public static final String SERIALIZED_NAME_DECISION_DEFINITION_KEY_IN = "decisionDefinitionKeyIn";
  @SerializedName(SERIALIZED_NAME_DECISION_DEFINITION_KEY_IN)
  private List<String> decisionDefinitionKeyIn = null;

  public static final String SERIALIZED_NAME_DECISION_DEFINITION_NAME = "decisionDefinitionName";
  @SerializedName(SERIALIZED_NAME_DECISION_DEFINITION_NAME)
  private String decisionDefinitionName;

  public static final String SERIALIZED_NAME_DECISION_DEFINITION_NAME_LIKE = "decisionDefinitionNameLike";
  @SerializedName(SERIALIZED_NAME_DECISION_DEFINITION_NAME_LIKE)
  private String decisionDefinitionNameLike;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_ID)
  private String processDefinitionId;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_KEY)
  private String processDefinitionKey;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_ID)
  private String processInstanceId;

  public static final String SERIALIZED_NAME_CASE_DEFINITION_ID = "caseDefinitionId";
  @SerializedName(SERIALIZED_NAME_CASE_DEFINITION_ID)
  private String caseDefinitionId;

  public static final String SERIALIZED_NAME_CASE_DEFINITION_KEY = "caseDefinitionKey";
  @SerializedName(SERIALIZED_NAME_CASE_DEFINITION_KEY)
  private String caseDefinitionKey;

  public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
  @SerializedName(SERIALIZED_NAME_CASE_INSTANCE_ID)
  private String caseInstanceId;

  public static final String SERIALIZED_NAME_ACTIVITY_ID_IN = "activityIdIn";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_ID_IN)
  private List<String> activityIdIn = null;

  public static final String SERIALIZED_NAME_ACTIVITY_INSTANCE_ID_IN = "activityInstanceIdIn";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_INSTANCE_ID_IN)
  private List<String> activityInstanceIdIn = null;

  public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
  @SerializedName(SERIALIZED_NAME_TENANT_ID_IN)
  private List<String> tenantIdIn = null;

  public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
  @SerializedName(SERIALIZED_NAME_WITHOUT_TENANT_ID)
  private Boolean withoutTenantId;

  public static final String SERIALIZED_NAME_EVALUATED_BEFORE = "evaluatedBefore";
  @SerializedName(SERIALIZED_NAME_EVALUATED_BEFORE)
  private Date evaluatedBefore;

  public static final String SERIALIZED_NAME_EVALUATED_AFTER = "evaluatedAfter";
  @SerializedName(SERIALIZED_NAME_EVALUATED_AFTER)
  private Date evaluatedAfter;

  public static final String SERIALIZED_NAME_USER_ID = "userId";
  @SerializedName(SERIALIZED_NAME_USER_ID)
  private String userId;

  public static final String SERIALIZED_NAME_ROOT_DECISION_INSTANCE_ID = "rootDecisionInstanceId";
  @SerializedName(SERIALIZED_NAME_ROOT_DECISION_INSTANCE_ID)
  private String rootDecisionInstanceId;

  public static final String SERIALIZED_NAME_ROOT_DECISION_INSTANCES_ONLY = "rootDecisionInstancesOnly";
  @SerializedName(SERIALIZED_NAME_ROOT_DECISION_INSTANCES_ONLY)
  private Boolean rootDecisionInstancesOnly;

  public static final String SERIALIZED_NAME_DECISION_REQUIREMENTS_DEFINITION_ID = "decisionRequirementsDefinitionId";
  @SerializedName(SERIALIZED_NAME_DECISION_REQUIREMENTS_DEFINITION_ID)
  private String decisionRequirementsDefinitionId;

  public static final String SERIALIZED_NAME_DECISION_REQUIREMENTS_DEFINITION_KEY = "decisionRequirementsDefinitionKey";
  @SerializedName(SERIALIZED_NAME_DECISION_REQUIREMENTS_DEFINITION_KEY)
  private String decisionRequirementsDefinitionKey;

  public static final String SERIALIZED_NAME_INCLUDE_INPUTS = "includeInputs";
  @SerializedName(SERIALIZED_NAME_INCLUDE_INPUTS)
  private Boolean includeInputs;

  public static final String SERIALIZED_NAME_INCLUDE_OUTPUTS = "includeOutputs";
  @SerializedName(SERIALIZED_NAME_INCLUDE_OUTPUTS)
  private Boolean includeOutputs;

  public static final String SERIALIZED_NAME_DISABLE_BINARY_FETCHING = "disableBinaryFetching";
  @SerializedName(SERIALIZED_NAME_DISABLE_BINARY_FETCHING)
  private Boolean disableBinaryFetching;

  public static final String SERIALIZED_NAME_DISABLE_CUSTOM_OBJECT_DESERIALIZATION = "disableCustomObjectDeserialization";
  @SerializedName(SERIALIZED_NAME_DISABLE_CUSTOM_OBJECT_DESERIALIZATION)
  private Boolean disableCustomObjectDeserialization;


  public HistoricDecisionInstanceQueryDto decisionInstanceId(String decisionInstanceId) {
    
    this.decisionInstanceId = decisionInstanceId;
    return this;
  }

   /**
   * Filter by decision instance id.
   * @return decisionInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by decision instance id.")

  public String getDecisionInstanceId() {
    return decisionInstanceId;
  }


  public void setDecisionInstanceId(String decisionInstanceId) {
    this.decisionInstanceId = decisionInstanceId;
  }


  public HistoricDecisionInstanceQueryDto decisionInstanceIdIn(List<String> decisionInstanceIdIn) {
    
    this.decisionInstanceIdIn = decisionInstanceIdIn;
    return this;
  }

  public HistoricDecisionInstanceQueryDto addDecisionInstanceIdInItem(String decisionInstanceIdInItem) {
    if (this.decisionInstanceIdIn == null) {
      this.decisionInstanceIdIn = new ArrayList<String>();
    }
    this.decisionInstanceIdIn.add(decisionInstanceIdInItem);
    return this;
  }

   /**
   * Filter by decision instance ids. Must be a comma-separated list of decision instance ids.
   * @return decisionInstanceIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by decision instance ids. Must be a comma-separated list of decision instance ids.")

  public List<String> getDecisionInstanceIdIn() {
    return decisionInstanceIdIn;
  }


  public void setDecisionInstanceIdIn(List<String> decisionInstanceIdIn) {
    this.decisionInstanceIdIn = decisionInstanceIdIn;
  }


  public HistoricDecisionInstanceQueryDto decisionDefinitionId(String decisionDefinitionId) {
    
    this.decisionDefinitionId = decisionDefinitionId;
    return this;
  }

   /**
   * Filter by the decision definition the instances belongs to.
   * @return decisionDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the decision definition the instances belongs to.")

  public String getDecisionDefinitionId() {
    return decisionDefinitionId;
  }


  public void setDecisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
  }


  public HistoricDecisionInstanceQueryDto decisionDefinitionIdIn(List<String> decisionDefinitionIdIn) {
    
    this.decisionDefinitionIdIn = decisionDefinitionIdIn;
    return this;
  }

  public HistoricDecisionInstanceQueryDto addDecisionDefinitionIdInItem(String decisionDefinitionIdInItem) {
    if (this.decisionDefinitionIdIn == null) {
      this.decisionDefinitionIdIn = new ArrayList<String>();
    }
    this.decisionDefinitionIdIn.add(decisionDefinitionIdInItem);
    return this;
  }

   /**
   * Filter by the decision definitions the instances belongs to. Must be a comma-separated list of decision definition ids.
   * @return decisionDefinitionIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the decision definitions the instances belongs to. Must be a comma-separated list of decision definition ids.")

  public List<String> getDecisionDefinitionIdIn() {
    return decisionDefinitionIdIn;
  }


  public void setDecisionDefinitionIdIn(List<String> decisionDefinitionIdIn) {
    this.decisionDefinitionIdIn = decisionDefinitionIdIn;
  }


  public HistoricDecisionInstanceQueryDto decisionDefinitionKey(String decisionDefinitionKey) {
    
    this.decisionDefinitionKey = decisionDefinitionKey;
    return this;
  }

   /**
   * Filter by the key of the decision definition the instances belongs to.
   * @return decisionDefinitionKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the key of the decision definition the instances belongs to.")

  public String getDecisionDefinitionKey() {
    return decisionDefinitionKey;
  }


  public void setDecisionDefinitionKey(String decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
  }


  public HistoricDecisionInstanceQueryDto decisionDefinitionKeyIn(List<String> decisionDefinitionKeyIn) {
    
    this.decisionDefinitionKeyIn = decisionDefinitionKeyIn;
    return this;
  }

  public HistoricDecisionInstanceQueryDto addDecisionDefinitionKeyInItem(String decisionDefinitionKeyInItem) {
    if (this.decisionDefinitionKeyIn == null) {
      this.decisionDefinitionKeyIn = new ArrayList<String>();
    }
    this.decisionDefinitionKeyIn.add(decisionDefinitionKeyInItem);
    return this;
  }

   /**
   * Filter by the keys of the decision definition the instances belongs to. Must be a comma- separated list of decision definition keys.
   * @return decisionDefinitionKeyIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the keys of the decision definition the instances belongs to. Must be a comma- separated list of decision definition keys.")

  public List<String> getDecisionDefinitionKeyIn() {
    return decisionDefinitionKeyIn;
  }


  public void setDecisionDefinitionKeyIn(List<String> decisionDefinitionKeyIn) {
    this.decisionDefinitionKeyIn = decisionDefinitionKeyIn;
  }


  public HistoricDecisionInstanceQueryDto decisionDefinitionName(String decisionDefinitionName) {
    
    this.decisionDefinitionName = decisionDefinitionName;
    return this;
  }

   /**
   * Filter by the name of the decision definition the instances belongs to.
   * @return decisionDefinitionName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the name of the decision definition the instances belongs to.")

  public String getDecisionDefinitionName() {
    return decisionDefinitionName;
  }


  public void setDecisionDefinitionName(String decisionDefinitionName) {
    this.decisionDefinitionName = decisionDefinitionName;
  }


  public HistoricDecisionInstanceQueryDto decisionDefinitionNameLike(String decisionDefinitionNameLike) {
    
    this.decisionDefinitionNameLike = decisionDefinitionNameLike;
    return this;
  }

   /**
   * Filter by the name of the decision definition the instances belongs to, that the parameter is a substring of.
   * @return decisionDefinitionNameLike
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the name of the decision definition the instances belongs to, that the parameter is a substring of.")

  public String getDecisionDefinitionNameLike() {
    return decisionDefinitionNameLike;
  }


  public void setDecisionDefinitionNameLike(String decisionDefinitionNameLike) {
    this.decisionDefinitionNameLike = decisionDefinitionNameLike;
  }


  public HistoricDecisionInstanceQueryDto processDefinitionId(String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

   /**
   * Filter by the process definition the instances belongs to.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the process definition the instances belongs to.")

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }


  public HistoricDecisionInstanceQueryDto processDefinitionKey(String processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

   /**
   * Filter by the key of the process definition the instances belongs to.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the key of the process definition the instances belongs to.")

  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }


  public HistoricDecisionInstanceQueryDto processInstanceId(String processInstanceId) {
    
    this.processInstanceId = processInstanceId;
    return this;
  }

   /**
   * Filter by the process instance the instances belongs to.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the process instance the instances belongs to.")

  public String getProcessInstanceId() {
    return processInstanceId;
  }


  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = processInstanceId;
  }


  public HistoricDecisionInstanceQueryDto caseDefinitionId(String caseDefinitionId) {
    
    this.caseDefinitionId = caseDefinitionId;
    return this;
  }

   /**
   * Filter by the case definition the instances belongs to.
   * @return caseDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the case definition the instances belongs to.")

  public String getCaseDefinitionId() {
    return caseDefinitionId;
  }


  public void setCaseDefinitionId(String caseDefinitionId) {
    this.caseDefinitionId = caseDefinitionId;
  }


  public HistoricDecisionInstanceQueryDto caseDefinitionKey(String caseDefinitionKey) {
    
    this.caseDefinitionKey = caseDefinitionKey;
    return this;
  }

   /**
   * Filter by the key of the case definition the instances belongs to.
   * @return caseDefinitionKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the key of the case definition the instances belongs to.")

  public String getCaseDefinitionKey() {
    return caseDefinitionKey;
  }


  public void setCaseDefinitionKey(String caseDefinitionKey) {
    this.caseDefinitionKey = caseDefinitionKey;
  }


  public HistoricDecisionInstanceQueryDto caseInstanceId(String caseInstanceId) {
    
    this.caseInstanceId = caseInstanceId;
    return this;
  }

   /**
   * Filter by the case instance the instances belongs to.
   * @return caseInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the case instance the instances belongs to.")

  public String getCaseInstanceId() {
    return caseInstanceId;
  }


  public void setCaseInstanceId(String caseInstanceId) {
    this.caseInstanceId = caseInstanceId;
  }


  public HistoricDecisionInstanceQueryDto activityIdIn(List<String> activityIdIn) {
    
    this.activityIdIn = activityIdIn;
    return this;
  }

  public HistoricDecisionInstanceQueryDto addActivityIdInItem(String activityIdInItem) {
    if (this.activityIdIn == null) {
      this.activityIdIn = new ArrayList<String>();
    }
    this.activityIdIn.add(activityIdInItem);
    return this;
  }

   /**
   * Filter by the activity ids the instances belongs to. Must be a comma-separated list of acitvity ids.
   * @return activityIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the activity ids the instances belongs to. Must be a comma-separated list of acitvity ids.")

  public List<String> getActivityIdIn() {
    return activityIdIn;
  }


  public void setActivityIdIn(List<String> activityIdIn) {
    this.activityIdIn = activityIdIn;
  }


  public HistoricDecisionInstanceQueryDto activityInstanceIdIn(List<String> activityInstanceIdIn) {
    
    this.activityInstanceIdIn = activityInstanceIdIn;
    return this;
  }

  public HistoricDecisionInstanceQueryDto addActivityInstanceIdInItem(String activityInstanceIdInItem) {
    if (this.activityInstanceIdIn == null) {
      this.activityInstanceIdIn = new ArrayList<String>();
    }
    this.activityInstanceIdIn.add(activityInstanceIdInItem);
    return this;
  }

   /**
   * Filter by the activity instance ids the instances belongs to. Must be a comma-separated list of acitvity instance ids.
   * @return activityInstanceIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the activity instance ids the instances belongs to. Must be a comma-separated list of acitvity instance ids.")

  public List<String> getActivityInstanceIdIn() {
    return activityInstanceIdIn;
  }


  public void setActivityInstanceIdIn(List<String> activityInstanceIdIn) {
    this.activityInstanceIdIn = activityInstanceIdIn;
  }


  public HistoricDecisionInstanceQueryDto tenantIdIn(List<String> tenantIdIn) {
    
    this.tenantIdIn = tenantIdIn;
    return this;
  }

  public HistoricDecisionInstanceQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null) {
      this.tenantIdIn = new ArrayList<String>();
    }
    this.tenantIdIn.add(tenantIdInItem);
    return this;
  }

   /**
   * Filter by a comma-separated list of tenant ids. A historic decision instance must have one of the given tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by a comma-separated list of tenant ids. A historic decision instance must have one of the given tenant ids.")

  public List<String> getTenantIdIn() {
    return tenantIdIn;
  }


  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }


  public HistoricDecisionInstanceQueryDto withoutTenantId(Boolean withoutTenantId) {
    
    this.withoutTenantId = withoutTenantId;
    return this;
  }

   /**
   * Only include historic decision instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include historic decision instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getWithoutTenantId() {
    return withoutTenantId;
  }


  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }


  public HistoricDecisionInstanceQueryDto evaluatedBefore(Date evaluatedBefore) {
    
    this.evaluatedBefore = evaluatedBefore;
    return this;
  }

   /**
   * Restrict to instances that were evaluated before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return evaluatedBefore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that were evaluated before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format `yyyy-MM- dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getEvaluatedBefore() {
    return evaluatedBefore;
  }


  public void setEvaluatedBefore(Date evaluatedBefore) {
    this.evaluatedBefore = evaluatedBefore;
  }


  public HistoricDecisionInstanceQueryDto evaluatedAfter(Date evaluatedAfter) {
    
    this.evaluatedAfter = evaluatedAfter;
    return this;
  }

   /**
   * Restrict to instances that were evaluated after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return evaluatedAfter
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that were evaluated after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format `yyyy-MM- dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getEvaluatedAfter() {
    return evaluatedAfter;
  }


  public void setEvaluatedAfter(Date evaluatedAfter) {
    this.evaluatedAfter = evaluatedAfter;
  }


  public HistoricDecisionInstanceQueryDto userId(String userId) {
    
    this.userId = userId;
    return this;
  }

   /**
   * Restrict to instances that were evaluated by the given user.
   * @return userId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that were evaluated by the given user.")

  public String getUserId() {
    return userId;
  }


  public void setUserId(String userId) {
    this.userId = userId;
  }


  public HistoricDecisionInstanceQueryDto rootDecisionInstanceId(String rootDecisionInstanceId) {
    
    this.rootDecisionInstanceId = rootDecisionInstanceId;
    return this;
  }

   /**
   * Restrict to instances that have a given root decision instance id. This also includes the decision instance with the given id.
   * @return rootDecisionInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that have a given root decision instance id. This also includes the decision instance with the given id.")

  public String getRootDecisionInstanceId() {
    return rootDecisionInstanceId;
  }


  public void setRootDecisionInstanceId(String rootDecisionInstanceId) {
    this.rootDecisionInstanceId = rootDecisionInstanceId;
  }


  public HistoricDecisionInstanceQueryDto rootDecisionInstancesOnly(Boolean rootDecisionInstancesOnly) {
    
    this.rootDecisionInstancesOnly = rootDecisionInstancesOnly;
    return this;
  }

   /**
   * Restrict to instances those are the root decision instance of an evaluation. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return rootDecisionInstancesOnly
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances those are the root decision instance of an evaluation. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getRootDecisionInstancesOnly() {
    return rootDecisionInstancesOnly;
  }


  public void setRootDecisionInstancesOnly(Boolean rootDecisionInstancesOnly) {
    this.rootDecisionInstancesOnly = rootDecisionInstancesOnly;
  }


  public HistoricDecisionInstanceQueryDto decisionRequirementsDefinitionId(String decisionRequirementsDefinitionId) {
    
    this.decisionRequirementsDefinitionId = decisionRequirementsDefinitionId;
    return this;
  }

   /**
   * Filter by the decision requirements definition the instances belongs to.
   * @return decisionRequirementsDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the decision requirements definition the instances belongs to.")

  public String getDecisionRequirementsDefinitionId() {
    return decisionRequirementsDefinitionId;
  }


  public void setDecisionRequirementsDefinitionId(String decisionRequirementsDefinitionId) {
    this.decisionRequirementsDefinitionId = decisionRequirementsDefinitionId;
  }


  public HistoricDecisionInstanceQueryDto decisionRequirementsDefinitionKey(String decisionRequirementsDefinitionKey) {
    
    this.decisionRequirementsDefinitionKey = decisionRequirementsDefinitionKey;
    return this;
  }

   /**
   * Filter by the key of the decision requirements definition the instances belongs to.
   * @return decisionRequirementsDefinitionKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the key of the decision requirements definition the instances belongs to.")

  public String getDecisionRequirementsDefinitionKey() {
    return decisionRequirementsDefinitionKey;
  }


  public void setDecisionRequirementsDefinitionKey(String decisionRequirementsDefinitionKey) {
    this.decisionRequirementsDefinitionKey = decisionRequirementsDefinitionKey;
  }


  public HistoricDecisionInstanceQueryDto includeInputs(Boolean includeInputs) {
    
    this.includeInputs = includeInputs;
    return this;
  }

   /**
   * Include input values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return includeInputs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Include input values in the result. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getIncludeInputs() {
    return includeInputs;
  }


  public void setIncludeInputs(Boolean includeInputs) {
    this.includeInputs = includeInputs;
  }


  public HistoricDecisionInstanceQueryDto includeOutputs(Boolean includeOutputs) {
    
    this.includeOutputs = includeOutputs;
    return this;
  }

   /**
   * Include output values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return includeOutputs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Include output values in the result. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getIncludeOutputs() {
    return includeOutputs;
  }


  public void setIncludeOutputs(Boolean includeOutputs) {
    this.includeOutputs = includeOutputs;
  }


  public HistoricDecisionInstanceQueryDto disableBinaryFetching(Boolean disableBinaryFetching) {
    
    this.disableBinaryFetching = disableBinaryFetching;
    return this;
  }

   /**
   * Disables fetching of byte array input and output values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return disableBinaryFetching
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Disables fetching of byte array input and output values. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getDisableBinaryFetching() {
    return disableBinaryFetching;
  }


  public void setDisableBinaryFetching(Boolean disableBinaryFetching) {
    this.disableBinaryFetching = disableBinaryFetching;
  }


  public HistoricDecisionInstanceQueryDto disableCustomObjectDeserialization(Boolean disableCustomObjectDeserialization) {
    
    this.disableCustomObjectDeserialization = disableCustomObjectDeserialization;
    return this;
  }

   /**
   * Disables deserialization of input and output values that are custom objects. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return disableCustomObjectDeserialization
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Disables deserialization of input and output values that are custom objects. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getDisableCustomObjectDeserialization() {
    return disableCustomObjectDeserialization;
  }


  public void setDisableCustomObjectDeserialization(Boolean disableCustomObjectDeserialization) {
    this.disableCustomObjectDeserialization = disableCustomObjectDeserialization;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricDecisionInstanceQueryDto historicDecisionInstanceQueryDto = (HistoricDecisionInstanceQueryDto) o;
    return Objects.equals(this.decisionInstanceId, historicDecisionInstanceQueryDto.decisionInstanceId) &&
        Objects.equals(this.decisionInstanceIdIn, historicDecisionInstanceQueryDto.decisionInstanceIdIn) &&
        Objects.equals(this.decisionDefinitionId, historicDecisionInstanceQueryDto.decisionDefinitionId) &&
        Objects.equals(this.decisionDefinitionIdIn, historicDecisionInstanceQueryDto.decisionDefinitionIdIn) &&
        Objects.equals(this.decisionDefinitionKey, historicDecisionInstanceQueryDto.decisionDefinitionKey) &&
        Objects.equals(this.decisionDefinitionKeyIn, historicDecisionInstanceQueryDto.decisionDefinitionKeyIn) &&
        Objects.equals(this.decisionDefinitionName, historicDecisionInstanceQueryDto.decisionDefinitionName) &&
        Objects.equals(this.decisionDefinitionNameLike, historicDecisionInstanceQueryDto.decisionDefinitionNameLike) &&
        Objects.equals(this.processDefinitionId, historicDecisionInstanceQueryDto.processDefinitionId) &&
        Objects.equals(this.processDefinitionKey, historicDecisionInstanceQueryDto.processDefinitionKey) &&
        Objects.equals(this.processInstanceId, historicDecisionInstanceQueryDto.processInstanceId) &&
        Objects.equals(this.caseDefinitionId, historicDecisionInstanceQueryDto.caseDefinitionId) &&
        Objects.equals(this.caseDefinitionKey, historicDecisionInstanceQueryDto.caseDefinitionKey) &&
        Objects.equals(this.caseInstanceId, historicDecisionInstanceQueryDto.caseInstanceId) &&
        Objects.equals(this.activityIdIn, historicDecisionInstanceQueryDto.activityIdIn) &&
        Objects.equals(this.activityInstanceIdIn, historicDecisionInstanceQueryDto.activityInstanceIdIn) &&
        Objects.equals(this.tenantIdIn, historicDecisionInstanceQueryDto.tenantIdIn) &&
        Objects.equals(this.withoutTenantId, historicDecisionInstanceQueryDto.withoutTenantId) &&
        Objects.equals(this.evaluatedBefore, historicDecisionInstanceQueryDto.evaluatedBefore) &&
        Objects.equals(this.evaluatedAfter, historicDecisionInstanceQueryDto.evaluatedAfter) &&
        Objects.equals(this.userId, historicDecisionInstanceQueryDto.userId) &&
        Objects.equals(this.rootDecisionInstanceId, historicDecisionInstanceQueryDto.rootDecisionInstanceId) &&
        Objects.equals(this.rootDecisionInstancesOnly, historicDecisionInstanceQueryDto.rootDecisionInstancesOnly) &&
        Objects.equals(this.decisionRequirementsDefinitionId, historicDecisionInstanceQueryDto.decisionRequirementsDefinitionId) &&
        Objects.equals(this.decisionRequirementsDefinitionKey, historicDecisionInstanceQueryDto.decisionRequirementsDefinitionKey) &&
        Objects.equals(this.includeInputs, historicDecisionInstanceQueryDto.includeInputs) &&
        Objects.equals(this.includeOutputs, historicDecisionInstanceQueryDto.includeOutputs) &&
        Objects.equals(this.disableBinaryFetching, historicDecisionInstanceQueryDto.disableBinaryFetching) &&
        Objects.equals(this.disableCustomObjectDeserialization, historicDecisionInstanceQueryDto.disableCustomObjectDeserialization);
  }

  @Override
  public int hashCode() {
    return Objects.hash(decisionInstanceId, decisionInstanceIdIn, decisionDefinitionId, decisionDefinitionIdIn, decisionDefinitionKey, decisionDefinitionKeyIn, decisionDefinitionName, decisionDefinitionNameLike, processDefinitionId, processDefinitionKey, processInstanceId, caseDefinitionId, caseDefinitionKey, caseInstanceId, activityIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, evaluatedBefore, evaluatedAfter, userId, rootDecisionInstanceId, rootDecisionInstancesOnly, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, includeInputs, includeOutputs, disableBinaryFetching, disableCustomObjectDeserialization);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricDecisionInstanceQueryDto {\n");
    sb.append("    decisionInstanceId: ").append(toIndentedString(decisionInstanceId)).append("\n");
    sb.append("    decisionInstanceIdIn: ").append(toIndentedString(decisionInstanceIdIn)).append("\n");
    sb.append("    decisionDefinitionId: ").append(toIndentedString(decisionDefinitionId)).append("\n");
    sb.append("    decisionDefinitionIdIn: ").append(toIndentedString(decisionDefinitionIdIn)).append("\n");
    sb.append("    decisionDefinitionKey: ").append(toIndentedString(decisionDefinitionKey)).append("\n");
    sb.append("    decisionDefinitionKeyIn: ").append(toIndentedString(decisionDefinitionKeyIn)).append("\n");
    sb.append("    decisionDefinitionName: ").append(toIndentedString(decisionDefinitionName)).append("\n");
    sb.append("    decisionDefinitionNameLike: ").append(toIndentedString(decisionDefinitionNameLike)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    caseDefinitionId: ").append(toIndentedString(caseDefinitionId)).append("\n");
    sb.append("    caseDefinitionKey: ").append(toIndentedString(caseDefinitionKey)).append("\n");
    sb.append("    caseInstanceId: ").append(toIndentedString(caseInstanceId)).append("\n");
    sb.append("    activityIdIn: ").append(toIndentedString(activityIdIn)).append("\n");
    sb.append("    activityInstanceIdIn: ").append(toIndentedString(activityInstanceIdIn)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    evaluatedBefore: ").append(toIndentedString(evaluatedBefore)).append("\n");
    sb.append("    evaluatedAfter: ").append(toIndentedString(evaluatedAfter)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    rootDecisionInstanceId: ").append(toIndentedString(rootDecisionInstanceId)).append("\n");
    sb.append("    rootDecisionInstancesOnly: ").append(toIndentedString(rootDecisionInstancesOnly)).append("\n");
    sb.append("    decisionRequirementsDefinitionId: ").append(toIndentedString(decisionRequirementsDefinitionId)).append("\n");
    sb.append("    decisionRequirementsDefinitionKey: ").append(toIndentedString(decisionRequirementsDefinitionKey)).append("\n");
    sb.append("    includeInputs: ").append(toIndentedString(includeInputs)).append("\n");
    sb.append("    includeOutputs: ").append(toIndentedString(includeOutputs)).append("\n");
    sb.append("    disableBinaryFetching: ").append(toIndentedString(disableBinaryFetching)).append("\n");
    sb.append("    disableCustomObjectDeserialization: ").append(toIndentedString(disableCustomObjectDeserialization)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

