/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.api;

import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;
import org.camunda.community.rest.client.invoker.ProgressRequestBody;
import org.camunda.community.rest.client.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import java.util.Date;
import org.camunda.community.rest.client.dto.DeleteHistoricDecisionInstancesDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.HistoricDecisionInstanceDto;
import org.camunda.community.rest.client.dto.SetRemovalTimeToHistoricDecisionInstancesDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoricDecisionInstanceApi {
    private ApiClient localVarApiClient;

    public HistoricDecisionInstanceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricDecisionInstanceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for deleteAsync
     * @param deleteHistoricDecisionInstancesDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, i.e. neither &#x60;historicDecisionInstanceIds&#x60; nor &#x60;historicDecisionInstanceQuery&#x60; is present. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling)  for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAsyncCall(DeleteHistoricDecisionInstancesDto deleteHistoricDecisionInstancesDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = deleteHistoricDecisionInstancesDto;

        // create path and map variables
        String localVarPath = "/history/decision-instance/delete";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteAsyncValidateBeforeCall(DeleteHistoricDecisionInstancesDto deleteHistoricDecisionInstancesDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = deleteAsyncCall(deleteHistoricDecisionInstancesDto, _callback);
        return localVarCall;

    }

    /**
     * Delete Async (POST)
     * Delete multiple historic decision instances asynchronously (batch). At least &#x60;historicDecisionInstanceIds&#x60; or &#x60;historicDecisionInstanceQuery&#x60;  has to be provided. If both are provided then all instances matching query  criterion and instances from the list will be deleted.
     * @param deleteHistoricDecisionInstancesDto  (optional)
     * @return BatchDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, i.e. neither &#x60;historicDecisionInstanceIds&#x60; nor &#x60;historicDecisionInstanceQuery&#x60; is present. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling)  for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public BatchDto deleteAsync(DeleteHistoricDecisionInstancesDto deleteHistoricDecisionInstancesDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = deleteAsyncWithHttpInfo(deleteHistoricDecisionInstancesDto);
        return localVarResp.getData();
    }

    /**
     * Delete Async (POST)
     * Delete multiple historic decision instances asynchronously (batch). At least &#x60;historicDecisionInstanceIds&#x60; or &#x60;historicDecisionInstanceQuery&#x60;  has to be provided. If both are provided then all instances matching query  criterion and instances from the list will be deleted.
     * @param deleteHistoricDecisionInstancesDto  (optional)
     * @return ApiResponse&lt;BatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, i.e. neither &#x60;historicDecisionInstanceIds&#x60; nor &#x60;historicDecisionInstanceQuery&#x60; is present. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling)  for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BatchDto> deleteAsyncWithHttpInfo(DeleteHistoricDecisionInstancesDto deleteHistoricDecisionInstancesDto) throws ApiException {
        okhttp3.Call localVarCall = deleteAsyncValidateBeforeCall(deleteHistoricDecisionInstancesDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Delete Async (POST) (asynchronously)
     * Delete multiple historic decision instances asynchronously (batch). At least &#x60;historicDecisionInstanceIds&#x60; or &#x60;historicDecisionInstanceQuery&#x60;  has to be provided. If both are provided then all instances matching query  criterion and instances from the list will be deleted.
     * @param deleteHistoricDecisionInstancesDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, i.e. neither &#x60;historicDecisionInstanceIds&#x60; nor &#x60;historicDecisionInstanceQuery&#x60; is present. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling)  for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAsyncAsync(DeleteHistoricDecisionInstancesDto deleteHistoricDecisionInstancesDto, final ApiCallback<BatchDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteAsyncValidateBeforeCall(deleteHistoricDecisionInstancesDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricDecisionInstance
     * @param id The id of the historic decision instance to be retrieved. (required)
     * @param includeInputs Include input values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeOutputs Include output values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param disableBinaryFetching Disables fetching of byte array input and output values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param disableCustomObjectDeserialization Disables deserialization of input and output values that are custom objects. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic decision instance with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricDecisionInstanceCall(String id, Boolean includeInputs, Boolean includeOutputs, Boolean disableBinaryFetching, Boolean disableCustomObjectDeserialization, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/decision-instance/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (includeInputs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeInputs", includeInputs));
        }

        if (includeOutputs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeOutputs", includeOutputs));
        }

        if (disableBinaryFetching != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("disableBinaryFetching", disableBinaryFetching));
        }

        if (disableCustomObjectDeserialization != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("disableCustomObjectDeserialization", disableCustomObjectDeserialization));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricDecisionInstanceValidateBeforeCall(String id, Boolean includeInputs, Boolean includeOutputs, Boolean disableBinaryFetching, Boolean disableCustomObjectDeserialization, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getHistoricDecisionInstance(Async)");
        }
        

        okhttp3.Call localVarCall = getHistoricDecisionInstanceCall(id, includeInputs, includeOutputs, disableBinaryFetching, disableCustomObjectDeserialization, _callback);
        return localVarCall;

    }

    /**
     * Get Historic Decision Instance
     * Retrieves a historic decision instance by id, according to the  &#x60;HistoricDecisionInstance&#x60; interface in the engine.
     * @param id The id of the historic decision instance to be retrieved. (required)
     * @param includeInputs Include input values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeOutputs Include output values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param disableBinaryFetching Disables fetching of byte array input and output values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param disableCustomObjectDeserialization Disables deserialization of input and output values that are custom objects. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return HistoricDecisionInstanceDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic decision instance with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public HistoricDecisionInstanceDto getHistoricDecisionInstance(String id, Boolean includeInputs, Boolean includeOutputs, Boolean disableBinaryFetching, Boolean disableCustomObjectDeserialization) throws ApiException {
        ApiResponse<HistoricDecisionInstanceDto> localVarResp = getHistoricDecisionInstanceWithHttpInfo(id, includeInputs, includeOutputs, disableBinaryFetching, disableCustomObjectDeserialization);
        return localVarResp.getData();
    }

    /**
     * Get Historic Decision Instance
     * Retrieves a historic decision instance by id, according to the  &#x60;HistoricDecisionInstance&#x60; interface in the engine.
     * @param id The id of the historic decision instance to be retrieved. (required)
     * @param includeInputs Include input values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeOutputs Include output values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param disableBinaryFetching Disables fetching of byte array input and output values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param disableCustomObjectDeserialization Disables deserialization of input and output values that are custom objects. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return ApiResponse&lt;HistoricDecisionInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic decision instance with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<HistoricDecisionInstanceDto> getHistoricDecisionInstanceWithHttpInfo(String id, Boolean includeInputs, Boolean includeOutputs, Boolean disableBinaryFetching, Boolean disableCustomObjectDeserialization) throws ApiException {
        okhttp3.Call localVarCall = getHistoricDecisionInstanceValidateBeforeCall(id, includeInputs, includeOutputs, disableBinaryFetching, disableCustomObjectDeserialization, null);
        Type localVarReturnType = new TypeToken<HistoricDecisionInstanceDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Historic Decision Instance (asynchronously)
     * Retrieves a historic decision instance by id, according to the  &#x60;HistoricDecisionInstance&#x60; interface in the engine.
     * @param id The id of the historic decision instance to be retrieved. (required)
     * @param includeInputs Include input values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeOutputs Include output values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param disableBinaryFetching Disables fetching of byte array input and output values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param disableCustomObjectDeserialization Disables deserialization of input and output values that are custom objects. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic decision instance with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricDecisionInstanceAsync(String id, Boolean includeInputs, Boolean includeOutputs, Boolean disableBinaryFetching, Boolean disableCustomObjectDeserialization, final ApiCallback<HistoricDecisionInstanceDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricDecisionInstanceValidateBeforeCall(id, includeInputs, includeOutputs, disableBinaryFetching, disableCustomObjectDeserialization, _callback);
        Type localVarReturnType = new TypeToken<HistoricDecisionInstanceDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricDecisionInstances
     * @param decisionInstanceId Filter by decision instance id. (optional)
     * @param decisionInstanceIdIn Filter by decision instance ids. Must be a comma-separated list of decision instance ids. (optional)
     * @param decisionDefinitionId Filter by the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionIdIn Filter by the decision definitions the instances belongs to. Must be a comma-separated list of decision definition ids. (optional)
     * @param decisionDefinitionKey Filter by the key of the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionKeyIn Filter by the keys of the decision definition the instances belongs to. Must be a comma- separated list of decision definition keys. (optional)
     * @param decisionDefinitionName Filter by the name of the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionNameLike Filter by the name of the decision definition the instances belongs to, that the parameter is a substring of. (optional)
     * @param processDefinitionId Filter by the process definition the instances belongs to. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances belongs to. (optional)
     * @param processInstanceId Filter by the process instance the instances belongs to. (optional)
     * @param caseDefinitionId Filter by the case definition the instances belongs to. (optional)
     * @param caseDefinitionKey Filter by the key of the case definition the instances belongs to. (optional)
     * @param caseInstanceId Filter by the case instance the instances belongs to. (optional)
     * @param activityIdIn Filter by the activity ids the instances belongs to. Must be a comma-separated list of acitvity ids. (optional)
     * @param activityInstanceIdIn Filter by the activity instance ids the instances belongs to. Must be a comma-separated list of acitvity instance ids. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A historic decision instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic decision instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param evaluatedBefore Restrict to instances that were evaluated before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param evaluatedAfter Restrict to instances that were evaluated after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param userId Restrict to instances that were evaluated by the given user. (optional)
     * @param rootDecisionInstanceId Restrict to instances that have a given root decision instance id. This also includes the decision instance with the given id. (optional)
     * @param rootDecisionInstancesOnly Restrict to instances those are the root decision instance of an evaluation. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param decisionRequirementsDefinitionId Filter by the decision requirements definition the instances belongs to. (optional)
     * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition the instances belongs to. (optional)
     * @param includeInputs Include input values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeOutputs Include output values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param disableBinaryFetching Disables fetching of byte array input and output values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param disableCustomObjectDeserialization Disables deserialization of input and output values that are custom objects. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricDecisionInstancesCall(String decisionInstanceId, String decisionInstanceIdIn, String decisionDefinitionId, String decisionDefinitionIdIn, String decisionDefinitionKey, String decisionDefinitionKeyIn, String decisionDefinitionName, String decisionDefinitionNameLike, String processDefinitionId, String processDefinitionKey, String processInstanceId, String caseDefinitionId, String caseDefinitionKey, String caseInstanceId, String activityIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, Date evaluatedBefore, Date evaluatedAfter, String userId, String rootDecisionInstanceId, Boolean rootDecisionInstancesOnly, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean includeInputs, Boolean includeOutputs, Boolean disableBinaryFetching, Boolean disableCustomObjectDeserialization, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/decision-instance";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (decisionInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionInstanceId", decisionInstanceId));
        }

        if (decisionInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionInstanceIdIn", decisionInstanceIdIn));
        }

        if (decisionDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionId", decisionDefinitionId));
        }

        if (decisionDefinitionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionIdIn", decisionDefinitionIdIn));
        }

        if (decisionDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionKey", decisionDefinitionKey));
        }

        if (decisionDefinitionKeyIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionKeyIn", decisionDefinitionKeyIn));
        }

        if (decisionDefinitionName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionName", decisionDefinitionName));
        }

        if (decisionDefinitionNameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionNameLike", decisionDefinitionNameLike));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (caseDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseDefinitionId", caseDefinitionId));
        }

        if (caseDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseDefinitionKey", caseDefinitionKey));
        }

        if (caseInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }

        if (activityIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityIdIn", activityIdIn));
        }

        if (activityInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (evaluatedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("evaluatedBefore", evaluatedBefore));
        }

        if (evaluatedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("evaluatedAfter", evaluatedAfter));
        }

        if (userId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("userId", userId));
        }

        if (rootDecisionInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("rootDecisionInstanceId", rootDecisionInstanceId));
        }

        if (rootDecisionInstancesOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("rootDecisionInstancesOnly", rootDecisionInstancesOnly));
        }

        if (decisionRequirementsDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionRequirementsDefinitionId", decisionRequirementsDefinitionId));
        }

        if (decisionRequirementsDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionRequirementsDefinitionKey", decisionRequirementsDefinitionKey));
        }

        if (includeInputs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeInputs", includeInputs));
        }

        if (includeOutputs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeOutputs", includeOutputs));
        }

        if (disableBinaryFetching != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("disableBinaryFetching", disableBinaryFetching));
        }

        if (disableCustomObjectDeserialization != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("disableCustomObjectDeserialization", disableCustomObjectDeserialization));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricDecisionInstancesValidateBeforeCall(String decisionInstanceId, String decisionInstanceIdIn, String decisionDefinitionId, String decisionDefinitionIdIn, String decisionDefinitionKey, String decisionDefinitionKeyIn, String decisionDefinitionName, String decisionDefinitionNameLike, String processDefinitionId, String processDefinitionKey, String processInstanceId, String caseDefinitionId, String caseDefinitionKey, String caseInstanceId, String activityIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, Date evaluatedBefore, Date evaluatedAfter, String userId, String rootDecisionInstanceId, Boolean rootDecisionInstancesOnly, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean includeInputs, Boolean includeOutputs, Boolean disableBinaryFetching, Boolean disableCustomObjectDeserialization, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricDecisionInstancesCall(decisionInstanceId, decisionInstanceIdIn, decisionDefinitionId, decisionDefinitionIdIn, decisionDefinitionKey, decisionDefinitionKeyIn, decisionDefinitionName, decisionDefinitionNameLike, processDefinitionId, processDefinitionKey, processInstanceId, caseDefinitionId, caseDefinitionKey, caseInstanceId, activityIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, evaluatedBefore, evaluatedAfter, userId, rootDecisionInstanceId, rootDecisionInstancesOnly, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, includeInputs, includeOutputs, disableBinaryFetching, disableCustomObjectDeserialization, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;

    }

    /**
     * Get Historic Decision Instances
     * Queries for historic decision instances that fulfill the given parameters.  The size of the result set can be retrieved by using the  [Get Historic Decision Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/decision-instance/get-decision-instance-query-count/)  method.
     * @param decisionInstanceId Filter by decision instance id. (optional)
     * @param decisionInstanceIdIn Filter by decision instance ids. Must be a comma-separated list of decision instance ids. (optional)
     * @param decisionDefinitionId Filter by the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionIdIn Filter by the decision definitions the instances belongs to. Must be a comma-separated list of decision definition ids. (optional)
     * @param decisionDefinitionKey Filter by the key of the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionKeyIn Filter by the keys of the decision definition the instances belongs to. Must be a comma- separated list of decision definition keys. (optional)
     * @param decisionDefinitionName Filter by the name of the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionNameLike Filter by the name of the decision definition the instances belongs to, that the parameter is a substring of. (optional)
     * @param processDefinitionId Filter by the process definition the instances belongs to. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances belongs to. (optional)
     * @param processInstanceId Filter by the process instance the instances belongs to. (optional)
     * @param caseDefinitionId Filter by the case definition the instances belongs to. (optional)
     * @param caseDefinitionKey Filter by the key of the case definition the instances belongs to. (optional)
     * @param caseInstanceId Filter by the case instance the instances belongs to. (optional)
     * @param activityIdIn Filter by the activity ids the instances belongs to. Must be a comma-separated list of acitvity ids. (optional)
     * @param activityInstanceIdIn Filter by the activity instance ids the instances belongs to. Must be a comma-separated list of acitvity instance ids. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A historic decision instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic decision instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param evaluatedBefore Restrict to instances that were evaluated before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param evaluatedAfter Restrict to instances that were evaluated after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param userId Restrict to instances that were evaluated by the given user. (optional)
     * @param rootDecisionInstanceId Restrict to instances that have a given root decision instance id. This also includes the decision instance with the given id. (optional)
     * @param rootDecisionInstancesOnly Restrict to instances those are the root decision instance of an evaluation. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param decisionRequirementsDefinitionId Filter by the decision requirements definition the instances belongs to. (optional)
     * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition the instances belongs to. (optional)
     * @param includeInputs Include input values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeOutputs Include output values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param disableBinaryFetching Disables fetching of byte array input and output values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param disableCustomObjectDeserialization Disables deserialization of input and output values that are custom objects. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return List&lt;HistoricDecisionInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricDecisionInstanceDto> getHistoricDecisionInstances(String decisionInstanceId, String decisionInstanceIdIn, String decisionDefinitionId, String decisionDefinitionIdIn, String decisionDefinitionKey, String decisionDefinitionKeyIn, String decisionDefinitionName, String decisionDefinitionNameLike, String processDefinitionId, String processDefinitionKey, String processInstanceId, String caseDefinitionId, String caseDefinitionKey, String caseInstanceId, String activityIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, Date evaluatedBefore, Date evaluatedAfter, String userId, String rootDecisionInstanceId, Boolean rootDecisionInstancesOnly, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean includeInputs, Boolean includeOutputs, Boolean disableBinaryFetching, Boolean disableCustomObjectDeserialization, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<HistoricDecisionInstanceDto>> localVarResp = getHistoricDecisionInstancesWithHttpInfo(decisionInstanceId, decisionInstanceIdIn, decisionDefinitionId, decisionDefinitionIdIn, decisionDefinitionKey, decisionDefinitionKeyIn, decisionDefinitionName, decisionDefinitionNameLike, processDefinitionId, processDefinitionKey, processInstanceId, caseDefinitionId, caseDefinitionKey, caseInstanceId, activityIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, evaluatedBefore, evaluatedAfter, userId, rootDecisionInstanceId, rootDecisionInstancesOnly, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, includeInputs, includeOutputs, disableBinaryFetching, disableCustomObjectDeserialization, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    /**
     * Get Historic Decision Instances
     * Queries for historic decision instances that fulfill the given parameters.  The size of the result set can be retrieved by using the  [Get Historic Decision Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/decision-instance/get-decision-instance-query-count/)  method.
     * @param decisionInstanceId Filter by decision instance id. (optional)
     * @param decisionInstanceIdIn Filter by decision instance ids. Must be a comma-separated list of decision instance ids. (optional)
     * @param decisionDefinitionId Filter by the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionIdIn Filter by the decision definitions the instances belongs to. Must be a comma-separated list of decision definition ids. (optional)
     * @param decisionDefinitionKey Filter by the key of the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionKeyIn Filter by the keys of the decision definition the instances belongs to. Must be a comma- separated list of decision definition keys. (optional)
     * @param decisionDefinitionName Filter by the name of the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionNameLike Filter by the name of the decision definition the instances belongs to, that the parameter is a substring of. (optional)
     * @param processDefinitionId Filter by the process definition the instances belongs to. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances belongs to. (optional)
     * @param processInstanceId Filter by the process instance the instances belongs to. (optional)
     * @param caseDefinitionId Filter by the case definition the instances belongs to. (optional)
     * @param caseDefinitionKey Filter by the key of the case definition the instances belongs to. (optional)
     * @param caseInstanceId Filter by the case instance the instances belongs to. (optional)
     * @param activityIdIn Filter by the activity ids the instances belongs to. Must be a comma-separated list of acitvity ids. (optional)
     * @param activityInstanceIdIn Filter by the activity instance ids the instances belongs to. Must be a comma-separated list of acitvity instance ids. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A historic decision instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic decision instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param evaluatedBefore Restrict to instances that were evaluated before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param evaluatedAfter Restrict to instances that were evaluated after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param userId Restrict to instances that were evaluated by the given user. (optional)
     * @param rootDecisionInstanceId Restrict to instances that have a given root decision instance id. This also includes the decision instance with the given id. (optional)
     * @param rootDecisionInstancesOnly Restrict to instances those are the root decision instance of an evaluation. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param decisionRequirementsDefinitionId Filter by the decision requirements definition the instances belongs to. (optional)
     * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition the instances belongs to. (optional)
     * @param includeInputs Include input values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeOutputs Include output values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param disableBinaryFetching Disables fetching of byte array input and output values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param disableCustomObjectDeserialization Disables deserialization of input and output values that are custom objects. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return ApiResponse&lt;List&lt;HistoricDecisionInstanceDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricDecisionInstanceDto>> getHistoricDecisionInstancesWithHttpInfo(String decisionInstanceId, String decisionInstanceIdIn, String decisionDefinitionId, String decisionDefinitionIdIn, String decisionDefinitionKey, String decisionDefinitionKeyIn, String decisionDefinitionName, String decisionDefinitionNameLike, String processDefinitionId, String processDefinitionKey, String processInstanceId, String caseDefinitionId, String caseDefinitionKey, String caseInstanceId, String activityIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, Date evaluatedBefore, Date evaluatedAfter, String userId, String rootDecisionInstanceId, Boolean rootDecisionInstancesOnly, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean includeInputs, Boolean includeOutputs, Boolean disableBinaryFetching, Boolean disableCustomObjectDeserialization, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = getHistoricDecisionInstancesValidateBeforeCall(decisionInstanceId, decisionInstanceIdIn, decisionDefinitionId, decisionDefinitionIdIn, decisionDefinitionKey, decisionDefinitionKeyIn, decisionDefinitionName, decisionDefinitionNameLike, processDefinitionId, processDefinitionKey, processInstanceId, caseDefinitionId, caseDefinitionKey, caseInstanceId, activityIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, evaluatedBefore, evaluatedAfter, userId, rootDecisionInstanceId, rootDecisionInstancesOnly, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, includeInputs, includeOutputs, disableBinaryFetching, disableCustomObjectDeserialization, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<HistoricDecisionInstanceDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Historic Decision Instances (asynchronously)
     * Queries for historic decision instances that fulfill the given parameters.  The size of the result set can be retrieved by using the  [Get Historic Decision Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/decision-instance/get-decision-instance-query-count/)  method.
     * @param decisionInstanceId Filter by decision instance id. (optional)
     * @param decisionInstanceIdIn Filter by decision instance ids. Must be a comma-separated list of decision instance ids. (optional)
     * @param decisionDefinitionId Filter by the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionIdIn Filter by the decision definitions the instances belongs to. Must be a comma-separated list of decision definition ids. (optional)
     * @param decisionDefinitionKey Filter by the key of the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionKeyIn Filter by the keys of the decision definition the instances belongs to. Must be a comma- separated list of decision definition keys. (optional)
     * @param decisionDefinitionName Filter by the name of the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionNameLike Filter by the name of the decision definition the instances belongs to, that the parameter is a substring of. (optional)
     * @param processDefinitionId Filter by the process definition the instances belongs to. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances belongs to. (optional)
     * @param processInstanceId Filter by the process instance the instances belongs to. (optional)
     * @param caseDefinitionId Filter by the case definition the instances belongs to. (optional)
     * @param caseDefinitionKey Filter by the key of the case definition the instances belongs to. (optional)
     * @param caseInstanceId Filter by the case instance the instances belongs to. (optional)
     * @param activityIdIn Filter by the activity ids the instances belongs to. Must be a comma-separated list of acitvity ids. (optional)
     * @param activityInstanceIdIn Filter by the activity instance ids the instances belongs to. Must be a comma-separated list of acitvity instance ids. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A historic decision instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic decision instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param evaluatedBefore Restrict to instances that were evaluated before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param evaluatedAfter Restrict to instances that were evaluated after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param userId Restrict to instances that were evaluated by the given user. (optional)
     * @param rootDecisionInstanceId Restrict to instances that have a given root decision instance id. This also includes the decision instance with the given id. (optional)
     * @param rootDecisionInstancesOnly Restrict to instances those are the root decision instance of an evaluation. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param decisionRequirementsDefinitionId Filter by the decision requirements definition the instances belongs to. (optional)
     * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition the instances belongs to. (optional)
     * @param includeInputs Include input values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeOutputs Include output values in the result. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param disableBinaryFetching Disables fetching of byte array input and output values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param disableCustomObjectDeserialization Disables deserialization of input and output values that are custom objects. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricDecisionInstancesAsync(String decisionInstanceId, String decisionInstanceIdIn, String decisionDefinitionId, String decisionDefinitionIdIn, String decisionDefinitionKey, String decisionDefinitionKeyIn, String decisionDefinitionName, String decisionDefinitionNameLike, String processDefinitionId, String processDefinitionKey, String processInstanceId, String caseDefinitionId, String caseDefinitionKey, String caseInstanceId, String activityIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, Date evaluatedBefore, Date evaluatedAfter, String userId, String rootDecisionInstanceId, Boolean rootDecisionInstancesOnly, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean includeInputs, Boolean includeOutputs, Boolean disableBinaryFetching, Boolean disableCustomObjectDeserialization, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback<List<HistoricDecisionInstanceDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricDecisionInstancesValidateBeforeCall(decisionInstanceId, decisionInstanceIdIn, decisionDefinitionId, decisionDefinitionIdIn, decisionDefinitionKey, decisionDefinitionKeyIn, decisionDefinitionName, decisionDefinitionNameLike, processDefinitionId, processDefinitionKey, processInstanceId, caseDefinitionId, caseDefinitionKey, caseInstanceId, activityIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, evaluatedBefore, evaluatedAfter, userId, rootDecisionInstanceId, rootDecisionInstancesOnly, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, includeInputs, includeOutputs, disableBinaryFetching, disableCustomObjectDeserialization, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricDecisionInstanceDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricDecisionInstancesCount
     * @param decisionInstanceId Filter by decision instance id. (optional)
     * @param decisionInstanceIdIn Filter by decision instance ids. Must be a comma-separated list of decision instance ids. (optional)
     * @param decisionDefinitionId Filter by the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionIdIn Filter by the decision definitions the instances belongs to. Must be a comma-separated list of decision definition ids. (optional)
     * @param decisionDefinitionKey Filter by the key of the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionKeyIn Filter by the keys of the decision definition the instances belongs to. Must be a comma- separated list of decision definition keys. (optional)
     * @param decisionDefinitionName Filter by the name of the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionNameLike Filter by the name of the decision definition the instances belongs to, that the parameter is a substring of. (optional)
     * @param processDefinitionId Filter by the process definition the instances belongs to. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances belongs to. (optional)
     * @param processInstanceId Filter by the process instance the instances belongs to. (optional)
     * @param caseDefinitionId Filter by the case definition the instances belongs to. (optional)
     * @param caseDefinitionKey Filter by the key of the case definition the instances belongs to. (optional)
     * @param caseInstanceId Filter by the case instance the instances belongs to. (optional)
     * @param activityIdIn Filter by the activity ids the instances belongs to. Must be a comma-separated list of acitvity ids. (optional)
     * @param activityInstanceIdIn Filter by the activity instance ids the instances belongs to. Must be a comma-separated list of acitvity instance ids. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A historic decision instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic decision instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param evaluatedBefore Restrict to instances that were evaluated before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param evaluatedAfter Restrict to instances that were evaluated after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param userId Restrict to instances that were evaluated by the given user. (optional)
     * @param rootDecisionInstanceId Restrict to instances that have a given root decision instance id. This also includes the decision instance with the given id. (optional)
     * @param rootDecisionInstancesOnly Restrict to instances those are the root decision instance of an evaluation. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param decisionRequirementsDefinitionId Filter by the decision requirements definition the instances belongs to. (optional)
     * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition the instances belongs to. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricDecisionInstancesCountCall(String decisionInstanceId, String decisionInstanceIdIn, String decisionDefinitionId, String decisionDefinitionIdIn, String decisionDefinitionKey, String decisionDefinitionKeyIn, String decisionDefinitionName, String decisionDefinitionNameLike, String processDefinitionId, String processDefinitionKey, String processInstanceId, String caseDefinitionId, String caseDefinitionKey, String caseInstanceId, String activityIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, Date evaluatedBefore, Date evaluatedAfter, String userId, String rootDecisionInstanceId, Boolean rootDecisionInstancesOnly, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/decision-instance/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (decisionInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionInstanceId", decisionInstanceId));
        }

        if (decisionInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionInstanceIdIn", decisionInstanceIdIn));
        }

        if (decisionDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionId", decisionDefinitionId));
        }

        if (decisionDefinitionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionIdIn", decisionDefinitionIdIn));
        }

        if (decisionDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionKey", decisionDefinitionKey));
        }

        if (decisionDefinitionKeyIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionKeyIn", decisionDefinitionKeyIn));
        }

        if (decisionDefinitionName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionName", decisionDefinitionName));
        }

        if (decisionDefinitionNameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionNameLike", decisionDefinitionNameLike));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (caseDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseDefinitionId", caseDefinitionId));
        }

        if (caseDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseDefinitionKey", caseDefinitionKey));
        }

        if (caseInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }

        if (activityIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityIdIn", activityIdIn));
        }

        if (activityInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (evaluatedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("evaluatedBefore", evaluatedBefore));
        }

        if (evaluatedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("evaluatedAfter", evaluatedAfter));
        }

        if (userId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("userId", userId));
        }

        if (rootDecisionInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("rootDecisionInstanceId", rootDecisionInstanceId));
        }

        if (rootDecisionInstancesOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("rootDecisionInstancesOnly", rootDecisionInstancesOnly));
        }

        if (decisionRequirementsDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionRequirementsDefinitionId", decisionRequirementsDefinitionId));
        }

        if (decisionRequirementsDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionRequirementsDefinitionKey", decisionRequirementsDefinitionKey));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricDecisionInstancesCountValidateBeforeCall(String decisionInstanceId, String decisionInstanceIdIn, String decisionDefinitionId, String decisionDefinitionIdIn, String decisionDefinitionKey, String decisionDefinitionKeyIn, String decisionDefinitionName, String decisionDefinitionNameLike, String processDefinitionId, String processDefinitionKey, String processInstanceId, String caseDefinitionId, String caseDefinitionKey, String caseInstanceId, String activityIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, Date evaluatedBefore, Date evaluatedAfter, String userId, String rootDecisionInstanceId, Boolean rootDecisionInstancesOnly, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricDecisionInstancesCountCall(decisionInstanceId, decisionInstanceIdIn, decisionDefinitionId, decisionDefinitionIdIn, decisionDefinitionKey, decisionDefinitionKeyIn, decisionDefinitionName, decisionDefinitionNameLike, processDefinitionId, processDefinitionKey, processInstanceId, caseDefinitionId, caseDefinitionKey, caseInstanceId, activityIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, evaluatedBefore, evaluatedAfter, userId, rootDecisionInstanceId, rootDecisionInstancesOnly, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, _callback);
        return localVarCall;

    }

    /**
     * Get Historic Decision Instance Count
     * Queries for the number of historic decision instances that fulfill the given parameters.  Takes the same parameters as the  [Get Historic Decision Instances](https://docs.camunda.org/manual/7.17/reference/rest/history/decision-instance/get-decision-instance-query/)  method.
     * @param decisionInstanceId Filter by decision instance id. (optional)
     * @param decisionInstanceIdIn Filter by decision instance ids. Must be a comma-separated list of decision instance ids. (optional)
     * @param decisionDefinitionId Filter by the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionIdIn Filter by the decision definitions the instances belongs to. Must be a comma-separated list of decision definition ids. (optional)
     * @param decisionDefinitionKey Filter by the key of the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionKeyIn Filter by the keys of the decision definition the instances belongs to. Must be a comma- separated list of decision definition keys. (optional)
     * @param decisionDefinitionName Filter by the name of the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionNameLike Filter by the name of the decision definition the instances belongs to, that the parameter is a substring of. (optional)
     * @param processDefinitionId Filter by the process definition the instances belongs to. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances belongs to. (optional)
     * @param processInstanceId Filter by the process instance the instances belongs to. (optional)
     * @param caseDefinitionId Filter by the case definition the instances belongs to. (optional)
     * @param caseDefinitionKey Filter by the key of the case definition the instances belongs to. (optional)
     * @param caseInstanceId Filter by the case instance the instances belongs to. (optional)
     * @param activityIdIn Filter by the activity ids the instances belongs to. Must be a comma-separated list of acitvity ids. (optional)
     * @param activityInstanceIdIn Filter by the activity instance ids the instances belongs to. Must be a comma-separated list of acitvity instance ids. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A historic decision instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic decision instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param evaluatedBefore Restrict to instances that were evaluated before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param evaluatedAfter Restrict to instances that were evaluated after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param userId Restrict to instances that were evaluated by the given user. (optional)
     * @param rootDecisionInstanceId Restrict to instances that have a given root decision instance id. This also includes the decision instance with the given id. (optional)
     * @param rootDecisionInstancesOnly Restrict to instances those are the root decision instance of an evaluation. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param decisionRequirementsDefinitionId Filter by the decision requirements definition the instances belongs to. (optional)
     * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition the instances belongs to. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getHistoricDecisionInstancesCount(String decisionInstanceId, String decisionInstanceIdIn, String decisionDefinitionId, String decisionDefinitionIdIn, String decisionDefinitionKey, String decisionDefinitionKeyIn, String decisionDefinitionName, String decisionDefinitionNameLike, String processDefinitionId, String processDefinitionKey, String processInstanceId, String caseDefinitionId, String caseDefinitionKey, String caseInstanceId, String activityIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, Date evaluatedBefore, Date evaluatedAfter, String userId, String rootDecisionInstanceId, Boolean rootDecisionInstancesOnly, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getHistoricDecisionInstancesCountWithHttpInfo(decisionInstanceId, decisionInstanceIdIn, decisionDefinitionId, decisionDefinitionIdIn, decisionDefinitionKey, decisionDefinitionKeyIn, decisionDefinitionName, decisionDefinitionNameLike, processDefinitionId, processDefinitionKey, processInstanceId, caseDefinitionId, caseDefinitionKey, caseInstanceId, activityIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, evaluatedBefore, evaluatedAfter, userId, rootDecisionInstanceId, rootDecisionInstancesOnly, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey);
        return localVarResp.getData();
    }

    /**
     * Get Historic Decision Instance Count
     * Queries for the number of historic decision instances that fulfill the given parameters.  Takes the same parameters as the  [Get Historic Decision Instances](https://docs.camunda.org/manual/7.17/reference/rest/history/decision-instance/get-decision-instance-query/)  method.
     * @param decisionInstanceId Filter by decision instance id. (optional)
     * @param decisionInstanceIdIn Filter by decision instance ids. Must be a comma-separated list of decision instance ids. (optional)
     * @param decisionDefinitionId Filter by the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionIdIn Filter by the decision definitions the instances belongs to. Must be a comma-separated list of decision definition ids. (optional)
     * @param decisionDefinitionKey Filter by the key of the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionKeyIn Filter by the keys of the decision definition the instances belongs to. Must be a comma- separated list of decision definition keys. (optional)
     * @param decisionDefinitionName Filter by the name of the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionNameLike Filter by the name of the decision definition the instances belongs to, that the parameter is a substring of. (optional)
     * @param processDefinitionId Filter by the process definition the instances belongs to. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances belongs to. (optional)
     * @param processInstanceId Filter by the process instance the instances belongs to. (optional)
     * @param caseDefinitionId Filter by the case definition the instances belongs to. (optional)
     * @param caseDefinitionKey Filter by the key of the case definition the instances belongs to. (optional)
     * @param caseInstanceId Filter by the case instance the instances belongs to. (optional)
     * @param activityIdIn Filter by the activity ids the instances belongs to. Must be a comma-separated list of acitvity ids. (optional)
     * @param activityInstanceIdIn Filter by the activity instance ids the instances belongs to. Must be a comma-separated list of acitvity instance ids. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A historic decision instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic decision instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param evaluatedBefore Restrict to instances that were evaluated before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param evaluatedAfter Restrict to instances that were evaluated after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param userId Restrict to instances that were evaluated by the given user. (optional)
     * @param rootDecisionInstanceId Restrict to instances that have a given root decision instance id. This also includes the decision instance with the given id. (optional)
     * @param rootDecisionInstancesOnly Restrict to instances those are the root decision instance of an evaluation. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param decisionRequirementsDefinitionId Filter by the decision requirements definition the instances belongs to. (optional)
     * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition the instances belongs to. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getHistoricDecisionInstancesCountWithHttpInfo(String decisionInstanceId, String decisionInstanceIdIn, String decisionDefinitionId, String decisionDefinitionIdIn, String decisionDefinitionKey, String decisionDefinitionKeyIn, String decisionDefinitionName, String decisionDefinitionNameLike, String processDefinitionId, String processDefinitionKey, String processInstanceId, String caseDefinitionId, String caseDefinitionKey, String caseInstanceId, String activityIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, Date evaluatedBefore, Date evaluatedAfter, String userId, String rootDecisionInstanceId, Boolean rootDecisionInstancesOnly, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey) throws ApiException {
        okhttp3.Call localVarCall = getHistoricDecisionInstancesCountValidateBeforeCall(decisionInstanceId, decisionInstanceIdIn, decisionDefinitionId, decisionDefinitionIdIn, decisionDefinitionKey, decisionDefinitionKeyIn, decisionDefinitionName, decisionDefinitionNameLike, processDefinitionId, processDefinitionKey, processInstanceId, caseDefinitionId, caseDefinitionKey, caseInstanceId, activityIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, evaluatedBefore, evaluatedAfter, userId, rootDecisionInstanceId, rootDecisionInstancesOnly, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Historic Decision Instance Count (asynchronously)
     * Queries for the number of historic decision instances that fulfill the given parameters.  Takes the same parameters as the  [Get Historic Decision Instances](https://docs.camunda.org/manual/7.17/reference/rest/history/decision-instance/get-decision-instance-query/)  method.
     * @param decisionInstanceId Filter by decision instance id. (optional)
     * @param decisionInstanceIdIn Filter by decision instance ids. Must be a comma-separated list of decision instance ids. (optional)
     * @param decisionDefinitionId Filter by the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionIdIn Filter by the decision definitions the instances belongs to. Must be a comma-separated list of decision definition ids. (optional)
     * @param decisionDefinitionKey Filter by the key of the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionKeyIn Filter by the keys of the decision definition the instances belongs to. Must be a comma- separated list of decision definition keys. (optional)
     * @param decisionDefinitionName Filter by the name of the decision definition the instances belongs to. (optional)
     * @param decisionDefinitionNameLike Filter by the name of the decision definition the instances belongs to, that the parameter is a substring of. (optional)
     * @param processDefinitionId Filter by the process definition the instances belongs to. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances belongs to. (optional)
     * @param processInstanceId Filter by the process instance the instances belongs to. (optional)
     * @param caseDefinitionId Filter by the case definition the instances belongs to. (optional)
     * @param caseDefinitionKey Filter by the key of the case definition the instances belongs to. (optional)
     * @param caseInstanceId Filter by the case instance the instances belongs to. (optional)
     * @param activityIdIn Filter by the activity ids the instances belongs to. Must be a comma-separated list of acitvity ids. (optional)
     * @param activityInstanceIdIn Filter by the activity instance ids the instances belongs to. Must be a comma-separated list of acitvity instance ids. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A historic decision instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic decision instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param evaluatedBefore Restrict to instances that were evaluated before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param evaluatedAfter Restrict to instances that were evaluated after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param userId Restrict to instances that were evaluated by the given user. (optional)
     * @param rootDecisionInstanceId Restrict to instances that have a given root decision instance id. This also includes the decision instance with the given id. (optional)
     * @param rootDecisionInstancesOnly Restrict to instances those are the root decision instance of an evaluation. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param decisionRequirementsDefinitionId Filter by the decision requirements definition the instances belongs to. (optional)
     * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition the instances belongs to. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricDecisionInstancesCountAsync(String decisionInstanceId, String decisionInstanceIdIn, String decisionDefinitionId, String decisionDefinitionIdIn, String decisionDefinitionKey, String decisionDefinitionKeyIn, String decisionDefinitionName, String decisionDefinitionNameLike, String processDefinitionId, String processDefinitionKey, String processInstanceId, String caseDefinitionId, String caseDefinitionKey, String caseInstanceId, String activityIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, Date evaluatedBefore, Date evaluatedAfter, String userId, String rootDecisionInstanceId, Boolean rootDecisionInstancesOnly, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricDecisionInstancesCountValidateBeforeCall(decisionInstanceId, decisionInstanceIdIn, decisionDefinitionId, decisionDefinitionIdIn, decisionDefinitionKey, decisionDefinitionKeyIn, decisionDefinitionName, decisionDefinitionNameLike, processDefinitionId, processDefinitionKey, processInstanceId, caseDefinitionId, caseDefinitionKey, caseInstanceId, activityIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, evaluatedBefore, evaluatedAfter, userId, rootDecisionInstanceId, rootDecisionInstancesOnly, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for setRemovalTimeAsyncHistoricDecisionInstance
     * @param setRemovalTimeToHistoricDecisionInstancesDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Request was unsuccessfull due to a bad user request. This occurs if some of the query parameters are invalid, e. g. if neither historicDecisionInstances nor historicDecisionInstanceQuery is present or if no mode is specified.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setRemovalTimeAsyncHistoricDecisionInstanceCall(SetRemovalTimeToHistoricDecisionInstancesDto setRemovalTimeToHistoricDecisionInstancesDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = setRemovalTimeToHistoricDecisionInstancesDto;

        // create path and map variables
        String localVarPath = "/history/decision-instance/set-removal-time";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setRemovalTimeAsyncHistoricDecisionInstanceValidateBeforeCall(SetRemovalTimeToHistoricDecisionInstancesDto setRemovalTimeToHistoricDecisionInstancesDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = setRemovalTimeAsyncHistoricDecisionInstanceCall(setRemovalTimeToHistoricDecisionInstancesDto, _callback);
        return localVarCall;

    }

    /**
     * Set Removal Time Async (POST)
     * Sets the removal time to multiple historic decision instances asynchronously (batch).  At least &#x60;historicDecisionInstanceIds&#x60; or &#x60;historicDecisionInstanceQuery&#x60; has to be provided. If both are provided, all instances matching query criterion and instances from the list will be updated with a removal time.
     * @param setRemovalTimeToHistoricDecisionInstancesDto  (optional)
     * @return BatchDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Request was unsuccessfull due to a bad user request. This occurs if some of the query parameters are invalid, e. g. if neither historicDecisionInstances nor historicDecisionInstanceQuery is present or if no mode is specified.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public BatchDto setRemovalTimeAsyncHistoricDecisionInstance(SetRemovalTimeToHistoricDecisionInstancesDto setRemovalTimeToHistoricDecisionInstancesDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = setRemovalTimeAsyncHistoricDecisionInstanceWithHttpInfo(setRemovalTimeToHistoricDecisionInstancesDto);
        return localVarResp.getData();
    }

    /**
     * Set Removal Time Async (POST)
     * Sets the removal time to multiple historic decision instances asynchronously (batch).  At least &#x60;historicDecisionInstanceIds&#x60; or &#x60;historicDecisionInstanceQuery&#x60; has to be provided. If both are provided, all instances matching query criterion and instances from the list will be updated with a removal time.
     * @param setRemovalTimeToHistoricDecisionInstancesDto  (optional)
     * @return ApiResponse&lt;BatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Request was unsuccessfull due to a bad user request. This occurs if some of the query parameters are invalid, e. g. if neither historicDecisionInstances nor historicDecisionInstanceQuery is present or if no mode is specified.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BatchDto> setRemovalTimeAsyncHistoricDecisionInstanceWithHttpInfo(SetRemovalTimeToHistoricDecisionInstancesDto setRemovalTimeToHistoricDecisionInstancesDto) throws ApiException {
        okhttp3.Call localVarCall = setRemovalTimeAsyncHistoricDecisionInstanceValidateBeforeCall(setRemovalTimeToHistoricDecisionInstancesDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Set Removal Time Async (POST) (asynchronously)
     * Sets the removal time to multiple historic decision instances asynchronously (batch).  At least &#x60;historicDecisionInstanceIds&#x60; or &#x60;historicDecisionInstanceQuery&#x60; has to be provided. If both are provided, all instances matching query criterion and instances from the list will be updated with a removal time.
     * @param setRemovalTimeToHistoricDecisionInstancesDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Request was unsuccessfull due to a bad user request. This occurs if some of the query parameters are invalid, e. g. if neither historicDecisionInstances nor historicDecisionInstanceQuery is present or if no mode is specified.  See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setRemovalTimeAsyncHistoricDecisionInstanceAsync(SetRemovalTimeToHistoricDecisionInstancesDto setRemovalTimeToHistoricDecisionInstancesDto, final ApiCallback<BatchDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = setRemovalTimeAsyncHistoricDecisionInstanceValidateBeforeCall(setRemovalTimeToHistoricDecisionInstancesDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
