/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cockpit.plugin.resource;

import java.util.List;
import org.camunda.bpm.cockpit.Cockpit;
import org.camunda.bpm.cockpit.db.CommandExecutor;
import org.camunda.bpm.cockpit.db.QueryParameters;
import org.camunda.bpm.cockpit.db.QueryService;
import org.camunda.bpm.cockpit.plugin.spi.CockpitPlugin;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.impl.db.AuthorizationCheck;
import org.camunda.bpm.engine.impl.db.PermissionCheck;
import org.camunda.bpm.engine.impl.db.TenantCheck;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.webapp.plugin.resource.AbstractAppPluginResource;

public class AbstractCockpitPluginResource
extends AbstractAppPluginResource<CockpitPlugin> {
    public AbstractCockpitPluginResource(String engineName) {
        super(Cockpit.getRuntimeDelegate(), engineName);
    }

    protected CommandExecutor getCommandExecutor() {
        return Cockpit.getCommandExecutor(this.engineName);
    }

    protected QueryService getQueryService() {
        return Cockpit.getQueryService(this.engineName);
    }

    protected boolean isAuthorizationEnabled() {
        return this.getProcessEngine().getProcessEngineConfiguration().isAuthorizationEnabled();
    }

    protected boolean isTenantCheckEnabled() {
        return this.getProcessEngine().getProcessEngineConfiguration().isTenantCheckEnabled() && this.getCurrentAuthentication() != null && !this.isCamundaAdmin(this.getCurrentAuthentication());
    }

    protected boolean isCamundaAdmin(Authentication authentication) {
        List groupIds = authentication.getGroupIds();
        if (groupIds != null) {
            return groupIds.contains("camunda-admin");
        }
        return false;
    }

    protected Authentication getCurrentAuthentication() {
        return this.getProcessEngine().getIdentityService().getCurrentAuthentication();
    }

    protected void configureAuthorizationCheck(QueryParameters query) {
        Authentication currentAuthentication = this.getCurrentAuthentication();
        AuthorizationCheck authCheck = query.getAuthCheck();
        authCheck.getPermissionChecks().clear();
        if (this.isAuthorizationEnabled() && currentAuthentication != null) {
            authCheck.setAuthorizationCheckEnabled(true);
            String currentUserId = currentAuthentication.getUserId();
            List currentGroupIds = currentAuthentication.getGroupIds();
            authCheck.setAuthUserId(currentUserId);
            authCheck.setAuthGroupIds(currentGroupIds);
        }
    }

    protected void configureTenantCheck(QueryParameters query) {
        TenantCheck tenantCheck = query.getTenantCheck();
        if (this.isTenantCheckEnabled()) {
            Authentication currentAuthentication = this.getCurrentAuthentication();
            tenantCheck.setTenantCheckEnabled(true);
            tenantCheck.setAuthTenantIds(currentAuthentication.getTenantIds());
        } else {
            tenantCheck.setTenantCheckEnabled(false);
            tenantCheck.setAuthTenantIds(null);
        }
    }

    protected void addPermissionCheck(QueryParameters query, Resource resource, String queryParam, Permission permission) {
        if (!this.isPermissionDisabled(permission)) {
            PermissionCheck permCheck = new PermissionCheck();
            permCheck.setResource(resource);
            permCheck.setResourceIdQueryParam(queryParam);
            permCheck.setPermission(permission);
            query.getAuthCheck().addAtomicPermissionCheck(permCheck);
        }
    }

    protected boolean isPermissionDisabled(Permission permission) {
        List disabledPermissions = this.getProcessEngine().getProcessEngineConfiguration().getDisabledPermissions();
        for (String disabledPerm : disabledPermissions) {
            if (disabledPerm.equals(permission.getName())) continue;
            return true;
        }
        return false;
    }
}

