/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.process_test_coverage.junit.rules;

import java.util.LinkedList;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.extension.process_test_coverage.listeners.CompensationEventCoverageHandler;
import org.camunda.bpm.extension.process_test_coverage.listeners.FlowNodeHistoryEventHandler;
import org.camunda.bpm.extension.process_test_coverage.listeners.PathCoverageParseListener;

public class ProcessCoverageConfigurator {
    public static void initializeProcessCoverageExtensions(ProcessEngineConfigurationImpl configuration) {
        ProcessCoverageConfigurator.initializeFlowNodeHandler(configuration);
        ProcessCoverageConfigurator.initializePathCoverageParseListener(configuration);
        ProcessCoverageConfigurator.initializeCompensationEventHandler(configuration);
    }

    private static void initializePathCoverageParseListener(ProcessEngineConfigurationImpl configuration) {
        LinkedList<PathCoverageParseListener> bpmnParseListeners = configuration.getCustomPostBPMNParseListeners();
        if (bpmnParseListeners == null) {
            bpmnParseListeners = new LinkedList<PathCoverageParseListener>();
            configuration.setCustomPostBPMNParseListeners(bpmnParseListeners);
        }
        bpmnParseListeners.add(new PathCoverageParseListener());
    }

    private static void initializeFlowNodeHandler(ProcessEngineConfigurationImpl configuration) {
        FlowNodeHistoryEventHandler historyEventHandler = new FlowNodeHistoryEventHandler();
        configuration.setHistoryEventHandler((HistoryEventHandler)historyEventHandler);
    }

    private static void initializeCompensationEventHandler(ProcessEngineConfigurationImpl configuration) {
        if (configuration.getCustomEventHandlers() == null) {
            configuration.setCustomEventHandlers(new LinkedList());
        }
        configuration.getCustomEventHandlers().add(new CompensationEventCoverageHandler());
    }
}

