/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.impl;

import java.io.IOException;
import java.util.Collection;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.camunda.bpm.client.exception.ConnectionLostException;
import org.camunda.bpm.client.exception.ExternalTaskClientException;
import org.camunda.bpm.client.exception.NotAcquiredException;
import org.camunda.bpm.client.exception.NotFoundException;
import org.camunda.bpm.client.exception.NotResumedException;
import org.camunda.bpm.client.exception.UnknownHttpErrorException;
import org.camunda.bpm.client.exception.ValueMapperException;
import org.camunda.bpm.client.impl.EngineClientException;
import org.camunda.bpm.client.impl.EngineClientLogger;
import org.camunda.bpm.client.spi.DataFormat;
import org.camunda.bpm.client.spi.DataFormatConfigurator;
import org.camunda.bpm.client.spi.DataFormatProvider;
import org.camunda.bpm.client.topic.impl.TopicSubscriptionManagerLogger;
import org.camunda.bpm.client.variable.impl.format.json.JacksonJsonLogger;
import org.camunda.bpm.client.variable.impl.format.serializable.SerializableLogger;
import org.camunda.bpm.client.variable.impl.format.xml.DomXmlLogger;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.commons.logging.BaseLogger;

public class ExternalTaskClientLogger
extends BaseLogger {
    protected static final String PROJECT_CODE = "TASK/CLIENT";
    protected static final String PROJECT_LOGGER = "org.camunda.bpm.client";
    public static final ExternalTaskClientLogger CLIENT_LOGGER = (ExternalTaskClientLogger)ExternalTaskClientLogger.createLogger(ExternalTaskClientLogger.class, (String)"TASK/CLIENT", (String)"org.camunda.bpm.client", (String)"01");
    public static final EngineClientLogger ENGINE_CLIENT_LOGGER = (EngineClientLogger)ExternalTaskClientLogger.createLogger(EngineClientLogger.class, (String)"TASK/CLIENT", (String)"org.camunda.bpm.client", (String)"02");
    public static final TopicSubscriptionManagerLogger TOPIC_SUBSCRIPTION_MANAGER_LOGGER = (TopicSubscriptionManagerLogger)ExternalTaskClientLogger.createLogger(TopicSubscriptionManagerLogger.class, (String)"TASK/CLIENT", (String)"org.camunda.bpm.client", (String)"03");
    public static final DomXmlLogger XML_FORMAT_LOGGER = (DomXmlLogger)ExternalTaskClientLogger.createLogger(DomXmlLogger.class, (String)"TASK/CLIENT", (String)"org.camunda.bpm.client", (String)"04");
    public static final JacksonJsonLogger JSON_FORMAT_LOGGER = (JacksonJsonLogger)ExternalTaskClientLogger.createLogger(JacksonJsonLogger.class, (String)"TASK/CLIENT", (String)"org.camunda.bpm.client", (String)"05");
    public static final SerializableLogger SERIALIZABLE_FORMAT_LOGGER = (SerializableLogger)ExternalTaskClientLogger.createLogger(SerializableLogger.class, (String)"TASK/CLIENT", (String)"org.camunda.bpm.client", (String)"06");

    public void logError(String id, String messageTemplate, Throwable t) {
        if (this.delegateLogger.isErrorEnabled()) {
            String msg = this.formatMessageTemplate(id, messageTemplate);
            this.delegateLogger.error(msg, t);
        }
    }

    public void logInfo(String id, String messageTemplate, Throwable t) {
        if (this.delegateLogger.isInfoEnabled()) {
            String msg = this.formatMessageTemplate(id, messageTemplate);
            this.delegateLogger.info(msg, t);
        }
    }

    protected ExternalTaskClientException baseUrlNullException() {
        return new ExternalTaskClientException(this.exceptionMessage("001", "Base URL cannot be null or an empty string", new Object[0]));
    }

    protected ExternalTaskClientException cannotGetHostnameException(Throwable cause) {
        return new ExternalTaskClientException(this.exceptionMessage("002", "Cannot get hostname", new Object[0]), cause);
    }

    public ExternalTaskClientException topicNameNullException() {
        return new ExternalTaskClientException(this.exceptionMessage("003", "Topic name cannot be null", new Object[0]));
    }

    public ExternalTaskClientException lockDurationIsNotGreaterThanZeroException(Long lockDuration) {
        return new ExternalTaskClientException(this.exceptionMessage("004", "Lock duration must be greater than 0, but was '{}'", new Object[]{lockDuration}));
    }

    public ExternalTaskClientException externalTaskHandlerNullException() {
        return new ExternalTaskClientException(this.exceptionMessage("005", "External task handler cannot be null", new Object[0]));
    }

    public ExternalTaskClientException topicNameAlreadySubscribedException(String topicName) {
        return new ExternalTaskClientException(this.exceptionMessage("006", "Topic name '{}' has already been subscribed", new Object[]{topicName}));
    }

    public ExternalTaskClientException externalTaskServiceException(String actionName, EngineClientException e) {
        Throwable causedException = e.getCause();
        if (causedException instanceof HttpResponseException) {
            switch (((HttpResponseException)causedException).getStatusCode()) {
                case 400: {
                    return new NotAcquiredException(this.exceptionMessage("007", "Exception while {}: The task's most recent lock could not be acquired", new Object[]{actionName}));
                }
                case 404: {
                    return new NotFoundException(this.exceptionMessage("008", "Exception while {}: The task could not be found", new Object[]{actionName}));
                }
                case 500: {
                    String processEngineError = e.getCause().getMessage();
                    String exceptionReason = processEngineError != null && !processEngineError.isEmpty() ? " Reason: " + processEngineError : "";
                    return new NotResumedException(this.exceptionMessage("009", "Exception while {}: The corresponding process instance could not be resumed.{}", new Object[]{actionName, exceptionReason}), processEngineError);
                }
            }
            int statusCode = ((HttpResponseException)causedException).getStatusCode();
            return new UnknownHttpErrorException(this.exceptionMessage("031", "Exception while performing an HTTP Request. The request failed with status code: {}.", new Object[]{statusCode}));
        }
        if (causedException instanceof ClientProtocolException || causedException instanceof IOException) {
            return new ConnectionLostException(this.exceptionMessage("010", "Exception while {}: Connection could not be established", new Object[]{actionName}));
        }
        return new ExternalTaskClientException(this.exceptionMessage("011", "Exception while {}: ", new Object[]{actionName}), e);
    }

    public ExternalTaskClientException basicAuthCredentialsNullException() {
        return new ExternalTaskClientException(this.exceptionMessage("012", "Basic authentication credentials (username, password) cannot be null", new Object[0]));
    }

    protected ExternalTaskClientException interceptorNullException() {
        return new ExternalTaskClientException(this.exceptionMessage("013", "Interceptor cannot be null", new Object[0]));
    }

    public ExternalTaskClientException maxTasksNotGreaterThanZeroException(Integer maxTasks) {
        return new ExternalTaskClientException(this.exceptionMessage("014", "Maximum amount of fetched tasks must be greater than zero, bus was '{}'", new Object[]{maxTasks}));
    }

    public ExternalTaskClientException asyncResponseTimeoutNotGreaterThanZeroException(Long asyncResponseTimeout) {
        return new ExternalTaskClientException(this.exceptionMessage("015", "Asynchronous response timeout must be greater than zero, but was '{}'", new Object[]{asyncResponseTimeout}));
    }

    public ValueMapperException valueMapperExceptionWhileParsingDate(String date, Exception e) {
        return new ValueMapperException(this.exceptionMessage("018", "Exception while mapping value: Cannot parse date '{}'", new Object[]{date}), e);
    }

    public ValueMapperException valueMapperExceptionDueToNoObjectTypeName() {
        return new ValueMapperException(this.exceptionMessage("019", "Exception while mapping value: Cannot write serialized value for variable: no 'objectTypeName' provided for non-null value.", new Object[0]));
    }

    public ValueMapperException valueMapperExceptionWhileSerializingObject(Exception e) {
        return new ValueMapperException(this.exceptionMessage("020", "Exception while mapping value: Cannot serialize object in variable.", new Object[0]), e);
    }

    public ValueMapperException valueMapperExceptionWhileDeserializingObject(Exception e) {
        return new ValueMapperException(this.exceptionMessage("021", "Exception while mapping value: Cannot deserialize object in variable.", new Object[0]), e);
    }

    public ValueMapperException valueMapperExceptionWhileSerializingAbstractValue(String name) {
        return new ValueMapperException(this.exceptionMessage("022", "Cannot serialize value of abstract type '{}'", new Object[]{name}));
    }

    public ValueMapperException valueMapperExceptionDueToSerializerNotFoundForTypedValue(TypedValue typedValue) {
        return new ValueMapperException(this.exceptionMessage("023", "Cannot find serializer for value '{}'", new Object[]{typedValue}));
    }

    public ValueMapperException valueMapperExceptionDueToSerializerNotFoundForTypedValueField(Object value) {
        return new ValueMapperException(this.exceptionMessage("024", "Cannot find serializer for value '{}'", new Object[]{value}));
    }

    public ValueMapperException cannotSerializeVariable(String variableName, Throwable e) {
        return new ValueMapperException(this.exceptionMessage("025", "Cannot serialize variable '{}'", new Object[]{variableName}), e);
    }

    public void logDataFormats(Collection<DataFormat> formats) {
        if (this.isInfoEnabled()) {
            for (DataFormat format : formats) {
                this.logDataFormat(format);
            }
        }
    }

    protected void logDataFormat(DataFormat dataFormat) {
        this.logInfo("025", "Discovered data format: {}[name = {}]", new Object[]{dataFormat.getClass().getName(), dataFormat.getName()});
    }

    public void logDataFormatProvider(DataFormatProvider provider) {
        if (this.isInfoEnabled()) {
            this.logInfo("026", "Discovered data format provider: {}[name = {}]", new Object[]{provider.getClass().getName(), provider.getDataFormatName()});
        }
    }

    public void logDataFormatConfigurator(DataFormatConfigurator configurator) {
        if (this.isInfoEnabled()) {
            this.logInfo("027", "Discovered data format configurator: {}[dataformat = {}]", new Object[]{configurator.getClass(), configurator.getDataFormatClass().getName()});
        }
    }

    public ExternalTaskClientException multipleProvidersForDataformat(String dataFormatName) {
        return new ExternalTaskClientException(this.exceptionMessage("028", "Multiple providers found for dataformat '{}'", new Object[]{dataFormatName}));
    }

    public ExternalTaskClientException cannotLoadDeferedFileValueException(String variableName, Exception e) {
        return new ExternalTaskClientException(this.exceptionMessage("029", "Variable '{}' of type file could not be retrieved", new Object[]{variableName}), e);
    }

    public ExternalTaskClientException passNullValueParameter(String parameterName) {
        return new ExternalTaskClientException(this.exceptionMessage("030", "Null value is not allowed as '{}'", new Object[]{parameterName}));
    }
}

