/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.topic.impl.dto;

import java.util.List;
import org.camunda.bpm.client.topic.TopicSubscription;

public class TopicRequestDto {
    protected String topicName;
    protected long lockDuration;
    protected List<String> variables;
    protected String businessKey;
    protected String processDefinitionId;
    protected List<String> processDefinitionIdIn;
    protected String processDefinitionKey;
    protected List<String> processDefinitionKeyIn;
    protected boolean withoutTenantId;
    protected List<String> tenantIdIn;

    public TopicRequestDto(String topicName, long lockDuration, List<String> variables, String businessKey) {
        this.topicName = topicName;
        this.lockDuration = lockDuration;
        this.variables = variables;
        this.businessKey = businessKey;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public long getLockDuration() {
        return this.lockDuration;
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public List<String> getProcessDefinitionIdIn() {
        return this.processDefinitionIdIn;
    }

    public void setProcessDefinitionIdIn(List<String> processDefinitionIds) {
        this.processDefinitionIdIn = processDefinitionIds;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public List<String> getProcessDefinitionKeyIn() {
        return this.processDefinitionKeyIn;
    }

    public void setProcessDefinitionKeyIn(List<String> processDefinitionKeys) {
        this.processDefinitionKeyIn = processDefinitionKeys;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public void setWithoutTenantId(boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public List<String> getTenantIdIn() {
        return this.tenantIdIn;
    }

    public void setTenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public static TopicRequestDto fromTopicSubscription(TopicSubscription topicSubscription, long clientLockDuration) {
        Long lockDuration = topicSubscription.getLockDuration();
        if (lockDuration == null) {
            lockDuration = clientLockDuration;
        }
        String topicName = topicSubscription.getTopicName();
        List<String> variables = topicSubscription.getVariableNames();
        String businessKey = topicSubscription.getBusinessKey();
        TopicRequestDto topicRequestDto = new TopicRequestDto(topicName, lockDuration, variables, businessKey);
        if (topicSubscription.getProcessDefinitionId() != null) {
            topicRequestDto.setProcessDefinitionId(topicSubscription.getProcessDefinitionId());
        }
        if (topicSubscription.getProcessDefinitionIdIn() != null) {
            topicRequestDto.setProcessDefinitionIdIn(topicSubscription.getProcessDefinitionIdIn());
        }
        if (topicSubscription.getProcessDefinitionKey() != null) {
            topicRequestDto.setProcessDefinitionKey(topicSubscription.getProcessDefinitionKey());
        }
        if (topicSubscription.getProcessDefinitionKeyIn() != null) {
            topicRequestDto.setProcessDefinitionKeyIn(topicSubscription.getProcessDefinitionKeyIn());
        }
        if (topicSubscription.isWithoutTenantId()) {
            topicRequestDto.setWithoutTenantId(topicSubscription.isWithoutTenantId());
        }
        if (topicSubscription.getTenantIdIn() != null) {
            topicRequestDto.setTenantIdIn(topicSubscription.getTenantIdIn());
        }
        return topicRequestDto;
    }
}

