/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.topic.impl;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.client.impl.ExternalTaskClientLogger;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.topic.TopicSubscription;
import org.camunda.bpm.client.topic.TopicSubscriptionBuilder;
import org.camunda.bpm.client.topic.impl.TopicSubscriptionImpl;
import org.camunda.bpm.client.topic.impl.TopicSubscriptionManager;

public class TopicSubscriptionBuilderImpl
implements TopicSubscriptionBuilder {
    protected static final ExternalTaskClientLogger LOG = ExternalTaskClientLogger.CLIENT_LOGGER;
    protected String topicName;
    protected Long lockDuration;
    protected List<String> variableNames;
    protected String businessKey;
    protected ExternalTaskHandler externalTaskHandler;
    protected TopicSubscriptionManager topicSubscriptionManager;

    public TopicSubscriptionBuilderImpl(String topicName, TopicSubscriptionManager topicSubscriptionManager) {
        this.topicName = topicName;
        this.variableNames = null;
        this.lockDuration = null;
        this.topicSubscriptionManager = topicSubscriptionManager;
    }

    @Override
    public TopicSubscriptionBuilder lockDuration(long lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    @Override
    public TopicSubscriptionBuilder handler(ExternalTaskHandler externalTaskHandler) {
        this.externalTaskHandler = externalTaskHandler;
        return this;
    }

    @Override
    public TopicSubscriptionBuilder variables(String ... variableNames) {
        this.variableNames = Arrays.asList(variableNames);
        return this;
    }

    @Override
    public TopicSubscriptionBuilder businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public TopicSubscription open() {
        if (this.topicName == null) {
            throw LOG.topicNameNullException();
        }
        if (this.lockDuration != null && this.lockDuration <= 0L) {
            throw LOG.lockDurationIsNotGreaterThanZeroException(this.lockDuration);
        }
        if (this.externalTaskHandler == null) {
            throw LOG.externalTaskHandlerNullException();
        }
        TopicSubscriptionImpl subscription = new TopicSubscriptionImpl(this.topicName, this.lockDuration, this.externalTaskHandler, this.topicSubscriptionManager, this.variableNames, this.businessKey);
        this.topicSubscriptionManager.subscribe(subscription);
        return subscription;
    }
}

