/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.topic.impl.dto;

import java.util.List;
import org.camunda.bpm.client.topic.TopicSubscription;

public class TopicRequestDto {
    protected String topicName;
    protected long lockDuration;
    protected List<String> variables;
    protected String businessKey;

    public TopicRequestDto(String topicName, long lockDuration, List<String> variables, String businessKey) {
        this.topicName = topicName;
        this.lockDuration = lockDuration;
        this.variables = variables;
        this.businessKey = businessKey;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public long getLockDuration() {
        return this.lockDuration;
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public static TopicRequestDto fromTopicSubscription(TopicSubscription topicSubscription, long clientLockDuration) {
        Long lockDuration = topicSubscription.getLockDuration();
        if (lockDuration == null) {
            lockDuration = clientLockDuration;
        }
        String topicName = topicSubscription.getTopicName();
        List<String> variables = topicSubscription.getVariableNames();
        String businessKey = topicSubscription.getBusinessKey();
        return new TopicRequestDto(topicName, lockDuration, variables, businessKey);
    }
}

