/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.topic.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.camunda.bpm.client.ClientBackoffStrategy;
import org.camunda.bpm.client.exception.ExternalTaskClientException;
import org.camunda.bpm.client.impl.EngineClient;
import org.camunda.bpm.client.impl.EngineClientException;
import org.camunda.bpm.client.impl.ExternalTaskClientLogger;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.impl.ExternalTaskImpl;
import org.camunda.bpm.client.task.impl.ExternalTaskServiceImpl;
import org.camunda.bpm.client.topic.TopicSubscription;
import org.camunda.bpm.client.topic.impl.TopicSubscriptionImpl;
import org.camunda.bpm.client.topic.impl.TopicSubscriptionManagerLogger;
import org.camunda.bpm.client.topic.impl.dto.TopicRequestDto;
import org.camunda.bpm.client.variable.impl.TypedValueField;
import org.camunda.bpm.client.variable.impl.TypedValues;
import org.camunda.bpm.client.variable.impl.VariableValue;

public class TopicSubscriptionManager
implements Runnable {
    protected static final TopicSubscriptionManagerLogger LOG = ExternalTaskClientLogger.TOPIC_SUBSCRIPTION_MANAGER_LOGGER;
    protected final Object MONITOR = new Object();
    protected ExternalTaskServiceImpl externalTaskService;
    protected EngineClient engineClient;
    protected List<TopicSubscription> subscriptions;
    protected List<TopicRequestDto> taskTopicRequests;
    protected Map<String, ExternalTaskHandler> externalTaskHandlers;
    protected volatile boolean isRunning;
    protected Thread thread;
    protected ClientBackoffStrategy backoffStrategy;
    protected TypedValues typedValues;
    protected long clientLockDuration;

    public TopicSubscriptionManager(EngineClient engineClient, TypedValues typedValues, long clientLockDuration) {
        this.engineClient = engineClient;
        this.subscriptions = new CopyOnWriteArrayList<TopicSubscription>();
        this.taskTopicRequests = new ArrayList<TopicRequestDto>();
        this.externalTaskHandlers = new HashMap<String, ExternalTaskHandler>();
        this.isRunning = false;
        this.clientLockDuration = clientLockDuration;
        this.typedValues = typedValues;
        this.externalTaskService = new ExternalTaskServiceImpl(engineClient);
    }

    @Override
    public void run() {
        while (this.isRunning) {
            try {
                this.acquire();
            }
            catch (Throwable e) {
                LOG.exceptionWhileAcquiringTasks(e);
            }
        }
    }

    protected void acquire() {
        this.taskTopicRequests.clear();
        this.externalTaskHandlers.clear();
        this.subscriptions.forEach(this::prepareAcquisition);
        if (!this.taskTopicRequests.isEmpty()) {
            List<ExternalTask> externalTasks = this.fetchAndLock(this.taskTopicRequests);
            externalTasks.forEach(externalTask -> {
                String topicName = externalTask.getTopicName();
                ExternalTaskHandler taskHandler = this.externalTaskHandlers.get(topicName);
                if (taskHandler != null) {
                    this.handleExternalTask((ExternalTask)externalTask, taskHandler);
                } else {
                    LOG.taskHandlerIsNull(topicName);
                }
            });
            if (this.backoffStrategy != null) {
                this.runBackoffStrategy(externalTasks.isEmpty());
            }
        }
    }

    protected void prepareAcquisition(TopicSubscription subscription) {
        TopicRequestDto taskTopicRequest = TopicRequestDto.fromTopicSubscription(subscription, this.clientLockDuration);
        this.taskTopicRequests.add(taskTopicRequest);
        String topicName = subscription.getTopicName();
        ExternalTaskHandler externalTaskHandler = subscription.getExternalTaskHandler();
        this.externalTaskHandlers.put(topicName, externalTaskHandler);
    }

    protected List<ExternalTask> fetchAndLock(List<TopicRequestDto> subscriptions) {
        List<ExternalTask> externalTasks = Collections.emptyList();
        try {
            externalTasks = this.engineClient.fetchAndLock(subscriptions);
        }
        catch (EngineClientException e) {
            LOG.exceptionWhilePerformingFetchAndLock(e);
        }
        return externalTasks;
    }

    protected void handleExternalTask(ExternalTask externalTask, ExternalTaskHandler taskHandler) {
        ExternalTaskImpl task = (ExternalTaskImpl)externalTask;
        Map<String, TypedValueField> variables = task.getVariables();
        Map<String, VariableValue> wrappedVariables = this.typedValues.wrapVariables(variables);
        task.setReceivedVariableMap(wrappedVariables);
        try {
            taskHandler.execute(task, this.externalTaskService);
        }
        catch (ExternalTaskClientException e) {
            LOG.exceptionOnExternalTaskServiceMethodInvocation(task.getTopicName(), e);
        }
        catch (Throwable e) {
            LOG.exceptionWhileExecutingExternalTaskHandler(task.getTopicName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.MONITOR;
        synchronized (object) {
            if (!this.isRunning || this.thread == null) {
                return;
            }
            this.isRunning = false;
            if (this.backoffStrategy != null) {
                this.resumeBackoffStrategy();
            }
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.exceptionWhileShuttingDown(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.MONITOR;
        synchronized (object) {
            if (this.isRunning && this.thread != null) {
                return;
            }
            this.isRunning = true;
            this.thread = new Thread((Runnable)this, TopicSubscriptionManager.class.getSimpleName());
            this.thread.start();
        }
    }

    protected synchronized void subscribe(TopicSubscriptionImpl subscription) {
        this.checkTopicNameAlreadySubscribed(subscription.getTopicName());
        this.subscriptions.add(subscription);
        if (this.backoffStrategy != null) {
            this.resumeBackoffStrategy();
        }
    }

    protected void checkTopicNameAlreadySubscribed(String topicName) {
        this.subscriptions.forEach(subscription -> {
            if (subscription.getTopicName().equals(topicName)) {
                throw LOG.topicNameAlreadySubscribedException(topicName);
            }
        });
    }

    protected void unsubscribe(TopicSubscriptionImpl subscription) {
        this.subscriptions.remove(subscription);
    }

    public EngineClient getEngineClient() {
        return this.engineClient;
    }

    public List<TopicSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setBackoffStrategy(ClientBackoffStrategy backOffStrategy) {
        this.backoffStrategy = backOffStrategy;
    }

    protected void runBackoffStrategy(boolean isExternalTasksEmpty) {
        try {
            if (isExternalTasksEmpty) {
                this.backoffStrategy.suspend();
            } else {
                this.backoffStrategy.reset();
            }
        }
        catch (Throwable e) {
            LOG.exceptionWhileExecutingBackoffStrategyMethod(e);
        }
    }

    protected void resumeBackoffStrategy() {
        try {
            this.backoffStrategy.resume();
        }
        catch (Throwable e) {
            LOG.exceptionWhileExecutingBackoffStrategyMethod(e);
        }
    }
}

