/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.client.impl.EngineClientException;
import org.camunda.bpm.client.impl.RequestExecutor;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.impl.ExternalTaskImpl;
import org.camunda.bpm.client.task.impl.dto.BpmnErrorRequestDto;
import org.camunda.bpm.client.task.impl.dto.CompleteRequestDto;
import org.camunda.bpm.client.task.impl.dto.ExtendLockRequestDto;
import org.camunda.bpm.client.task.impl.dto.FailureRequestDto;
import org.camunda.bpm.client.topic.impl.dto.FetchAndLockRequestDto;
import org.camunda.bpm.client.topic.impl.dto.TopicRequestDto;
import org.camunda.bpm.client.variable.impl.TypedValueField;
import org.camunda.bpm.client.variable.impl.TypedValues;

public class EngineClient {
    protected static final String EXTERNAL_TASK_RESOURCE_PATH = "/external-task";
    protected static final String FETCH_AND_LOCK_RESOURCE_PATH = "/external-task/fetchAndLock";
    public static final String ID_PATH_PARAM = "{id}";
    protected static final String ID_RESOURCE_PATH = "/external-task/{id}";
    public static final String UNLOCK_RESOURCE_PATH = "/external-task/{id}/unlock";
    public static final String COMPLETE_RESOURCE_PATH = "/external-task/{id}/complete";
    public static final String FAILURE_RESOURCE_PATH = "/external-task/{id}/failure";
    public static final String BPMN_ERROR_RESOURCE_PATH = "/external-task/{id}/bpmnError";
    public static final String EXTEND_LOCK_RESOURCE_PATH = "/external-task/{id}/extendLock";
    protected String baseUrl;
    protected String workerId;
    protected int maxTasks;
    protected Long asyncResponseTimeout;
    protected RequestExecutor engineInteraction;
    protected TypedValues typedValues;

    public EngineClient(String workerId, int maxTasks, Long asyncResponseTimeout, String baseUrl, RequestExecutor engineInteraction, TypedValues typedValues) {
        this.workerId = workerId;
        this.asyncResponseTimeout = asyncResponseTimeout;
        this.maxTasks = maxTasks;
        this.engineInteraction = engineInteraction;
        this.baseUrl = baseUrl;
        this.typedValues = typedValues;
    }

    public List<ExternalTask> fetchAndLock(List<TopicRequestDto> topics) throws EngineClientException {
        FetchAndLockRequestDto payload = new FetchAndLockRequestDto(this.workerId, this.maxTasks, this.asyncResponseTimeout, topics);
        String resourceUrl = this.baseUrl + FETCH_AND_LOCK_RESOURCE_PATH;
        ExternalTask[] externalTasks = this.engineInteraction.postRequest(resourceUrl, payload, ExternalTaskImpl[].class);
        return Arrays.asList(externalTasks);
    }

    public void unlock(String taskId) throws EngineClientException {
        String resourcePath = UNLOCK_RESOURCE_PATH.replace(ID_PATH_PARAM, taskId);
        String resourceUrl = this.baseUrl + resourcePath;
        this.engineInteraction.postRequest(resourceUrl, null, Void.class);
    }

    public void complete(String taskId, Map<String, Object> variables, Map<String, Object> localVariables) throws EngineClientException {
        Map<String, TypedValueField> typedValueDtoMap = this.typedValues.serializeVariables(variables);
        Map<String, TypedValueField> localTypedValueDtoMap = this.typedValues.serializeVariables(localVariables);
        CompleteRequestDto payload = new CompleteRequestDto(this.workerId, typedValueDtoMap, localTypedValueDtoMap);
        String resourcePath = COMPLETE_RESOURCE_PATH.replace(ID_PATH_PARAM, taskId);
        String resourceUrl = this.baseUrl + resourcePath;
        this.engineInteraction.postRequest(resourceUrl, payload, Void.class);
    }

    public void failure(String taskId, String errorMessage, String errorDetails, int retries, long retryTimeout) throws EngineClientException {
        FailureRequestDto payload = new FailureRequestDto(this.workerId, errorMessage, errorDetails, retries, retryTimeout);
        String resourcePath = FAILURE_RESOURCE_PATH.replace(ID_PATH_PARAM, taskId);
        String resourceUrl = this.baseUrl + resourcePath;
        this.engineInteraction.postRequest(resourceUrl, payload, Void.class);
    }

    public void bpmnError(String taskId, String errorCode) throws EngineClientException {
        BpmnErrorRequestDto payload = new BpmnErrorRequestDto(this.workerId, errorCode);
        String resourcePath = BPMN_ERROR_RESOURCE_PATH.replace(ID_PATH_PARAM, taskId);
        String resourceUrl = this.baseUrl + resourcePath;
        this.engineInteraction.postRequest(resourceUrl, payload, Void.class);
    }

    public void extendLock(String taskId, long newDuration) throws EngineClientException {
        ExtendLockRequestDto payload = new ExtendLockRequestDto(this.workerId, newDuration);
        String resourcePath = EXTEND_LOCK_RESOURCE_PATH.replace(ID_PATH_PARAM, taskId);
        String resourceUrl = this.baseUrl + resourcePath;
        this.engineInteraction.postRequest(resourceUrl, payload, Void.class);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getWorkerId() {
        return this.workerId;
    }
}

