/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.spring.impl.subscription;

import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.spring.impl.client.util.ClientLoggerUtil;
import org.camunda.bpm.client.spring.impl.subscription.SpringTopicSubscriptionImpl;
import org.camunda.bpm.client.spring.impl.subscription.SubscriptionConfiguration;
import org.camunda.bpm.client.spring.impl.subscription.util.SubscriptionLoggerUtil;
import org.camunda.bpm.client.spring.impl.util.AnnotationUtil;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;

public class SubscriptionPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    protected static final SubscriptionLoggerUtil LOG = ClientLoggerUtil.SUBSCRIPTION_LOGGER;
    protected Class<? extends SpringTopicSubscriptionImpl> springTopicSubscription;

    public SubscriptionPostProcessor() {
        this(SpringTopicSubscriptionImpl.class);
    }

    public SubscriptionPostProcessor(Class<? extends SpringTopicSubscriptionImpl> springTopicSubscription) {
        this.springTopicSubscription = springTopicSubscription;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        ListableBeanFactory listableBeanFactory = (ListableBeanFactory)registry;
        String[] handlerBeans = listableBeanFactory.getBeanNamesForType(ExternalTaskHandler.class);
        LOG.handlerBeansFound(ExternalTaskHandler.class, handlerBeans);
        for (String handlerBeanName : handlerBeans) {
            BeanDefinition handlerBeanDefinition = registry.getBeanDefinition(handlerBeanName);
            ExternalTaskSubscription subscriptionAnnotation = this.findSubscriptionAnnotation(handlerBeanDefinition);
            if (subscriptionAnnotation == null) continue;
            SubscriptionConfiguration subscriptionConfiguration = new SubscriptionConfiguration();
            subscriptionConfiguration.fromAnnotation(subscriptionAnnotation);
            BeanDefinition subscriptionBeanDefinition = this.getBeanDefinition(handlerBeanName, subscriptionConfiguration);
            String subscriptionBeanName = handlerBeanName + "Subscription";
            registry.registerBeanDefinition(subscriptionBeanName, subscriptionBeanDefinition);
            LOG.beanRegistered(subscriptionBeanName, handlerBeanName);
        }
    }

    protected BeanDefinition getBeanDefinition(String beanName, SubscriptionConfiguration subscriptionConfiguration) {
        return BeanDefinitionBuilder.genericBeanDefinition(this.springTopicSubscription).addPropertyReference("externalTaskHandler", beanName).addPropertyValue("subscriptionConfiguration", (Object)subscriptionConfiguration).setDestroyMethodName("closeInternally").getBeanDefinition();
    }

    protected ExternalTaskSubscription findSubscriptionAnnotation(BeanDefinition beanDefinition) {
        ExternalTaskSubscription annotation = null;
        if (beanDefinition instanceof AnnotatedBeanDefinition) {
            AnnotatedBeanDefinition annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition;
            MethodMetadata metadata = annotatedBeanDefinition.getFactoryMethodMetadata();
            if (metadata == null) {
                metadata = annotatedBeanDefinition.getMetadata();
            }
            annotation = AnnotationUtil.get(ExternalTaskSubscription.class, (AnnotatedTypeMetadata)metadata);
        }
        if (annotation == null) {
            LOG.notFound(beanDefinition);
        } else {
            LOG.found(annotation, beanDefinition);
        }
        return annotation;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }
}

