/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable.serializer;

import org.camunda.bpm.engine.impl.core.variable.value.UntypedValueImpl;
import org.camunda.bpm.engine.impl.variable.serializer.PrimitiveValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.ShortValue;

public class ShortValueSerializer
extends PrimitiveValueSerializer<ShortValue> {
    public ShortValueSerializer() {
        super(ValueType.SHORT);
    }

    @Override
    public ShortValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return Variables.shortValue((Short)untypedValue.getValue());
    }

    @Override
    public ShortValue readValue(ValueFields valueFields) {
        Long longValue = valueFields.getLongValue();
        Short shortValue = null;
        if (longValue != null) {
            shortValue = new Short(longValue.shortValue());
        }
        return Variables.shortValue(shortValue);
    }

    @Override
    public void writeValue(ShortValue value, ValueFields valueFields) {
        Short shortValue = (Short)value.getValue();
        if (shortValue != null) {
            valueFields.setLongValue(shortValue.longValue());
            valueFields.setTextValue(value.toString());
        } else {
            valueFields.setLongValue(null);
            valueFields.setTextValue(null);
        }
    }
}

