/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.impl.ExecutionQueryImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.runtime.CorrelationHandler;
import org.camunda.bpm.engine.impl.runtime.CorrelationSet;
import org.camunda.bpm.engine.impl.runtime.MessageCorrelationResult;
import org.camunda.bpm.engine.runtime.Execution;

public class DefaultCorrelationHandler
implements CorrelationHandler {
    private static final Logger LOGGER = Logger.getLogger(DefaultCorrelationHandler.class.getName());

    @Override
    public MessageCorrelationResult correlateMessage(CommandContext commandContext, String messageName, CorrelationSet correlationSet) {
        List<MessageCorrelationResult> correlations = this.correlateMessageToExecutions(commandContext, messageName, correlationSet);
        if (correlations.size() > 1) {
            throw new MismatchingMessageCorrelationException(messageName, correlationSet.getBusinessKey(), correlationSet.getCorrelationKeys(), String.valueOf(correlations.size()) + " executions match the correlation keys. Should be one or zero.");
        }
        if (!correlations.isEmpty()) {
            return correlations.get(0);
        }
        return this.tryCorrelateMessageToProcessDefinition(commandContext, messageName, correlationSet);
    }

    @Override
    public List<MessageCorrelationResult> correlateMessages(CommandContext commandContext, String messageName, CorrelationSet correlationSet) {
        ArrayList<MessageCorrelationResult> result = new ArrayList<MessageCorrelationResult>();
        result.addAll(this.correlateMessageToExecutions(commandContext, messageName, correlationSet));
        MessageCorrelationResult processDefinitionCorrelation = this.tryCorrelateMessageToProcessDefinition(commandContext, messageName, correlationSet);
        if (processDefinitionCorrelation != null) {
            result.add(processDefinitionCorrelation);
        }
        return result;
    }

    protected List<MessageCorrelationResult> correlateMessageToExecutions(CommandContext commandContext, String messageName, CorrelationSet correlationSet) {
        String processInstanceId;
        String businessKey;
        ExecutionQueryImpl query = new ExecutionQueryImpl();
        Map<String, Object> correlationKeys = correlationSet.getCorrelationKeys();
        if (correlationKeys != null) {
            for (Map.Entry<String, Object> correlationKey : correlationKeys.entrySet()) {
                query.processVariableValueEquals(correlationKey.getKey(), correlationKey.getValue());
            }
        }
        if ((businessKey = correlationSet.getBusinessKey()) != null) {
            query.processInstanceBusinessKey(businessKey);
        }
        if ((processInstanceId = correlationSet.getProcessInstanceId()) != null) {
            query.processInstanceId(processInstanceId);
        }
        if (messageName != null) {
            query.messageEventSubscriptionName(messageName);
        } else {
            query.messageEventSubscription();
        }
        List matchingExecutions = query.evaluateExpressionsAndExecuteList(commandContext, null);
        ArrayList<MessageCorrelationResult> result = new ArrayList<MessageCorrelationResult>(matchingExecutions.size());
        for (Execution matchingExecution : matchingExecutions) {
            result.add(MessageCorrelationResult.matchedExecution((ExecutionEntity)matchingExecution));
        }
        return result;
    }

    protected MessageCorrelationResult tryCorrelateMessageToProcessDefinition(CommandContext commandContext, String messageName, CorrelationSet correlationSet) {
        String processDefinitionId;
        if (messageName == null) {
            return null;
        }
        MessageEventSubscriptionEntity messageEventSubscription = commandContext.getEventSubscriptionManager().findMessageStartEventSubscriptionByName(messageName);
        if (messageEventSubscription == null || messageEventSubscription.getConfiguration() == null) {
            return null;
        }
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId = messageEventSubscription.getConfiguration());
        if (processDefinition == null) {
            LOGGER.log(Level.FINE, "Found event subscription with {0} but process definition {1} could not be found.", new Object[]{messageEventSubscription, processDefinitionId});
            return null;
        }
        return MessageCorrelationResult.matchedProcessDefinition(processDefinition, messageEventSubscription.getActivityId());
    }
}

