/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime.operation;

import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperationActivityInstanceEnd;

public class PvmAtomicOperationDeleteCascadeFireActivityEnd
extends PvmAtomicOperationActivityInstanceEnd {
    @Override
    protected boolean isSkipNotifyListeners(PvmExecutionImpl execution) {
        return false;
    }

    @Override
    protected PvmExecutionImpl eventNotificationsStarted(PvmExecutionImpl execution) {
        execution.setCanceled(true);
        return super.eventNotificationsStarted(execution);
    }

    @Override
    protected ScopeImpl getScope(PvmExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        if (activity != null) {
            return activity;
        }
        PvmExecutionImpl parent = execution.getParent();
        if (parent != null) {
            return this.getScope(execution.getParent());
        }
        return execution.getProcessDefinition();
    }

    @Override
    protected String getEventName() {
        return "end";
    }

    @Override
    protected void eventNotificationsCompleted(PvmExecutionImpl execution) {
        super.eventNotificationsCompleted(execution);
        ActivityImpl activity = execution.getActivity();
        if (execution.isScope() && activity != null && !activity.isScope()) {
            execution.setActivity(activity.getParentActivity());
            execution.performOperation(DELETE_CASCADE_FIRE_ACTIVITY_END);
        } else {
            PvmExecutionImpl parent;
            if (execution.isScope()) {
                execution.destroy();
            }
            execution.remove();
            if (!execution.isDeleteRoot() && (parent = execution.getParent()) != null) {
                if (parent.getActivity() == null && activity != null && activity.getParentActivity() != null) {
                    parent.setActivity(activity.getParentActivity());
                }
                parent.performOperation(DELETE_CASCADE);
            }
        }
    }

    @Override
    public String getCanonicalName() {
        return "delete-cascade-fire-activity-end";
    }
}

