/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.form.validator;

import java.util.concurrent.Callable;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.form.validator.FormFieldValidator;
import org.camunda.bpm.engine.impl.form.validator.FormFieldValidatorContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.util.ReflectUtil;

public class DelegateFormFieldValidator
implements FormFieldValidator {
    protected String clazz;
    protected Expression delegateExpression;

    public DelegateFormFieldValidator(Expression expression) {
        this.delegateExpression = expression;
    }

    public DelegateFormFieldValidator(String clazz) {
        this.clazz = clazz;
    }

    public DelegateFormFieldValidator() {
    }

    @Override
    public boolean validate(final Object submittedValue, final FormFieldValidatorContext validatorContext) {
        DelegateExecution execution = validatorContext.getExecution();
        if (this.shouldPerformPaContextSwitch(validatorContext.getExecution())) {
            return Context.executeWithinProcessApplication(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return DelegateFormFieldValidator.this.doValidate(submittedValue, validatorContext);
                }
            }, ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution));
        }
        return this.doValidate(submittedValue, validatorContext);
    }

    protected boolean shouldPerformPaContextSwitch(DelegateExecution execution) {
        if (execution == null) {
            return false;
        }
        ProcessApplicationReference targetPa = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
        return targetPa != null && !targetPa.equals(Context.getCurrentProcessApplication());
    }

    protected boolean doValidate(Object submittedValue, FormFieldValidatorContext validatorContext) {
        if (this.clazz != null) {
            Object validatorObject = ReflectUtil.instantiate(this.clazz);
            if (validatorObject instanceof FormFieldValidator) {
                FormFieldValidator validator = (FormFieldValidator)validatorObject;
                return validator.validate(submittedValue, validatorContext);
            }
            throw new ProcessEngineException("Validator class '" + this.clazz + "' is not an instance of " + FormFieldValidator.class.getName());
        }
        Object validatorObject = this.delegateExpression.getValue(validatorContext.getExecution());
        if (validatorObject instanceof FormFieldValidator) {
            FormFieldValidator validator = (FormFieldValidator)validatorObject;
            return validator.validate(submittedValue, validatorContext);
        }
        throw new ProcessEngineException("Validator expression '" + this.delegateExpression + "' does not resolve to instance of " + FormFieldValidator.class.getName());
    }
}

