/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db;

import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DbSchemaExecuteFile {
    public static void main(String[] args) {
        if (args.length != 2) {
            throw new ProcessEngineException("Schema resource tool must be invoked with exactly 2 parameters: \n - 1st parameter is process engine configuration file, \n - 2nd parameter is schema resource file name");
        }
        String configurationFileResourceName = args[0];
        final String schemaFileResourceName = args[1];
        EnsureUtil.ensureNotNull("Process engine configuration file name cannot be null", "configurationFileResourceName", (Object)configurationFileResourceName);
        EnsureUtil.ensureNotNull("Schema resource file name cannot be null", "schemaFileResourceName", (Object)schemaFileResourceName);
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource(configurationFileResourceName);
        ProcessEngine processEngine = configuration.buildProcessEngine();
        configuration.getCommandExecutorTxRequired().execute(new Command<Void>(){

            @Override
            public Void execute(CommandContext commandContext) {
                commandContext.getDbSqlSession().executeSchemaResource(schemaFileResourceName);
                return null;
            }
        });
        processEngine.close();
    }
}

