/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.behavior;

import org.camunda.bpm.engine.exception.cmmn.CaseIllegalStateTransitionException;
import org.camunda.bpm.engine.impl.cmmn.behavior.PlanItemDefinitionActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;

public abstract class EventListenerOrMilestoneActivityBehavior
extends PlanItemDefinitionActivityBehavior {
    @Override
    public void onEnable(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("enable", execution);
    }

    @Override
    public void onReenable(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("reenable", execution);
    }

    @Override
    public void onDisable(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("disable", execution);
    }

    @Override
    public void onStart(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("start", execution);
    }

    @Override
    public void onManualStart(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("manualStart", execution);
    }

    @Override
    public void onCompletion(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("complete", execution);
    }

    @Override
    public void onManualCompletion(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("complete", execution);
    }

    @Override
    public void onTermination(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.AVAILABLE, CaseExecutionState.TERMINATED, "terminate");
        this.performTerminate(execution);
    }

    @Override
    public void onParentTermination(CmmnActivityExecution execution) {
        String id = execution.getId();
        if (execution.isCompleted()) {
            String message = "Case execution '" + id + "' must be available or suspended, but was completed.";
            throw this.createIllegalStateTransitionException("parentTerminate", message, execution);
        }
        this.performParentTerminate(execution);
    }

    @Override
    public void onExit(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("exit", execution);
    }

    @Override
    public void onOccur(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.AVAILABLE, CaseExecutionState.COMPLETED, "occur");
    }

    @Override
    public void onSuspension(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.AVAILABLE, CaseExecutionState.SUSPENDED, "suspend");
        this.performSuspension(execution);
    }

    @Override
    public void onParentSuspension(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("parentSuspend", execution);
    }

    @Override
    public void onResume(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.SUSPENDED, CaseExecutionState.AVAILABLE, "resume");
        CmmnActivityExecution parent = execution.getParent();
        if (parent != null && !parent.isActive()) {
            String id = execution.getId();
            String message = "It is not possible to resume case execution '" + id + "' which parent is not active.";
            throw this.createIllegalStateTransitionException("resume", message, execution);
        }
        this.resuming(execution);
    }

    @Override
    public void onParentResume(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("parentResume", execution);
    }

    @Override
    public void onReactivation(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("reactivate", execution);
    }

    @Override
    protected boolean isAtLeastOneExitCriteriaSatisfied(CmmnActivityExecution execution) {
        return false;
    }

    @Override
    public void fireExitCriteria(CmmnActivityExecution execution) {
        throw new CaseIllegalStateTransitionException("Cannot trigger case execution '" + execution.getId() + "': exit criteria are not allowed for event listener.");
    }

    protected CaseIllegalStateTransitionException createIllegalStateTransitionException(String transition, CmmnActivityExecution execution) {
        String id = execution.getId();
        String message = String.format("It is not possible to %s case execution '%s' which associated with a %s.", transition, id, this.getTypeName());
        return this.createIllegalStateTransitionException(transition, message, execution);
    }

    protected abstract String getTypeName();
}

