/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.calendar.DurationHelper;
import org.camunda.bpm.engine.impl.cfg.TransactionContext;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.cmd.DecrementJobRetriesCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.MessageAddedNotification;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;

public class FoxJobRetryCmd
implements Command<Object> {
    private static final Logger log = Logger.getLogger(FoxJobRetryCmd.class.getName());
    protected String jobId;
    protected Throwable exception;

    public FoxJobRetryCmd(String jobId, Throwable exception) {
        this.jobId = jobId;
        this.exception = exception;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        JobEntity job = Context.getCommandContext().getJobManager().findJobById(this.jobId);
        ActivityImpl activity = this.getCurrentActivity(commandContext, job);
        if (activity == null) {
            log.log(Level.SEVERE, "Failure while executing " + FoxJobRetryCmd.class.getName() + " for job id '" + this.jobId + "'. Falling back to standard job retry strategy.");
            this.executeStandardStrategy(commandContext);
        } else {
            try {
                this.executeCustomStrategy(commandContext, job, activity);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failure while executing " + FoxJobRetryCmd.class.getName() + " for job id '" + this.jobId + "'. Falling back to standard job retry strategy.", e);
                this.executeStandardStrategy(commandContext);
            }
        }
        return null;
    }

    private void executeCustomStrategy(CommandContext commandContext, JobEntity job, ActivityImpl activity) throws Exception {
        String failedJobRetryTimeCycle = (String)activity.getProperty("FOX_FAILED_JOB_CONFIGURATION");
        if (failedJobRetryTimeCycle == null) {
            this.executeStandardStrategy(commandContext);
        } else {
            DurationHelper durationHelper = new DurationHelper(failedJobRetryTimeCycle);
            job.setLockExpirationTime(durationHelper.getDateAfter());
            if (job.getExceptionByteArrayId() == null && job.getExceptionMessage() == null) {
                log.fine("Applying JobRetryStrategy '" + failedJobRetryTimeCycle + "' the first time for job " + job.getId() + " with " + durationHelper.getTimes() + " retries");
                job.setRetries(durationHelper.getTimes());
            } else {
                log.fine("Decrementing retries of JobRetryStrategy '" + failedJobRetryTimeCycle + "' for job " + job.getId());
            }
            if (this.exception != null) {
                job.setExceptionMessage(this.exception.getMessage());
                job.setExceptionStacktrace(this.getExceptionStacktrace());
            }
            if (this.exception == null || this.shouldDecrementRetriesFor(this.exception)) {
                job.setRetries(job.getRetries() - 1);
            }
            JobExecutor jobExecutor = Context.getProcessEngineConfiguration().getJobExecutor();
            MessageAddedNotification messageAddedNotification = new MessageAddedNotification(jobExecutor);
            TransactionContext transactionContext = commandContext.getTransactionContext();
            transactionContext.addTransactionListener(TransactionState.COMMITTED, messageAddedNotification);
        }
    }

    private ActivityImpl getCurrentActivity(CommandContext commandContext, JobEntity job) {
        ExecutionEntity execution;
        String type = job.getJobHandlerType();
        ActivityImpl activity = null;
        if ("timer-transition".equals(type) || "timer-intermediate-transition".equals(type)) {
            ExecutionEntity execution2 = this.fetchExecutionEntity(job.getExecutionId());
            if (execution2 != null) {
                activity = execution2.getProcessDefinition().findActivity(job.getJobHandlerConfiguration());
            }
        } else if ("timer-start-event".equals(type)) {
            DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
            ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedLatestProcessDefinitionByKey(job.getJobHandlerConfiguration());
            if (processDefinition != null) {
                activity = processDefinition.getInitial();
            }
        } else if ("async-continuation".equals(type) && (execution = this.fetchExecutionEntity(job.getExecutionId())) != null) {
            activity = execution.getActivity();
        }
        return activity;
    }

    private String getExceptionStacktrace() {
        StringWriter stringWriter = new StringWriter();
        this.exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private ExecutionEntity fetchExecutionEntity(String executionId) {
        return Context.getCommandContext().getExecutionManager().findExecutionById(executionId);
    }

    private void executeStandardStrategy(CommandContext commandContext) {
        DecrementJobRetriesCmd decrementCmd = new DecrementJobRetriesCmd(this.jobId, this.exception);
        decrementCmd.execute(commandContext);
    }

    protected boolean shouldDecrementRetriesFor(Throwable t) {
        return !(t instanceof OptimisticLockingException);
    }
}

