/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Map;
import org.camunda.bpm.engine.impl.MessageCorrelationBuilderImpl;
import org.camunda.bpm.engine.impl.cmd.MessageEventReceivedCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.runtime.MessageCorrelationResult;

public abstract class AbstractCorrelateMessageCmd
implements Command<Void> {
    protected final String messageName;
    protected final String businessKey;
    protected final Map<String, Object> correlationKeys;
    protected final Map<String, Object> processVariables;
    protected String processInstanceId;

    protected AbstractCorrelateMessageCmd(String messageName, String businessKey, Map<String, Object> correlationKeys, Map<String, Object> processVariables) {
        this.messageName = messageName;
        this.businessKey = businessKey;
        this.correlationKeys = correlationKeys;
        this.processVariables = processVariables;
    }

    protected AbstractCorrelateMessageCmd(MessageCorrelationBuilderImpl messageCorrelationBuilderImpl) {
        this.messageName = messageCorrelationBuilderImpl.getMessageName();
        this.processVariables = messageCorrelationBuilderImpl.getPayloadProcessInstanceVariables();
        this.correlationKeys = messageCorrelationBuilderImpl.getCorrelationProcessInstanceVariables();
        this.businessKey = messageCorrelationBuilderImpl.getBusinessKey();
        this.processInstanceId = messageCorrelationBuilderImpl.getProcessInstanceId();
    }

    protected void triggerExecution(CommandContext commandContext, MessageCorrelationResult correlationResult) {
        new MessageEventReceivedCmd(this.messageName, correlationResult.getExecutionEntity().getId(), this.processVariables).execute(commandContext);
    }

    protected void instantiateProcess(CommandContext commandContext, MessageCorrelationResult correlationResult) {
        ProcessDefinitionEntity processDefinitionEntity = correlationResult.getProcessDefinitionEntity();
        ActivityImpl messageStartEvent = processDefinitionEntity.findActivity(correlationResult.getStartEventActivityId());
        ExecutionEntity processInstance = processDefinitionEntity.createProcessInstance(this.businessKey, messageStartEvent);
        processInstance.start(this.processVariables);
    }
}

