/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cfg.auth;

import java.util.ArrayList;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;

public class DefaultAuthorizationProvider
implements ResourceAuthorizationProvider {
    @Override
    public AuthorizationEntity[] newUser(User user) {
        AuthorizationEntity resourceOwnerAuthorization = new AuthorizationEntity(1);
        resourceOwnerAuthorization.setUserId(user.getId());
        resourceOwnerAuthorization.setResource(Resources.USER);
        resourceOwnerAuthorization.setResourceId(user.getId());
        resourceOwnerAuthorization.addPermission(Permissions.ALL);
        return new AuthorizationEntity[]{resourceOwnerAuthorization};
    }

    @Override
    public AuthorizationEntity[] newGroup(Group group) {
        ArrayList<AuthorizationEntity> authorizations = new ArrayList<AuthorizationEntity>();
        AuthorizationEntity groupMemberAuthorization = new AuthorizationEntity(1);
        groupMemberAuthorization.setGroupId(group.getId());
        groupMemberAuthorization.setResource(Resources.GROUP);
        groupMemberAuthorization.setResourceId(group.getId());
        groupMemberAuthorization.addPermission(Permissions.READ);
        authorizations.add(groupMemberAuthorization);
        return authorizations.toArray(new AuthorizationEntity[0]);
    }

    @Override
    public AuthorizationEntity[] groupMembershipCreated(String groupId, String userId) {
        return null;
    }

    @Override
    public AuthorizationEntity[] newFilter(Filter filter) {
        if (filter.getOwner() != null) {
            AuthorizationEntity filterOwnerAuthorization = new AuthorizationEntity(1);
            filterOwnerAuthorization.setUserId(filter.getOwner());
            filterOwnerAuthorization.setResource(Resources.FILTER);
            filterOwnerAuthorization.setResourceId(filter.getId());
            filterOwnerAuthorization.addPermission(Permissions.ALL);
            return new AuthorizationEntity[]{filterOwnerAuthorization};
        }
        return null;
    }
}

