/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.parser;

import java.io.InputStream;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.BpmnParseException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.Condition;
import org.camunda.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.CallActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.CancelBoundaryEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.CancelEndEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ClassDelegateActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ErrorEndEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.EventBasedGatewayActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.EventSubProcessStartEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ExclusiveGatewayActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.InclusiveGatewayActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.IntermediateCatchEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.IntermediateCatchLinkEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.IntermediateThrowCompensationEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.IntermediateThrowNoneEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.IntermediateThrowSignalEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.MailActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ManualTaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.NoneEndEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.NoneStartEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ParallelGatewayActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ReceiveTaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ScriptTaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ServiceTaskDelegateExpressionActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ServiceTaskExpressionActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ShellActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.SignalEndEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.SubProcessActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.TerminateEndEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.TransactionActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.listener.ClassDelegateExecutionListener;
import org.camunda.bpm.engine.impl.bpmn.listener.DelegateExpressionExecutionListener;
import org.camunda.bpm.engine.impl.bpmn.listener.ExpressionExecutionListener;
import org.camunda.bpm.engine.impl.bpmn.listener.ScriptExecutionListener;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParseListener;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParser;
import org.camunda.bpm.engine.impl.bpmn.parser.CompensateEventDefinition;
import org.camunda.bpm.engine.impl.bpmn.parser.DataAssociation;
import org.camunda.bpm.engine.impl.bpmn.parser.Error;
import org.camunda.bpm.engine.impl.bpmn.parser.ErrorEventDefinition;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.camunda.bpm.engine.impl.bpmn.parser.MessageDefinition;
import org.camunda.bpm.engine.impl.bpmn.parser.SignalDefinition;
import org.camunda.bpm.engine.impl.bpmn.parser.XMLImporter;
import org.camunda.bpm.engine.impl.core.variable.mapping.IoMapping;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.el.FixedValue;
import org.camunda.bpm.engine.impl.el.UelExpressionCondition;
import org.camunda.bpm.engine.impl.form.handler.DefaultStartFormHandler;
import org.camunda.bpm.engine.impl.form.handler.DefaultTaskFormHandler;
import org.camunda.bpm.engine.impl.form.handler.StartFormHandler;
import org.camunda.bpm.engine.impl.form.handler.TaskFormHandler;
import org.camunda.bpm.engine.impl.jobexecutor.AsyncAfterMessageJobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.AsyncBeforeMessageJobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.MessageJobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationType;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.HasDIBounds;
import org.camunda.bpm.engine.impl.pvm.process.Lane;
import org.camunda.bpm.engine.impl.pvm.process.LaneSet;
import org.camunda.bpm.engine.impl.pvm.process.ParticipantProcess;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.scripting.ExecutableScript;
import org.camunda.bpm.engine.impl.scripting.ScriptCondition;
import org.camunda.bpm.engine.impl.task.TaskDecorator;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.impl.task.listener.ClassDelegateTaskListener;
import org.camunda.bpm.engine.impl.task.listener.DelegateExpressionTaskListener;
import org.camunda.bpm.engine.impl.task.listener.ExpressionTaskListener;
import org.camunda.bpm.engine.impl.task.listener.ScriptTaskListener;
import org.camunda.bpm.engine.impl.util.BpmnParseUtil;
import org.camunda.bpm.engine.impl.util.ClassDelegateUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.engine.impl.util.ScriptUtil;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.camunda.bpm.engine.impl.util.xml.Parse;
import org.camunda.bpm.engine.impl.variable.VariableDeclaration;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class BpmnParse
extends Parse {
    protected static final Logger LOGGER = Logger.getLogger(BpmnParse.class.getName());
    public static final String PROPERTYNAME_DOCUMENTATION = "documentation";
    public static final String PROPERTYNAME_INITIAL = "initial";
    public static final String PROPERTYNAME_INITIATOR_VARIABLE_NAME = "initiatorVariableName";
    public static final String PROPERTYNAME_CONDITION = "condition";
    public static final String PROPERTYNAME_CONDITION_TEXT = "conditionText";
    public static final String PROPERTYNAME_VARIABLE_DECLARATIONS = "variableDeclarations";
    public static final String PROPERTYNAME_TIMER_DECLARATION = "timerDeclarations";
    public static final String PROPERTYNAME_MESSAGE_JOB_DECLARATION = "messageJobDeclaration";
    public static final String PROPERTYNAME_ISEXPANDED = "isExpanded";
    public static final String PROPERTYNAME_START_TIMER = "timerStart";
    public static final String PROPERTYNAME_COMPENSATION_HANDLER_ID = "compensationHandler";
    public static final String PROPERTYNAME_IS_FOR_COMPENSATION = "isForCompensation";
    public static final String PROPERTYNAME_ERROR_EVENT_DEFINITIONS = "errorEventDefinitions";
    public static final String PROPERTYNAME_EVENT_SUBSCRIPTION_DECLARATION = "eventDefinitions";
    public static final String PROPERTYNAME_TRIGGERED_BY_EVENT = "triggeredByEvent";
    public static final String PROPERTYNAME_TYPE = "type";
    protected static final String POTENTIAL_STARTER = "potentialStarter";
    protected static final String CANDIDATE_STARTER_USERS_EXTENSION = "candidateStarterUsers";
    protected static final String CANDIDATE_STARTER_GROUPS_EXTENSION = "candidateStarterGroups";
    protected static final String ATTRIBUTEVALUE_T_FORMAL_EXPRESSION = "http://www.omg.org/spec/BPMN/20100524/MODEL:tFormalExpression";
    protected DeploymentEntity deployment;
    protected List<ProcessDefinitionEntity> processDefinitions = new ArrayList<ProcessDefinitionEntity>();
    protected Map<String, Error> errors = new HashMap<String, Error>();
    protected Map<String, List<JobDeclaration<?>>> jobDeclarations = new HashMap();
    protected Map<String, TransitionImpl> sequenceFlows;
    protected List<String> elementIds = new ArrayList<String>();
    protected Map<String, String> participantProcesses = new HashMap<String, String>();
    protected Map<String, MessageDefinition> messages = new HashMap<String, MessageDefinition>();
    protected Map<String, SignalDefinition> signals = new HashMap<String, SignalDefinition>();
    protected ExpressionManager expressionManager;
    protected List<BpmnParseListener> parseListeners;
    protected Map<String, XMLImporter> importers = new HashMap<String, XMLImporter>();
    protected Map<String, String> prefixs = new HashMap<String, String>();
    protected String targetNamespace;
    private Map<String, String> eventLinkTargets = new HashMap<String, String>();
    private Map<String, String> eventLinkSources = new HashMap<String, String>();
    protected static final String HUMAN_PERFORMER = "humanPerformer";
    protected static final String POTENTIAL_OWNER = "potentialOwner";
    protected static final String RESOURCE_ASSIGNMENT_EXPR = "resourceAssignmentExpression";
    protected static final String FORMAL_EXPRESSION = "formalExpression";
    protected static final String USER_PREFIX = "user(";
    protected static final String GROUP_PREFIX = "group(";
    protected static final String ASSIGNEE_EXTENSION = "assignee";
    protected static final String CANDIDATE_USERS_EXTENSION = "candidateUsers";
    protected static final String CANDIDATE_GROUPS_EXTENSION = "candidateGroups";
    protected static final String DUE_DATE_EXTENSION = "dueDate";
    protected static final String PRIORITY_EXTENSION = "priority";

    public BpmnParse(BpmnParser parser) {
        super(parser);
        this.expressionManager = parser.getExpressionManager();
        this.parseListeners = parser.getParseListeners();
        this.setSchemaResource(ReflectUtil.getResourceUrlAsString("org/camunda/bpm/engine/impl/bpmn/parser/BPMN20.xsd"));
    }

    public BpmnParse deployment(DeploymentEntity deployment) {
        this.deployment = deployment;
        return this;
    }

    @Override
    public BpmnParse execute() {
        super.execute();
        try {
            this.parseRootElement();
        }
        catch (BpmnParseException e) {
            this.addError(e);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unknown exception", e);
            throw new ProcessEngineException("Error while parsing process: " + e.getMessage(), e);
        }
        finally {
            if (this.hasWarnings()) {
                this.logWarnings();
            }
            if (this.hasErrors()) {
                this.throwExceptionForErrors();
            }
        }
        return this;
    }

    protected void parseRootElement() {
        this.collectElementIds();
        this.parseDefinitionsAttributes();
        this.parseImports();
        this.parseMessages();
        this.parseErrors();
        this.parseSignals();
        this.parseProcessDefinitions();
        this.parseCollaboration();
        this.parseDiagramInterchangeElements();
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseRootElement(this.rootElement, this.getProcessDefinitions());
        }
    }

    protected void collectElementIds() {
        this.rootElement.collectIds(this.elementIds);
    }

    protected void parseDefinitionsAttributes() {
        this.targetNamespace = this.rootElement.attribute("targetNamespace");
        for (String attribute : this.rootElement.attributes()) {
            if (!attribute.startsWith("xmlns:")) continue;
            String prefixValue = this.rootElement.attribute(attribute);
            String prefixName = attribute.substring(6);
            this.prefixs.put(prefixName, prefixValue);
        }
    }

    protected String resolveName(String name) {
        if (name == null) {
            return null;
        }
        int indexOfP = name.indexOf(58);
        if (indexOfP != -1) {
            String prefix = name.substring(0, indexOfP);
            String resolvedPrefix = this.prefixs.get(prefix);
            return resolvedPrefix + ":" + name.substring(indexOfP + 1);
        }
        return this.targetNamespace + ":" + name;
    }

    protected void parseImports() {
        List<Element> imports = this.rootElement.elements("import");
        for (Element theImport : imports) {
            String importType = theImport.attribute("importType");
            XMLImporter importer = this.getImporter(importType, theImport);
            if (importer == null) {
                this.addError("Could not import item of type " + importType, theImport);
                continue;
            }
            importer.importFrom(theImport, this);
        }
    }

    protected XMLImporter getImporter(String importType, Element theImport) {
        if (this.importers.containsKey(importType)) {
            return this.importers.get(importType);
        }
        if (importType.equals("http://schemas.xmlsoap.org/wsdl/")) {
            try {
                Class<?> wsdlImporterClass = Class.forName("org.camunda.bpm.engine.impl.webservice.CxfWSDLImporter", true, Thread.currentThread().getContextClassLoader());
                XMLImporter newInstance = (XMLImporter)wsdlImporterClass.newInstance();
                this.importers.put(importType, newInstance);
                return newInstance;
            }
            catch (Exception e) {
                this.addError("Could not find importer for type " + importType, theImport);
            }
        }
        return null;
    }

    public void parseMessages() {
        for (Element messageElement : this.rootElement.elements("message")) {
            String id = messageElement.attribute("id");
            String name = messageElement.attribute("name");
            MessageDefinition messageDefinition = new MessageDefinition(this.targetNamespace + ":" + id, name);
            this.messages.put(messageDefinition.getId(), messageDefinition);
        }
    }

    protected void parseSignals() {
        for (Element signalElement : this.rootElement.elements("signal")) {
            String id = signalElement.attribute("id");
            String signalName = signalElement.attribute("name");
            for (SignalDefinition signalDefinition : this.signals.values()) {
                if (!signalDefinition.getName().equals(signalName)) continue;
                this.addError("duplicate signal name '" + signalName + "'.", signalElement);
            }
            if (id == null) {
                this.addError("signal must have an id", signalElement);
                continue;
            }
            if (signalName == null) {
                this.addError("signal with id '" + id + "' has no name", signalElement);
                continue;
            }
            SignalDefinition signal = new SignalDefinition();
            signal.setId(this.targetNamespace + ":" + id);
            signal.setName(signalName);
            this.signals.put(signal.getId(), signal);
        }
    }

    public void parseErrors() {
        for (Element errorElement : this.rootElement.elements("error")) {
            Error error = new Error();
            String id = errorElement.attribute("id");
            if (id == null) {
                this.addError("'id' is mandatory on error definition", errorElement);
            }
            error.setId(id);
            String errorCode = errorElement.attribute("errorCode");
            if (errorCode != null) {
                error.setErrorCode(errorCode);
            }
            this.errors.put(id, error);
        }
    }

    public void parseProcessDefinitions() {
        for (Element processElement : this.rootElement.elements("process")) {
            boolean isExecutable = true;
            String isExecutableStr = processElement.attribute("isExecutable");
            if (isExecutableStr != null) {
                if (!Boolean.parseBoolean(isExecutableStr)) {
                    isExecutable = false;
                    LOGGER.info("Ignoring non-executable process with id='" + processElement.attribute("id") + "'. Set the attribute isExecutable=\"true\" to deploy this process.");
                }
            } else {
                LOGGER.info("Process with id='" + processElement.attribute("id") + "' has no attribute isExecutable. Assuming it is executable. Better set the attribute explicitely, especially to be compatible with future engine versions which might change the default behavior.");
            }
            if (!isExecutable) continue;
            this.processDefinitions.add(this.parseProcess(processElement));
        }
    }

    public void parseCollaboration() {
        Element collaboration = this.rootElement.element("collaboration");
        if (collaboration != null) {
            for (Element participant : collaboration.elements("participant")) {
                ProcessDefinitionEntity procDef;
                String processRef = participant.attribute("processRef");
                if (processRef == null || (procDef = this.getProcessDefinition(processRef)) == null) continue;
                ParticipantProcess participantProcess = new ParticipantProcess();
                participantProcess.setId(participant.attribute("id"));
                participantProcess.setName(participant.attribute("name"));
                procDef.setParticipantProcess(participantProcess);
                this.participantProcesses.put(participantProcess.getId(), processRef);
            }
        }
    }

    public ProcessDefinitionEntity parseProcess(Element processElement) {
        this.sequenceFlows = new HashMap<String, TransitionImpl>();
        ProcessDefinitionEntity processDefinition = new ProcessDefinitionEntity();
        processDefinition.setKey(processElement.attribute("id"));
        processDefinition.setName(processElement.attribute("name"));
        processDefinition.setCategory(this.rootElement.attribute("targetNamespace"));
        processDefinition.setProperty(PROPERTYNAME_DOCUMENTATION, this.parseDocumentation(processElement));
        processDefinition.setTaskDefinitions(new HashMap<String, TaskDefinition>());
        processDefinition.setDeploymentId(this.deployment.getId());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Parsing process " + processDefinition.getKey());
        }
        this.parseScope(processElement, processDefinition);
        this.parseLaneSets(processElement, processDefinition);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseProcess(processElement, processDefinition);
        }
        this.validateActivities(processDefinition.getActivities());
        return processDefinition;
    }

    protected void parseLaneSets(Element parentElement, ProcessDefinitionEntity processDefinition) {
        List<Element> laneSets = parentElement.elements("laneSet");
        if (laneSets != null && laneSets.size() > 0) {
            for (Element laneSetElement : laneSets) {
                LaneSet newLaneSet = new LaneSet();
                newLaneSet.setId(laneSetElement.attribute("id"));
                newLaneSet.setName(laneSetElement.attribute("name"));
                this.parseLanes(laneSetElement, newLaneSet);
                processDefinition.addLaneSet(newLaneSet);
            }
        }
    }

    protected void parseLanes(Element laneSetElement, LaneSet laneSet) {
        List<Element> lanes = laneSetElement.elements("lane");
        if (lanes != null && lanes.size() > 0) {
            for (Element laneElement : lanes) {
                Lane lane = new Lane();
                lane.setId(laneElement.attribute("id"));
                lane.setName(laneElement.attribute("name"));
                List<Element> flowNodeElements = laneElement.elements("flowNodeRef");
                if (flowNodeElements != null && flowNodeElements.size() > 0) {
                    for (Element flowNodeElement : flowNodeElements) {
                        lane.getFlowNodeIds().add(flowNodeElement.getText());
                    }
                }
                laneSet.addLane(lane);
            }
        }
    }

    public void parseScope(Element scopeElement, ScopeImpl parentScope) {
        HashMap<String, Element> postponedElements = new HashMap<String, Element>();
        this.parseStartEvents(scopeElement, parentScope);
        this.parseActivities(scopeElement, parentScope, postponedElements);
        this.parsePostponedElements(scopeElement, parentScope, postponedElements);
        this.parseEndEvents(scopeElement, parentScope);
        this.parseBoundaryEvents(scopeElement, parentScope);
        this.parseSequenceFlow(scopeElement, parentScope);
        this.parseExecutionListenersOnScope(scopeElement, parentScope);
        this.parseAssociations(scopeElement, parentScope);
        if (parentScope instanceof ProcessDefinition) {
            this.parseProcessDefinitionCustomExtensions(scopeElement, (ProcessDefinition)((Object)parentScope));
        }
        postponedElements.clear();
    }

    protected void parsePostponedElements(Element scopeElement, ScopeImpl parentScope, HashMap<String, Element> postponedElements) {
        for (Element postponedElement : postponedElements.values()) {
            ActivityImpl activity;
            if (parentScope.findActivity(postponedElement.attribute("id")) != null || !postponedElement.getTagName().equals("intermediateCatchEvent") || (activity = this.parseIntermediateCatchEvent(postponedElement, parentScope, false)) == null) continue;
            this.parseActivityInputOutput(postponedElement, activity);
        }
    }

    protected void parseProcessDefinitionCustomExtensions(Element scopeElement, ProcessDefinition definition) {
        this.parseStartAuthorization(scopeElement, definition);
    }

    protected void parseStartAuthorization(Element scopeElement, ProcessDefinition definition) {
        String candidateGroupsString;
        String candidateUsersString;
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)definition;
        Element extentionsElement = scopeElement.element("extensionElements");
        if (extentionsElement != null) {
            List<Element> potentialStarterElements = extentionsElement.elementsNS("http://activiti.org/bpmn", POTENTIAL_STARTER);
            for (Element potentialStarterElement : potentialStarterElements) {
                this.parsePotentialStarterResourceAssignment(potentialStarterElement, processDefinition);
            }
        }
        if ((candidateUsersString = scopeElement.attributeNS("http://activiti.org/bpmn", CANDIDATE_STARTER_USERS_EXTENSION)) != null) {
            List<String> candidateUsers = this.parseCommaSeparatedList(candidateUsersString);
            for (String candidateUser : candidateUsers) {
                processDefinition.addCandidateStarterUserIdExpression(this.expressionManager.createExpression(candidateUser.trim()));
            }
        }
        if ((candidateGroupsString = scopeElement.attributeNS("http://activiti.org/bpmn", CANDIDATE_STARTER_GROUPS_EXTENSION)) != null) {
            List<String> candidateGroups = this.parseCommaSeparatedList(candidateGroupsString);
            for (String candidateGroup : candidateGroups) {
                processDefinition.addCandidateStarterGroupIdExpression(this.expressionManager.createExpression(candidateGroup.trim()));
            }
        }
    }

    protected void parsePotentialStarterResourceAssignment(Element performerElement, ProcessDefinitionEntity processDefinition) {
        Element feElement;
        Element raeElement = performerElement.element(RESOURCE_ASSIGNMENT_EXPR);
        if (raeElement != null && (feElement = raeElement.element(FORMAL_EXPRESSION)) != null) {
            List<String> assignmentExpressions = this.parseCommaSeparatedList(feElement.getText());
            for (String assignmentExpression : assignmentExpressions) {
                if ((assignmentExpression = assignmentExpression.trim()).startsWith(USER_PREFIX)) {
                    String userAssignementId = this.getAssignmentId(assignmentExpression, USER_PREFIX);
                    processDefinition.addCandidateStarterUserIdExpression(this.expressionManager.createExpression(userAssignementId));
                    continue;
                }
                if (assignmentExpression.startsWith(GROUP_PREFIX)) {
                    String groupAssignementId = this.getAssignmentId(assignmentExpression, GROUP_PREFIX);
                    processDefinition.addCandidateStarterGroupIdExpression(this.expressionManager.createExpression(groupAssignementId));
                    continue;
                }
                processDefinition.addCandidateStarterGroupIdExpression(this.expressionManager.createExpression(assignmentExpression));
            }
        }
    }

    protected void parseAssociations(Element scopeElement, ScopeImpl parentScope) {
        for (Element associationElement : scopeElement.elements("association")) {
            String targetRef;
            String sourceRef = associationElement.attribute("sourceRef");
            if (sourceRef == null) {
                this.addError("association element missing attribute 'sourceRef'", associationElement);
            }
            if ((targetRef = associationElement.attribute("targetRef")) == null) {
                this.addError("association element missing attribute 'targetRef'", associationElement);
            }
            ActivityImpl sourceActivity = parentScope.findActivity(sourceRef);
            ActivityImpl targetActivity = parentScope.findActivity(targetRef);
            if (sourceActivity == null && !this.elementIds.contains(sourceRef)) {
                this.addError("Invalid reference sourceRef '" + sourceRef + "' of association element ", associationElement);
                continue;
            }
            if (targetActivity == null && !this.elementIds.contains(targetRef)) {
                this.addError("Invalid reference targetRef '" + targetRef + "' of association element ", associationElement);
                continue;
            }
            if (sourceActivity == null || !sourceActivity.getProperty(PROPERTYNAME_TYPE).equals("compensationBoundaryCatch")) continue;
            Object isForCompensation = targetActivity.getProperty(PROPERTYNAME_IS_FOR_COMPENSATION);
            if (isForCompensation == null || !((Boolean)isForCompensation).booleanValue()) {
                this.addError("compensation boundary catch must be connected to element with isForCompensation=true", associationElement);
                continue;
            }
            ActivityImpl compensatedActivity = sourceActivity.getParentActivity();
            compensatedActivity.setProperty(PROPERTYNAME_COMPENSATION_HANDLER_ID, targetActivity.getId());
        }
    }

    public void parseStartEvents(Element parentElement, ScopeImpl scope) {
        List<Element> startEventElements = parentElement.elements("startEvent");
        ArrayList<ActivityImpl> startEventActivities = new ArrayList<ActivityImpl>();
        for (Element startEventElement : startEventElements) {
            ActivityImpl startEventActivity = this.createActivityOnScope(startEventElement, scope);
            this.parseAsynchronousContinuation(startEventElement, startEventActivity);
            if (scope instanceof ProcessDefinitionEntity) {
                this.parseProcessDefinitionStartEvent(startEventActivity, startEventElement, parentElement, scope);
                startEventActivities.add(startEventActivity);
            } else {
                this.parseScopeStartEvent(startEventActivity, startEventElement, parentElement, scope);
            }
            this.ensureNoIoMappingDefined(startEventElement);
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseStartEvent(startEventElement, scope, startEventActivity);
            }
            this.parseExecutionListenersOnScope(startEventElement, startEventActivity);
        }
        if (scope instanceof ProcessDefinitionEntity) {
            this.selectInitial(startEventActivities, (ProcessDefinitionEntity)scope, parentElement);
            this.parseStartFormHandlers(startEventElements, (ProcessDefinitionEntity)scope);
        }
    }

    protected void selectInitial(List<ActivityImpl> startEventActivities, ProcessDefinitionEntity processDefinition, Element parentElement) {
        ActivityImpl initial = null;
        for (ActivityImpl activityImpl : startEventActivities) {
            if (activityImpl.getProperty(PROPERTYNAME_TYPE).equals("messageStartEvent")) continue;
            if (initial == null) {
                initial = activityImpl;
                continue;
            }
            this.addError("multiple none start events or timer start events not supported on process definition", parentElement);
        }
        if (initial == null && startEventActivities.size() == 1) {
            initial = startEventActivities.get(0);
        }
        processDefinition.setInitial(initial);
    }

    protected void parseProcessDefinitionStartEvent(ActivityImpl startEventActivity, Element startEventElement, Element parentElement, ScopeImpl scope) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)scope;
        String initiatorVariableName = startEventElement.attributeNS("http://activiti.org/bpmn", "initiator");
        if (initiatorVariableName != null) {
            processDefinition.setProperty(PROPERTYNAME_INITIATOR_VARIABLE_NAME, initiatorVariableName);
        }
        startEventActivity.setActivityBehavior(new NoneStartEventActivityBehavior());
        Element timerEventDefinition = startEventElement.element("timerEventDefinition");
        Element messageEventDefinition = startEventElement.element("messageEventDefinition");
        if (timerEventDefinition != null) {
            this.parseTimerStartEventDefinition(timerEventDefinition, startEventActivity, processDefinition);
        } else if (messageEventDefinition != null) {
            EventSubscriptionDeclaration messageDefinition = this.parseMessageEventDefinition(messageEventDefinition);
            startEventActivity.setProperty(PROPERTYNAME_TYPE, "messageStartEvent");
            messageDefinition.setActivityId(startEventActivity.getId());
            messageDefinition.setStartEvent(true);
            this.addEventSubscriptionDeclaration(messageDefinition, processDefinition, startEventElement);
        }
    }

    protected void parseStartFormHandlers(List<Element> startEventElements, ProcessDefinitionEntity processDefinition) {
        if (processDefinition.getInitial() != null) {
            for (Element startEventElement : startEventElements) {
                if (!startEventElement.attribute("id").equals(processDefinition.getInitial().getId())) continue;
                String startFormHandlerClassName = startEventElement.attributeNS("http://activiti.org/bpmn", "formHandlerClass");
                StartFormHandler startFormHandler = startFormHandlerClassName != null ? (StartFormHandler)ReflectUtil.instantiate(startFormHandlerClassName) : new DefaultStartFormHandler();
                startFormHandler.parseConfiguration(startEventElement, this.deployment, processDefinition, this);
                processDefinition.setStartFormHandler(startFormHandler);
            }
        }
    }

    protected void parseScopeStartEvent(ActivityImpl startEventActivity, Element startEventElement, Element parentElement, ScopeImpl scope) {
        Object triggeredByEvent = scope.getProperty(PROPERTYNAME_TRIGGERED_BY_EVENT);
        boolean isTriggeredByEvent = triggeredByEvent != null && (Boolean)triggeredByEvent != false;
        Element errorEventDefinition = startEventElement.element("errorEventDefinition");
        Element messageEventDefinition = startEventElement.element("messageEventDefinition");
        Element signalEventDefinition = startEventElement.element("signalEventDefinition");
        Element timerEventDefinition = startEventElement.element("timerEventDefinition");
        if (isTriggeredByEvent) {
            EventSubProcessStartEventActivityBehavior activityBehavior = new EventSubProcessStartEventActivityBehavior();
            startEventActivity.setActivityBehavior(activityBehavior);
            String isInterrupting = startEventElement.attribute("isInterrupting");
            boolean interrupting = isInterrupting.equalsIgnoreCase("true");
            ((ActivityImpl)scope).setCancelScope(interrupting);
            ((ActivityImpl)scope).setConcurrent(!interrupting);
            ScopeImpl catchingScope = ((ActivityImpl)scope).getParent();
            startEventActivity.setScope(catchingScope);
            startEventActivity.setFlowScope(scope);
            if (scope.getProperty(PROPERTYNAME_INITIAL) == null) {
                scope.setProperty(PROPERTYNAME_INITIAL, startEventActivity);
            } else {
                this.addError("multiple start events not supported for subprocess", startEventElement);
            }
            if (errorEventDefinition != null) {
                if (!interrupting) {
                    this.addError("error start event of event subprocess must be interrupting", startEventElement);
                }
                this.parseErrorStartEventDefinition(errorEventDefinition, startEventActivity, catchingScope);
            } else if (messageEventDefinition != null) {
                startEventActivity.setProperty(PROPERTYNAME_TYPE, "messageStartEvent");
                EventSubscriptionDeclaration eventSubscriptionDeclaration = this.parseMessageEventDefinition(messageEventDefinition);
                this.parseEventDefinitionForSubprocess(eventSubscriptionDeclaration, startEventActivity, catchingScope, messageEventDefinition);
            } else if (signalEventDefinition != null) {
                startEventActivity.setProperty(PROPERTYNAME_TYPE, "signalStartEvent");
                EventSubscriptionDeclaration eventSubscriptionDeclaration = this.parseSignalEventDefinition(signalEventDefinition);
                this.parseEventDefinitionForSubprocess(eventSubscriptionDeclaration, startEventActivity, catchingScope, signalEventDefinition);
            } else if (timerEventDefinition != null) {
                this.parseTimerStartEventDefinitionForEventSubprocess(timerEventDefinition, startEventActivity, catchingScope);
            } else {
                this.addError("start event of event subprocess must be of type 'error', 'message', 'timer' or 'signal'", startEventElement);
            }
        } else {
            Element compensateEventDefinition = startEventElement.element("compensateEventDefinition");
            Element conditionalEventDefinition = startEventElement.element("conditionalEventDefinition");
            Element escalationEventDefinition = startEventElement.element("escalationEventDefinition");
            if (conditionalEventDefinition != null) {
                this.addError("conditionalEventDefinition is not allowed on start event within a subprocess", conditionalEventDefinition);
            }
            if (timerEventDefinition != null) {
                this.addError("timerEventDefinition is not allowed on start event within a subprocess", timerEventDefinition);
            }
            if (escalationEventDefinition != null) {
                this.addError("escalationEventDefinition is not allowed on start event within a subprocess", escalationEventDefinition);
            }
            if (compensateEventDefinition != null) {
                this.addError("compensateEventDefinition is not allowed on start event within a subprocess", compensateEventDefinition);
            }
            if (errorEventDefinition != null) {
                this.addError("errorEventDefinition only allowed on start event if subprocess is an event subprocess", errorEventDefinition);
            }
            if (messageEventDefinition != null) {
                this.addError("messageEventDefinition only allowed on start event if subprocess is an event subprocess", messageEventDefinition);
            }
            if (signalEventDefinition != null) {
                this.addError("signalEventDefintion only allowed on start event if subprocess is an event subprocess", messageEventDefinition);
            }
            if (scope.getProperty(PROPERTYNAME_INITIAL) == null) {
                scope.setProperty(PROPERTYNAME_INITIAL, startEventActivity);
                startEventActivity.setActivityBehavior(new NoneStartEventActivityBehavior());
            } else {
                this.addError("multiple start events not supported for subprocess", startEventElement);
            }
        }
    }

    protected void parseErrorStartEventDefinition(Element errorEventDefinition, ActivityImpl startEventActivity, ScopeImpl scope) {
        startEventActivity.setProperty(PROPERTYNAME_TYPE, "errorStartEvent");
        String errorRef = errorEventDefinition.attribute("errorRef");
        Error error = null;
        ErrorEventDefinition definition = new ErrorEventDefinition(startEventActivity.getId());
        if (errorRef != null) {
            error = this.errors.get(errorRef);
            String errorCode = error == null ? errorRef : error.getErrorCode();
            definition.setErrorCode(errorCode);
        }
        definition.setPrecedence(10);
        this.addErrorEventDefinition(definition, scope);
    }

    protected EventSubscriptionDeclaration parseMessageEventDefinition(Element messageEventDefinition) {
        MessageDefinition messageDefinition;
        String messageRef = messageEventDefinition.attribute("messageRef");
        if (messageRef == null) {
            this.addError("attribute 'messageRef' is required", messageEventDefinition);
        }
        if ((messageDefinition = this.messages.get(this.resolveName(messageRef))) == null) {
            this.addError("Invalid 'messageRef': no message with id '" + messageRef + "' found.", messageEventDefinition);
        }
        return new EventSubscriptionDeclaration(messageDefinition.getName(), "message");
    }

    protected void addEventSubscriptionDeclaration(EventSubscriptionDeclaration subscription, ScopeImpl scope, Element element) {
        ArrayList<EventSubscriptionDeclaration> eventDefinitions;
        if (subscription.getEventType().equals("message") && (subscription.getEventName() == null || "".equalsIgnoreCase(subscription.getEventName().trim()))) {
            this.addError("Cannot have a message event subscription with an empty or missing name", element);
        }
        if ((eventDefinitions = (ArrayList<EventSubscriptionDeclaration>)scope.getProperty(PROPERTYNAME_EVENT_SUBSCRIPTION_DECLARATION)) == null) {
            eventDefinitions = new ArrayList<EventSubscriptionDeclaration>();
            scope.setProperty(PROPERTYNAME_EVENT_SUBSCRIPTION_DECLARATION, eventDefinitions);
        } else if (subscription.getEventType().equals("message")) {
            for (EventSubscriptionDeclaration eventDefinition : eventDefinitions) {
                if (!eventDefinition.getEventType().equals("message") || !eventDefinition.getEventName().equals(subscription.getEventName()) || eventDefinition.isStartEvent() != subscription.isStartEvent()) continue;
                this.addError("Cannot have more than one message event subscription with name '" + subscription.getEventName() + "' for scope '" + scope.getId() + "'", element);
            }
        }
        eventDefinitions.add(subscription);
    }

    public void parseActivities(Element parentElement, ScopeImpl scopeElement, HashMap<String, Element> postponedElements) {
        for (Element activityElement : parentElement.elements()) {
            this.parseActivity(activityElement, parentElement, scopeElement, postponedElements);
        }
    }

    protected void parseActivity(Element activityElement, Element parentElement, ScopeImpl scopeElement, HashMap<String, Element> postponedElements) {
        ActivityImpl activity = null;
        if (activityElement.getTagName().equals("exclusiveGateway")) {
            activity = this.parseExclusiveGateway(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("inclusiveGateway")) {
            activity = this.parseInclusiveGateway(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("parallelGateway")) {
            activity = this.parseParallelGateway(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("scriptTask")) {
            activity = this.parseScriptTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("serviceTask")) {
            activity = this.parseServiceTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("businessRuleTask")) {
            activity = this.parseBusinessRuleTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("task")) {
            activity = this.parseTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("manualTask")) {
            activity = this.parseManualTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("userTask")) {
            activity = this.parseUserTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("sendTask")) {
            activity = this.parseSendTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("receiveTask")) {
            activity = this.parseReceiveTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("subProcess")) {
            activity = this.parseSubProcess(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("callActivity")) {
            activity = this.parseCallActivity(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("intermediateCatchEvent")) {
            postponedElements.put(activityElement.attribute("id"), activityElement);
        } else if (activityElement.getTagName().equals("intermediateThrowEvent")) {
            activity = this.parseIntermediateThrowEvent(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("eventBasedGateway")) {
            activity = this.parseEventBasedGateway(activityElement, parentElement, scopeElement);
        } else if (activityElement.getTagName().equals("transaction")) {
            activity = this.parseTransaction(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("adHocSubProcess") || activityElement.getTagName().equals("complexGateway")) {
            this.addWarning("Ignoring unsupported activity type", activityElement);
        }
        if (activity != null) {
            this.parseMultiInstanceLoopCharacteristics(activityElement, activity);
        }
        if (activity != null) {
            this.parseActivityInputOutput(activityElement, activity);
        }
    }

    public void validateActivities(List<ActivityImpl> activities) {
        for (ActivityImpl activity : activities) {
            this.validateActivity(activity);
            if (activity.getActivities().size() <= 0) continue;
            this.validateActivities(activity.getActivities());
        }
    }

    protected void validateActivity(ActivityImpl activity) {
        if (activity.getActivityBehavior() instanceof ExclusiveGatewayActivityBehavior) {
            this.validateExclusiveGateway(activity);
        }
        this.validateOutgoingFlows(activity);
    }

    protected void validateOutgoingFlows(ActivityImpl activity) {
        if (activity.isAsyncAfter()) {
            for (PvmTransition transition : activity.getOutgoingTransitions()) {
                if (transition.getId() != null) continue;
                this.addError("Sequence flow with sourceRef='" + activity.getId() + "' must have an id, activity with id '" + activity.getId() + "' uses 'asyncAfter'.", null);
            }
        }
    }

    public void validateExclusiveGateway(ActivityImpl activity) {
        if (activity.getOutgoingTransitions().size() == 0) {
            this.addError("Exclusive Gateway '" + activity.getId() + "' has no outgoing sequence flows.", null);
        } else if (activity.getOutgoingTransitions().size() == 1) {
            PvmTransition flow = activity.getOutgoingTransitions().get(0);
            Condition condition = (Condition)flow.getProperty(PROPERTYNAME_CONDITION);
            if (condition != null) {
                this.addError("Exclusive Gateway '" + activity.getId() + "' has only one outgoing sequence flow ('" + flow.getId() + "'). This is not allowed to have a condition.", null);
            }
        } else {
            String defaultSequenceFlow = (String)activity.getProperty("default");
            boolean hasDefaultFlow = defaultSequenceFlow != null && defaultSequenceFlow.length() > 0;
            ArrayList<PvmTransition> flowsWithoutCondition = new ArrayList<PvmTransition>();
            for (PvmTransition flow : activity.getOutgoingTransitions()) {
                boolean hasConditon;
                Condition condition = (Condition)flow.getProperty(PROPERTYNAME_CONDITION);
                boolean isDefaultFlow = flow.getId() != null && flow.getId().equals(defaultSequenceFlow);
                boolean bl = hasConditon = condition != null;
                if (!hasConditon && !isDefaultFlow) {
                    flowsWithoutCondition.add(flow);
                }
                if (!hasConditon || !isDefaultFlow) continue;
                this.addError("Exclusive Gateway '" + activity.getId() + "' has outgoing sequence flow '" + flow.getId() + "' which is the default flow but has a condition too.", null);
            }
            if (hasDefaultFlow || flowsWithoutCondition.size() > 1) {
                for (PvmTransition flow : flowsWithoutCondition) {
                    this.addError("Exclusive Gateway '" + activity.getId() + "' has outgoing sequence flow '" + flow.getId() + "' without condition which is not the default flow.", null);
                }
            } else if (flowsWithoutCondition.size() == 1) {
                PvmTransition flow = (PvmTransition)flowsWithoutCondition.get(0);
                this.addWarning("Exclusive Gateway '" + activity.getId() + "' has outgoing sequence flow '" + flow.getId() + "' without condition which is not the default flow. We assume it to be the default flow, but it is bad modeling practice, better set the default flow in your gateway.", null);
            }
        }
    }

    public ActivityImpl parseIntermediateCatchEvent(Element intermediateEventElement, ScopeImpl scopeElement, boolean isAfterEventBasedGateway) {
        ActivityImpl nestedActivity = this.createActivityOnScope(intermediateEventElement, scopeElement);
        Element timerEventDefinition = intermediateEventElement.element("timerEventDefinition");
        Element signalEventDefinition = intermediateEventElement.element("signalEventDefinition");
        Element messageEventDefinition = intermediateEventElement.element("messageEventDefinition");
        Element linkEventDefinitionElement = intermediateEventElement.element("linkEventDefinition");
        IntermediateCatchEventActivityBehavior defaultCatchBehaviour = new IntermediateCatchEventActivityBehavior(isAfterEventBasedGateway);
        this.parseAsynchronousContinuation(intermediateEventElement, nestedActivity);
        if (isAfterEventBasedGateway) {
            nestedActivity.setCancelScope(true);
            nestedActivity.setScope(scopeElement.getParentScope());
        }
        if (timerEventDefinition != null) {
            nestedActivity.setActivityBehavior(defaultCatchBehaviour);
            this.parseIntermediateTimerEventDefinition(timerEventDefinition, nestedActivity, isAfterEventBasedGateway);
        } else if (signalEventDefinition != null) {
            nestedActivity.setActivityBehavior(defaultCatchBehaviour);
            this.parseIntermediateSignalEventDefinition(signalEventDefinition, nestedActivity, isAfterEventBasedGateway);
        } else if (messageEventDefinition != null) {
            nestedActivity.setActivityBehavior(defaultCatchBehaviour);
            this.parseIntermediateMessageEventDefinition(messageEventDefinition, nestedActivity, isAfterEventBasedGateway);
        } else if (linkEventDefinitionElement != null) {
            if (isAfterEventBasedGateway) {
                this.addError("IntermediateCatchLinkEvent is not allowed after an EventBasedGateway.", intermediateEventElement);
            }
            nestedActivity.setActivityBehavior(new IntermediateCatchLinkEventActivityBehavior());
            this.parseIntermediateLinkEventCatchBehavior(intermediateEventElement, nestedActivity, linkEventDefinitionElement);
        } else {
            this.addError("Unsupported intermediate catch event type", intermediateEventElement);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseIntermediateCatchEvent(intermediateEventElement, scopeElement, nestedActivity);
        }
        this.parseExecutionListenersOnScope(intermediateEventElement, nestedActivity);
        return nestedActivity;
    }

    protected void parseIntermediateLinkEventCatchBehavior(Element intermediateEventElement, ActivityImpl activity, Element linkEventDefinitionElement) {
        activity.setProperty(PROPERTYNAME_TYPE, "intermediateLinkCatch");
        String linkName = linkEventDefinitionElement.attribute("name");
        String elementName = intermediateEventElement.attribute("name");
        String elementId = intermediateEventElement.attribute("id");
        if (this.eventLinkTargets.containsKey(linkName)) {
            this.addError("Multiple Intermediate Catch Events with the same link event name ('" + linkName + "') are not allowed.", intermediateEventElement);
        } else {
            if (!linkName.equals(elementName)) {
                this.addWarning("Link Event named '" + elementName + "' containes link event definition with name '" + linkName + "' - it is recommended to use the same name for both.", intermediateEventElement);
            }
            this.eventLinkTargets.put(linkName, elementId);
        }
    }

    protected void parseIntermediateMessageEventDefinition(Element messageEventDefinition, ActivityImpl nestedActivity, boolean isAfterEventBasedGateway) {
        nestedActivity.setProperty(PROPERTYNAME_TYPE, "intermediateMessageCatch");
        EventSubscriptionDeclaration messageDefinition = this.parseMessageEventDefinition(messageEventDefinition);
        if (isAfterEventBasedGateway) {
            messageDefinition.setActivityId(nestedActivity.getId());
            this.addEventSubscriptionDeclaration(messageDefinition, nestedActivity.getParent(), messageEventDefinition);
        } else {
            nestedActivity.setScope(true);
            this.addEventSubscriptionDeclaration(messageDefinition, nestedActivity, messageEventDefinition);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseIntermediateMessageCatchEventDefinition(messageEventDefinition, nestedActivity);
        }
    }

    public ActivityImpl parseIntermediateThrowEvent(Element intermediateEventElement, ScopeImpl scopeElement) {
        Element signalEventDefinitionElement = intermediateEventElement.element("signalEventDefinition");
        Element compensateEventDefinitionElement = intermediateEventElement.element("compensateEventDefinition");
        Element linkEventDefinitionElement = intermediateEventElement.element("linkEventDefinition");
        Element messageEventDefinitionElement = intermediateEventElement.element("messageEventDefinition");
        if (linkEventDefinitionElement != null) {
            String linkName = linkEventDefinitionElement.attribute("name");
            String elementId = intermediateEventElement.attribute("id");
            this.eventLinkSources.put(elementId, linkName);
            return null;
        }
        boolean otherUnsupportedThrowingIntermediateEvent = intermediateEventElement.element("escalationEventDefinition") != null;
        ActivityImpl nestedActivityImpl = this.createActivityOnScope(intermediateEventElement, scopeElement);
        ActivityBehavior activityBehavior = null;
        this.parseAsynchronousContinuation(intermediateEventElement, nestedActivityImpl);
        if (signalEventDefinitionElement != null) {
            nestedActivityImpl.setProperty(PROPERTYNAME_TYPE, "intermediateSignalThrow");
            EventSubscriptionDeclaration signalDefinition = this.parseSignalEventDefinition(signalEventDefinitionElement);
            activityBehavior = new IntermediateThrowSignalEventActivityBehavior(signalDefinition);
        } else if (compensateEventDefinitionElement != null) {
            nestedActivityImpl.setProperty(PROPERTYNAME_TYPE, "intermediateCompensationThrowEvent");
            CompensateEventDefinition compensateEventDefinition = this.parseCompensateEventDefinition(compensateEventDefinitionElement, scopeElement);
            activityBehavior = new IntermediateThrowCompensationEventActivityBehavior(compensateEventDefinition);
        } else if (messageEventDefinitionElement != null) {
            if (this.isServiceTaskLike(messageEventDefinitionElement)) {
                nestedActivityImpl.setProperty(PROPERTYNAME_TYPE, "intermediateMessageThrowEvent");
                activityBehavior = this.parseServiceTaskLike("intermediateMessageThrowEvent", messageEventDefinitionElement, scopeElement).getActivityBehavior();
            } else {
                nestedActivityImpl.setProperty(PROPERTYNAME_TYPE, "intermediateNoneThrowEvent");
                activityBehavior = new IntermediateThrowNoneEventActivityBehavior();
            }
        } else if (otherUnsupportedThrowingIntermediateEvent) {
            this.addError("Unsupported intermediate throw event type", intermediateEventElement);
        } else {
            nestedActivityImpl.setProperty(PROPERTYNAME_TYPE, "intermediateNoneThrowEvent");
            activityBehavior = new IntermediateThrowNoneEventActivityBehavior();
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseIntermediateThrowEvent(intermediateEventElement, scopeElement, nestedActivityImpl);
        }
        nestedActivityImpl.setActivityBehavior(activityBehavior);
        this.parseExecutionListenersOnScope(intermediateEventElement, nestedActivityImpl);
        return nestedActivityImpl;
    }

    protected CompensateEventDefinition parseCompensateEventDefinition(Element compensateEventDefinitionElement, ScopeImpl scopeElement) {
        String activityRef = compensateEventDefinitionElement.attribute("activityRef");
        boolean waitForCompletion = "true".equals(compensateEventDefinitionElement.attribute("waitForCompletion", "true"));
        if (activityRef != null && scopeElement.getChildActivity(activityRef) == null) {
            Boolean isTriggeredByEvent = (Boolean)scopeElement.getProperty(PROPERTYNAME_TRIGGERED_BY_EVENT);
            String type = (String)scopeElement.getProperty(PROPERTYNAME_TYPE);
            if (Boolean.TRUE == isTriggeredByEvent && "subProcess".equals(type)) {
                scopeElement = scopeElement.getParentScope();
            }
            if (scopeElement.getChildActivity(activityRef) == null) {
                this.addError("Invalid attribute value for 'activityRef': no activity with id '" + activityRef + "' in scope '" + scopeElement.getId() + "'", compensateEventDefinitionElement);
            }
        }
        CompensateEventDefinition compensateEventDefinition = new CompensateEventDefinition();
        compensateEventDefinition.setActivityRef(activityRef);
        compensateEventDefinition.setWaitForCompletion(waitForCompletion);
        return compensateEventDefinition;
    }

    protected void parseCatchCompensateEventDefinition(Element compensateEventDefinition, ActivityImpl activity) {
        activity.setProperty(PROPERTYNAME_TYPE, "compensationBoundaryCatch");
        ScopeImpl parent = activity.getParent();
        for (ActivityImpl child : parent.getActivities()) {
            if (!child.getProperty(PROPERTYNAME_TYPE).equals("compensationBoundaryCatch") || child == activity) continue;
            this.addError("multiple boundary events with compensateEventDefinition not supported on same activity", compensateEventDefinition);
        }
    }

    protected ActivityBehavior parseBoundaryCancelEventDefinition(Element cancelEventDefinition, ActivityImpl activity) {
        activity.setProperty(PROPERTYNAME_TYPE, "cancelBoundaryCatch");
        ActivityImpl parent = (ActivityImpl)activity.getParent();
        if (!parent.getProperty(PROPERTYNAME_TYPE).equals("transaction")) {
            this.addError("boundary event with cancelEventDefinition only supported on transaction subprocesses", cancelEventDefinition);
        }
        for (ActivityImpl child : parent.getActivities()) {
            if (!child.getProperty(PROPERTYNAME_TYPE).equals("cancelBoundaryCatch") || child == activity) continue;
            this.addError("multiple boundary events with cancelEventDefinition not supported on same transaction subprocess", cancelEventDefinition);
        }
        return new CancelBoundaryEventActivityBehavior();
    }

    public void parseMultiInstanceLoopCharacteristics(Element activityElement, ActivityImpl activity) {
        if (!(activity.getActivityBehavior() instanceof AbstractBpmnActivityBehavior)) {
            return;
        }
        Element miLoopCharacteristics = activityElement.element("multiInstanceLoopCharacteristics");
        if (miLoopCharacteristics != null) {
            Element inputDataItem;
            String elementVariable;
            String loopDataInputRefText;
            Element loopDataInputRef;
            String collection;
            Element completionCondition;
            MultiInstanceActivityBehavior miActivityBehavior = null;
            boolean isSequential = this.parseBooleanAttribute(miLoopCharacteristics.attribute("isSequential"), false);
            miActivityBehavior = isSequential ? new SequentialMultiInstanceBehavior(activity, (AbstractBpmnActivityBehavior)activity.getActivityBehavior()) : new ParallelMultiInstanceBehavior(activity, (AbstractBpmnActivityBehavior)activity.getActivityBehavior());
            activity.setScope(true);
            activity.setProperty("multiInstance", isSequential ? "sequential" : "parallel");
            activity.setActivityBehavior(miActivityBehavior);
            Element loopCardinality = miLoopCharacteristics.element("loopCardinality");
            if (loopCardinality != null) {
                String loopCardinalityText = loopCardinality.getText();
                if (loopCardinalityText == null || "".equals(loopCardinalityText)) {
                    this.addError("loopCardinality must be defined for a multiInstanceLoopCharacteristics definition ", miLoopCharacteristics);
                }
                miActivityBehavior.setLoopCardinalityExpression(this.expressionManager.createExpression(loopCardinalityText));
            }
            if ((completionCondition = miLoopCharacteristics.element("completionCondition")) != null) {
                String completionConditionText = completionCondition.getText();
                miActivityBehavior.setCompletionConditionExpression(this.expressionManager.createExpression(completionConditionText));
            }
            if ((collection = miLoopCharacteristics.attributeNS("http://activiti.org/bpmn", "collection")) != null) {
                if (collection.contains("{")) {
                    miActivityBehavior.setCollectionExpression(this.expressionManager.createExpression(collection));
                } else {
                    miActivityBehavior.setCollectionVariable(collection);
                }
            }
            if ((loopDataInputRef = miLoopCharacteristics.element("loopDataInputRef")) != null && (loopDataInputRefText = loopDataInputRef.getText()) != null) {
                if (loopDataInputRefText.contains("{")) {
                    miActivityBehavior.setCollectionExpression(this.expressionManager.createExpression(loopDataInputRefText));
                } else {
                    miActivityBehavior.setCollectionVariable(loopDataInputRefText);
                }
            }
            if ((elementVariable = miLoopCharacteristics.attributeNS("http://activiti.org/bpmn", "elementVariable")) != null) {
                miActivityBehavior.setCollectionElementVariable(elementVariable);
            }
            if ((inputDataItem = miLoopCharacteristics.element("inputDataItem")) != null) {
                String inputDataItemName = inputDataItem.attribute("name");
                miActivityBehavior.setCollectionElementVariable(inputDataItemName);
            }
            if (miActivityBehavior.getLoopCardinalityExpression() == null && miActivityBehavior.getCollectionExpression() == null && miActivityBehavior.getCollectionVariable() == null) {
                this.addError("Either loopCardinality or loopDataInputRef/activiti:collection must been set", miLoopCharacteristics);
            }
            if (miActivityBehavior.getCollectionExpression() == null && miActivityBehavior.getCollectionVariable() == null && miActivityBehavior.getCollectionElementVariable() != null) {
                this.addError("LoopDataInputRef/activiti:collection must be set when using inputDataItem or activiti:elementVariable", miLoopCharacteristics);
            }
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseMultiInstanceLoopCharacteristics(activityElement, miLoopCharacteristics, activity);
            }
        }
    }

    public ActivityImpl createActivityOnScope(Element activityElement, ScopeImpl scopeElement) {
        String id = activityElement.attribute("id");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Parsing activity " + id);
        }
        ActivityImpl activity = scopeElement.createActivity(id);
        activity.setProperty("name", activityElement.attribute("name"));
        activity.setProperty(PROPERTYNAME_DOCUMENTATION, this.parseDocumentation(activityElement));
        activity.setProperty("default", activityElement.attribute("default"));
        activity.setProperty(PROPERTYNAME_TYPE, activityElement.getTagName());
        activity.setProperty("line", activityElement.getLine());
        String isForCompensation = activityElement.attribute(PROPERTYNAME_IS_FOR_COMPENSATION);
        if (isForCompensation != null && (isForCompensation.equals("true") || isForCompensation.equals("TRUE"))) {
            activity.setProperty(PROPERTYNAME_IS_FOR_COMPENSATION, true);
        }
        return activity;
    }

    public String parseDocumentation(Element element) {
        List<Element> docElements = element.elements(PROPERTYNAME_DOCUMENTATION);
        if (docElements.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Element e : docElements) {
            if (builder.length() != 0) {
                builder.append("\n\n");
            }
            builder.append(e.getText().trim());
        }
        return builder.toString();
    }

    public ActivityImpl parseExclusiveGateway(Element exclusiveGwElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(exclusiveGwElement, scope);
        activity.setActivityBehavior(new ExclusiveGatewayActivityBehavior());
        this.parseAsynchronousContinuation(exclusiveGwElement, activity);
        this.parseExecutionListenersOnScope(exclusiveGwElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseExclusiveGateway(exclusiveGwElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseInclusiveGateway(Element inclusiveGwElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(inclusiveGwElement, scope);
        activity.setActivityBehavior(new InclusiveGatewayActivityBehavior());
        this.parseAsynchronousContinuation(inclusiveGwElement, activity);
        this.parseExecutionListenersOnScope(inclusiveGwElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseInclusiveGateway(inclusiveGwElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseEventBasedGateway(Element eventBasedGwElement, Element parentElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(eventBasedGwElement, scope);
        activity.setActivityBehavior(new EventBasedGatewayActivityBehavior());
        activity.setScope(true);
        this.parseAsynchronousContinuation(eventBasedGwElement, activity);
        if (activity.isAsyncAfter()) {
            this.addError("'asyncAfter' not supported for " + eventBasedGwElement.getTagName() + " elements.", eventBasedGwElement);
        }
        this.parseExecutionListenersOnScope(eventBasedGwElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseEventBasedGateway(eventBasedGwElement, scope, activity);
        }
        List<Element> sequenceFlows = parentElement.elements("sequenceFlow");
        HashMap<String, Element> siblingsMap = new HashMap<String, Element>();
        List<Element> siblings = parentElement.elements();
        for (Element sibling : siblings) {
            siblingsMap.put(sibling.attribute("id"), sibling);
        }
        for (Element sequenceFlow : sequenceFlows) {
            Element sibling;
            String sourceRef = sequenceFlow.attribute("sourceRef");
            String targetRef = sequenceFlow.attribute("targetRef");
            if (!activity.getId().equals(sourceRef) || (sibling = (Element)siblingsMap.get(targetRef)) == null) continue;
            if (sibling.getTagName().equals("intermediateCatchEvent")) {
                this.parseIntermediateCatchEvent(sibling, activity, true);
                continue;
            }
            this.addError("Event based gateway can only be connected to elements of type intermediateCatchEvent", sibling);
        }
        return activity;
    }

    public ActivityImpl parseParallelGateway(Element parallelGwElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(parallelGwElement, scope);
        activity.setActivityBehavior(new ParallelGatewayActivityBehavior());
        this.parseAsynchronousContinuation(parallelGwElement, activity);
        this.parseExecutionListenersOnScope(parallelGwElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseParallelGateway(parallelGwElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseScriptTask(Element scriptTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(scriptTaskElement, scope);
        ScriptTaskActivityBehavior activityBehavior = this.parseScriptTaskElement(scriptTaskElement);
        if (activityBehavior != null) {
            this.parseAsynchronousContinuation(scriptTaskElement, activity);
            activity.setActivityBehavior(activityBehavior);
            this.parseExecutionListenersOnScope(scriptTaskElement, activity);
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseScriptTask(scriptTaskElement, scope, activity);
            }
        }
        return activity;
    }

    protected ScriptTaskActivityBehavior parseScriptTaskElement(Element scriptTaskElement) {
        String resultVariableName;
        String language = scriptTaskElement.attribute("scriptFormat");
        if (language == null) {
            language = "juel";
        }
        if ((resultVariableName = scriptTaskElement.attributeNS("http://activiti.org/bpmn", "resultVariable")) == null) {
            resultVariableName = scriptTaskElement.attributeNS("http://activiti.org/bpmn", "resultVariableName");
        }
        String scriptSource = null;
        Element scriptElement = scriptTaskElement.element("script");
        if (scriptElement != null) {
            scriptSource = scriptElement.getText();
        }
        String scriptResource = scriptTaskElement.attributeNS("http://activiti.org/bpmn", "resource");
        try {
            ExecutableScript script = ScriptUtil.getScript(language, scriptSource, scriptResource, this.expressionManager);
            return new ScriptTaskActivityBehavior(script, resultVariableName);
        }
        catch (ProcessEngineException e) {
            this.addError("Unable to process ScriptTask: " + e.getMessage(), scriptElement);
            return null;
        }
    }

    public ActivityImpl parseServiceTask(Element serviceTaskElement, ScopeImpl scope) {
        return this.parseServiceTaskLike("serviceTask", serviceTaskElement, scope);
    }

    public ActivityImpl parseServiceTaskLike(String elementName, Element serviceTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(serviceTaskElement, scope);
        String type = serviceTaskElement.attributeNS("http://activiti.org/bpmn", PROPERTYNAME_TYPE);
        String className = serviceTaskElement.attributeNS("http://activiti.org/bpmn", "class");
        String expression = serviceTaskElement.attributeNS("http://activiti.org/bpmn", "expression");
        String delegateExpression = serviceTaskElement.attributeNS("http://activiti.org/bpmn", "delegateExpression");
        String resultVariableName = serviceTaskElement.attributeNS("http://activiti.org/bpmn", "resultVariable");
        if (resultVariableName == null) {
            resultVariableName = serviceTaskElement.attributeNS("http://activiti.org/bpmn", "resultVariableName");
        }
        this.parseAsynchronousContinuation(serviceTaskElement, activity);
        if (type != null) {
            if (type.equalsIgnoreCase("mail")) {
                this.parseEmailServiceTask(activity, serviceTaskElement, this.parseFieldDeclarations(serviceTaskElement));
            } else if (type.equalsIgnoreCase("shell")) {
                this.parseShellServiceTask(activity, serviceTaskElement, this.parseFieldDeclarations(serviceTaskElement));
            } else {
                this.addError("Invalid usage of type attribute on " + elementName + ": '" + type + "'", serviceTaskElement);
            }
        } else if (className != null && className.trim().length() > 0) {
            if (resultVariableName != null) {
                this.addError("'resultVariableName' not supported for " + elementName + " elements using 'class'", serviceTaskElement);
            }
            activity.setActivityBehavior(new ClassDelegateActivityBehavior(className, this.parseFieldDeclarations(serviceTaskElement)));
        } else if (delegateExpression != null) {
            if (resultVariableName != null) {
                this.addError("'resultVariableName' not supported for " + elementName + " elements using 'delegateExpression'", serviceTaskElement);
            }
            activity.setActivityBehavior(new ServiceTaskDelegateExpressionActivityBehavior(this.expressionManager.createExpression(delegateExpression), this.parseFieldDeclarations(serviceTaskElement)));
        } else if (expression != null && expression.trim().length() > 0) {
            activity.setActivityBehavior(new ServiceTaskExpressionActivityBehavior(this.expressionManager.createExpression(expression), resultVariableName));
        }
        this.parseExecutionListenersOnScope(serviceTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseServiceTask(serviceTaskElement, scope, activity);
        }
        if (activity.getActivityBehavior() == null) {
            this.addError("One of the attributes 'class', 'delegateExpression', 'type', or 'expression' is mandatory on " + elementName + ".", serviceTaskElement);
        }
        return activity;
    }

    public ActivityImpl parseBusinessRuleTask(Element businessRuleTaskElement, ScopeImpl scope) {
        return this.parseServiceTaskLike("businessRuleTask", businessRuleTaskElement, scope);
    }

    protected void parseAsynchronousContinuation(Element element, ActivityImpl activity) {
        MessageJobDeclaration messageJobDeclaration;
        boolean isAsyncBefore = this.isAsyncBefore(element);
        boolean isAsyncAfter = this.isAsyncAfter(element);
        boolean exclusive = this.isExclusive(element);
        activity.setAsyncBefore(isAsyncBefore);
        activity.setAsyncAfter(isAsyncAfter);
        if (isAsyncBefore) {
            messageJobDeclaration = new AsyncBeforeMessageJobDeclaration();
            messageJobDeclaration.setExclusive(exclusive);
            messageJobDeclaration.setActivityId(activity.getId());
            this.addMessageJobDeclarationToActivity(messageJobDeclaration, activity);
            this.addJobDeclarationToProcessDefinition(messageJobDeclaration, activity.getProcessDefinition());
        }
        if (isAsyncAfter) {
            messageJobDeclaration = new AsyncAfterMessageJobDeclaration();
            messageJobDeclaration.setExclusive(exclusive);
            messageJobDeclaration.setActivityId(activity.getId());
            this.addMessageJobDeclarationToActivity(messageJobDeclaration, activity);
            this.addJobDeclarationToProcessDefinition(messageJobDeclaration, activity.getProcessDefinition());
        }
    }

    protected void addMessageJobDeclarationToActivity(MessageJobDeclaration messageJobDeclaration, ActivityImpl activity) {
        ArrayList<MessageJobDeclaration> messageJobDeclarations = (ArrayList<MessageJobDeclaration>)activity.getProperty(PROPERTYNAME_MESSAGE_JOB_DECLARATION);
        if (messageJobDeclarations == null) {
            messageJobDeclarations = new ArrayList<MessageJobDeclaration>();
            activity.setProperty(PROPERTYNAME_MESSAGE_JOB_DECLARATION, messageJobDeclarations);
        }
        messageJobDeclarations.add(messageJobDeclaration);
    }

    protected void addJobDeclarationToProcessDefinition(JobDeclaration<?> jobDeclaration, ProcessDefinitionImpl processDefinition) {
        ProcessDefinition definition = (ProcessDefinition)((Object)processDefinition);
        String key = definition.getKey();
        List<JobDeclaration<?>> containingJobDeclarations = this.jobDeclarations.get(key);
        if (containingJobDeclarations == null) {
            containingJobDeclarations = new ArrayList();
            this.jobDeclarations.put(key, containingJobDeclarations);
        }
        containingJobDeclarations.add(jobDeclaration);
    }

    public ActivityImpl parseSendTask(Element sendTaskElement, ScopeImpl scope) {
        if (this.isServiceTaskLike(sendTaskElement)) {
            return this.parseServiceTaskLike("sendTask", sendTaskElement, scope);
        }
        ActivityImpl activity = this.createActivityOnScope(sendTaskElement, scope);
        this.parseAsynchronousContinuation(sendTaskElement, activity);
        String type = sendTaskElement.attributeNS("http://activiti.org/bpmn", PROPERTYNAME_TYPE);
        if (type != null) {
            if (type.equalsIgnoreCase("mail")) {
                this.parseEmailServiceTask(activity, sendTaskElement, this.parseFieldDeclarations(sendTaskElement));
            } else {
                this.addError("Invalid usage of type attribute: '" + type + "'", sendTaskElement);
            }
        } else {
            this.addError("One of the attributes 'class', 'delegateExpression', 'type', or 'expression' is mandatory on sendTask.", sendTaskElement);
        }
        this.parseExecutionListenersOnScope(sendTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseSendTask(sendTaskElement, scope, activity);
        }
        return activity;
    }

    protected void parseEmailServiceTask(ActivityImpl activity, Element serviceTaskElement, List<FieldDeclaration> fieldDeclarations) {
        this.validateFieldDeclarationsForEmail(serviceTaskElement, fieldDeclarations);
        activity.setActivityBehavior((MailActivityBehavior)ClassDelegateUtil.instantiateDelegate(MailActivityBehavior.class, fieldDeclarations));
    }

    protected void parseShellServiceTask(ActivityImpl activity, Element serviceTaskElement, List<FieldDeclaration> fieldDeclarations) {
        this.validateFieldDeclarationsForShell(serviceTaskElement, fieldDeclarations);
        activity.setActivityBehavior((ActivityBehavior)ClassDelegateUtil.instantiateDelegate(ShellActivityBehavior.class, fieldDeclarations));
    }

    protected void validateFieldDeclarationsForEmail(Element serviceTaskElement, List<FieldDeclaration> fieldDeclarations) {
        boolean toDefined = false;
        boolean textOrHtmlDefined = false;
        for (FieldDeclaration fieldDeclaration : fieldDeclarations) {
            if (fieldDeclaration.getName().equals("to")) {
                toDefined = true;
            }
            if (fieldDeclaration.getName().equals("html")) {
                textOrHtmlDefined = true;
            }
            if (!fieldDeclaration.getName().equals("text")) continue;
            textOrHtmlDefined = true;
        }
        if (!toDefined) {
            this.addError("No recipient is defined on the mail activity", serviceTaskElement);
        }
        if (!textOrHtmlDefined) {
            this.addError("Text or html field should be provided", serviceTaskElement);
        }
    }

    protected void validateFieldDeclarationsForShell(Element serviceTaskElement, List<FieldDeclaration> fieldDeclarations) {
        boolean shellCommandDefined = false;
        for (FieldDeclaration fieldDeclaration : fieldDeclarations) {
            String fieldName = fieldDeclaration.getName();
            FixedValue fieldFixedValue = (FixedValue)fieldDeclaration.getValue();
            String fieldValue = fieldFixedValue.getExpressionText();
            shellCommandDefined |= fieldName.equals("command");
            if (!fieldName.equals("wait") && !fieldName.equals("redirectError") && !fieldName.equals("cleanEnv") || fieldValue.toLowerCase().equals("true") || fieldValue.toLowerCase().equals("false")) continue;
            this.addError("undefined value for shell " + fieldName + " parameter :" + fieldValue.toString(), serviceTaskElement);
        }
        if (!shellCommandDefined) {
            this.addError("No shell command is defined on the shell activity", serviceTaskElement);
        }
    }

    public List<FieldDeclaration> parseFieldDeclarations(Element element) {
        List<Element> fieldDeclarationElements;
        ArrayList<FieldDeclaration> fieldDeclarations = new ArrayList<FieldDeclaration>();
        Element elementWithFieldInjections = element.element("extensionElements");
        if (elementWithFieldInjections == null) {
            elementWithFieldInjections = element;
        }
        if ((fieldDeclarationElements = elementWithFieldInjections.elementsNS("http://activiti.org/bpmn", "field")) != null && !fieldDeclarationElements.isEmpty()) {
            for (Element fieldDeclarationElement : fieldDeclarationElements) {
                FieldDeclaration fieldDeclaration = this.parseFieldDeclaration(element, fieldDeclarationElement);
                if (fieldDeclaration == null) continue;
                fieldDeclarations.add(fieldDeclaration);
            }
        }
        return fieldDeclarations;
    }

    protected FieldDeclaration parseFieldDeclaration(Element serviceTaskElement, Element fieldDeclarationElement) {
        String fieldName = fieldDeclarationElement.attribute("name");
        FieldDeclaration fieldDeclaration = this.parseStringFieldDeclaration(fieldDeclarationElement, serviceTaskElement, fieldName);
        if (fieldDeclaration == null) {
            fieldDeclaration = this.parseExpressionFieldDeclaration(fieldDeclarationElement, serviceTaskElement, fieldName);
        }
        if (fieldDeclaration == null) {
            this.addError("One of the following is mandatory on a field declaration: one of attributes stringValue|expression or one of child elements string|expression", serviceTaskElement);
        }
        return fieldDeclaration;
    }

    protected FieldDeclaration parseStringFieldDeclaration(Element fieldDeclarationElement, Element serviceTaskElement, String fieldName) {
        try {
            String fieldValue = this.getStringValueFromAttributeOrElement("stringValue", "string", fieldDeclarationElement);
            if (fieldValue != null) {
                return new FieldDeclaration(fieldName, Expression.class.getName(), new FixedValue(fieldValue));
            }
        }
        catch (ProcessEngineException ae) {
            if (ae.getMessage().contains("multiple elements with tag name")) {
                this.addError("Multiple string field declarations found", serviceTaskElement);
            }
            this.addError("Error when paring field declarations: " + ae.getMessage(), serviceTaskElement);
        }
        return null;
    }

    protected FieldDeclaration parseExpressionFieldDeclaration(Element fieldDeclarationElement, Element serviceTaskElement, String fieldName) {
        try {
            String expression = this.getStringValueFromAttributeOrElement("expression", "expression", fieldDeclarationElement);
            if (expression != null && expression.trim().length() > 0) {
                return new FieldDeclaration(fieldName, Expression.class.getName(), this.expressionManager.createExpression(expression));
            }
        }
        catch (ProcessEngineException ae) {
            if (ae.getMessage().contains("multiple elements with tag name")) {
                this.addError("Multiple expression field declarations found", serviceTaskElement);
            }
            this.addError("Error when paring field declarations: " + ae.getMessage(), serviceTaskElement);
        }
        return null;
    }

    protected String getStringValueFromAttributeOrElement(String attributeName, String elementName, Element element) {
        String value = null;
        String attributeValue = element.attribute(attributeName);
        Element childElement = element.elementNS("http://activiti.org/bpmn", elementName);
        String stringElementText = null;
        if (attributeValue != null && childElement != null) {
            this.addError("Can't use attribute '" + attributeName + "' and element '" + elementName + "' together, only use one", element);
        } else if (childElement != null) {
            stringElementText = childElement.getText();
            if (stringElementText == null || stringElementText.length() == 0) {
                this.addError("No valid value found in attribute '" + attributeName + "' nor element '" + elementName + "'", element);
            } else {
                value = stringElementText;
            }
        } else if (attributeValue != null && attributeValue.length() > 0) {
            value = attributeValue;
        }
        return value;
    }

    public ActivityImpl parseTask(Element taskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(taskElement, scope);
        activity.setActivityBehavior(new TaskActivityBehavior());
        this.parseAsynchronousContinuation(taskElement, activity);
        this.parseExecutionListenersOnScope(taskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseTask(taskElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseManualTask(Element manualTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(manualTaskElement, scope);
        activity.setActivityBehavior(new ManualTaskActivityBehavior());
        this.parseAsynchronousContinuation(manualTaskElement, activity);
        this.parseExecutionListenersOnScope(manualTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseManualTask(manualTaskElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseReceiveTask(Element receiveTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(receiveTaskElement, scope);
        activity.setActivityBehavior(new ReceiveTaskActivityBehavior());
        this.parseAsynchronousContinuation(receiveTaskElement, activity);
        this.parseExecutionListenersOnScope(receiveTaskElement, activity);
        if (receiveTaskElement.attribute("messageRef") != null) {
            activity.setScope(true);
            EventSubscriptionDeclaration declaration = this.parseMessageEventDefinition(receiveTaskElement);
            declaration.setActivityId(activity.getActivityId());
            declaration.setEventScopeActivityId(activity.getActivityId());
            this.addEventSubscriptionDeclaration(declaration, activity, receiveTaskElement);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseReceiveTask(receiveTaskElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseUserTask(Element userTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(userTaskElement, scope);
        this.parseAsynchronousContinuation(userTaskElement, activity);
        TaskDefinition taskDefinition = this.parseTaskDefinition(userTaskElement, activity.getId(), (ProcessDefinitionEntity)scope.getProcessDefinition());
        TaskDecorator taskDecorator = new TaskDecorator(taskDefinition, this.expressionManager);
        UserTaskActivityBehavior userTaskActivity = new UserTaskActivityBehavior(taskDecorator);
        activity.setActivityBehavior(userTaskActivity);
        this.parseProperties(userTaskElement, activity);
        this.parseExecutionListenersOnScope(userTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseUserTask(userTaskElement, scope, activity);
        }
        return activity;
    }

    public TaskDefinition parseTaskDefinition(Element taskElement, String taskDefinitionKey, ProcessDefinitionEntity processDefinition) {
        String descriptionStr;
        String name;
        String taskFormHandlerClassName = taskElement.attributeNS("http://activiti.org/bpmn", "formHandlerClass");
        TaskFormHandler taskFormHandler = taskFormHandlerClassName != null ? (TaskFormHandler)ReflectUtil.instantiate(taskFormHandlerClassName) : new DefaultTaskFormHandler();
        taskFormHandler.parseConfiguration(taskElement, this.deployment, processDefinition, this);
        TaskDefinition taskDefinition = new TaskDefinition(taskFormHandler);
        taskDefinition.setKey(taskDefinitionKey);
        processDefinition.getTaskDefinitions().put(taskDefinitionKey, taskDefinition);
        String formKeyAttribute = taskElement.attributeNS("http://activiti.org/bpmn", "formKey");
        if (formKeyAttribute != null) {
            taskDefinition.setFormKey(this.expressionManager.createExpression(formKeyAttribute));
        }
        if ((name = taskElement.attribute("name")) != null) {
            taskDefinition.setNameExpression(this.expressionManager.createExpression(name));
        }
        if ((descriptionStr = this.parseDocumentation(taskElement)) != null) {
            taskDefinition.setDescriptionExpression(this.expressionManager.createExpression(descriptionStr));
        }
        this.parseHumanPerformer(taskElement, taskDefinition);
        this.parsePotentialOwner(taskElement, taskDefinition);
        this.parseUserTaskCustomExtensions(taskElement, taskDefinition);
        return taskDefinition;
    }

    protected void parseHumanPerformer(Element taskElement, TaskDefinition taskDefinition) {
        Element humanPerformerElement;
        List<Element> humanPerformerElements = taskElement.elements(HUMAN_PERFORMER);
        if (humanPerformerElements.size() > 1) {
            this.addError("Invalid task definition: multiple humanPerformer sub elements defined for " + taskDefinition.getNameExpression(), taskElement);
        } else if (humanPerformerElements.size() == 1 && (humanPerformerElement = humanPerformerElements.get(0)) != null) {
            this.parseHumanPerformerResourceAssignment(humanPerformerElement, taskDefinition);
        }
    }

    protected void parsePotentialOwner(Element taskElement, TaskDefinition taskDefinition) {
        List<Element> potentialOwnerElements = taskElement.elements(POTENTIAL_OWNER);
        for (Element potentialOwnerElement : potentialOwnerElements) {
            this.parsePotentialOwnerResourceAssignment(potentialOwnerElement, taskDefinition);
        }
    }

    protected void parseHumanPerformerResourceAssignment(Element performerElement, TaskDefinition taskDefinition) {
        Element feElement;
        Element raeElement = performerElement.element(RESOURCE_ASSIGNMENT_EXPR);
        if (raeElement != null && (feElement = raeElement.element(FORMAL_EXPRESSION)) != null) {
            taskDefinition.setAssigneeExpression(this.expressionManager.createExpression(feElement.getText()));
        }
    }

    protected void parsePotentialOwnerResourceAssignment(Element performerElement, TaskDefinition taskDefinition) {
        Element feElement;
        Element raeElement = performerElement.element(RESOURCE_ASSIGNMENT_EXPR);
        if (raeElement != null && (feElement = raeElement.element(FORMAL_EXPRESSION)) != null) {
            List<String> assignmentExpressions = this.parseCommaSeparatedList(feElement.getText());
            for (String assignmentExpression : assignmentExpressions) {
                if ((assignmentExpression = assignmentExpression.trim()).startsWith(USER_PREFIX)) {
                    String userAssignementId = this.getAssignmentId(assignmentExpression, USER_PREFIX);
                    taskDefinition.addCandidateUserIdExpression(this.expressionManager.createExpression(userAssignementId));
                    continue;
                }
                if (assignmentExpression.startsWith(GROUP_PREFIX)) {
                    String groupAssignementId = this.getAssignmentId(assignmentExpression, GROUP_PREFIX);
                    taskDefinition.addCandidateGroupIdExpression(this.expressionManager.createExpression(groupAssignementId));
                    continue;
                }
                taskDefinition.addCandidateGroupIdExpression(this.expressionManager.createExpression(assignmentExpression));
            }
        }
    }

    protected String getAssignmentId(String expression, String prefix) {
        return expression.substring(prefix.length(), expression.length() - 1).trim();
    }

    protected void parseUserTaskCustomExtensions(Element taskElement, TaskDefinition taskDefinition) {
        String priorityExpression;
        String candidateGroupsString;
        String candidateUsersString;
        String assignee = taskElement.attributeNS("http://activiti.org/bpmn", ASSIGNEE_EXTENSION);
        if (assignee != null) {
            if (taskDefinition.getAssigneeExpression() == null) {
                taskDefinition.setAssigneeExpression(this.expressionManager.createExpression(assignee));
            } else {
                this.addError("Invalid usage: duplicate assignee declaration for task " + taskDefinition.getNameExpression(), taskElement);
            }
        }
        if ((candidateUsersString = taskElement.attributeNS("http://activiti.org/bpmn", CANDIDATE_USERS_EXTENSION)) != null) {
            List<String> candidateUsers = this.parseCommaSeparatedList(candidateUsersString);
            for (String candidateUser : candidateUsers) {
                taskDefinition.addCandidateUserIdExpression(this.expressionManager.createExpression(candidateUser.trim()));
            }
        }
        if ((candidateGroupsString = taskElement.attributeNS("http://activiti.org/bpmn", CANDIDATE_GROUPS_EXTENSION)) != null) {
            List<String> candidateGroups = this.parseCommaSeparatedList(candidateGroupsString);
            for (String candidateGroup : candidateGroups) {
                taskDefinition.addCandidateGroupIdExpression(this.expressionManager.createExpression(candidateGroup.trim()));
            }
        }
        this.parseTaskListeners(taskElement, taskDefinition);
        String dueDateExpression = taskElement.attributeNS("http://activiti.org/bpmn", DUE_DATE_EXTENSION);
        if (dueDateExpression != null) {
            taskDefinition.setDueDateExpression(this.expressionManager.createExpression(dueDateExpression));
        }
        if ((priorityExpression = taskElement.attributeNS("http://activiti.org/bpmn", PRIORITY_EXTENSION)) != null) {
            taskDefinition.setPriorityExpression(this.expressionManager.createExpression(priorityExpression));
        }
    }

    protected List<String> parseCommaSeparatedList(String s) {
        ArrayList<String> result = new ArrayList<String>();
        if (s != null && !"".equals(s)) {
            StringCharacterIterator iterator = new StringCharacterIterator(s);
            char c = iterator.first();
            StringBuilder strb = new StringBuilder();
            boolean insideExpression = false;
            while (c != '\uffff') {
                if (c == '{' || c == '$') {
                    insideExpression = true;
                } else if (c == '}') {
                    insideExpression = false;
                } else if (c == ',' && !insideExpression) {
                    result.add(strb.toString().trim());
                    strb.delete(0, strb.length());
                }
                if (c != ',' || insideExpression) {
                    strb.append(c);
                }
                c = iterator.next();
            }
            if (strb.length() > 0) {
                result.add(strb.toString().trim());
            }
        }
        return result;
    }

    protected void parseTaskListeners(Element userTaskElement, TaskDefinition taskDefinition) {
        Element extentionsElement = userTaskElement.element("extensionElements");
        if (extentionsElement != null) {
            List<Element> taskListenerElements = extentionsElement.elementsNS("http://activiti.org/bpmn", "taskListener");
            for (Element taskListenerElement : taskListenerElements) {
                String eventName = taskListenerElement.attribute("event");
                if (eventName != null) {
                    if ("create".equals(eventName) || "assignment".equals(eventName) || "complete".equals(eventName) || "delete".equals(eventName)) {
                        TaskListener taskListener = this.parseTaskListener(taskListenerElement);
                        taskDefinition.addTaskListener(eventName, taskListener);
                        continue;
                    }
                    this.addError("Attribute 'event' must be one of {create|assignment|complete|delete}", userTaskElement);
                    continue;
                }
                this.addError("Attribute 'event' is mandatory on taskListener", userTaskElement);
            }
        }
    }

    protected TaskListener parseTaskListener(Element taskListenerElement) {
        TaskListener taskListener = null;
        String className = taskListenerElement.attribute("class");
        String expression = taskListenerElement.attribute("expression");
        String delegateExpression = taskListenerElement.attribute("delegateExpression");
        Element scriptElement = taskListenerElement.elementNS("http://activiti.org/bpmn", "script");
        if (className != null) {
            taskListener = new ClassDelegateTaskListener(className, this.parseFieldDeclarations(taskListenerElement));
        } else if (expression != null) {
            taskListener = new ExpressionTaskListener(this.expressionManager.createExpression(expression));
        } else if (delegateExpression != null) {
            taskListener = new DelegateExpressionTaskListener(this.expressionManager.createExpression(delegateExpression), this.parseFieldDeclarations(taskListenerElement));
        } else if (scriptElement != null) {
            try {
                ExecutableScript executableScript = BpmnParseUtil.parseCamundaScript(scriptElement);
                if (executableScript != null) {
                    taskListener = new ScriptTaskListener(executableScript);
                }
            }
            catch (BpmnParseException e) {
                this.addError(e);
            }
        } else {
            this.addError("Element 'class', 'expression', 'delegateExpression' or 'script' is mandatory on taskListener", taskListenerElement);
        }
        return taskListener;
    }

    public void parseEndEvents(Element parentElement, ScopeImpl scope) {
        for (Element endEventElement : parentElement.elements("endEvent")) {
            ActivityImpl activity = this.createActivityOnScope(endEventElement, scope);
            Element errorEventDefinition = endEventElement.element("errorEventDefinition");
            Element cancelEventDefinition = endEventElement.element("cancelEventDefinition");
            Element terminateEventDefinition = endEventElement.element("terminateEventDefinition");
            Element messageEventDefinitionElement = endEventElement.element("messageEventDefinition");
            Element signalEventDefinition = endEventElement.element("signalEventDefinition");
            if (errorEventDefinition != null) {
                String errorRef = errorEventDefinition.attribute("errorRef");
                if (errorRef == null || "".equals(errorRef)) {
                    this.addError("'errorRef' attribute is mandatory on error end event", errorEventDefinition);
                } else {
                    Error error = this.errors.get(errorRef);
                    if (error != null && (error.getErrorCode() == null || "".equals(error.getErrorCode()))) {
                        this.addError("'errorCode' is mandatory on errors referenced by throwing error event definitions, but the error '" + error.getId() + "' does not define one.", errorEventDefinition);
                    }
                    activity.setProperty(PROPERTYNAME_TYPE, "errorEndEvent");
                    activity.setActivityBehavior(new ErrorEndEventActivityBehavior(error != null ? error.getErrorCode() : errorRef));
                }
            } else if (cancelEventDefinition != null) {
                if (scope.getProperty(PROPERTYNAME_TYPE) == null || !scope.getProperty(PROPERTYNAME_TYPE).equals("transaction")) {
                    this.addError("end event with cancelEventDefinition only supported inside transaction subprocess", cancelEventDefinition);
                } else {
                    activity.setProperty(PROPERTYNAME_TYPE, "cancelEndEvent");
                    activity.setActivityBehavior(new CancelEndEventActivityBehavior());
                }
            } else if (terminateEventDefinition != null) {
                activity.setProperty(PROPERTYNAME_TYPE, "terminateEndEvent");
                activity.setActivityBehavior(new TerminateEndEventActivityBehavior());
                activity.setCancelScope(true);
            } else if (messageEventDefinitionElement != null) {
                if (this.isServiceTaskLike(messageEventDefinitionElement)) {
                    activity.setProperty(PROPERTYNAME_TYPE, "messageEndEvent");
                    activity.setActivityBehavior(this.parseServiceTaskLike("messageEndEvent", messageEventDefinitionElement, scope).getActivityBehavior());
                } else {
                    activity.setActivityBehavior(new IntermediateThrowNoneEventActivityBehavior());
                }
            } else if (signalEventDefinition != null) {
                activity.setProperty(PROPERTYNAME_TYPE, "signalEndEvent");
                EventSubscriptionDeclaration signalDefinition = this.parseSignalEventDefinition(signalEventDefinition);
                activity.setActivityBehavior(new SignalEndEventActivityBehavior(signalDefinition));
            } else {
                activity.setProperty(PROPERTYNAME_TYPE, "noneEndEvent");
                activity.setActivityBehavior(new NoneEndEventActivityBehavior());
            }
            if (activity != null) {
                this.parseActivityInputOutput(endEventElement, activity);
            }
            this.parseAsynchronousContinuation(endEventElement, activity);
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseEndEvent(endEventElement, scope, activity);
            }
            this.parseExecutionListenersOnScope(endEventElement, activity);
        }
    }

    public void parseBoundaryEvents(Element parentElement, ScopeImpl scopeElement) {
        for (Element boundaryEventElement : parentElement.elements("boundaryEvent")) {
            ActivityImpl parentActivity;
            String attachedToRef = boundaryEventElement.attribute("attachedToRef");
            if (attachedToRef == null || attachedToRef.equals("")) {
                this.addError("AttachedToRef is required when using a timerEventDefinition", boundaryEventElement);
            }
            String id = boundaryEventElement.attribute("id");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Parsing boundary event " + id);
            }
            if ((parentActivity = scopeElement.findActivity(attachedToRef)) == null) {
                this.addError("Invalid reference in boundary event. Make sure that the referenced activity is defined in the same scope as the boundary event", boundaryEventElement);
            }
            ActivityImpl nestedActivity = this.createActivityOnScope(boundaryEventElement, parentActivity);
            String cancelActivity = boundaryEventElement.attribute("cancelActivity", "true");
            boolean interrupting = cancelActivity.equals("true");
            ActivityBehavior behavior = null;
            Element timerEventDefinition = boundaryEventElement.element("timerEventDefinition");
            Element errorEventDefinition = boundaryEventElement.element("errorEventDefinition");
            Element signalEventDefinition = boundaryEventElement.element("signalEventDefinition");
            Element cancelEventDefinition = boundaryEventElement.element("cancelEventDefinition");
            Element compensateEventDefinition = boundaryEventElement.element("compensateEventDefinition");
            Element messageEventDefinition = boundaryEventElement.element("messageEventDefinition");
            behavior = new BoundaryEventActivityBehavior();
            if (timerEventDefinition != null) {
                this.parseBoundaryTimerEventDefinition(timerEventDefinition, interrupting, nestedActivity);
            } else if (errorEventDefinition != null) {
                interrupting = true;
                this.parseBoundaryErrorEventDefinition(errorEventDefinition, interrupting, parentActivity, nestedActivity);
            } else if (signalEventDefinition != null) {
                this.parseBoundarySignalEventDefinition(signalEventDefinition, interrupting, nestedActivity);
            } else if (cancelEventDefinition != null) {
                behavior = this.parseBoundaryCancelEventDefinition(cancelEventDefinition, nestedActivity);
            } else if (compensateEventDefinition != null) {
                this.parseCatchCompensateEventDefinition(compensateEventDefinition, nestedActivity);
            } else if (messageEventDefinition != null) {
                this.parseBoundaryMessageEventDefinition(messageEventDefinition, interrupting, nestedActivity);
            } else {
                this.addError("Unsupported boundary event type", boundaryEventElement);
            }
            this.ensureNoIoMappingDefined(boundaryEventElement);
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseBoundaryEvent(boundaryEventElement, scopeElement, nestedActivity);
            }
            if (cancelEventDefinition == null) {
                nestedActivity.setCancelScope(interrupting);
                nestedActivity.setConcurrent(!interrupting);
            }
            nestedActivity.setScope(parentActivity.getParentScope());
            nestedActivity.setActivityBehavior(behavior);
            this.parseExecutionListenersOnScope(boundaryEventElement, nestedActivity);
        }
    }

    public void parseBoundaryTimerEventDefinition(Element timerEventDefinition, boolean interrupting, ActivityImpl timerActivity) {
        timerActivity.setProperty(PROPERTYNAME_TYPE, "boundaryTimer");
        TimerDeclarationImpl timerDeclaration = this.parseTimer(timerEventDefinition, timerActivity, "timer-transition");
        if (interrupting) {
            timerDeclaration.setInterruptingTimer(true);
        }
        this.addTimerDeclaration(timerActivity.getParent(), timerDeclaration);
        if (timerActivity.getParent() instanceof ActivityImpl) {
            ((ActivityImpl)timerActivity.getParent()).setScope(true);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBoundaryTimerEventDefinition(timerEventDefinition, interrupting, timerActivity);
        }
    }

    public void parseBoundarySignalEventDefinition(Element element, boolean interrupting, ActivityImpl signalActivity) {
        signalActivity.setProperty(PROPERTYNAME_TYPE, "boundarySignal");
        EventSubscriptionDeclaration signalDefinition = this.parseSignalEventDefinition(element);
        if (signalActivity.getId() == null) {
            this.addError("boundary event has no id", element);
        }
        signalDefinition.setActivityId(signalActivity.getId());
        this.addEventSubscriptionDeclaration(signalDefinition, signalActivity.getParent(), element);
        if (signalActivity.getParent() instanceof ActivityImpl) {
            ((ActivityImpl)signalActivity.getParent()).setScope(true);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBoundarySignalEventDefinition(element, interrupting, signalActivity);
        }
    }

    public void parseBoundaryMessageEventDefinition(Element element, boolean interrupting, ActivityImpl messageActivity) {
        messageActivity.setProperty(PROPERTYNAME_TYPE, "boundaryMessage");
        EventSubscriptionDeclaration messageEventDefinition = this.parseMessageEventDefinition(element);
        if (messageActivity.getId() == null) {
            this.addError("boundary event has no id", element);
        }
        messageEventDefinition.setActivityId(messageActivity.getId());
        this.addEventSubscriptionDeclaration(messageEventDefinition, messageActivity.getParent(), element);
        if (messageActivity.getParent() instanceof ActivityImpl) {
            ((ActivityImpl)messageActivity.getParent()).setScope(true);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBoundaryMessageEventDefinition(element, interrupting, messageActivity);
        }
    }

    protected void parseTimerStartEventDefinition(Element timerEventDefinition, ActivityImpl timerActivity, ProcessDefinitionEntity processDefinition) {
        timerActivity.setProperty(PROPERTYNAME_TYPE, "startTimerEvent");
        TimerDeclarationImpl timerDeclaration = this.parseTimer(timerEventDefinition, timerActivity, "timer-start-event");
        timerDeclaration.setJobHandlerConfiguration(processDefinition.getKey());
        ArrayList<TimerDeclarationImpl> timerDeclarations = (ArrayList<TimerDeclarationImpl>)processDefinition.getProperty(PROPERTYNAME_START_TIMER);
        if (timerDeclarations == null) {
            timerDeclarations = new ArrayList<TimerDeclarationImpl>();
            processDefinition.setProperty(PROPERTYNAME_START_TIMER, timerDeclarations);
        }
        timerDeclarations.add(timerDeclaration);
    }

    protected void parseTimerStartEventDefinitionforEventSubprocess(Element timerEventDefinition, ActivityImpl timerActivity, ScopeImpl catchingScope) {
        this.parseTimerStartEventDefinitionForEventSubprocess(timerEventDefinition, timerActivity, catchingScope);
    }

    protected void parseTimerStartEventDefinitionForEventSubprocess(Element timerEventDefinition, ActivityImpl timerActivity, ScopeImpl catchingScope) {
        timerActivity.setProperty(PROPERTYNAME_TYPE, "startTimerEvent");
        TimerDeclarationImpl timerDeclaration = this.parseTimer(timerEventDefinition, timerActivity, "timer-start-event-subprocess");
        timerDeclaration.setActivityId(timerActivity.getId());
        timerDeclaration.setEventScopeActivityId(catchingScope.getId());
        timerDeclaration.setJobHandlerConfiguration(timerActivity.getParent().getId());
        this.addTimerDeclaration(catchingScope, timerDeclaration);
    }

    protected void parseEventDefinitionForSubprocess(EventSubscriptionDeclaration subscriptionDeclaration, ActivityImpl activity, ScopeImpl catchingScope, Element element) {
        subscriptionDeclaration.setActivityId(activity.getId());
        subscriptionDeclaration.setEventScopeActivityId(catchingScope.getId());
        subscriptionDeclaration.setStartEvent(false);
        this.addEventSubscriptionDeclaration(subscriptionDeclaration, catchingScope, element);
    }

    protected void parseIntemediateSignalEventDefinition(Element element, ActivityImpl signalActivity, boolean isAfterEventBasedGateway) {
        this.parseIntermediateSignalEventDefinition(element, signalActivity, isAfterEventBasedGateway);
    }

    protected void parseIntermediateSignalEventDefinition(Element element, ActivityImpl signalActivity, boolean isAfterEventBasedGateway) {
        signalActivity.setProperty(PROPERTYNAME_TYPE, "intermediateSignalCatch");
        EventSubscriptionDeclaration signalDefinition = this.parseSignalEventDefinition(element);
        if (isAfterEventBasedGateway) {
            signalDefinition.setActivityId(signalActivity.getId());
            this.addEventSubscriptionDeclaration(signalDefinition, signalActivity.getParent(), element);
        } else {
            signalActivity.setScope(true);
            this.addEventSubscriptionDeclaration(signalDefinition, signalActivity, element);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseIntermediateSignalCatchEventDefinition(element, signalActivity);
        }
    }

    protected EventSubscriptionDeclaration parseSignalEventDefinition(Element signalEventDefinitionElement) {
        String signalRef = signalEventDefinitionElement.attribute("signalRef");
        if (signalRef == null) {
            this.addError("signalEventDefinition does not have required property 'signalRef'", signalEventDefinitionElement);
            return null;
        }
        SignalDefinition signalDefinition = this.signals.get(this.resolveName(signalRef));
        if (signalDefinition == null) {
            this.addError("Could not find signal with id '" + signalRef + "'", signalEventDefinitionElement);
        }
        EventSubscriptionDeclaration signalEventDefinition = new EventSubscriptionDeclaration(signalDefinition.getName(), "signal");
        boolean asynch = "true".equals(signalEventDefinitionElement.attributeNS("http://activiti.org/bpmn", "async", "false"));
        signalEventDefinition.setAsync(asynch);
        return signalEventDefinition;
    }

    protected void parseIntemediateTimerEventDefinition(Element timerEventDefinition, ActivityImpl timerActivity, boolean isAfterEventBasedGateway) {
        this.parseIntermediateTimerEventDefinition(timerEventDefinition, timerActivity, isAfterEventBasedGateway);
    }

    protected void parseIntermediateTimerEventDefinition(Element timerEventDefinition, ActivityImpl timerActivity, boolean isAfterEventBasedGateway) {
        timerActivity.setProperty(PROPERTYNAME_TYPE, "intermediateTimer");
        TimerDeclarationImpl timerDeclaration = this.parseTimer(timerEventDefinition, timerActivity, "timer-intermediate-transition");
        if (isAfterEventBasedGateway) {
            this.addTimerDeclaration(timerActivity.getParent(), timerDeclaration);
        } else {
            this.addTimerDeclaration(timerActivity, timerDeclaration);
            timerActivity.setScope(true);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseIntermediateTimerEventDefinition(timerEventDefinition, timerActivity);
        }
    }

    protected TimerDeclarationImpl parseTimer(Element timerEventDefinition, ScopeImpl timerActivity, String jobHandlerType) {
        TimerDeclarationType type = TimerDeclarationType.DATE;
        Expression expression = this.parseExpression(timerEventDefinition, "timeDate");
        if (expression == null) {
            type = TimerDeclarationType.CYCLE;
            expression = this.parseExpression(timerEventDefinition, "timeCycle");
        }
        if (expression == null) {
            type = TimerDeclarationType.DURATION;
            expression = this.parseExpression(timerEventDefinition, "timeDuration");
        }
        if (expression == null) {
            this.addError("Timer needs configuration (either timeDate, timeCycle or timeDuration is needed).", timerEventDefinition);
        }
        TimerDeclarationImpl timerDeclaration = new TimerDeclarationImpl(expression, type, jobHandlerType);
        timerDeclaration.setJobHandlerConfiguration(timerActivity.getId());
        timerDeclaration.setExclusive("true".equals(timerEventDefinition.attributeNS("http://activiti.org/bpmn", "exclusive", String.valueOf(true))));
        if (timerActivity.getId() == null) {
            this.addError("Attribute \"id\" is required!", timerEventDefinition);
        }
        timerDeclaration.setActivityId(timerActivity.getId());
        timerDeclaration.setJobConfiguration(type.toString() + ": " + expression.getExpressionText());
        this.addJobDeclarationToProcessDefinition(timerDeclaration, timerActivity.getProcessDefinition());
        return timerDeclaration;
    }

    protected Expression parseExpression(Element parent, String name) {
        Element value = parent.element(name);
        if (value != null) {
            String expressionText = value.getText().trim();
            return this.expressionManager.createExpression(expressionText);
        }
        return null;
    }

    public void parseBoundaryErrorEventDefinition(Element errorEventDefinition, boolean interrupting, ActivityImpl activity, ActivityImpl nestedErrorEventActivity) {
        nestedErrorEventActivity.setProperty(PROPERTYNAME_TYPE, "boundaryError");
        ScopeImpl catchingScope = nestedErrorEventActivity.getParent();
        ((ActivityImpl)catchingScope).setScope(true);
        String errorRef = errorEventDefinition.attribute("errorRef");
        Error error = null;
        ErrorEventDefinition definition = new ErrorEventDefinition(nestedErrorEventActivity.getId());
        if (errorRef != null) {
            error = this.errors.get(errorRef);
            definition.setErrorCode(error == null ? errorRef : error.getErrorCode());
        }
        this.addErrorEventDefinition(definition, catchingScope);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBoundaryErrorEventDefinition(errorEventDefinition, interrupting, activity, nestedErrorEventActivity);
        }
    }

    protected void addErrorEventDefinition(ErrorEventDefinition errorEventDefinition, ScopeImpl catchingScope) {
        ArrayList<ErrorEventDefinition> errorEventDefinitions = (ArrayList<ErrorEventDefinition>)catchingScope.getProperty(PROPERTYNAME_ERROR_EVENT_DEFINITIONS);
        if (errorEventDefinitions == null) {
            errorEventDefinitions = new ArrayList<ErrorEventDefinition>();
            catchingScope.setProperty(PROPERTYNAME_ERROR_EVENT_DEFINITIONS, errorEventDefinitions);
        }
        errorEventDefinitions.add(errorEventDefinition);
        Collections.sort(errorEventDefinitions, ErrorEventDefinition.comparator);
    }

    protected List<ActivityImpl> getAllChildActivitiesOfType(String type, ScopeImpl scope) {
        ArrayList<ActivityImpl> children = new ArrayList<ActivityImpl>();
        for (ActivityImpl childActivity : scope.getActivities()) {
            if (type.equals(childActivity.getProperty(PROPERTYNAME_TYPE))) {
                children.add(childActivity);
            }
            children.addAll(this.getAllChildActivitiesOfType(type, childActivity));
        }
        return children;
    }

    protected boolean isChildActivity(ActivityImpl activityToCheck, ActivityImpl possibleParentActivity) {
        for (ActivityImpl child : possibleParentActivity.getActivities()) {
            if (!child.getId().equals(activityToCheck.getId()) && !this.isChildActivity(activityToCheck, child)) continue;
            return true;
        }
        return false;
    }

    protected void addTimerDeclaration(ScopeImpl scope, TimerDeclarationImpl timerDeclaration) {
        ArrayList<TimerDeclarationImpl> timerDeclarations = (ArrayList<TimerDeclarationImpl>)scope.getProperty(PROPERTYNAME_TIMER_DECLARATION);
        if (timerDeclarations == null) {
            timerDeclarations = new ArrayList<TimerDeclarationImpl>();
            scope.setProperty(PROPERTYNAME_TIMER_DECLARATION, timerDeclarations);
        }
        timerDeclarations.add(timerDeclaration);
    }

    protected void addVariableDeclaration(ScopeImpl scope, VariableDeclaration variableDeclaration) {
        ArrayList<VariableDeclaration> variableDeclarations = (ArrayList<VariableDeclaration>)scope.getProperty(PROPERTYNAME_VARIABLE_DECLARATIONS);
        if (variableDeclarations == null) {
            variableDeclarations = new ArrayList<VariableDeclaration>();
            scope.setProperty(PROPERTYNAME_VARIABLE_DECLARATIONS, variableDeclarations);
        }
        variableDeclarations.add(variableDeclaration);
    }

    public ActivityImpl parseSubProcess(Element subProcessElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(subProcessElement, scope);
        this.parseAsynchronousContinuation(subProcessElement, activity);
        Boolean isTriggeredByEvent = this.parseBooleanAttribute(subProcessElement.attribute(PROPERTYNAME_TRIGGERED_BY_EVENT), false);
        activity.setProperty(PROPERTYNAME_TRIGGERED_BY_EVENT, isTriggeredByEvent);
        activity.setScope(isTriggeredByEvent == false);
        activity.setActivityBehavior(new SubProcessActivityBehavior());
        this.parseScope(subProcessElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseSubProcess(subProcessElement, scope, activity);
        }
        return activity;
    }

    protected ActivityImpl parseTransaction(Element transactionElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(transactionElement, scope);
        this.parseAsynchronousContinuation(transactionElement, activity);
        activity.setScope(true);
        activity.setActivityBehavior(new TransactionActivityBehavior());
        activity.setProperty(PROPERTYNAME_TRIGGERED_BY_EVENT, false);
        this.parseScope(transactionElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseTransaction(transactionElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseCallActivity(Element callActivityElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(callActivityElement, scope);
        this.parseAsynchronousContinuation(callActivityElement, activity);
        String calledElement = callActivityElement.attribute("calledElement");
        String calledElementBinding = callActivityElement.attributeNS("http://activiti.org/bpmn", "calledElementBinding");
        String calledElementVersion = callActivityElement.attributeNS("http://activiti.org/bpmn", "calledElementVersion");
        if (calledElement == null) {
            this.addError("Missing attribute 'calledElement'", callActivityElement);
        }
        if (calledElementBinding != null && calledElementBinding.equals(CallActivityBehavior.CalledElementBinding.VERSION.getValue()) && calledElementVersion == null) {
            this.addError("Missing attribute 'calledElementVersion' when calledElementBinding has value '" + CallActivityBehavior.CalledElementBinding.VERSION.getValue() + "'", callActivityElement);
        }
        Integer processDefinitionVersion = null;
        if (calledElementVersion != null) {
            processDefinitionVersion = Integer.parseInt(calledElementVersion);
        }
        CallActivityBehavior callActivityBehaviour = null;
        String expressionRegex = "(\\$|#)(\\{.+\\})";
        callActivityBehaviour = calledElement != null && calledElement.matches(expressionRegex) ? (calledElementBinding == null ? new CallActivityBehavior(this.expressionManager.createExpression(calledElement)) : new CallActivityBehavior(this.expressionManager.createExpression(calledElement), calledElementBinding, processDefinitionVersion)) : (calledElementBinding == null ? new CallActivityBehavior(calledElement) : new CallActivityBehavior(calledElement, calledElementBinding, processDefinitionVersion));
        Element extensionsElement = callActivityElement.element("extensionElements");
        if (extensionsElement != null) {
            String variables;
            String target;
            String sourceExpression;
            String source;
            for (Element inElement : extensionsElement.elementsNS("http://activiti.org/bpmn", "in")) {
                Expression expression;
                source = inElement.attribute("source");
                sourceExpression = inElement.attribute("sourceExpression");
                target = inElement.attribute("target");
                variables = inElement.attribute("variables");
                String businessKeyExpression = inElement.attribute("businessKey");
                if ((source != null || sourceExpression != null) && target == null) {
                    this.addError("Missing attribute 'target' when attribute source or sourceExpression is set", inElement);
                    continue;
                }
                if (sourceExpression != null) {
                    expression = this.expressionManager.createExpression(sourceExpression.trim());
                    callActivityBehaviour.addDataInputAssociation(new DataAssociation(expression, target));
                    continue;
                }
                if (variables != null && "all".equals(variables)) {
                    callActivityBehaviour.addDataInputAssociation(new DataAssociation(variables));
                    continue;
                }
                if (businessKeyExpression != null) {
                    expression = this.expressionManager.createExpression(businessKeyExpression.trim());
                    callActivityBehaviour.addDataInputAssociation(new DataAssociation(expression));
                    continue;
                }
                callActivityBehaviour.addDataInputAssociation(new DataAssociation(source, target));
            }
            for (Element outElement : extensionsElement.elementsNS("http://activiti.org/bpmn", "out")) {
                source = outElement.attribute("source");
                sourceExpression = outElement.attribute("sourceExpression");
                target = outElement.attribute("target");
                variables = outElement.attribute("variables");
                if ((source != null || sourceExpression != null) && target == null) {
                    this.addError("Missing attribute 'target' when attribute source or sourceExpression is set", outElement);
                    continue;
                }
                if (sourceExpression != null) {
                    Expression expression = this.expressionManager.createExpression(sourceExpression.trim());
                    callActivityBehaviour.addDataOutputAssociation(new DataAssociation(expression, target));
                    continue;
                }
                if (variables != null && "all".equals(variables)) {
                    callActivityBehaviour.addDataOutputAssociation(new DataAssociation(variables));
                    continue;
                }
                callActivityBehaviour.addDataOutputAssociation(new DataAssociation(source, target));
            }
        }
        activity.setScope(true);
        activity.setActivityBehavior(callActivityBehaviour);
        this.parseExecutionListenersOnScope(callActivityElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseCallActivity(callActivityElement, scope, activity);
        }
        return activity;
    }

    public void parseProperties(Element element, ActivityImpl activity) {
        List<Element> propertyElements = element.elements("property");
        for (Element propertyElement : propertyElements) {
            this.parseProperty(propertyElement, activity);
        }
    }

    public void parseProperty(Element propertyElement, ActivityImpl activity) {
        String id = propertyElement.attribute("id");
        String name = propertyElement.attribute("name");
        if (name == null) {
            if (id == null) {
                this.addError("Invalid property usage on line " + propertyElement.getLine() + ": no id or name specified.", propertyElement);
            } else {
                name = id;
            }
        }
        String type = null;
        this.parsePropertyCustomExtensions(activity, propertyElement, name, type);
    }

    public void parsePropertyCustomExtensions(ActivityImpl activity, Element propertyElement, String propertyName, String propertyType) {
        String linkExpr;
        String link;
        String destExpr;
        String dst;
        String srcExpr;
        if (propertyType == null) {
            String type = propertyElement.attributeNS("http://activiti.org/bpmn", PROPERTYNAME_TYPE);
            propertyType = type != null ? type : "string";
        }
        VariableDeclaration variableDeclaration = new VariableDeclaration(propertyName, propertyType);
        this.addVariableDeclaration(activity, variableDeclaration);
        activity.setScope(true);
        String src = propertyElement.attributeNS("http://activiti.org/bpmn", "src");
        if (src != null) {
            variableDeclaration.setSourceVariableName(src);
        }
        if ((srcExpr = propertyElement.attributeNS("http://activiti.org/bpmn", "srcExpr")) != null) {
            Expression sourceExpression = this.expressionManager.createExpression(srcExpr);
            variableDeclaration.setSourceExpression(sourceExpression);
        }
        if ((dst = propertyElement.attributeNS("http://activiti.org/bpmn", "dst")) != null) {
            variableDeclaration.setDestinationVariableName(dst);
        }
        if ((destExpr = propertyElement.attributeNS("http://activiti.org/bpmn", "dstExpr")) != null) {
            Expression destinationExpression = this.expressionManager.createExpression(destExpr);
            variableDeclaration.setDestinationExpression(destinationExpression);
        }
        if ((link = propertyElement.attributeNS("http://activiti.org/bpmn", "link")) != null) {
            variableDeclaration.setLink(link);
        }
        if ((linkExpr = propertyElement.attributeNS("http://activiti.org/bpmn", "linkExpr")) != null) {
            Expression linkExpression = this.expressionManager.createExpression(linkExpr);
            variableDeclaration.setLinkExpression(linkExpression);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseProperty(propertyElement, variableDeclaration, activity);
        }
    }

    public void parseSequenceFlow(Element processElement, ScopeImpl scope) {
        for (Element sequenceFlowElement : processElement.elements("sequenceFlow")) {
            String linkName;
            String id = sequenceFlowElement.attribute("id");
            String sourceRef = sequenceFlowElement.attribute("sourceRef");
            String destinationRef = sequenceFlowElement.attribute("targetRef");
            if (this.eventLinkSources.containsKey(destinationRef) && (destinationRef = this.eventLinkTargets.get(linkName = this.eventLinkSources.get(destinationRef))) == null) {
                this.addError("sequence flow points to link event source with name '" + linkName + "' but no event target with that name exists. Most probably your link events are not configured correctly.", sequenceFlowElement);
                return;
            }
            ActivityImpl sourceActivity = scope.findActivity(sourceRef);
            ActivityImpl destinationActivity = scope.findActivity(destinationRef);
            if (sourceActivity == null) {
                this.addError("Invalid source '" + sourceRef + "' of sequence flow '" + id + "'", sequenceFlowElement);
                continue;
            }
            if (destinationActivity == null) {
                this.addError("Invalid destination '" + destinationRef + "' of sequence flow '" + id + "'", sequenceFlowElement);
                continue;
            }
            if (sourceActivity.getActivityBehavior() instanceof EventBasedGatewayActivityBehavior) continue;
            if (destinationActivity.getActivityBehavior() instanceof IntermediateCatchEventActivityBehavior && destinationActivity.getParentActivity() != null && destinationActivity.getParentActivity().getActivityBehavior() instanceof EventBasedGatewayActivityBehavior) {
                this.addError("Invalid incoming sequenceflow for intermediateCatchEvent with id '" + destinationActivity.getId() + "' connected to an event-based gateway.", sequenceFlowElement);
                continue;
            }
            if (sourceActivity.getActivityBehavior() instanceof SubProcessActivityBehavior && ((Boolean)sourceActivity.getProperty(PROPERTYNAME_TRIGGERED_BY_EVENT)).booleanValue()) {
                this.addError("Invalid outgoing sequence flow of event subprocess", sequenceFlowElement);
                continue;
            }
            if (destinationActivity.getActivityBehavior() instanceof SubProcessActivityBehavior && ((Boolean)destinationActivity.getProperty(PROPERTYNAME_TRIGGERED_BY_EVENT)).booleanValue()) {
                this.addError("Invalid incoming sequence flow of event subprocess", sequenceFlowElement);
                continue;
            }
            TransitionImpl transition = sourceActivity.createOutgoingTransition(id);
            this.sequenceFlows.put(id, transition);
            transition.setProperty("name", sequenceFlowElement.attribute("name"));
            transition.setProperty(PROPERTYNAME_DOCUMENTATION, this.parseDocumentation(sequenceFlowElement));
            transition.setDestination(destinationActivity);
            this.parseSequenceFlowConditionExpression(sequenceFlowElement, transition);
            this.parseExecutionListenersOnTransition(sequenceFlowElement, transition);
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseSequenceFlow(sequenceFlowElement, scope, transition);
            }
        }
    }

    public void parseSequenceFlowConditionExpression(Element seqFlowElement, TransitionImpl seqFlow) {
        Element conditionExprElement = seqFlowElement.element("conditionExpression");
        if (conditionExprElement != null) {
            String expression = conditionExprElement.getText().trim();
            String type = conditionExprElement.attributeNS("http://www.w3.org/2001/XMLSchema-instance", PROPERTYNAME_TYPE);
            String language = conditionExprElement.attribute("language");
            String resource = conditionExprElement.attributeNS("http://activiti.org/bpmn", "resource");
            if (type != null) {
                String value;
                String string = value = type.contains(":") ? this.resolveName(type) : "http://www.omg.org/spec/BPMN/20100524/MODEL:" + type;
                if (!value.equals(ATTRIBUTEVALUE_T_FORMAL_EXPRESSION)) {
                    this.addError("Invalid type, only tFormalExpression is currently supported", conditionExprElement);
                }
            }
            Condition condition = null;
            if (language == null) {
                condition = new UelExpressionCondition(this.expressionManager.createExpression(expression));
            } else {
                try {
                    ExecutableScript script = ScriptUtil.getScript(language, expression, resource, this.expressionManager);
                    condition = new ScriptCondition(script);
                }
                catch (ProcessEngineException e) {
                    this.addError("Unable to process condition expression:" + e.getMessage(), conditionExprElement);
                }
            }
            seqFlow.setProperty(PROPERTYNAME_CONDITION_TEXT, expression);
            seqFlow.setProperty(PROPERTYNAME_CONDITION, condition);
        }
    }

    public void parseExecutionListenersOnScope(Element scopeElement, ScopeImpl scope) {
        Element extentionsElement = scopeElement.element("extensionElements");
        if (extentionsElement != null) {
            List<Element> listenerElements = extentionsElement.elementsNS("http://activiti.org/bpmn", "executionListener");
            for (Element listenerElement : listenerElements) {
                ExecutionListener listener;
                String eventName = listenerElement.attribute("event");
                if (!this.isValidEventNameForScope(eventName, listenerElement) || (listener = this.parseExecutionListener(listenerElement)) == null) continue;
                scope.addExecutionListener(eventName, listener);
            }
        }
    }

    protected boolean isValidEventNameForScope(String eventName, Element listenerElement) {
        if (eventName != null && eventName.trim().length() > 0) {
            if ("start".equals(eventName) || "end".equals(eventName)) {
                return true;
            }
            this.addError("Attribute 'event' must be one of {start|end}", listenerElement);
        } else {
            this.addError("Attribute 'event' is mandatory on listener", listenerElement);
        }
        return false;
    }

    public void parseExecutionListenersOnTransition(Element activitiElement, TransitionImpl activity) {
        Element extensionElements = activitiElement.element("extensionElements");
        if (extensionElements != null) {
            List<Element> listenerElements = extensionElements.elementsNS("http://activiti.org/bpmn", "executionListener");
            for (Element listenerElement : listenerElements) {
                ExecutionListener listener = this.parseExecutionListener(listenerElement);
                if (listener == null) continue;
                activity.addExecutionListener(listener);
            }
        }
    }

    public ExecutionListener parseExecutionListener(Element executionListenerElement) {
        ExecutionListener executionListener = null;
        String className = executionListenerElement.attribute("class");
        String expression = executionListenerElement.attribute("expression");
        String delegateExpression = executionListenerElement.attribute("delegateExpression");
        Element scriptElement = executionListenerElement.elementNS("http://activiti.org/bpmn", "script");
        if (className != null) {
            executionListener = new ClassDelegateExecutionListener(className, this.parseFieldDeclarations(executionListenerElement));
        } else if (expression != null) {
            executionListener = new ExpressionExecutionListener(this.expressionManager.createExpression(expression));
        } else if (delegateExpression != null) {
            executionListener = new DelegateExpressionExecutionListener(this.expressionManager.createExpression(delegateExpression), this.parseFieldDeclarations(executionListenerElement));
        } else if (scriptElement != null) {
            try {
                ExecutableScript executableScript = BpmnParseUtil.parseCamundaScript(scriptElement);
                if (executableScript != null) {
                    executionListener = new ScriptExecutionListener(executableScript);
                }
            }
            catch (BpmnParseException e) {
                this.addError(e);
            }
        } else {
            this.addError("Element 'class', 'expression', 'delegateExpression' or 'script' is mandatory on executionListener", executionListenerElement);
        }
        return executionListener;
    }

    public void parseDiagramInterchangeElements() {
        List<Element> diagrams = this.rootElement.elementsNS("http://www.omg.org/spec/BPMN/20100524/DI", "BPMNDiagram");
        if (!diagrams.isEmpty()) {
            for (Element diagramElement : diagrams) {
                this.parseBPMNDiagram(diagramElement);
            }
        }
    }

    public void parseBPMNDiagram(Element bpmndiagramElement) {
        Element bpmnPlane = bpmndiagramElement.elementNS("http://www.omg.org/spec/BPMN/20100524/DI", "BPMNPlane");
        if (bpmnPlane != null) {
            this.parseBPMNPlane(bpmnPlane);
        }
    }

    public void parseBPMNPlane(Element bpmnPlaneElement) {
        String bpmnElement = bpmnPlaneElement.attribute("bpmnElement");
        if (bpmnElement != null && !"".equals(bpmnElement)) {
            if (this.getProcessDefinition(bpmnElement) != null) {
                this.getProcessDefinition(bpmnElement).setGraphicalNotationDefined(true);
            }
            List<Element> shapes = bpmnPlaneElement.elementsNS("http://www.omg.org/spec/BPMN/20100524/DI", "BPMNShape");
            for (Element shape : shapes) {
                this.parseBPMNShape(shape);
            }
            List<Element> edges = bpmnPlaneElement.elementsNS("http://www.omg.org/spec/BPMN/20100524/DI", "BPMNEdge");
            for (Element edge : edges) {
                this.parseBPMNEdge(edge);
            }
        } else {
            this.addError("'bpmnElement' attribute is required on BPMNPlane ", bpmnPlaneElement);
        }
    }

    public void parseBPMNShape(Element bpmnShapeElement) {
        String bpmnElement = bpmnShapeElement.attribute("bpmnElement");
        if (bpmnElement != null && !"".equals(bpmnElement)) {
            if (this.participantProcesses.get(bpmnElement) != null) {
                ProcessDefinitionEntity procDef = this.getProcessDefinition(this.participantProcesses.get(bpmnElement));
                procDef.setGraphicalNotationDefined(true);
                this.parseDIBounds(bpmnShapeElement, procDef.getParticipantProcess());
                return;
            }
            for (ProcessDefinitionEntity processDefinition : this.getProcessDefinitions()) {
                ActivityImpl activity = processDefinition.findActivity(bpmnElement);
                if (activity != null) {
                    this.parseDIBounds(bpmnShapeElement, activity);
                    String isExpanded = bpmnShapeElement.attribute(PROPERTYNAME_ISEXPANDED);
                    if (isExpanded == null) continue;
                    activity.setProperty(PROPERTYNAME_ISEXPANDED, this.parseBooleanAttribute(isExpanded));
                    continue;
                }
                Lane lane = processDefinition.getLaneForId(bpmnElement);
                if (lane != null) {
                    this.parseDIBounds(bpmnShapeElement, lane);
                    continue;
                }
                if (this.elementIds.contains(bpmnElement)) continue;
                this.addError("Invalid reference in 'bpmnElement' attribute, activity " + bpmnElement + "not found", bpmnShapeElement);
            }
        } else {
            this.addError("'bpmnElement' attribute is required on BPMNShape", bpmnShapeElement);
        }
    }

    protected void parseDIBounds(Element bpmnShapeElement, HasDIBounds target) {
        Element bounds = bpmnShapeElement.elementNS("http://www.omg.org/spec/DD/20100524/DC", "Bounds");
        if (bounds != null) {
            target.setX(this.parseDoubleAttribute(bpmnShapeElement, "x", bounds.attribute("x"), true).intValue());
            target.setY(this.parseDoubleAttribute(bpmnShapeElement, "y", bounds.attribute("y"), true).intValue());
            target.setWidth(this.parseDoubleAttribute(bpmnShapeElement, "width", bounds.attribute("width"), true).intValue());
            target.setHeight(this.parseDoubleAttribute(bpmnShapeElement, "height", bounds.attribute("height"), true).intValue());
        } else {
            this.addError("'Bounds' element is required", bpmnShapeElement);
        }
    }

    public void parseBPMNEdge(Element bpmnEdgeElement) {
        String sequenceFlowId = bpmnEdgeElement.attribute("bpmnElement");
        if (sequenceFlowId != null && !"".equals(sequenceFlowId)) {
            if (this.sequenceFlows != null && this.sequenceFlows.containsKey(sequenceFlowId)) {
                TransitionImpl sequenceFlow = this.sequenceFlows.get(sequenceFlowId);
                List<Element> waypointElements = bpmnEdgeElement.elementsNS("http://www.omg.org/spec/DD/20100524/DI", "waypoint");
                if (waypointElements.size() >= 2) {
                    ArrayList<Integer> waypoints = new ArrayList<Integer>();
                    for (Element waypointElement : waypointElements) {
                        waypoints.add(this.parseDoubleAttribute(waypointElement, "x", waypointElement.attribute("x"), true).intValue());
                        waypoints.add(this.parseDoubleAttribute(waypointElement, "y", waypointElement.attribute("y"), true).intValue());
                    }
                    sequenceFlow.setWaypoints(waypoints);
                } else {
                    this.addError("Minimum 2 waypoint elements must be definted for a 'BPMNEdge'", bpmnEdgeElement);
                }
            } else if (!this.elementIds.contains(sequenceFlowId)) {
                this.addError("Invalid reference in 'bpmnElement' attribute, sequenceFlow " + sequenceFlowId + "not found", bpmnEdgeElement);
            }
        } else {
            this.addError("'bpmnElement' attribute is required on BPMNEdge", bpmnEdgeElement);
        }
    }

    public List<ProcessDefinitionEntity> getProcessDefinitions() {
        return this.processDefinitions;
    }

    public ProcessDefinitionEntity getProcessDefinition(String processDefinitionKey) {
        for (ProcessDefinitionEntity processDefinition : this.processDefinitions) {
            if (!processDefinition.getKey().equals(processDefinitionKey)) continue;
            return processDefinition;
        }
        return null;
    }

    @Override
    public BpmnParse name(String name) {
        super.name(name);
        return this;
    }

    @Override
    public BpmnParse sourceInputStream(InputStream inputStream) {
        super.sourceInputStream(inputStream);
        return this;
    }

    @Override
    public BpmnParse sourceResource(String resource, ClassLoader classLoader) {
        super.sourceResource(resource, classLoader);
        return this;
    }

    @Override
    public BpmnParse sourceResource(String resource) {
        super.sourceResource(resource);
        return this;
    }

    @Override
    public BpmnParse sourceString(String string) {
        super.sourceString(string);
        return this;
    }

    @Override
    public BpmnParse sourceUrl(String url) {
        super.sourceUrl(url);
        return this;
    }

    @Override
    public BpmnParse sourceUrl(URL url) {
        super.sourceUrl(url);
        return this;
    }

    public Boolean parseBooleanAttribute(String booleanText, boolean defaultValue) {
        if (booleanText == null) {
            return defaultValue;
        }
        return this.parseBooleanAttribute(booleanText);
    }

    public Boolean parseBooleanAttribute(String booleanText) {
        if ("true".equals(booleanText) || "enabled".equals(booleanText) || "on".equals(booleanText) || "active".equals(booleanText) || "yes".equals(booleanText)) {
            return Boolean.TRUE;
        }
        if ("false".equals(booleanText) || "disabled".equals(booleanText) || "off".equals(booleanText) || "inactive".equals(booleanText) || "no".equals(booleanText)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public Double parseDoubleAttribute(Element element, String attributename, String doubleText, boolean required) {
        if (required && (doubleText == null || "".equals(doubleText))) {
            this.addError(attributename + " is required", element);
        } else {
            try {
                return Double.parseDouble(doubleText);
            }
            catch (NumberFormatException e) {
                this.addError("Cannot parse " + attributename + ": " + e.getMessage(), element);
            }
        }
        return -1.0;
    }

    protected boolean isExclusive(Element element) {
        return "true".equals(element.attributeNS("http://activiti.org/bpmn", "exclusive", String.valueOf(true)));
    }

    protected boolean isAsyncBefore(Element element) {
        return "true".equals(element.attributeNS("http://activiti.org/bpmn", "async")) || "true".equals(element.attributeNS("http://activiti.org/bpmn", "asyncBefore"));
    }

    protected boolean isAsyncAfter(Element element) {
        return "true".equals(element.attributeNS("http://activiti.org/bpmn", "asyncAfter"));
    }

    private boolean isServiceTaskLike(Element element) {
        return element.attributeNS("http://activiti.org/bpmn", "class") != null || element.attributeNS("http://activiti.org/bpmn", "expression") != null || element.attributeNS("http://activiti.org/bpmn", "delegateExpression") != null;
    }

    public Map<String, List<JobDeclaration<?>>> getJobDeclarations() {
        return this.jobDeclarations;
    }

    public List<JobDeclaration<?>> getJobDeclarationsByKey(String processDefinitionKey) {
        return this.jobDeclarations.get(processDefinitionKey);
    }

    protected void parseActivityInputOutput(Element activityElement, ActivityImpl activity) {
        Element extensionElements = activityElement.element("extensionElements");
        if (extensionElements != null) {
            IoMapping inputOutput = null;
            try {
                inputOutput = BpmnParseUtil.parseInputOutput(extensionElements);
            }
            catch (BpmnParseException e) {
                this.addError(e);
            }
            if (inputOutput != null && this.checkActivityInputOutputSupported(activityElement, activity, inputOutput)) {
                if (activity.getActivityBehavior() instanceof MultiInstanceActivityBehavior) {
                    MultiInstanceActivityBehavior behavior = (MultiInstanceActivityBehavior)activity.getActivityBehavior();
                    behavior.setIoMapping(inputOutput);
                } else {
                    activity.setIoMapping(inputOutput);
                }
                activity.setScope(true);
            }
        }
    }

    protected boolean checkActivityInputOutputSupported(Element activityElement, ActivityImpl activity, IoMapping inputOutput) {
        String tagName = activityElement.getTagName();
        if (!(tagName.contains("Task") || tagName.contains("Event") || tagName.equals("transaction") || tagName.equals("subProcess"))) {
            this.addError("camunda:inputOutput mapping unsupported for element type '" + tagName + "'.", activityElement);
            return false;
        }
        if (tagName.equals("subProcess") && "true".equals(activityElement.attribute(PROPERTYNAME_TRIGGERED_BY_EVENT))) {
            this.addError("camunda:inputOutput mapping unsupported for element type '" + tagName + "' with attribute 'triggeredByEvent = true'.", activityElement);
            return false;
        }
        if (!inputOutput.getOutputParameters().isEmpty()) {
            return this.checkActivityOutputParameterSupported(activityElement, activity);
        }
        return true;
    }

    protected boolean checkActivityOutputParameterSupported(Element activityElement, ActivityImpl activity) {
        String tagName = activityElement.getTagName();
        if (tagName.equals("endEvent")) {
            this.addError("camunda:outputParameter not allowed for element type '" + tagName + "'.", activityElement);
            return true;
        }
        if (activity.getActivityBehavior() instanceof MultiInstanceActivityBehavior) {
            this.addError("camunda:outputParameter not allowed for multi-instance constructs", activityElement);
            return false;
        }
        return true;
    }

    protected void ensureNoIoMappingDefined(Element element) {
        Element inputOutput = BpmnParseUtil.findCamundaExtensionElement(element, "inputOutput");
        if (inputOutput != null) {
            this.addError("camunda:inputOutput mapping unsupported for element type '" + element.getTagName() + "'.", element);
        }
    }
}

