/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ServiceTaskJavaDelegateActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.helper.ErrorPropagation;
import org.camunda.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.camunda.bpm.engine.impl.util.ClassDelegateUtil;

public class ClassDelegateActivityBehavior
extends AbstractBpmnActivityBehavior {
    protected String className;
    protected List<FieldDeclaration> fieldDeclarations;

    public ClassDelegateActivityBehavior(String className, List<FieldDeclaration> fieldDeclarations) {
        this.className = className;
        this.fieldDeclarations = fieldDeclarations;
    }

    public ClassDelegateActivityBehavior(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        this(clazz.getName(), fieldDeclarations);
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        ActivityBehavior activityBehaviorInstance = this.getActivityBehaviorInstance(execution);
        try {
            activityBehaviorInstance.execute(execution);
        }
        catch (BpmnError error) {
            ErrorPropagation.propagateError(error, execution);
        }
        catch (Exception ex) {
            ErrorPropagation.propagateException(ex, execution);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void signal(final ActivityExecution execution, final String signalName, final Object signalData) throws Exception {
        ProcessApplicationReference targetProcessApplication = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
        if (!ProcessApplicationContextUtil.requiresContextSwitch(targetProcessApplication)) {
            ActivityBehavior activityBehaviorInstance = this.getActivityBehaviorInstance(execution);
            if (!(activityBehaviorInstance instanceof SignallableActivityBehavior)) throw new ProcessEngineException("signal() can only be called on a " + SignallableActivityBehavior.class.getName() + " instance");
            try {
                ((SignallableActivityBehavior)activityBehaviorInstance).signal(execution, signalName, signalData);
                return;
            }
            catch (BpmnError error) {
                ErrorPropagation.propagateError(error, execution);
                return;
            }
            catch (Exception exception) {
                ErrorPropagation.propagateException(exception, execution);
            }
            return;
        } else {
            Context.executeWithinProcessApplication(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        ClassDelegateActivityBehavior.this.signal(execution, signalName, signalData);
                    }
                    catch (BpmnError error) {
                        ErrorPropagation.propagateError(error, execution);
                    }
                    catch (Exception exception) {
                        ErrorPropagation.propagateException(exception, execution);
                    }
                    return null;
                }
            }, targetProcessApplication);
        }
    }

    protected ActivityBehavior getActivityBehaviorInstance(ActivityExecution execution) {
        Object delegateInstance = ClassDelegateUtil.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof ActivityBehavior) {
            return this.determineBehaviour((ActivityBehavior)delegateInstance, execution);
        }
        if (delegateInstance instanceof JavaDelegate) {
            return this.determineBehaviour(new ServiceTaskJavaDelegateActivityBehavior((JavaDelegate)delegateInstance), execution);
        }
        throw new ProcessEngineException(delegateInstance.getClass().getName() + " doesn't implement " + JavaDelegate.class.getName() + " nor " + ActivityBehavior.class.getName());
    }

    protected ActivityBehavior determineBehaviour(ActivityBehavior delegateInstance, ActivityExecution execution) {
        if (this.hasMultiInstanceCharacteristics()) {
            ((AbstractBpmnActivityBehavior)delegateInstance).setMultiInstanceActivityBehavior(this.multiInstanceActivityBehavior);
        }
        return delegateInstance;
    }
}

