/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapitools.client.model.ExecutionDto;
import org.openapitools.client.model.ProcessInstanceDto;
import org.openapitools.client.model.VariableValueDto;

/**
 * The &#x60;processInstance&#x60; property only has a value if the resultType is set to &#x60;ProcessDefinition&#x60;. The processInstance with the properties as described in the [get single instance](https://docs.camunda.org/manual/7.22/reference/rest/process-instance/get/) method.  The &#x60;execution&#x60; property only has a value if the resultType is set to &#x60;Execution&#x60;. The execution with the properties as described in the [get single execution](https://docs.camunda.org/manual/7.22/reference/rest/execution/get/) method.
 */
@ApiModel(description = "The `processInstance` property only has a value if the resultType is set to `ProcessDefinition`. The processInstance with the properties as described in the [get single instance](https://docs.camunda.org/manual/7.22/reference/rest/process-instance/get/) method.  The `execution` property only has a value if the resultType is set to `Execution`. The execution with the properties as described in the [get single execution](https://docs.camunda.org/manual/7.22/reference/rest/execution/get/) method.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-30T07:31:15.229408535Z[Etc/UTC]")
public class MessageCorrelationResultWithVariableDto {
  /**
   * Indicates if the message was correlated to a message start event or an  intermediate message catching event. In the first case, the resultType is  &#x60;ProcessDefinition&#x60; and otherwise &#x60;Execution&#x60;.
   */
  @JsonAdapter(ResultTypeEnum.Adapter.class)
  public enum ResultTypeEnum {
    EXECUTION("Execution"),
    
    PROCESSDEFINITION("ProcessDefinition");

    private String value;

    ResultTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ResultTypeEnum fromValue(String value) {
      for (ResultTypeEnum b : ResultTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<ResultTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ResultTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ResultTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ResultTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_RESULT_TYPE = "resultType";
  @SerializedName(SERIALIZED_NAME_RESULT_TYPE)
  private ResultTypeEnum resultType;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE = "processInstance";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE)
  private ProcessInstanceDto processInstance = null;

  public static final String SERIALIZED_NAME_EXECUTION = "execution";
  @SerializedName(SERIALIZED_NAME_EXECUTION)
  private ExecutionDto execution;

  public static final String SERIALIZED_NAME_VARIABLES = "variables";
  @SerializedName(SERIALIZED_NAME_VARIABLES)
  private Map<String, VariableValueDto> variables = null;


  public MessageCorrelationResultWithVariableDto resultType(ResultTypeEnum resultType) {
    
    this.resultType = resultType;
    return this;
  }

   /**
   * Indicates if the message was correlated to a message start event or an  intermediate message catching event. In the first case, the resultType is  &#x60;ProcessDefinition&#x60; and otherwise &#x60;Execution&#x60;.
   * @return resultType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Indicates if the message was correlated to a message start event or an  intermediate message catching event. In the first case, the resultType is  `ProcessDefinition` and otherwise `Execution`.")

  public ResultTypeEnum getResultType() {
    return resultType;
  }


  public void setResultType(ResultTypeEnum resultType) {
    this.resultType = resultType;
  }


  public MessageCorrelationResultWithVariableDto processInstance(ProcessInstanceDto processInstance) {
    
    this.processInstance = processInstance;
    return this;
  }

   /**
   * Get processInstance
   * @return processInstance
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ProcessInstanceDto getProcessInstance() {
    return processInstance;
  }


  public void setProcessInstance(ProcessInstanceDto processInstance) {
    this.processInstance = processInstance;
  }


  public MessageCorrelationResultWithVariableDto execution(ExecutionDto execution) {
    
    this.execution = execution;
    return this;
  }

   /**
   * Get execution
   * @return execution
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ExecutionDto getExecution() {
    return execution;
  }


  public void setExecution(ExecutionDto execution) {
    this.execution = execution;
  }


  public MessageCorrelationResultWithVariableDto variables(Map<String, VariableValueDto> variables) {
    
    this.variables = variables;
    return this;
  }

  public MessageCorrelationResultWithVariableDto putVariablesItem(String key, VariableValueDto variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<String, VariableValueDto>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

   /**
   * This property is returned if the &#x60;variablesInResultEnabled&#x60; is set to &#x60;true&#x60;. Contains a list of the process variables. 
   * @return variables
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "This property is returned if the `variablesInResultEnabled` is set to `true`. Contains a list of the process variables. ")

  public Map<String, VariableValueDto> getVariables() {
    return variables;
  }


  public void setVariables(Map<String, VariableValueDto> variables) {
    this.variables = variables;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MessageCorrelationResultWithVariableDto messageCorrelationResultWithVariableDto = (MessageCorrelationResultWithVariableDto) o;
    return Objects.equals(this.resultType, messageCorrelationResultWithVariableDto.resultType) &&
        Objects.equals(this.processInstance, messageCorrelationResultWithVariableDto.processInstance) &&
        Objects.equals(this.execution, messageCorrelationResultWithVariableDto.execution) &&
        Objects.equals(this.variables, messageCorrelationResultWithVariableDto.variables);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resultType, processInstance, execution, variables);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MessageCorrelationResultWithVariableDto {\n");
    sb.append("    resultType: ").append(toIndentedString(resultType)).append("\n");
    sb.append("    processInstance: ").append(toIndentedString(processInstance)).append("\n");
    sb.append("    execution: ").append(toIndentedString(execution)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

