/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openapitools.client.model.HistoricDetailQueryDtoSorting;

/**
 * A historic detail query which defines a group of historic details.
 */
@ApiModel(description = "A historic detail query which defines a group of historic details.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-30T07:31:15.229408535Z[Etc/UTC]")
public class HistoricDetailQueryDto {
  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_ID)
  private String processInstanceId;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID_IN = "processInstanceIdIn";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_ID_IN)
  private List<String> processInstanceIdIn = null;

  public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
  @SerializedName(SERIALIZED_NAME_EXECUTION_ID)
  private String executionId;

  public static final String SERIALIZED_NAME_TASK_ID = "taskId";
  @SerializedName(SERIALIZED_NAME_TASK_ID)
  private String taskId;

  public static final String SERIALIZED_NAME_ACTIVITY_INSTANCE_ID = "activityInstanceId";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_INSTANCE_ID)
  private String activityInstanceId;

  public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
  @SerializedName(SERIALIZED_NAME_CASE_INSTANCE_ID)
  private String caseInstanceId;

  public static final String SERIALIZED_NAME_CASE_EXECUTION_ID = "caseExecutionId";
  @SerializedName(SERIALIZED_NAME_CASE_EXECUTION_ID)
  private String caseExecutionId;

  public static final String SERIALIZED_NAME_VARIABLE_INSTANCE_ID = "variableInstanceId";
  @SerializedName(SERIALIZED_NAME_VARIABLE_INSTANCE_ID)
  private String variableInstanceId;

  public static final String SERIALIZED_NAME_VARIABLE_TYPE_IN = "variableTypeIn";
  @SerializedName(SERIALIZED_NAME_VARIABLE_TYPE_IN)
  private List<String> variableTypeIn = null;

  public static final String SERIALIZED_NAME_VARIABLE_NAME_LIKE = "variableNameLike";
  @SerializedName(SERIALIZED_NAME_VARIABLE_NAME_LIKE)
  private String variableNameLike;

  public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
  @SerializedName(SERIALIZED_NAME_TENANT_ID_IN)
  private List<String> tenantIdIn = null;

  public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
  @SerializedName(SERIALIZED_NAME_WITHOUT_TENANT_ID)
  private Boolean withoutTenantId;

  public static final String SERIALIZED_NAME_USER_OPERATION_ID = "userOperationId";
  @SerializedName(SERIALIZED_NAME_USER_OPERATION_ID)
  private String userOperationId;

  public static final String SERIALIZED_NAME_FORM_FIELDS = "formFields";
  @SerializedName(SERIALIZED_NAME_FORM_FIELDS)
  private Boolean formFields;

  public static final String SERIALIZED_NAME_VARIABLE_UPDATES = "variableUpdates";
  @SerializedName(SERIALIZED_NAME_VARIABLE_UPDATES)
  private Boolean variableUpdates;

  public static final String SERIALIZED_NAME_EXCLUDE_TASK_DETAILS = "excludeTaskDetails";
  @SerializedName(SERIALIZED_NAME_EXCLUDE_TASK_DETAILS)
  private Boolean excludeTaskDetails;

  public static final String SERIALIZED_NAME_INITIAL = "initial";
  @SerializedName(SERIALIZED_NAME_INITIAL)
  private Boolean initial;

  public static final String SERIALIZED_NAME_OCCURRED_BEFORE = "occurredBefore";
  @SerializedName(SERIALIZED_NAME_OCCURRED_BEFORE)
  private Date occurredBefore;

  public static final String SERIALIZED_NAME_OCCURRED_AFTER = "occurredAfter";
  @SerializedName(SERIALIZED_NAME_OCCURRED_AFTER)
  private Date occurredAfter;

  public static final String SERIALIZED_NAME_SORTING = "sorting";
  @SerializedName(SERIALIZED_NAME_SORTING)
  private List<HistoricDetailQueryDtoSorting> sorting = null;


  public HistoricDetailQueryDto processInstanceId(String processInstanceId) {
    
    this.processInstanceId = processInstanceId;
    return this;
  }

   /**
   * Filter by process instance id.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by process instance id.")

  public String getProcessInstanceId() {
    return processInstanceId;
  }


  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = processInstanceId;
  }


  public HistoricDetailQueryDto processInstanceIdIn(List<String> processInstanceIdIn) {
    
    this.processInstanceIdIn = processInstanceIdIn;
    return this;
  }

  public HistoricDetailQueryDto addProcessInstanceIdInItem(String processInstanceIdInItem) {
    if (this.processInstanceIdIn == null) {
      this.processInstanceIdIn = new ArrayList<String>();
    }
    this.processInstanceIdIn.add(processInstanceIdInItem);
    return this;
  }

   /**
   * Only include historic details which belong to one of the passed  process instance ids.
   * @return processInstanceIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include historic details which belong to one of the passed  process instance ids.")

  public List<String> getProcessInstanceIdIn() {
    return processInstanceIdIn;
  }


  public void setProcessInstanceIdIn(List<String> processInstanceIdIn) {
    this.processInstanceIdIn = processInstanceIdIn;
  }


  public HistoricDetailQueryDto executionId(String executionId) {
    
    this.executionId = executionId;
    return this;
  }

   /**
   * Filter by execution id.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by execution id.")

  public String getExecutionId() {
    return executionId;
  }


  public void setExecutionId(String executionId) {
    this.executionId = executionId;
  }


  public HistoricDetailQueryDto taskId(String taskId) {
    
    this.taskId = taskId;
    return this;
  }

   /**
   * Filter by task id.
   * @return taskId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by task id.")

  public String getTaskId() {
    return taskId;
  }


  public void setTaskId(String taskId) {
    this.taskId = taskId;
  }


  public HistoricDetailQueryDto activityInstanceId(String activityInstanceId) {
    
    this.activityInstanceId = activityInstanceId;
    return this;
  }

   /**
   * Filter by activity instance id.
   * @return activityInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by activity instance id.")

  public String getActivityInstanceId() {
    return activityInstanceId;
  }


  public void setActivityInstanceId(String activityInstanceId) {
    this.activityInstanceId = activityInstanceId;
  }


  public HistoricDetailQueryDto caseInstanceId(String caseInstanceId) {
    
    this.caseInstanceId = caseInstanceId;
    return this;
  }

   /**
   * Filter by case instance id.
   * @return caseInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by case instance id.")

  public String getCaseInstanceId() {
    return caseInstanceId;
  }


  public void setCaseInstanceId(String caseInstanceId) {
    this.caseInstanceId = caseInstanceId;
  }


  public HistoricDetailQueryDto caseExecutionId(String caseExecutionId) {
    
    this.caseExecutionId = caseExecutionId;
    return this;
  }

   /**
   * Filter by case execution id.
   * @return caseExecutionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by case execution id.")

  public String getCaseExecutionId() {
    return caseExecutionId;
  }


  public void setCaseExecutionId(String caseExecutionId) {
    this.caseExecutionId = caseExecutionId;
  }


  public HistoricDetailQueryDto variableInstanceId(String variableInstanceId) {
    
    this.variableInstanceId = variableInstanceId;
    return this;
  }

   /**
   * Filter by variable instance id.
   * @return variableInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by variable instance id.")

  public String getVariableInstanceId() {
    return variableInstanceId;
  }


  public void setVariableInstanceId(String variableInstanceId) {
    this.variableInstanceId = variableInstanceId;
  }


  public HistoricDetailQueryDto variableTypeIn(List<String> variableTypeIn) {
    
    this.variableTypeIn = variableTypeIn;
    return this;
  }

  public HistoricDetailQueryDto addVariableTypeInItem(String variableTypeInItem) {
    if (this.variableTypeIn == null) {
      this.variableTypeIn = new ArrayList<String>();
    }
    this.variableTypeIn.add(variableTypeInItem);
    return this;
  }

   /**
   * Only include historic details where the variable updates belong to one of the passed  list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.22/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#x60;serializable&#x60;.
   * @return variableTypeIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include historic details where the variable updates belong to one of the passed  list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.22/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type `serializable`.")

  public List<String> getVariableTypeIn() {
    return variableTypeIn;
  }


  public void setVariableTypeIn(List<String> variableTypeIn) {
    this.variableTypeIn = variableTypeIn;
  }


  public HistoricDetailQueryDto variableNameLike(String variableNameLike) {
    
    this.variableNameLike = variableNameLike;
    return this;
  }

   /**
   * Filter by variable name like. Example usage: &#x60;variableNameLike(%camunda%)&#x60;. The query will match the names of variables in a case-insensitive way.
   * @return variableNameLike
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by variable name like. Example usage: `variableNameLike(%camunda%)`. The query will match the names of variables in a case-insensitive way.")

  public String getVariableNameLike() {
    return variableNameLike;
  }


  public void setVariableNameLike(String variableNameLike) {
    this.variableNameLike = variableNameLike;
  }


  public HistoricDetailQueryDto tenantIdIn(List<String> tenantIdIn) {
    
    this.tenantIdIn = tenantIdIn;
    return this;
  }

  public HistoricDetailQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null) {
      this.tenantIdIn = new ArrayList<String>();
    }
    this.tenantIdIn.add(tenantIdInItem);
    return this;
  }

   /**
   * Filter by a  list of tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by a  list of tenant ids.")

  public List<String> getTenantIdIn() {
    return tenantIdIn;
  }


  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }


  public HistoricDetailQueryDto withoutTenantId(Boolean withoutTenantId) {
    
    this.withoutTenantId = withoutTenantId;
    return this;
  }

   /**
   * Only include historic details that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include historic details that belong to no tenant. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getWithoutTenantId() {
    return withoutTenantId;
  }


  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }


  public HistoricDetailQueryDto userOperationId(String userOperationId) {
    
    this.userOperationId = userOperationId;
    return this;
  }

   /**
   * Filter by a user operation id.
   * @return userOperationId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by a user operation id.")

  public String getUserOperationId() {
    return userOperationId;
  }


  public void setUserOperationId(String userOperationId) {
    this.userOperationId = userOperationId;
  }


  public HistoricDetailQueryDto formFields(Boolean formFields) {
    
    this.formFields = formFields;
    return this;
  }

   /**
   * Only include &#x60;HistoricFormFields&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return formFields
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include `HistoricFormFields`. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getFormFields() {
    return formFields;
  }


  public void setFormFields(Boolean formFields) {
    this.formFields = formFields;
  }


  public HistoricDetailQueryDto variableUpdates(Boolean variableUpdates) {
    
    this.variableUpdates = variableUpdates;
    return this;
  }

   /**
   * Only include &#x60;HistoricVariableUpdates&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return variableUpdates
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include `HistoricVariableUpdates`. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getVariableUpdates() {
    return variableUpdates;
  }


  public void setVariableUpdates(Boolean variableUpdates) {
    this.variableUpdates = variableUpdates;
  }


  public HistoricDetailQueryDto excludeTaskDetails(Boolean excludeTaskDetails) {
    
    this.excludeTaskDetails = excludeTaskDetails;
    return this;
  }

   /**
   * Excludes all task-related &#x60;HistoricDetails&#x60;, so only items which have no task id set will be selected. When this parameter is used together with &#x60;taskId&#x60;, this call is ignored and task details are not excluded. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return excludeTaskDetails
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Excludes all task-related `HistoricDetails`, so only items which have no task id set will be selected. When this parameter is used together with `taskId`, this call is ignored and task details are not excluded. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getExcludeTaskDetails() {
    return excludeTaskDetails;
  }


  public void setExcludeTaskDetails(Boolean excludeTaskDetails) {
    this.excludeTaskDetails = excludeTaskDetails;
  }


  public HistoricDetailQueryDto initial(Boolean initial) {
    
    this.initial = initial;
    return this;
  }

   /**
   * Restrict to historic variable updates that contain only initial variable values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return initial
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to historic variable updates that contain only initial variable values. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getInitial() {
    return initial;
  }


  public void setInitial(Boolean initial) {
    this.initial = initial;
  }


  public HistoricDetailQueryDto occurredBefore(Date occurredBefore) {
    
    this.occurredBefore = occurredBefore;
    return this;
  }

   /**
   * Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200.
   * @return occurredBefore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.")

  public Date getOccurredBefore() {
    return occurredBefore;
  }


  public void setOccurredBefore(Date occurredBefore) {
    this.occurredBefore = occurredBefore;
  }


  public HistoricDetailQueryDto occurredAfter(Date occurredAfter) {
    
    this.occurredAfter = occurredAfter;
    return this;
  }

   /**
   * Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200.
   * @return occurredAfter
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.22/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.")

  public Date getOccurredAfter() {
    return occurredAfter;
  }


  public void setOccurredAfter(Date occurredAfter) {
    this.occurredAfter = occurredAfter;
  }


  public HistoricDetailQueryDto sorting(List<HistoricDetailQueryDtoSorting> sorting) {
    
    this.sorting = sorting;
    return this;
  }

  public HistoricDetailQueryDto addSortingItem(HistoricDetailQueryDtoSorting sortingItem) {
    if (this.sorting == null) {
      this.sorting = new ArrayList<HistoricDetailQueryDtoSorting>();
    }
    this.sorting.add(sortingItem);
    return this;
  }

   /**
   * A JSON array of criteria to sort the result by. Each element of the array is                     a JSON object that specifies one ordering. The position in the array                     identifies the rank of an ordering, i.e., whether it is primary, secondary,                     etc. Does not have an effect for the &#x60;count&#x60; endpoint.
   * @return sorting
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A JSON array of criteria to sort the result by. Each element of the array is                     a JSON object that specifies one ordering. The position in the array                     identifies the rank of an ordering, i.e., whether it is primary, secondary,                     etc. Does not have an effect for the `count` endpoint.")

  public List<HistoricDetailQueryDtoSorting> getSorting() {
    return sorting;
  }


  public void setSorting(List<HistoricDetailQueryDtoSorting> sorting) {
    this.sorting = sorting;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricDetailQueryDto historicDetailQueryDto = (HistoricDetailQueryDto) o;
    return Objects.equals(this.processInstanceId, historicDetailQueryDto.processInstanceId) &&
        Objects.equals(this.processInstanceIdIn, historicDetailQueryDto.processInstanceIdIn) &&
        Objects.equals(this.executionId, historicDetailQueryDto.executionId) &&
        Objects.equals(this.taskId, historicDetailQueryDto.taskId) &&
        Objects.equals(this.activityInstanceId, historicDetailQueryDto.activityInstanceId) &&
        Objects.equals(this.caseInstanceId, historicDetailQueryDto.caseInstanceId) &&
        Objects.equals(this.caseExecutionId, historicDetailQueryDto.caseExecutionId) &&
        Objects.equals(this.variableInstanceId, historicDetailQueryDto.variableInstanceId) &&
        Objects.equals(this.variableTypeIn, historicDetailQueryDto.variableTypeIn) &&
        Objects.equals(this.variableNameLike, historicDetailQueryDto.variableNameLike) &&
        Objects.equals(this.tenantIdIn, historicDetailQueryDto.tenantIdIn) &&
        Objects.equals(this.withoutTenantId, historicDetailQueryDto.withoutTenantId) &&
        Objects.equals(this.userOperationId, historicDetailQueryDto.userOperationId) &&
        Objects.equals(this.formFields, historicDetailQueryDto.formFields) &&
        Objects.equals(this.variableUpdates, historicDetailQueryDto.variableUpdates) &&
        Objects.equals(this.excludeTaskDetails, historicDetailQueryDto.excludeTaskDetails) &&
        Objects.equals(this.initial, historicDetailQueryDto.initial) &&
        Objects.equals(this.occurredBefore, historicDetailQueryDto.occurredBefore) &&
        Objects.equals(this.occurredAfter, historicDetailQueryDto.occurredAfter) &&
        Objects.equals(this.sorting, historicDetailQueryDto.sorting);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processInstanceId, processInstanceIdIn, executionId, taskId, activityInstanceId, caseInstanceId, caseExecutionId, variableInstanceId, variableTypeIn, variableNameLike, tenantIdIn, withoutTenantId, userOperationId, formFields, variableUpdates, excludeTaskDetails, initial, occurredBefore, occurredAfter, sorting);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricDetailQueryDto {\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processInstanceIdIn: ").append(toIndentedString(processInstanceIdIn)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    taskId: ").append(toIndentedString(taskId)).append("\n");
    sb.append("    activityInstanceId: ").append(toIndentedString(activityInstanceId)).append("\n");
    sb.append("    caseInstanceId: ").append(toIndentedString(caseInstanceId)).append("\n");
    sb.append("    caseExecutionId: ").append(toIndentedString(caseExecutionId)).append("\n");
    sb.append("    variableInstanceId: ").append(toIndentedString(variableInstanceId)).append("\n");
    sb.append("    variableTypeIn: ").append(toIndentedString(variableTypeIn)).append("\n");
    sb.append("    variableNameLike: ").append(toIndentedString(variableNameLike)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    userOperationId: ").append(toIndentedString(userOperationId)).append("\n");
    sb.append("    formFields: ").append(toIndentedString(formFields)).append("\n");
    sb.append("    variableUpdates: ").append(toIndentedString(variableUpdates)).append("\n");
    sb.append("    excludeTaskDetails: ").append(toIndentedString(excludeTaskDetails)).append("\n");
    sb.append("    initial: ").append(toIndentedString(initial)).append("\n");
    sb.append("    occurredBefore: ").append(toIndentedString(occurredBefore)).append("\n");
    sb.append("    occurredAfter: ").append(toIndentedString(occurredAfter)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

