/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.api;

import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.ProgressRequestBody;
import org.openapitools.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.openapitools.client.model.ActivityInstanceDto;
import org.openapitools.client.model.AuthorizationExceptionDto;
import org.openapitools.client.model.BatchDto;
import org.openapitools.client.model.CommentDto;
import org.openapitools.client.model.CorrelationMessageAsyncDto;
import org.openapitools.client.model.CountResultDto;
import org.openapitools.client.model.DeleteProcessInstancesDto;
import org.openapitools.client.model.ExceptionDto;
import java.io.File;
import org.openapitools.client.model.PatchVariablesDto;
import org.openapitools.client.model.ProcessInstanceDto;
import org.openapitools.client.model.ProcessInstanceModificationDto;
import org.openapitools.client.model.ProcessInstanceQueryDto;
import org.openapitools.client.model.ProcessInstanceSuspensionStateAsyncDto;
import org.openapitools.client.model.ProcessInstanceSuspensionStateDto;
import org.openapitools.client.model.SetJobRetriesByProcessDto;
import org.openapitools.client.model.SetVariablesAsyncDto;
import org.openapitools.client.model.SuspensionStateDto;
import org.openapitools.client.model.VariableValueDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcessInstanceApi {
    private ApiClient localVarApiClient;

    public ProcessInstanceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProcessInstanceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for correlateMessageAsyncOperation
     * @param correlationMessageAsyncDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request * If none of &#x60;processInstanceIds&#x60;, &#x60;processInstanceQuery&#x60;, and &#x60;historicProcessInstanceQuery&#x60; is given * If no process instance ids where found </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user is not allowed to create the batch.  See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call correlateMessageAsyncOperationCall(CorrelationMessageAsyncDto correlationMessageAsyncDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = correlationMessageAsyncDto;

        // create path and map variables
        String localVarPath = "/process-instance/message-async";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call correlateMessageAsyncOperationValidateBeforeCall(CorrelationMessageAsyncDto correlationMessageAsyncDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = correlateMessageAsyncOperationCall(correlationMessageAsyncDto, _callback);
        return localVarCall;

    }

    /**
     * Correlate Message Async (POST)
     * Correlates a message asynchronously to executions that are waiting for this message.  Messages will not be correlated to process definition-level start message events to start process instances.
     * @param correlationMessageAsyncDto  (optional)
     * @return BatchDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request * If none of &#x60;processInstanceIds&#x60;, &#x60;processInstanceQuery&#x60;, and &#x60;historicProcessInstanceQuery&#x60; is given * If no process instance ids where found </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user is not allowed to create the batch.  See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public BatchDto correlateMessageAsyncOperation(CorrelationMessageAsyncDto correlationMessageAsyncDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = correlateMessageAsyncOperationWithHttpInfo(correlationMessageAsyncDto);
        return localVarResp.getData();
    }

    /**
     * Correlate Message Async (POST)
     * Correlates a message asynchronously to executions that are waiting for this message.  Messages will not be correlated to process definition-level start message events to start process instances.
     * @param correlationMessageAsyncDto  (optional)
     * @return ApiResponse&lt;BatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request * If none of &#x60;processInstanceIds&#x60;, &#x60;processInstanceQuery&#x60;, and &#x60;historicProcessInstanceQuery&#x60; is given * If no process instance ids where found </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user is not allowed to create the batch.  See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BatchDto> correlateMessageAsyncOperationWithHttpInfo(CorrelationMessageAsyncDto correlationMessageAsyncDto) throws ApiException {
        okhttp3.Call localVarCall = correlateMessageAsyncOperationValidateBeforeCall(correlationMessageAsyncDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Correlate Message Async (POST) (asynchronously)
     * Correlates a message asynchronously to executions that are waiting for this message.  Messages will not be correlated to process definition-level start message events to start process instances.
     * @param correlationMessageAsyncDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request * If none of &#x60;processInstanceIds&#x60;, &#x60;processInstanceQuery&#x60;, and &#x60;historicProcessInstanceQuery&#x60; is given * If no process instance ids where found </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user is not allowed to create the batch.  See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call correlateMessageAsyncOperationAsync(CorrelationMessageAsyncDto correlationMessageAsyncDto, final ApiCallback<BatchDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = correlateMessageAsyncOperationValidateBeforeCall(correlationMessageAsyncDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteAsyncHistoricQueryBased
     * @param deleteProcessInstancesDto **Unallowed property**: &#x60;processInstanceQuery&#x60; (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, i.e., neither processInstanceIds, nor historicProcessInstanceQuery is present </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAsyncHistoricQueryBasedCall(DeleteProcessInstancesDto deleteProcessInstancesDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = deleteProcessInstancesDto;

        // create path and map variables
        String localVarPath = "/process-instance/delete-historic-query-based";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteAsyncHistoricQueryBasedValidateBeforeCall(DeleteProcessInstancesDto deleteProcessInstancesDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = deleteAsyncHistoricQueryBasedCall(deleteProcessInstancesDto, _callback);
        return localVarCall;

    }

    /**
     * Delete Async Historic Query Based (POST)
     * Deletes a set of process instances asynchronously (batch) based on a historic process instance query.
     * @param deleteProcessInstancesDto **Unallowed property**: &#x60;processInstanceQuery&#x60; (optional)
     * @return BatchDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, i.e., neither processInstanceIds, nor historicProcessInstanceQuery is present </td><td>  -  </td></tr>
     </table>
     */
    public BatchDto deleteAsyncHistoricQueryBased(DeleteProcessInstancesDto deleteProcessInstancesDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = deleteAsyncHistoricQueryBasedWithHttpInfo(deleteProcessInstancesDto);
        return localVarResp.getData();
    }

    /**
     * Delete Async Historic Query Based (POST)
     * Deletes a set of process instances asynchronously (batch) based on a historic process instance query.
     * @param deleteProcessInstancesDto **Unallowed property**: &#x60;processInstanceQuery&#x60; (optional)
     * @return ApiResponse&lt;BatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, i.e., neither processInstanceIds, nor historicProcessInstanceQuery is present </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BatchDto> deleteAsyncHistoricQueryBasedWithHttpInfo(DeleteProcessInstancesDto deleteProcessInstancesDto) throws ApiException {
        okhttp3.Call localVarCall = deleteAsyncHistoricQueryBasedValidateBeforeCall(deleteProcessInstancesDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Delete Async Historic Query Based (POST) (asynchronously)
     * Deletes a set of process instances asynchronously (batch) based on a historic process instance query.
     * @param deleteProcessInstancesDto **Unallowed property**: &#x60;processInstanceQuery&#x60; (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, i.e., neither processInstanceIds, nor historicProcessInstanceQuery is present </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAsyncHistoricQueryBasedAsync(DeleteProcessInstancesDto deleteProcessInstancesDto, final ApiCallback<BatchDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteAsyncHistoricQueryBasedValidateBeforeCall(deleteProcessInstancesDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteProcessInstance
     * @param id The id of the process instance to be deleted. (required)
     * @param skipCustomListeners If set to true, the custom listeners will be skipped. (optional, default to false)
     * @param skipIoMappings If set to true, the input/output mappings will be skipped. (optional, default to false)
     * @param skipSubprocesses If set to true, subprocesses related to deleted processes will be skipped. (optional, default to false)
     * @param failIfNotExists If set to false, the request will still be successful if the process id is not found. (optional, default to true)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Process instance with given id does not exist.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteProcessInstanceCall(String id, Boolean skipCustomListeners, Boolean skipIoMappings, Boolean skipSubprocesses, Boolean failIfNotExists, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-instance/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (skipCustomListeners != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("skipCustomListeners", skipCustomListeners));
        }

        if (skipIoMappings != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("skipIoMappings", skipIoMappings));
        }

        if (skipSubprocesses != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("skipSubprocesses", skipSubprocesses));
        }

        if (failIfNotExists != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("failIfNotExists", failIfNotExists));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteProcessInstanceValidateBeforeCall(String id, Boolean skipCustomListeners, Boolean skipIoMappings, Boolean skipSubprocesses, Boolean failIfNotExists, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteProcessInstance(Async)");
        }
        

        okhttp3.Call localVarCall = deleteProcessInstanceCall(id, skipCustomListeners, skipIoMappings, skipSubprocesses, failIfNotExists, _callback);
        return localVarCall;

    }

    /**
     * Delete
     * Deletes a running process instance by id.
     * @param id The id of the process instance to be deleted. (required)
     * @param skipCustomListeners If set to true, the custom listeners will be skipped. (optional, default to false)
     * @param skipIoMappings If set to true, the input/output mappings will be skipped. (optional, default to false)
     * @param skipSubprocesses If set to true, subprocesses related to deleted processes will be skipped. (optional, default to false)
     * @param failIfNotExists If set to false, the request will still be successful if the process id is not found. (optional, default to true)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Process instance with given id does not exist.  </td><td>  -  </td></tr>
     </table>
     */
    public void deleteProcessInstance(String id, Boolean skipCustomListeners, Boolean skipIoMappings, Boolean skipSubprocesses, Boolean failIfNotExists) throws ApiException {
        deleteProcessInstanceWithHttpInfo(id, skipCustomListeners, skipIoMappings, skipSubprocesses, failIfNotExists);
    }

    /**
     * Delete
     * Deletes a running process instance by id.
     * @param id The id of the process instance to be deleted. (required)
     * @param skipCustomListeners If set to true, the custom listeners will be skipped. (optional, default to false)
     * @param skipIoMappings If set to true, the input/output mappings will be skipped. (optional, default to false)
     * @param skipSubprocesses If set to true, subprocesses related to deleted processes will be skipped. (optional, default to false)
     * @param failIfNotExists If set to false, the request will still be successful if the process id is not found. (optional, default to true)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Process instance with given id does not exist.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteProcessInstanceWithHttpInfo(String id, Boolean skipCustomListeners, Boolean skipIoMappings, Boolean skipSubprocesses, Boolean failIfNotExists) throws ApiException {
        okhttp3.Call localVarCall = deleteProcessInstanceValidateBeforeCall(id, skipCustomListeners, skipIoMappings, skipSubprocesses, failIfNotExists, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete (asynchronously)
     * Deletes a running process instance by id.
     * @param id The id of the process instance to be deleted. (required)
     * @param skipCustomListeners If set to true, the custom listeners will be skipped. (optional, default to false)
     * @param skipIoMappings If set to true, the input/output mappings will be skipped. (optional, default to false)
     * @param skipSubprocesses If set to true, subprocesses related to deleted processes will be skipped. (optional, default to false)
     * @param failIfNotExists If set to false, the request will still be successful if the process id is not found. (optional, default to true)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found Process instance with given id does not exist.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteProcessInstanceAsync(String id, Boolean skipCustomListeners, Boolean skipIoMappings, Boolean skipSubprocesses, Boolean failIfNotExists, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteProcessInstanceValidateBeforeCall(id, skipCustomListeners, skipIoMappings, skipSubprocesses, failIfNotExists, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteProcessInstanceVariable
     * @param id The id of the process instance to delete the variable from. (required)
     * @param varName The name of the variable to delete. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteProcessInstanceVariableCall(String id, String varName, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-instance/{id}/variables/{varName}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()))
            .replaceAll("\\{" + "varName" + "\\}", localVarApiClient.escapeString(varName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteProcessInstanceVariableValidateBeforeCall(String id, String varName, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteProcessInstanceVariable(Async)");
        }
        
        // verify the required parameter 'varName' is set
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling deleteProcessInstanceVariable(Async)");
        }
        

        okhttp3.Call localVarCall = deleteProcessInstanceVariableCall(id, varName, _callback);
        return localVarCall;

    }

    /**
     * Delete Process Variable
     * Deletes a variable of a process instance by id.
     * @param id The id of the process instance to delete the variable from. (required)
     * @param varName The name of the variable to delete. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteProcessInstanceVariable(String id, String varName) throws ApiException {
        deleteProcessInstanceVariableWithHttpInfo(id, varName);
    }

    /**
     * Delete Process Variable
     * Deletes a variable of a process instance by id.
     * @param id The id of the process instance to delete the variable from. (required)
     * @param varName The name of the variable to delete. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteProcessInstanceVariableWithHttpInfo(String id, String varName) throws ApiException {
        okhttp3.Call localVarCall = deleteProcessInstanceVariableValidateBeforeCall(id, varName, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete Process Variable (asynchronously)
     * Deletes a variable of a process instance by id.
     * @param id The id of the process instance to delete the variable from. (required)
     * @param varName The name of the variable to delete. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteProcessInstanceVariableAsync(String id, String varName, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteProcessInstanceVariableValidateBeforeCall(id, varName, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteProcessInstancesAsyncOperation
     * @param deleteProcessInstancesDto **Unallowed property**: &#x60;historicProcessInstanceQuery&#x60; (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, i.e., neither processInstanceIds, nor processInstanceQuery is present </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteProcessInstancesAsyncOperationCall(DeleteProcessInstancesDto deleteProcessInstancesDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = deleteProcessInstancesDto;

        // create path and map variables
        String localVarPath = "/process-instance/delete";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteProcessInstancesAsyncOperationValidateBeforeCall(DeleteProcessInstancesDto deleteProcessInstancesDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = deleteProcessInstancesAsyncOperationCall(deleteProcessInstancesDto, _callback);
        return localVarCall;

    }

    /**
     * Delete Async (POST)
     * Deletes multiple process instances asynchronously (batch).
     * @param deleteProcessInstancesDto **Unallowed property**: &#x60;historicProcessInstanceQuery&#x60; (optional)
     * @return BatchDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, i.e., neither processInstanceIds, nor processInstanceQuery is present </td><td>  -  </td></tr>
     </table>
     */
    public BatchDto deleteProcessInstancesAsyncOperation(DeleteProcessInstancesDto deleteProcessInstancesDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = deleteProcessInstancesAsyncOperationWithHttpInfo(deleteProcessInstancesDto);
        return localVarResp.getData();
    }

    /**
     * Delete Async (POST)
     * Deletes multiple process instances asynchronously (batch).
     * @param deleteProcessInstancesDto **Unallowed property**: &#x60;historicProcessInstanceQuery&#x60; (optional)
     * @return ApiResponse&lt;BatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, i.e., neither processInstanceIds, nor processInstanceQuery is present </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BatchDto> deleteProcessInstancesAsyncOperationWithHttpInfo(DeleteProcessInstancesDto deleteProcessInstancesDto) throws ApiException {
        okhttp3.Call localVarCall = deleteProcessInstancesAsyncOperationValidateBeforeCall(deleteProcessInstancesDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Delete Async (POST) (asynchronously)
     * Deletes multiple process instances asynchronously (batch).
     * @param deleteProcessInstancesDto **Unallowed property**: &#x60;historicProcessInstanceQuery&#x60; (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, i.e., neither processInstanceIds, nor processInstanceQuery is present </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteProcessInstancesAsyncOperationAsync(DeleteProcessInstancesDto deleteProcessInstancesDto, final ApiCallback<BatchDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteProcessInstancesAsyncOperationValidateBeforeCall(deleteProcessInstancesDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getActivityInstanceTree
     * @param id The id of the process instance for which the activity instance should be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Process instance with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getActivityInstanceTreeCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-instance/{id}/activity-instances"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getActivityInstanceTreeValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getActivityInstanceTree(Async)");
        }
        

        okhttp3.Call localVarCall = getActivityInstanceTreeCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Activity Instance
     * Retrieves an Activity Instance (Tree) for a given process instance by id.
     * @param id The id of the process instance for which the activity instance should be retrieved. (required)
     * @return ActivityInstanceDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Process instance with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ActivityInstanceDto getActivityInstanceTree(String id) throws ApiException {
        ApiResponse<ActivityInstanceDto> localVarResp = getActivityInstanceTreeWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Activity Instance
     * Retrieves an Activity Instance (Tree) for a given process instance by id.
     * @param id The id of the process instance for which the activity instance should be retrieved. (required)
     * @return ApiResponse&lt;ActivityInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Process instance with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ActivityInstanceDto> getActivityInstanceTreeWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getActivityInstanceTreeValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ActivityInstanceDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Activity Instance (asynchronously)
     * Retrieves an Activity Instance (Tree) for a given process instance by id.
     * @param id The id of the process instance for which the activity instance should be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Process instance with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getActivityInstanceTreeAsync(String id, final ApiCallback<ActivityInstanceDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getActivityInstanceTreeValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ActivityInstanceDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProcessInstance
     * @param id The id of the process instance to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process instance with given id does not exist. See the  [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessInstanceCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-instance/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProcessInstanceValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProcessInstance(Async)");
        }
        

        okhttp3.Call localVarCall = getProcessInstanceCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Process Instance
     * Retrieves a process instance by id, according to the &#x60;ProcessInstance&#x60; interface in the engine.
     * @param id The id of the process instance to be retrieved. (required)
     * @return ProcessInstanceDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process instance with given id does not exist. See the  [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ProcessInstanceDto getProcessInstance(String id) throws ApiException {
        ApiResponse<ProcessInstanceDto> localVarResp = getProcessInstanceWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Process Instance
     * Retrieves a process instance by id, according to the &#x60;ProcessInstance&#x60; interface in the engine.
     * @param id The id of the process instance to be retrieved. (required)
     * @return ApiResponse&lt;ProcessInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process instance with given id does not exist. See the  [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ProcessInstanceDto> getProcessInstanceWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getProcessInstanceValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ProcessInstanceDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Process Instance (asynchronously)
     * Retrieves a process instance by id, according to the &#x60;ProcessInstance&#x60; interface in the engine.
     * @param id The id of the process instance to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Process instance with given id does not exist. See the  [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessInstanceAsync(String id, final ApiCallback<ProcessInstanceDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProcessInstanceValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ProcessInstanceDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProcessInstanceComments
     * @param id The id of the process instance to retrieve the comments for. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No process instance exists for the given process instance id. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessInstanceCommentsCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-instance/{id}/comment"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProcessInstanceCommentsValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProcessInstanceComments(Async)");
        }
        

        okhttp3.Call localVarCall = getProcessInstanceCommentsCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Process Instance Comments
     * Gets the comments for a process instance by id.
     * @param id The id of the process instance to retrieve the comments for. (required)
     * @return List&lt;CommentDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No process instance exists for the given process instance id. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<CommentDto> getProcessInstanceComments(String id) throws ApiException {
        ApiResponse<List<CommentDto>> localVarResp = getProcessInstanceCommentsWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Process Instance Comments
     * Gets the comments for a process instance by id.
     * @param id The id of the process instance to retrieve the comments for. (required)
     * @return ApiResponse&lt;List&lt;CommentDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No process instance exists for the given process instance id. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<CommentDto>> getProcessInstanceCommentsWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getProcessInstanceCommentsValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<List<CommentDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Process Instance Comments (asynchronously)
     * Gets the comments for a process instance by id.
     * @param id The id of the process instance to retrieve the comments for. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No process instance exists for the given process instance id. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessInstanceCommentsAsync(String id, final ApiCallback<List<CommentDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProcessInstanceCommentsValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<List<CommentDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProcessInstanceVariable
     * @param id The id of the process instance to retrieve the variable for. (required)
     * @param varName The name of the variable to retrieve. (required)
     * @param deserializeValue Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  Note: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Variable with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessInstanceVariableCall(String id, String varName, Boolean deserializeValue, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-instance/{id}/variables/{varName}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()))
            .replaceAll("\\{" + "varName" + "\\}", localVarApiClient.escapeString(varName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (deserializeValue != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deserializeValue", deserializeValue));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProcessInstanceVariableValidateBeforeCall(String id, String varName, Boolean deserializeValue, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProcessInstanceVariable(Async)");
        }
        
        // verify the required parameter 'varName' is set
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling getProcessInstanceVariable(Async)");
        }
        

        okhttp3.Call localVarCall = getProcessInstanceVariableCall(id, varName, deserializeValue, _callback);
        return localVarCall;

    }

    /**
     * Get Process Variable
     * Retrieves a variable of a given process instance by id.
     * @param id The id of the process instance to retrieve the variable for. (required)
     * @param varName The name of the variable to retrieve. (required)
     * @param deserializeValue Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  Note: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @return VariableValueDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Variable with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public VariableValueDto getProcessInstanceVariable(String id, String varName, Boolean deserializeValue) throws ApiException {
        ApiResponse<VariableValueDto> localVarResp = getProcessInstanceVariableWithHttpInfo(id, varName, deserializeValue);
        return localVarResp.getData();
    }

    /**
     * Get Process Variable
     * Retrieves a variable of a given process instance by id.
     * @param id The id of the process instance to retrieve the variable for. (required)
     * @param varName The name of the variable to retrieve. (required)
     * @param deserializeValue Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  Note: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @return ApiResponse&lt;VariableValueDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Variable with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<VariableValueDto> getProcessInstanceVariableWithHttpInfo(String id, String varName, Boolean deserializeValue) throws ApiException {
        okhttp3.Call localVarCall = getProcessInstanceVariableValidateBeforeCall(id, varName, deserializeValue, null);
        Type localVarReturnType = new TypeToken<VariableValueDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Process Variable (asynchronously)
     * Retrieves a variable of a given process instance by id.
     * @param id The id of the process instance to retrieve the variable for. (required)
     * @param varName The name of the variable to retrieve. (required)
     * @param deserializeValue Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  Note: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Variable with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessInstanceVariableAsync(String id, String varName, Boolean deserializeValue, final ApiCallback<VariableValueDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProcessInstanceVariableValidateBeforeCall(id, varName, deserializeValue, _callback);
        Type localVarReturnType = new TypeToken<VariableValueDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProcessInstanceVariableBinary
     * @param id The id of the process instance to retrieve the variable for. (required)
     * @param varName The name of the variable to retrieve. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful.         For binary variables or files without any MIME type information, a byte stream is returned.         File variables with MIME type information are returned as the saved type.         Additionally, for file variables the Content-Disposition header will be set. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request A Process Variable with the given id exists but does not serialize as binary data. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found A Process Variable with the given id does not exist.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessInstanceVariableBinaryCall(String id, String varName, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-instance/{id}/variables/{varName}/data"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()))
            .replaceAll("\\{" + "varName" + "\\}", localVarApiClient.escapeString(varName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/octet-stream", "text/plain", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProcessInstanceVariableBinaryValidateBeforeCall(String id, String varName, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProcessInstanceVariableBinary(Async)");
        }
        
        // verify the required parameter 'varName' is set
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling getProcessInstanceVariableBinary(Async)");
        }
        

        okhttp3.Call localVarCall = getProcessInstanceVariableBinaryCall(id, varName, _callback);
        return localVarCall;

    }

    /**
     * Get Process Variable (Binary)
     * Retrieves the content of a Process Variable by the Process Instance id and the Process Variable name. Applicable for byte array or file Process Variables.
     * @param id The id of the process instance to retrieve the variable for. (required)
     * @param varName The name of the variable to retrieve. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful.         For binary variables or files without any MIME type information, a byte stream is returned.         File variables with MIME type information are returned as the saved type.         Additionally, for file variables the Content-Disposition header will be set. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request A Process Variable with the given id exists but does not serialize as binary data. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found A Process Variable with the given id does not exist.  </td><td>  -  </td></tr>
     </table>
     */
    public File getProcessInstanceVariableBinary(String id, String varName) throws ApiException {
        ApiResponse<File> localVarResp = getProcessInstanceVariableBinaryWithHttpInfo(id, varName);
        return localVarResp.getData();
    }

    /**
     * Get Process Variable (Binary)
     * Retrieves the content of a Process Variable by the Process Instance id and the Process Variable name. Applicable for byte array or file Process Variables.
     * @param id The id of the process instance to retrieve the variable for. (required)
     * @param varName The name of the variable to retrieve. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful.         For binary variables or files without any MIME type information, a byte stream is returned.         File variables with MIME type information are returned as the saved type.         Additionally, for file variables the Content-Disposition header will be set. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request A Process Variable with the given id exists but does not serialize as binary data. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found A Process Variable with the given id does not exist.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getProcessInstanceVariableBinaryWithHttpInfo(String id, String varName) throws ApiException {
        okhttp3.Call localVarCall = getProcessInstanceVariableBinaryValidateBeforeCall(id, varName, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Process Variable (Binary) (asynchronously)
     * Retrieves the content of a Process Variable by the Process Instance id and the Process Variable name. Applicable for byte array or file Process Variables.
     * @param id The id of the process instance to retrieve the variable for. (required)
     * @param varName The name of the variable to retrieve. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful.         For binary variables or files without any MIME type information, a byte stream is returned.         File variables with MIME type information are returned as the saved type.         Additionally, for file variables the Content-Disposition header will be set. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request A Process Variable with the given id exists but does not serialize as binary data. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found A Process Variable with the given id does not exist.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessInstanceVariableBinaryAsync(String id, String varName, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProcessInstanceVariableBinaryValidateBeforeCall(id, varName, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProcessInstanceVariables
     * @param id The id of the process instance to retrieve the variables from. (required)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  Note: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Process instance with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessInstanceVariablesCall(String id, Boolean deserializeValues, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-instance/{id}/variables"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (deserializeValues != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deserializeValues", deserializeValues));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProcessInstanceVariablesValidateBeforeCall(String id, Boolean deserializeValues, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProcessInstanceVariables(Async)");
        }
        

        okhttp3.Call localVarCall = getProcessInstanceVariablesCall(id, deserializeValues, _callback);
        return localVarCall;

    }

    /**
     * Get Process Variables
     * Retrieves all variables of a given process instance by id.
     * @param id The id of the process instance to retrieve the variables from. (required)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  Note: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @return Map&lt;String, VariableValueDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Process instance with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public Map<String, VariableValueDto> getProcessInstanceVariables(String id, Boolean deserializeValues) throws ApiException {
        ApiResponse<Map<String, VariableValueDto>> localVarResp = getProcessInstanceVariablesWithHttpInfo(id, deserializeValues);
        return localVarResp.getData();
    }

    /**
     * Get Process Variables
     * Retrieves all variables of a given process instance by id.
     * @param id The id of the process instance to retrieve the variables from. (required)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  Note: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @return ApiResponse&lt;Map&lt;String, VariableValueDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Process instance with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Map<String, VariableValueDto>> getProcessInstanceVariablesWithHttpInfo(String id, Boolean deserializeValues) throws ApiException {
        okhttp3.Call localVarCall = getProcessInstanceVariablesValidateBeforeCall(id, deserializeValues, null);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Process Variables (asynchronously)
     * Retrieves all variables of a given process instance by id.
     * @param id The id of the process instance to retrieve the variables from. (required)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  Note: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine. (optional, default to true)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Process instance with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessInstanceVariablesAsync(String id, Boolean deserializeValues, final ApiCallback<Map<String, VariableValueDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProcessInstanceVariablesValidateBeforeCall(id, deserializeValues, _callback);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProcessInstances
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param processInstanceIds Filter by a comma-separated list of process instance ids. (optional)
     * @param businessKey Filter by process instance business key. (optional)
     * @param businessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param processDefinitionId Filter by the deployment the id belongs to. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
     * @param processDefinitionKeyIn Filter by a comma-separated list of process definition keys. A process instance must have one of the given process definition keys. (optional)
     * @param processDefinitionKeyNotIn Exclude instances by a comma-separated list of process definition keys. A process instance must not have one of the given process definition keys. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param superProcessInstance Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
     * @param subProcessInstance Restrict query to all process instances that have the given process instance as a sub process instance. Takes a process instance id. (optional)
     * @param superCaseInstance Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param subCaseInstance Restrict query to all process instances that have the given case instance as a sub case instance. Takes a case instance id. (optional)
     * @param active Only include active process instances. Value may only be true, as false is the default behavior. (optional, default to false)
     * @param suspended Only include suspended process instances. Value may only be true, as false is the default behavior. (optional, default to false)
     * @param withIncident Filter by presence of incidents. Selects only process instances that have an incident. (optional, default to false)
     * @param incidentId Filter by the incident id. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include process instances which belong to no tenant. (optional, default to false)
     * @param processDefinitionWithoutTenantId Only include process instances which process definition has no tenant id. (optional, default to false)
     * @param activityIdIn Filter by a comma-separated list of activity ids. A process instance must currently wait in a leaf activity with one of the given activity ids. (optional)
     * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional, default to false)
     * @param leafProcessInstances Restrict the query to all process instances that are leaf instances. (i.e. don&#39;t have any sub instances). (optional, default to false)
     * @param variables Only include process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note**: Values are always treated as String objects on server side.  Valid &#x60;operator&#x60; values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match all variable names in this query case-insensitively. If set to true variableName and variablename are treated as equal. (optional, default to false)
     * @param variableValuesIgnoreCase Match all variable values in this query case-insensitively. If set to true variableValue and variablevalue are treated as equal. (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy, or if an invalid operator for variable comparison is used. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessInstancesCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-instance";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        if (processInstanceIds != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceIds", processInstanceIds));
        }

        if (businessKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("businessKey", businessKey));
        }

        if (businessKeyLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("businessKeyLike", businessKeyLike));
        }

        if (caseInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (processDefinitionKeyIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        }

        if (processDefinitionKeyNotIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKeyNotIn", processDefinitionKeyNotIn));
        }

        if (deploymentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deploymentId", deploymentId));
        }

        if (superProcessInstance != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("superProcessInstance", superProcessInstance));
        }

        if (subProcessInstance != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("subProcessInstance", subProcessInstance));
        }

        if (superCaseInstance != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("superCaseInstance", superCaseInstance));
        }

        if (subCaseInstance != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("subCaseInstance", subCaseInstance));
        }

        if (active != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("active", active));
        }

        if (suspended != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("suspended", suspended));
        }

        if (withIncident != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withIncident", withIncident));
        }

        if (incidentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentId", incidentId));
        }

        if (incidentType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentType", incidentType));
        }

        if (incidentMessage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }

        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (processDefinitionWithoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionWithoutTenantId", processDefinitionWithoutTenantId));
        }

        if (activityIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityIdIn", activityIdIn));
        }

        if (rootProcessInstances != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("rootProcessInstances", rootProcessInstances));
        }

        if (leafProcessInstances != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("leafProcessInstances", leafProcessInstances));
        }

        if (variables != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variables", variables));
        }

        if (variableNamesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        }

        if (variableValuesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProcessInstancesValidateBeforeCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getProcessInstancesCall(sortBy, sortOrder, firstResult, maxResults, processInstanceIds, businessKey, businessKeyLike, caseInstanceId, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionKeyNotIn, deploymentId, superProcessInstance, subProcessInstance, superCaseInstance, subCaseInstance, active, suspended, withIncident, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, processDefinitionWithoutTenantId, activityIdIn, rootProcessInstances, leafProcessInstances, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, _callback);
        return localVarCall;

    }

    /**
     * Get List
     * Queries for process instances that fulfill given parameters. Parameters may be static as well as dynamic runtime properties of process instances. The size of the result set can be retrieved by using the Get Instance Count method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param processInstanceIds Filter by a comma-separated list of process instance ids. (optional)
     * @param businessKey Filter by process instance business key. (optional)
     * @param businessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param processDefinitionId Filter by the deployment the id belongs to. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
     * @param processDefinitionKeyIn Filter by a comma-separated list of process definition keys. A process instance must have one of the given process definition keys. (optional)
     * @param processDefinitionKeyNotIn Exclude instances by a comma-separated list of process definition keys. A process instance must not have one of the given process definition keys. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param superProcessInstance Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
     * @param subProcessInstance Restrict query to all process instances that have the given process instance as a sub process instance. Takes a process instance id. (optional)
     * @param superCaseInstance Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param subCaseInstance Restrict query to all process instances that have the given case instance as a sub case instance. Takes a case instance id. (optional)
     * @param active Only include active process instances. Value may only be true, as false is the default behavior. (optional, default to false)
     * @param suspended Only include suspended process instances. Value may only be true, as false is the default behavior. (optional, default to false)
     * @param withIncident Filter by presence of incidents. Selects only process instances that have an incident. (optional, default to false)
     * @param incidentId Filter by the incident id. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include process instances which belong to no tenant. (optional, default to false)
     * @param processDefinitionWithoutTenantId Only include process instances which process definition has no tenant id. (optional, default to false)
     * @param activityIdIn Filter by a comma-separated list of activity ids. A process instance must currently wait in a leaf activity with one of the given activity ids. (optional)
     * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional, default to false)
     * @param leafProcessInstances Restrict the query to all process instances that are leaf instances. (i.e. don&#39;t have any sub instances). (optional, default to false)
     * @param variables Only include process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note**: Values are always treated as String objects on server side.  Valid &#x60;operator&#x60; values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match all variable names in this query case-insensitively. If set to true variableName and variablename are treated as equal. (optional, default to false)
     * @param variableValuesIgnoreCase Match all variable values in this query case-insensitively. If set to true variableValue and variablevalue are treated as equal. (optional, default to false)
     * @return List&lt;ProcessInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy, or if an invalid operator for variable comparison is used. </td><td>  -  </td></tr>
     </table>
     */
    public List<ProcessInstanceDto> getProcessInstances(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        ApiResponse<List<ProcessInstanceDto>> localVarResp = getProcessInstancesWithHttpInfo(sortBy, sortOrder, firstResult, maxResults, processInstanceIds, businessKey, businessKeyLike, caseInstanceId, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionKeyNotIn, deploymentId, superProcessInstance, subProcessInstance, superCaseInstance, subCaseInstance, active, suspended, withIncident, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, processDefinitionWithoutTenantId, activityIdIn, rootProcessInstances, leafProcessInstances, variables, variableNamesIgnoreCase, variableValuesIgnoreCase);
        return localVarResp.getData();
    }

    /**
     * Get List
     * Queries for process instances that fulfill given parameters. Parameters may be static as well as dynamic runtime properties of process instances. The size of the result set can be retrieved by using the Get Instance Count method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param processInstanceIds Filter by a comma-separated list of process instance ids. (optional)
     * @param businessKey Filter by process instance business key. (optional)
     * @param businessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param processDefinitionId Filter by the deployment the id belongs to. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
     * @param processDefinitionKeyIn Filter by a comma-separated list of process definition keys. A process instance must have one of the given process definition keys. (optional)
     * @param processDefinitionKeyNotIn Exclude instances by a comma-separated list of process definition keys. A process instance must not have one of the given process definition keys. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param superProcessInstance Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
     * @param subProcessInstance Restrict query to all process instances that have the given process instance as a sub process instance. Takes a process instance id. (optional)
     * @param superCaseInstance Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param subCaseInstance Restrict query to all process instances that have the given case instance as a sub case instance. Takes a case instance id. (optional)
     * @param active Only include active process instances. Value may only be true, as false is the default behavior. (optional, default to false)
     * @param suspended Only include suspended process instances. Value may only be true, as false is the default behavior. (optional, default to false)
     * @param withIncident Filter by presence of incidents. Selects only process instances that have an incident. (optional, default to false)
     * @param incidentId Filter by the incident id. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include process instances which belong to no tenant. (optional, default to false)
     * @param processDefinitionWithoutTenantId Only include process instances which process definition has no tenant id. (optional, default to false)
     * @param activityIdIn Filter by a comma-separated list of activity ids. A process instance must currently wait in a leaf activity with one of the given activity ids. (optional)
     * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional, default to false)
     * @param leafProcessInstances Restrict the query to all process instances that are leaf instances. (i.e. don&#39;t have any sub instances). (optional, default to false)
     * @param variables Only include process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note**: Values are always treated as String objects on server side.  Valid &#x60;operator&#x60; values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match all variable names in this query case-insensitively. If set to true variableName and variablename are treated as equal. (optional, default to false)
     * @param variableValuesIgnoreCase Match all variable values in this query case-insensitively. If set to true variableValue and variablevalue are treated as equal. (optional, default to false)
     * @return ApiResponse&lt;List&lt;ProcessInstanceDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy, or if an invalid operator for variable comparison is used. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<ProcessInstanceDto>> getProcessInstancesWithHttpInfo(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        okhttp3.Call localVarCall = getProcessInstancesValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, processInstanceIds, businessKey, businessKeyLike, caseInstanceId, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionKeyNotIn, deploymentId, superProcessInstance, subProcessInstance, superCaseInstance, subCaseInstance, active, suspended, withIncident, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, processDefinitionWithoutTenantId, activityIdIn, rootProcessInstances, leafProcessInstances, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, null);
        Type localVarReturnType = new TypeToken<List<ProcessInstanceDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List (asynchronously)
     * Queries for process instances that fulfill given parameters. Parameters may be static as well as dynamic runtime properties of process instances. The size of the result set can be retrieved by using the Get Instance Count method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param processInstanceIds Filter by a comma-separated list of process instance ids. (optional)
     * @param businessKey Filter by process instance business key. (optional)
     * @param businessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param processDefinitionId Filter by the deployment the id belongs to. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
     * @param processDefinitionKeyIn Filter by a comma-separated list of process definition keys. A process instance must have one of the given process definition keys. (optional)
     * @param processDefinitionKeyNotIn Exclude instances by a comma-separated list of process definition keys. A process instance must not have one of the given process definition keys. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param superProcessInstance Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
     * @param subProcessInstance Restrict query to all process instances that have the given process instance as a sub process instance. Takes a process instance id. (optional)
     * @param superCaseInstance Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param subCaseInstance Restrict query to all process instances that have the given case instance as a sub case instance. Takes a case instance id. (optional)
     * @param active Only include active process instances. Value may only be true, as false is the default behavior. (optional, default to false)
     * @param suspended Only include suspended process instances. Value may only be true, as false is the default behavior. (optional, default to false)
     * @param withIncident Filter by presence of incidents. Selects only process instances that have an incident. (optional, default to false)
     * @param incidentId Filter by the incident id. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include process instances which belong to no tenant. (optional, default to false)
     * @param processDefinitionWithoutTenantId Only include process instances which process definition has no tenant id. (optional, default to false)
     * @param activityIdIn Filter by a comma-separated list of activity ids. A process instance must currently wait in a leaf activity with one of the given activity ids. (optional)
     * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional, default to false)
     * @param leafProcessInstances Restrict the query to all process instances that are leaf instances. (i.e. don&#39;t have any sub instances). (optional, default to false)
     * @param variables Only include process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note**: Values are always treated as String objects on server side.  Valid &#x60;operator&#x60; values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match all variable names in this query case-insensitively. If set to true variableName and variablename are treated as equal. (optional, default to false)
     * @param variableValuesIgnoreCase Match all variable values in this query case-insensitively. If set to true variableValue and variablevalue are treated as equal. (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy, or if an invalid operator for variable comparison is used. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessInstancesAsync(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, final ApiCallback<List<ProcessInstanceDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProcessInstancesValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, processInstanceIds, businessKey, businessKeyLike, caseInstanceId, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionKeyNotIn, deploymentId, superProcessInstance, subProcessInstance, superCaseInstance, subCaseInstance, active, suspended, withIncident, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, processDefinitionWithoutTenantId, activityIdIn, rootProcessInstances, leafProcessInstances, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, _callback);
        Type localVarReturnType = new TypeToken<List<ProcessInstanceDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getProcessInstancesCount
     * @param processInstanceIds Filter by a comma-separated list of process instance ids. (optional)
     * @param businessKey Filter by process instance business key. (optional)
     * @param businessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param processDefinitionId Filter by the deployment the id belongs to. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
     * @param processDefinitionKeyIn Filter by a comma-separated list of process definition keys. A process instance must have one of the given process definition keys. (optional)
     * @param processDefinitionKeyNotIn Exclude instances by a comma-separated list of process definition keys. A process instance must not have one of the given process definition keys. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param superProcessInstance Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
     * @param subProcessInstance Restrict query to all process instances that have the given process instance as a sub process instance. Takes a process instance id. (optional)
     * @param superCaseInstance Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param subCaseInstance Restrict query to all process instances that have the given case instance as a sub case instance. Takes a case instance id. (optional)
     * @param active Only include active process instances. Value may only be true, as false is the default behavior. (optional, default to false)
     * @param suspended Only include suspended process instances. Value may only be true, as false is the default behavior. (optional, default to false)
     * @param withIncident Filter by presence of incidents. Selects only process instances that have an incident. (optional, default to false)
     * @param incidentId Filter by the incident id. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include process instances which belong to no tenant. (optional, default to false)
     * @param processDefinitionWithoutTenantId Only include process instances which process definition has no tenant id. (optional, default to false)
     * @param activityIdIn Filter by a comma-separated list of activity ids. A process instance must currently wait in a leaf activity with one of the given activity ids. (optional)
     * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional, default to false)
     * @param leafProcessInstances Restrict the query to all process instances that are leaf instances. (i.e. don&#39;t have any sub instances). (optional, default to false)
     * @param variables Only include process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note**: Values are always treated as String objects on server side.  Valid &#x60;operator&#x60; values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match all variable names in this query case-insensitively. If set to true variableName and variablename are treated as equal. (optional, default to false)
     * @param variableValuesIgnoreCase Match all variable values in this query case-insensitively. If set to true variableValue and variablevalue are treated as equal. (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example an invalid operator for variable comparison is used. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessInstancesCountCall(String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-instance/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (processInstanceIds != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceIds", processInstanceIds));
        }

        if (businessKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("businessKey", businessKey));
        }

        if (businessKeyLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("businessKeyLike", businessKeyLike));
        }

        if (caseInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (processDefinitionKeyIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        }

        if (processDefinitionKeyNotIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKeyNotIn", processDefinitionKeyNotIn));
        }

        if (deploymentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deploymentId", deploymentId));
        }

        if (superProcessInstance != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("superProcessInstance", superProcessInstance));
        }

        if (subProcessInstance != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("subProcessInstance", subProcessInstance));
        }

        if (superCaseInstance != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("superCaseInstance", superCaseInstance));
        }

        if (subCaseInstance != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("subCaseInstance", subCaseInstance));
        }

        if (active != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("active", active));
        }

        if (suspended != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("suspended", suspended));
        }

        if (withIncident != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withIncident", withIncident));
        }

        if (incidentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentId", incidentId));
        }

        if (incidentType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentType", incidentType));
        }

        if (incidentMessage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }

        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (processDefinitionWithoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionWithoutTenantId", processDefinitionWithoutTenantId));
        }

        if (activityIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityIdIn", activityIdIn));
        }

        if (rootProcessInstances != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("rootProcessInstances", rootProcessInstances));
        }

        if (leafProcessInstances != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("leafProcessInstances", leafProcessInstances));
        }

        if (variables != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variables", variables));
        }

        if (variableNamesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        }

        if (variableValuesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getProcessInstancesCountValidateBeforeCall(String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getProcessInstancesCountCall(processInstanceIds, businessKey, businessKeyLike, caseInstanceId, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionKeyNotIn, deploymentId, superProcessInstance, subProcessInstance, superCaseInstance, subCaseInstance, active, suspended, withIncident, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, processDefinitionWithoutTenantId, activityIdIn, rootProcessInstances, leafProcessInstances, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, _callback);
        return localVarCall;

    }

    /**
     * Get List Count
     * Queries for the number of process instances that fulfill given parameters.
     * @param processInstanceIds Filter by a comma-separated list of process instance ids. (optional)
     * @param businessKey Filter by process instance business key. (optional)
     * @param businessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param processDefinitionId Filter by the deployment the id belongs to. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
     * @param processDefinitionKeyIn Filter by a comma-separated list of process definition keys. A process instance must have one of the given process definition keys. (optional)
     * @param processDefinitionKeyNotIn Exclude instances by a comma-separated list of process definition keys. A process instance must not have one of the given process definition keys. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param superProcessInstance Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
     * @param subProcessInstance Restrict query to all process instances that have the given process instance as a sub process instance. Takes a process instance id. (optional)
     * @param superCaseInstance Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param subCaseInstance Restrict query to all process instances that have the given case instance as a sub case instance. Takes a case instance id. (optional)
     * @param active Only include active process instances. Value may only be true, as false is the default behavior. (optional, default to false)
     * @param suspended Only include suspended process instances. Value may only be true, as false is the default behavior. (optional, default to false)
     * @param withIncident Filter by presence of incidents. Selects only process instances that have an incident. (optional, default to false)
     * @param incidentId Filter by the incident id. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include process instances which belong to no tenant. (optional, default to false)
     * @param processDefinitionWithoutTenantId Only include process instances which process definition has no tenant id. (optional, default to false)
     * @param activityIdIn Filter by a comma-separated list of activity ids. A process instance must currently wait in a leaf activity with one of the given activity ids. (optional)
     * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional, default to false)
     * @param leafProcessInstances Restrict the query to all process instances that are leaf instances. (i.e. don&#39;t have any sub instances). (optional, default to false)
     * @param variables Only include process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note**: Values are always treated as String objects on server side.  Valid &#x60;operator&#x60; values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match all variable names in this query case-insensitively. If set to true variableName and variablename are treated as equal. (optional, default to false)
     * @param variableValuesIgnoreCase Match all variable values in this query case-insensitively. If set to true variableValue and variablevalue are treated as equal. (optional, default to false)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example an invalid operator for variable comparison is used. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getProcessInstancesCount(String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getProcessInstancesCountWithHttpInfo(processInstanceIds, businessKey, businessKeyLike, caseInstanceId, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionKeyNotIn, deploymentId, superProcessInstance, subProcessInstance, superCaseInstance, subCaseInstance, active, suspended, withIncident, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, processDefinitionWithoutTenantId, activityIdIn, rootProcessInstances, leafProcessInstances, variables, variableNamesIgnoreCase, variableValuesIgnoreCase);
        return localVarResp.getData();
    }

    /**
     * Get List Count
     * Queries for the number of process instances that fulfill given parameters.
     * @param processInstanceIds Filter by a comma-separated list of process instance ids. (optional)
     * @param businessKey Filter by process instance business key. (optional)
     * @param businessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param processDefinitionId Filter by the deployment the id belongs to. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
     * @param processDefinitionKeyIn Filter by a comma-separated list of process definition keys. A process instance must have one of the given process definition keys. (optional)
     * @param processDefinitionKeyNotIn Exclude instances by a comma-separated list of process definition keys. A process instance must not have one of the given process definition keys. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param superProcessInstance Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
     * @param subProcessInstance Restrict query to all process instances that have the given process instance as a sub process instance. Takes a process instance id. (optional)
     * @param superCaseInstance Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param subCaseInstance Restrict query to all process instances that have the given case instance as a sub case instance. Takes a case instance id. (optional)
     * @param active Only include active process instances. Value may only be true, as false is the default behavior. (optional, default to false)
     * @param suspended Only include suspended process instances. Value may only be true, as false is the default behavior. (optional, default to false)
     * @param withIncident Filter by presence of incidents. Selects only process instances that have an incident. (optional, default to false)
     * @param incidentId Filter by the incident id. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include process instances which belong to no tenant. (optional, default to false)
     * @param processDefinitionWithoutTenantId Only include process instances which process definition has no tenant id. (optional, default to false)
     * @param activityIdIn Filter by a comma-separated list of activity ids. A process instance must currently wait in a leaf activity with one of the given activity ids. (optional)
     * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional, default to false)
     * @param leafProcessInstances Restrict the query to all process instances that are leaf instances. (i.e. don&#39;t have any sub instances). (optional, default to false)
     * @param variables Only include process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note**: Values are always treated as String objects on server side.  Valid &#x60;operator&#x60; values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match all variable names in this query case-insensitively. If set to true variableName and variablename are treated as equal. (optional, default to false)
     * @param variableValuesIgnoreCase Match all variable values in this query case-insensitively. If set to true variableValue and variablevalue are treated as equal. (optional, default to false)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example an invalid operator for variable comparison is used. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getProcessInstancesCountWithHttpInfo(String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        okhttp3.Call localVarCall = getProcessInstancesCountValidateBeforeCall(processInstanceIds, businessKey, businessKeyLike, caseInstanceId, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionKeyNotIn, deploymentId, superProcessInstance, subProcessInstance, superCaseInstance, subCaseInstance, active, suspended, withIncident, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, processDefinitionWithoutTenantId, activityIdIn, rootProcessInstances, leafProcessInstances, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List Count (asynchronously)
     * Queries for the number of process instances that fulfill given parameters.
     * @param processInstanceIds Filter by a comma-separated list of process instance ids. (optional)
     * @param businessKey Filter by process instance business key. (optional)
     * @param businessKeyLike Filter by process instance business key that the parameter is a substring of. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param processDefinitionId Filter by the deployment the id belongs to. (optional)
     * @param processDefinitionKey Filter by the key of the process definition the instances run on. (optional)
     * @param processDefinitionKeyIn Filter by a comma-separated list of process definition keys. A process instance must have one of the given process definition keys. (optional)
     * @param processDefinitionKeyNotIn Exclude instances by a comma-separated list of process definition keys. A process instance must not have one of the given process definition keys. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param superProcessInstance Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id. (optional)
     * @param subProcessInstance Restrict query to all process instances that have the given process instance as a sub process instance. Takes a process instance id. (optional)
     * @param superCaseInstance Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id. (optional)
     * @param subCaseInstance Restrict query to all process instances that have the given case instance as a sub case instance. Takes a case instance id. (optional)
     * @param active Only include active process instances. Value may only be true, as false is the default behavior. (optional, default to false)
     * @param suspended Only include suspended process instances. Value may only be true, as false is the default behavior. (optional, default to false)
     * @param withIncident Filter by presence of incidents. Selects only process instances that have an incident. (optional, default to false)
     * @param incidentId Filter by the incident id. (optional)
     * @param incidentType Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Filter by the incident message. Exact match. (optional)
     * @param incidentMessageLike Filter by the incident message that the parameter is a substring of. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A process instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include process instances which belong to no tenant. (optional, default to false)
     * @param processDefinitionWithoutTenantId Only include process instances which process definition has no tenant id. (optional, default to false)
     * @param activityIdIn Filter by a comma-separated list of activity ids. A process instance must currently wait in a leaf activity with one of the given activity ids. (optional)
     * @param rootProcessInstances Restrict the query to all process instances that are top level process instances. (optional, default to false)
     * @param leafProcessInstances Restrict the query to all process instances that are leaf instances. (i.e. don&#39;t have any sub instances). (optional, default to false)
     * @param variables Only include process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note**: Values are always treated as String objects on server side.  Valid &#x60;operator&#x60; values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match all variable names in this query case-insensitively. If set to true variableName and variablename are treated as equal. (optional, default to false)
     * @param variableValuesIgnoreCase Match all variable values in this query case-insensitively. If set to true variableValue and variablevalue are treated as equal. (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example an invalid operator for variable comparison is used. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getProcessInstancesCountAsync(String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getProcessInstancesCountValidateBeforeCall(processInstanceIds, businessKey, businessKeyLike, caseInstanceId, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionKeyNotIn, deploymentId, superProcessInstance, subProcessInstance, superCaseInstance, subCaseInstance, active, suspended, withIncident, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, processDefinitionWithoutTenantId, activityIdIn, rootProcessInstances, leafProcessInstances, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for modifyProcessInstance
     * @param id The id of the process instance to modify. (required)
     * @param processInstanceModificationDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> At least one modification instruction misses required parameters. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The modification cannot be performed, for example because it starts a failing activity. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call modifyProcessInstanceCall(String id, ProcessInstanceModificationDto processInstanceModificationDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = processInstanceModificationDto;

        // create path and map variables
        String localVarPath = "/process-instance/{id}/modification"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call modifyProcessInstanceValidateBeforeCall(String id, ProcessInstanceModificationDto processInstanceModificationDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling modifyProcessInstance(Async)");
        }
        

        okhttp3.Call localVarCall = modifyProcessInstanceCall(id, processInstanceModificationDto, _callback);
        return localVarCall;

    }

    /**
     * Modify Process Instance Execution State
     * Submits a list of modification instructions to change a process instance&#39;s execution state. A modification instruction is one of the following:  * Starting execution before an activity * Starting execution after an activity on its single outgoing sequence flow * Starting execution on a specific sequence flow * Canceling an activity instance, transition instance, or all instances (activity or transition) for an activity  Instructions are executed immediately and in the order they are provided in this request&#39;s body. Variables can be provided with every starting instruction.  The exact semantics of modification can be read about in the [User guide](https://docs.camunda.org/manual/develop/user-guide/process-engine/process-instance-modification/).
     * @param id The id of the process instance to modify. (required)
     * @param processInstanceModificationDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> At least one modification instruction misses required parameters. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The modification cannot be performed, for example because it starts a failing activity. </td><td>  -  </td></tr>
     </table>
     */
    public void modifyProcessInstance(String id, ProcessInstanceModificationDto processInstanceModificationDto) throws ApiException {
        modifyProcessInstanceWithHttpInfo(id, processInstanceModificationDto);
    }

    /**
     * Modify Process Instance Execution State
     * Submits a list of modification instructions to change a process instance&#39;s execution state. A modification instruction is one of the following:  * Starting execution before an activity * Starting execution after an activity on its single outgoing sequence flow * Starting execution on a specific sequence flow * Canceling an activity instance, transition instance, or all instances (activity or transition) for an activity  Instructions are executed immediately and in the order they are provided in this request&#39;s body. Variables can be provided with every starting instruction.  The exact semantics of modification can be read about in the [User guide](https://docs.camunda.org/manual/develop/user-guide/process-engine/process-instance-modification/).
     * @param id The id of the process instance to modify. (required)
     * @param processInstanceModificationDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> At least one modification instruction misses required parameters. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The modification cannot be performed, for example because it starts a failing activity. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> modifyProcessInstanceWithHttpInfo(String id, ProcessInstanceModificationDto processInstanceModificationDto) throws ApiException {
        okhttp3.Call localVarCall = modifyProcessInstanceValidateBeforeCall(id, processInstanceModificationDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Modify Process Instance Execution State (asynchronously)
     * Submits a list of modification instructions to change a process instance&#39;s execution state. A modification instruction is one of the following:  * Starting execution before an activity * Starting execution after an activity on its single outgoing sequence flow * Starting execution on a specific sequence flow * Canceling an activity instance, transition instance, or all instances (activity or transition) for an activity  Instructions are executed immediately and in the order they are provided in this request&#39;s body. Variables can be provided with every starting instruction.  The exact semantics of modification can be read about in the [User guide](https://docs.camunda.org/manual/develop/user-guide/process-engine/process-instance-modification/).
     * @param id The id of the process instance to modify. (required)
     * @param processInstanceModificationDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> At least one modification instruction misses required parameters. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The modification cannot be performed, for example because it starts a failing activity. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call modifyProcessInstanceAsync(String id, ProcessInstanceModificationDto processInstanceModificationDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = modifyProcessInstanceValidateBeforeCall(id, processInstanceModificationDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for modifyProcessInstanceAsyncOperation
     * @param id The id of the process instance to modify. (required)
     * @param processInstanceModificationDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request At least one modification instruction misses required parameters. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden If the user is not allowed to execute batches. See the Introduction for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The modification cannot be performed, for example because it starts a failing activity. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call modifyProcessInstanceAsyncOperationCall(String id, ProcessInstanceModificationDto processInstanceModificationDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = processInstanceModificationDto;

        // create path and map variables
        String localVarPath = "/process-instance/{id}/modification-async"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call modifyProcessInstanceAsyncOperationValidateBeforeCall(String id, ProcessInstanceModificationDto processInstanceModificationDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling modifyProcessInstanceAsyncOperation(Async)");
        }
        

        okhttp3.Call localVarCall = modifyProcessInstanceAsyncOperationCall(id, processInstanceModificationDto, _callback);
        return localVarCall;

    }

    /**
     * Modify Process Instance Execution State Async
     * Submits a list of modification instructions to change a process instance&#39;s execution state async. A modification instruction is one of the following:  * Starting execution before an activity * Starting execution after an activity on its single outgoing sequence flow * Starting execution on a specific sequence flow * Cancelling an activity instance, transition instance, or all instances (activity or transition) for an activity  Instructions are executed asynchronous and in the order they are provided in this request&#39;s body. Variables can be provided with every starting instruction.  The exact semantics of modification can be read about in the [User guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/process-instance-modification/).
     * @param id The id of the process instance to modify. (required)
     * @param processInstanceModificationDto  (optional)
     * @return BatchDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request At least one modification instruction misses required parameters. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden If the user is not allowed to execute batches. See the Introduction for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The modification cannot be performed, for example because it starts a failing activity. </td><td>  -  </td></tr>
     </table>
     */
    public BatchDto modifyProcessInstanceAsyncOperation(String id, ProcessInstanceModificationDto processInstanceModificationDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = modifyProcessInstanceAsyncOperationWithHttpInfo(id, processInstanceModificationDto);
        return localVarResp.getData();
    }

    /**
     * Modify Process Instance Execution State Async
     * Submits a list of modification instructions to change a process instance&#39;s execution state async. A modification instruction is one of the following:  * Starting execution before an activity * Starting execution after an activity on its single outgoing sequence flow * Starting execution on a specific sequence flow * Cancelling an activity instance, transition instance, or all instances (activity or transition) for an activity  Instructions are executed asynchronous and in the order they are provided in this request&#39;s body. Variables can be provided with every starting instruction.  The exact semantics of modification can be read about in the [User guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/process-instance-modification/).
     * @param id The id of the process instance to modify. (required)
     * @param processInstanceModificationDto  (optional)
     * @return ApiResponse&lt;BatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request At least one modification instruction misses required parameters. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden If the user is not allowed to execute batches. See the Introduction for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The modification cannot be performed, for example because it starts a failing activity. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BatchDto> modifyProcessInstanceAsyncOperationWithHttpInfo(String id, ProcessInstanceModificationDto processInstanceModificationDto) throws ApiException {
        okhttp3.Call localVarCall = modifyProcessInstanceAsyncOperationValidateBeforeCall(id, processInstanceModificationDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Modify Process Instance Execution State Async (asynchronously)
     * Submits a list of modification instructions to change a process instance&#39;s execution state async. A modification instruction is one of the following:  * Starting execution before an activity * Starting execution after an activity on its single outgoing sequence flow * Starting execution on a specific sequence flow * Cancelling an activity instance, transition instance, or all instances (activity or transition) for an activity  Instructions are executed asynchronous and in the order they are provided in this request&#39;s body. Variables can be provided with every starting instruction.  The exact semantics of modification can be read about in the [User guide](https://docs.camunda.org/manual/7.22/user-guide/process-engine/process-instance-modification/).
     * @param id The id of the process instance to modify. (required)
     * @param processInstanceModificationDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request At least one modification instruction misses required parameters. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden If the user is not allowed to execute batches. See the Introduction for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The modification cannot be performed, for example because it starts a failing activity. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call modifyProcessInstanceAsyncOperationAsync(String id, ProcessInstanceModificationDto processInstanceModificationDto, final ApiCallback<BatchDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = modifyProcessInstanceAsyncOperationValidateBeforeCall(id, processInstanceModificationDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for modifyProcessInstanceVariables
     * @param id The id of the process instance to set variables for. (required)
     * @param patchVariablesDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request The variable value or type is invalid, for example if the value could not be parsed to an Integer value or the passed variable type is not supported. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Update or delete could not be executed, for example because the process instance does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call modifyProcessInstanceVariablesCall(String id, PatchVariablesDto patchVariablesDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = patchVariablesDto;

        // create path and map variables
        String localVarPath = "/process-instance/{id}/variables"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call modifyProcessInstanceVariablesValidateBeforeCall(String id, PatchVariablesDto patchVariablesDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling modifyProcessInstanceVariables(Async)");
        }
        

        okhttp3.Call localVarCall = modifyProcessInstanceVariablesCall(id, patchVariablesDto, _callback);
        return localVarCall;

    }

    /**
     * Update/Delete Process Variables
     * Updates or deletes the variables of a process instance by id. Updates precede deletions. So, if a variable is updated AND deleted, the deletion overrides the update.
     * @param id The id of the process instance to set variables for. (required)
     * @param patchVariablesDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request The variable value or type is invalid, for example if the value could not be parsed to an Integer value or the passed variable type is not supported. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Update or delete could not be executed, for example because the process instance does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public void modifyProcessInstanceVariables(String id, PatchVariablesDto patchVariablesDto) throws ApiException {
        modifyProcessInstanceVariablesWithHttpInfo(id, patchVariablesDto);
    }

    /**
     * Update/Delete Process Variables
     * Updates or deletes the variables of a process instance by id. Updates precede deletions. So, if a variable is updated AND deleted, the deletion overrides the update.
     * @param id The id of the process instance to set variables for. (required)
     * @param patchVariablesDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request The variable value or type is invalid, for example if the value could not be parsed to an Integer value or the passed variable type is not supported. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Update or delete could not be executed, for example because the process instance does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> modifyProcessInstanceVariablesWithHttpInfo(String id, PatchVariablesDto patchVariablesDto) throws ApiException {
        okhttp3.Call localVarCall = modifyProcessInstanceVariablesValidateBeforeCall(id, patchVariablesDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Update/Delete Process Variables (asynchronously)
     * Updates or deletes the variables of a process instance by id. Updates precede deletions. So, if a variable is updated AND deleted, the deletion overrides the update.
     * @param id The id of the process instance to set variables for. (required)
     * @param patchVariablesDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request The variable value or type is invalid, for example if the value could not be parsed to an Integer value or the passed variable type is not supported. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Update or delete could not be executed, for example because the process instance does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call modifyProcessInstanceVariablesAsync(String id, PatchVariablesDto patchVariablesDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = modifyProcessInstanceVariablesValidateBeforeCall(id, patchVariablesDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryProcessInstances
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param processInstanceQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy, or if an invalid operator for variable comparison is used. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryProcessInstancesCall(Integer firstResult, Integer maxResults, ProcessInstanceQueryDto processInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = processInstanceQueryDto;

        // create path and map variables
        String localVarPath = "/process-instance";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryProcessInstancesValidateBeforeCall(Integer firstResult, Integer maxResults, ProcessInstanceQueryDto processInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryProcessInstancesCall(firstResult, maxResults, processInstanceQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get List (POST)
     * Queries for process instances that fulfill given parameters through a JSON object. This method is slightly more powerful than the Get Instances method because it allows filtering by multiple process variables of types &#x60;string&#x60;, &#x60;number&#x60; or &#x60;boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param processInstanceQueryDto  (optional)
     * @return List&lt;ProcessInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy, or if an invalid operator for variable comparison is used. </td><td>  -  </td></tr>
     </table>
     */
    public List<ProcessInstanceDto> queryProcessInstances(Integer firstResult, Integer maxResults, ProcessInstanceQueryDto processInstanceQueryDto) throws ApiException {
        ApiResponse<List<ProcessInstanceDto>> localVarResp = queryProcessInstancesWithHttpInfo(firstResult, maxResults, processInstanceQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get List (POST)
     * Queries for process instances that fulfill given parameters through a JSON object. This method is slightly more powerful than the Get Instances method because it allows filtering by multiple process variables of types &#x60;string&#x60;, &#x60;number&#x60; or &#x60;boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param processInstanceQueryDto  (optional)
     * @return ApiResponse&lt;List&lt;ProcessInstanceDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy, or if an invalid operator for variable comparison is used. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<ProcessInstanceDto>> queryProcessInstancesWithHttpInfo(Integer firstResult, Integer maxResults, ProcessInstanceQueryDto processInstanceQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryProcessInstancesValidateBeforeCall(firstResult, maxResults, processInstanceQueryDto, null);
        Type localVarReturnType = new TypeToken<List<ProcessInstanceDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List (POST) (asynchronously)
     * Queries for process instances that fulfill given parameters through a JSON object. This method is slightly more powerful than the Get Instances method because it allows filtering by multiple process variables of types &#x60;string&#x60;, &#x60;number&#x60; or &#x60;boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param processInstanceQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy, or if an invalid operator for variable comparison is used. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryProcessInstancesAsync(Integer firstResult, Integer maxResults, ProcessInstanceQueryDto processInstanceQueryDto, final ApiCallback<List<ProcessInstanceDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryProcessInstancesValidateBeforeCall(firstResult, maxResults, processInstanceQueryDto, _callback);
        Type localVarReturnType = new TypeToken<List<ProcessInstanceDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryProcessInstancesCount
     * @param processInstanceQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if an invalid operator for variable comparison is used. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryProcessInstancesCountCall(ProcessInstanceQueryDto processInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = processInstanceQueryDto;

        // create path and map variables
        String localVarPath = "/process-instance/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryProcessInstancesCountValidateBeforeCall(ProcessInstanceQueryDto processInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryProcessInstancesCountCall(processInstanceQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get List Count (POST)
     * Queries for the number of process instances that fulfill the given parameters. This method takes the same message body as the Get Instances (POST) method and therefore it is slightly more powerful than the Get Instance Count method.
     * @param processInstanceQueryDto  (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if an invalid operator for variable comparison is used. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto queryProcessInstancesCount(ProcessInstanceQueryDto processInstanceQueryDto) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = queryProcessInstancesCountWithHttpInfo(processInstanceQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get List Count (POST)
     * Queries for the number of process instances that fulfill the given parameters. This method takes the same message body as the Get Instances (POST) method and therefore it is slightly more powerful than the Get Instance Count method.
     * @param processInstanceQueryDto  (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if an invalid operator for variable comparison is used. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> queryProcessInstancesCountWithHttpInfo(ProcessInstanceQueryDto processInstanceQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryProcessInstancesCountValidateBeforeCall(processInstanceQueryDto, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List Count (POST) (asynchronously)
     * Queries for the number of process instances that fulfill the given parameters. This method takes the same message body as the Get Instances (POST) method and therefore it is slightly more powerful than the Get Instance Count method.
     * @param processInstanceQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if an invalid operator for variable comparison is used. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryProcessInstancesCountAsync(ProcessInstanceQueryDto processInstanceQueryDto, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryProcessInstancesCountValidateBeforeCall(processInstanceQueryDto, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for setProcessInstanceVariable
     * @param id The id of the process instance to set the variable for. (required)
     * @param varName The name of the variable to set. (required)
     * @param variableValueDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request The variable value or type is invalid, for example if the value could not be parsed to an Integer value or the passed variable type is not supported. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setProcessInstanceVariableCall(String id, String varName, VariableValueDto variableValueDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = variableValueDto;

        // create path and map variables
        String localVarPath = "/process-instance/{id}/variables/{varName}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()))
            .replaceAll("\\{" + "varName" + "\\}", localVarApiClient.escapeString(varName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setProcessInstanceVariableValidateBeforeCall(String id, String varName, VariableValueDto variableValueDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setProcessInstanceVariable(Async)");
        }
        
        // verify the required parameter 'varName' is set
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling setProcessInstanceVariable(Async)");
        }
        

        okhttp3.Call localVarCall = setProcessInstanceVariableCall(id, varName, variableValueDto, _callback);
        return localVarCall;

    }

    /**
     * Update Process Variable
     * Sets a variable of a given process instance by id.
     * @param id The id of the process instance to set the variable for. (required)
     * @param varName The name of the variable to set. (required)
     * @param variableValueDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request The variable value or type is invalid, for example if the value could not be parsed to an Integer value or the passed variable type is not supported. </td><td>  -  </td></tr>
     </table>
     */
    public void setProcessInstanceVariable(String id, String varName, VariableValueDto variableValueDto) throws ApiException {
        setProcessInstanceVariableWithHttpInfo(id, varName, variableValueDto);
    }

    /**
     * Update Process Variable
     * Sets a variable of a given process instance by id.
     * @param id The id of the process instance to set the variable for. (required)
     * @param varName The name of the variable to set. (required)
     * @param variableValueDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request The variable value or type is invalid, for example if the value could not be parsed to an Integer value or the passed variable type is not supported. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> setProcessInstanceVariableWithHttpInfo(String id, String varName, VariableValueDto variableValueDto) throws ApiException {
        okhttp3.Call localVarCall = setProcessInstanceVariableValidateBeforeCall(id, varName, variableValueDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Update Process Variable (asynchronously)
     * Sets a variable of a given process instance by id.
     * @param id The id of the process instance to set the variable for. (required)
     * @param varName The name of the variable to set. (required)
     * @param variableValueDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request The variable value or type is invalid, for example if the value could not be parsed to an Integer value or the passed variable type is not supported. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setProcessInstanceVariableAsync(String id, String varName, VariableValueDto variableValueDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = setProcessInstanceVariableValidateBeforeCall(id, varName, variableValueDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for setProcessInstanceVariableBinary
     * @param id The id of the process instance to retrieve the variable for. (required)
     * @param varName The name of the variable to retrieve. (required)
     * @param data The binary data to be set. For File variables, this multipart can contain the filename, binary value and MIME type of the file variable to be set Only the filename is mandatory. (optional)
     * @param valueType The name of the variable type. Either Bytes for a byte array variable or File for a file variable. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request The variable value or type is invalid, for example if no filename is set. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setProcessInstanceVariableBinaryCall(String id, String varName, File data, String valueType, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/process-instance/{id}/variables/{varName}/data"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()))
            .replaceAll("\\{" + "varName" + "\\}", localVarApiClient.escapeString(varName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (data != null) {
            localVarFormParams.put("data", data);
        }

        if (valueType != null) {
            localVarFormParams.put("valueType", valueType);
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setProcessInstanceVariableBinaryValidateBeforeCall(String id, String varName, File data, String valueType, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setProcessInstanceVariableBinary(Async)");
        }
        
        // verify the required parameter 'varName' is set
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling setProcessInstanceVariableBinary(Async)");
        }
        

        okhttp3.Call localVarCall = setProcessInstanceVariableBinaryCall(id, varName, data, valueType, _callback);
        return localVarCall;

    }

    /**
     * Update Process Variable (Binary)
     * Sets the serialized value for a binary variable or the binary value for a file variable.
     * @param id The id of the process instance to retrieve the variable for. (required)
     * @param varName The name of the variable to retrieve. (required)
     * @param data The binary data to be set. For File variables, this multipart can contain the filename, binary value and MIME type of the file variable to be set Only the filename is mandatory. (optional)
     * @param valueType The name of the variable type. Either Bytes for a byte array variable or File for a file variable. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request The variable value or type is invalid, for example if no filename is set. </td><td>  -  </td></tr>
     </table>
     */
    public void setProcessInstanceVariableBinary(String id, String varName, File data, String valueType) throws ApiException {
        setProcessInstanceVariableBinaryWithHttpInfo(id, varName, data, valueType);
    }

    /**
     * Update Process Variable (Binary)
     * Sets the serialized value for a binary variable or the binary value for a file variable.
     * @param id The id of the process instance to retrieve the variable for. (required)
     * @param varName The name of the variable to retrieve. (required)
     * @param data The binary data to be set. For File variables, this multipart can contain the filename, binary value and MIME type of the file variable to be set Only the filename is mandatory. (optional)
     * @param valueType The name of the variable type. Either Bytes for a byte array variable or File for a file variable. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request The variable value or type is invalid, for example if no filename is set. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> setProcessInstanceVariableBinaryWithHttpInfo(String id, String varName, File data, String valueType) throws ApiException {
        okhttp3.Call localVarCall = setProcessInstanceVariableBinaryValidateBeforeCall(id, varName, data, valueType, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Update Process Variable (Binary) (asynchronously)
     * Sets the serialized value for a binary variable or the binary value for a file variable.
     * @param id The id of the process instance to retrieve the variable for. (required)
     * @param varName The name of the variable to retrieve. (required)
     * @param data The binary data to be set. For File variables, this multipart can contain the filename, binary value and MIME type of the file variable to be set Only the filename is mandatory. (optional)
     * @param valueType The name of the variable type. Either Bytes for a byte array variable or File for a file variable. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request The variable value or type is invalid, for example if no filename is set. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setProcessInstanceVariableBinaryAsync(String id, String varName, File data, String valueType, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = setProcessInstanceVariableBinaryValidateBeforeCall(id, varName, data, valueType, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for setRetriesByProcess
     * @param setJobRetriesByProcessDto Please note that if both processInstances and processInstanceQuery are provided, then the resulting execution will be performed on the union of these sets. **Unallowed property**: &#x60;historicProcessInstanceQuery&#x60; (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if neither processInstanceIds, nor processInstanceQuery is present. Or if the retry count is not specified. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setRetriesByProcessCall(SetJobRetriesByProcessDto setJobRetriesByProcessDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = setJobRetriesByProcessDto;

        // create path and map variables
        String localVarPath = "/process-instance/job-retries";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setRetriesByProcessValidateBeforeCall(SetJobRetriesByProcessDto setJobRetriesByProcessDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = setRetriesByProcessCall(setJobRetriesByProcessDto, _callback);
        return localVarCall;

    }

    /**
     * Set Job Retries Async (POST)
     * Create a batch to set retries of jobs associated with given processes asynchronously.
     * @param setJobRetriesByProcessDto Please note that if both processInstances and processInstanceQuery are provided, then the resulting execution will be performed on the union of these sets. **Unallowed property**: &#x60;historicProcessInstanceQuery&#x60; (optional)
     * @return BatchDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if neither processInstanceIds, nor processInstanceQuery is present. Or if the retry count is not specified. </td><td>  -  </td></tr>
     </table>
     */
    public BatchDto setRetriesByProcess(SetJobRetriesByProcessDto setJobRetriesByProcessDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = setRetriesByProcessWithHttpInfo(setJobRetriesByProcessDto);
        return localVarResp.getData();
    }

    /**
     * Set Job Retries Async (POST)
     * Create a batch to set retries of jobs associated with given processes asynchronously.
     * @param setJobRetriesByProcessDto Please note that if both processInstances and processInstanceQuery are provided, then the resulting execution will be performed on the union of these sets. **Unallowed property**: &#x60;historicProcessInstanceQuery&#x60; (optional)
     * @return ApiResponse&lt;BatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if neither processInstanceIds, nor processInstanceQuery is present. Or if the retry count is not specified. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BatchDto> setRetriesByProcessWithHttpInfo(SetJobRetriesByProcessDto setJobRetriesByProcessDto) throws ApiException {
        okhttp3.Call localVarCall = setRetriesByProcessValidateBeforeCall(setJobRetriesByProcessDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Set Job Retries Async (POST) (asynchronously)
     * Create a batch to set retries of jobs associated with given processes asynchronously.
     * @param setJobRetriesByProcessDto Please note that if both processInstances and processInstanceQuery are provided, then the resulting execution will be performed on the union of these sets. **Unallowed property**: &#x60;historicProcessInstanceQuery&#x60; (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if neither processInstanceIds, nor processInstanceQuery is present. Or if the retry count is not specified. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setRetriesByProcessAsync(SetJobRetriesByProcessDto setJobRetriesByProcessDto, final ApiCallback<BatchDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = setRetriesByProcessValidateBeforeCall(setJobRetriesByProcessDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for setRetriesByProcessHistoricQueryBased
     * @param setJobRetriesByProcessDto Please note that if both processInstances and historicProcessInstanceQuery are provided, then the resulting execution will be performed on the union of these sets. **Unallowed property**: &#x60;processInstanceQuery&#x60; (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if neither processInstanceIds, nor historicProcessInstanceQuery is present. Or if the retry count is not specified. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setRetriesByProcessHistoricQueryBasedCall(SetJobRetriesByProcessDto setJobRetriesByProcessDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = setJobRetriesByProcessDto;

        // create path and map variables
        String localVarPath = "/process-instance/job-retries-historic-query-based";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setRetriesByProcessHistoricQueryBasedValidateBeforeCall(SetJobRetriesByProcessDto setJobRetriesByProcessDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = setRetriesByProcessHistoricQueryBasedCall(setJobRetriesByProcessDto, _callback);
        return localVarCall;

    }

    /**
     * Set Job Retries Async Historic Query Based (POST)
     * Create a batch to set retries of jobs asynchronously based on a historic process instance query.
     * @param setJobRetriesByProcessDto Please note that if both processInstances and historicProcessInstanceQuery are provided, then the resulting execution will be performed on the union of these sets. **Unallowed property**: &#x60;processInstanceQuery&#x60; (optional)
     * @return BatchDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if neither processInstanceIds, nor historicProcessInstanceQuery is present. Or if the retry count is not specified. </td><td>  -  </td></tr>
     </table>
     */
    public BatchDto setRetriesByProcessHistoricQueryBased(SetJobRetriesByProcessDto setJobRetriesByProcessDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = setRetriesByProcessHistoricQueryBasedWithHttpInfo(setJobRetriesByProcessDto);
        return localVarResp.getData();
    }

    /**
     * Set Job Retries Async Historic Query Based (POST)
     * Create a batch to set retries of jobs asynchronously based on a historic process instance query.
     * @param setJobRetriesByProcessDto Please note that if both processInstances and historicProcessInstanceQuery are provided, then the resulting execution will be performed on the union of these sets. **Unallowed property**: &#x60;processInstanceQuery&#x60; (optional)
     * @return ApiResponse&lt;BatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if neither processInstanceIds, nor historicProcessInstanceQuery is present. Or if the retry count is not specified. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BatchDto> setRetriesByProcessHistoricQueryBasedWithHttpInfo(SetJobRetriesByProcessDto setJobRetriesByProcessDto) throws ApiException {
        okhttp3.Call localVarCall = setRetriesByProcessHistoricQueryBasedValidateBeforeCall(setJobRetriesByProcessDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Set Job Retries Async Historic Query Based (POST) (asynchronously)
     * Create a batch to set retries of jobs asynchronously based on a historic process instance query.
     * @param setJobRetriesByProcessDto Please note that if both processInstances and historicProcessInstanceQuery are provided, then the resulting execution will be performed on the union of these sets. **Unallowed property**: &#x60;processInstanceQuery&#x60; (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if neither processInstanceIds, nor historicProcessInstanceQuery is present. Or if the retry count is not specified. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setRetriesByProcessHistoricQueryBasedAsync(SetJobRetriesByProcessDto setJobRetriesByProcessDto, final ApiCallback<BatchDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = setRetriesByProcessHistoricQueryBasedValidateBeforeCall(setJobRetriesByProcessDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for setVariablesAsyncOperation
     * @param setVariablesAsyncDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request * The variable value or type is invalid, for example if the value could not be parsed to an Integer value or the passed variable type is not supported * If none of &#x60;processInstanceIds&#x60;, &#x60;processInstanceQuery&#x60; and &#x60;historicProcessInstanceQuery&#x60; is given * If no or an empty array of &#x60;variables&#x60; is given * If no process instance ids where found * If a transient variable is set * If the engine config flag &#x60;javaSerializationFormatEnabled&#x60; is &#x60;false&#x60; and a Java serialized variable is given </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user is not allowed to create the batch.  See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setVariablesAsyncOperationCall(SetVariablesAsyncDto setVariablesAsyncDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = setVariablesAsyncDto;

        // create path and map variables
        String localVarPath = "/process-instance/variables-async";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setVariablesAsyncOperationValidateBeforeCall(SetVariablesAsyncDto setVariablesAsyncDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = setVariablesAsyncOperationCall(setVariablesAsyncDto, _callback);
        return localVarCall;

    }

    /**
     * Set Variables Async (POST)
     * Update or create runtime process variables in the root scope of process instances.
     * @param setVariablesAsyncDto  (optional)
     * @return BatchDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request * The variable value or type is invalid, for example if the value could not be parsed to an Integer value or the passed variable type is not supported * If none of &#x60;processInstanceIds&#x60;, &#x60;processInstanceQuery&#x60; and &#x60;historicProcessInstanceQuery&#x60; is given * If no or an empty array of &#x60;variables&#x60; is given * If no process instance ids where found * If a transient variable is set * If the engine config flag &#x60;javaSerializationFormatEnabled&#x60; is &#x60;false&#x60; and a Java serialized variable is given </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user is not allowed to create the batch.  See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public BatchDto setVariablesAsyncOperation(SetVariablesAsyncDto setVariablesAsyncDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = setVariablesAsyncOperationWithHttpInfo(setVariablesAsyncDto);
        return localVarResp.getData();
    }

    /**
     * Set Variables Async (POST)
     * Update or create runtime process variables in the root scope of process instances.
     * @param setVariablesAsyncDto  (optional)
     * @return ApiResponse&lt;BatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request * The variable value or type is invalid, for example if the value could not be parsed to an Integer value or the passed variable type is not supported * If none of &#x60;processInstanceIds&#x60;, &#x60;processInstanceQuery&#x60; and &#x60;historicProcessInstanceQuery&#x60; is given * If no or an empty array of &#x60;variables&#x60; is given * If no process instance ids where found * If a transient variable is set * If the engine config flag &#x60;javaSerializationFormatEnabled&#x60; is &#x60;false&#x60; and a Java serialized variable is given </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user is not allowed to create the batch.  See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BatchDto> setVariablesAsyncOperationWithHttpInfo(SetVariablesAsyncDto setVariablesAsyncDto) throws ApiException {
        okhttp3.Call localVarCall = setVariablesAsyncOperationValidateBeforeCall(setVariablesAsyncDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Set Variables Async (POST) (asynchronously)
     * Update or create runtime process variables in the root scope of process instances.
     * @param setVariablesAsyncDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request * The variable value or type is invalid, for example if the value could not be parsed to an Integer value or the passed variable type is not supported * If none of &#x60;processInstanceIds&#x60;, &#x60;processInstanceQuery&#x60; and &#x60;historicProcessInstanceQuery&#x60; is given * If no or an empty array of &#x60;variables&#x60; is given * If no process instance ids where found * If a transient variable is set * If the engine config flag &#x60;javaSerializationFormatEnabled&#x60; is &#x60;false&#x60; and a Java serialized variable is given </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Returned if the user is not allowed to create the batch.  See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setVariablesAsyncOperationAsync(SetVariablesAsyncDto setVariablesAsyncDto, final ApiCallback<BatchDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = setVariablesAsyncOperationValidateBeforeCall(setVariablesAsyncDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateSuspensionState
     * @param processInstanceSuspensionStateDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the request parameters are invalid, for example if the provided processDefinitionId or processDefinitionKey parameter is null. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateSuspensionStateCall(ProcessInstanceSuspensionStateDto processInstanceSuspensionStateDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = processInstanceSuspensionStateDto;

        // create path and map variables
        String localVarPath = "/process-instance/suspended";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateSuspensionStateValidateBeforeCall(ProcessInstanceSuspensionStateDto processInstanceSuspensionStateDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = updateSuspensionStateCall(processInstanceSuspensionStateDto, _callback);
        return localVarCall;

    }

    /**
     * Activate/Suspend In Group
     * Activates or suspends process instances by providing certain criteria:  # Activate/Suspend Process Instance By Process Definition Id * &#x60;suspend&#x60; * &#x60;processDefinitionId&#x60;  # Activate/Suspend Process Instance By Process Definition Key  * &#x60;suspend&#x60; * &#x60;processDefinitionKey&#x60; * &#x60;processDefinitionTenantId&#x60; * &#x60;processDefinitionWithoutTenantId&#x60;  # Activate/Suspend Process Instance In Group * &#x60;suspend&#x60; * &#x60;processInstanceIds&#x60; * &#x60;processInstanceQuery&#x60; * &#x60;historicProcessInstanceQuery&#x60;
     * @param processInstanceSuspensionStateDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the request parameters are invalid, for example if the provided processDefinitionId or processDefinitionKey parameter is null. </td><td>  -  </td></tr>
     </table>
     */
    public void updateSuspensionState(ProcessInstanceSuspensionStateDto processInstanceSuspensionStateDto) throws ApiException {
        updateSuspensionStateWithHttpInfo(processInstanceSuspensionStateDto);
    }

    /**
     * Activate/Suspend In Group
     * Activates or suspends process instances by providing certain criteria:  # Activate/Suspend Process Instance By Process Definition Id * &#x60;suspend&#x60; * &#x60;processDefinitionId&#x60;  # Activate/Suspend Process Instance By Process Definition Key  * &#x60;suspend&#x60; * &#x60;processDefinitionKey&#x60; * &#x60;processDefinitionTenantId&#x60; * &#x60;processDefinitionWithoutTenantId&#x60;  # Activate/Suspend Process Instance In Group * &#x60;suspend&#x60; * &#x60;processInstanceIds&#x60; * &#x60;processInstanceQuery&#x60; * &#x60;historicProcessInstanceQuery&#x60;
     * @param processInstanceSuspensionStateDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the request parameters are invalid, for example if the provided processDefinitionId or processDefinitionKey parameter is null. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateSuspensionStateWithHttpInfo(ProcessInstanceSuspensionStateDto processInstanceSuspensionStateDto) throws ApiException {
        okhttp3.Call localVarCall = updateSuspensionStateValidateBeforeCall(processInstanceSuspensionStateDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Activate/Suspend In Group (asynchronously)
     * Activates or suspends process instances by providing certain criteria:  # Activate/Suspend Process Instance By Process Definition Id * &#x60;suspend&#x60; * &#x60;processDefinitionId&#x60;  # Activate/Suspend Process Instance By Process Definition Key  * &#x60;suspend&#x60; * &#x60;processDefinitionKey&#x60; * &#x60;processDefinitionTenantId&#x60; * &#x60;processDefinitionWithoutTenantId&#x60;  # Activate/Suspend Process Instance In Group * &#x60;suspend&#x60; * &#x60;processInstanceIds&#x60; * &#x60;processInstanceQuery&#x60; * &#x60;historicProcessInstanceQuery&#x60;
     * @param processInstanceSuspensionStateDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the request parameters are invalid, for example if the provided processDefinitionId or processDefinitionKey parameter is null. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateSuspensionStateAsync(ProcessInstanceSuspensionStateDto processInstanceSuspensionStateDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateSuspensionStateValidateBeforeCall(processInstanceSuspensionStateDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateSuspensionStateAsyncOperation
     * @param processInstanceSuspensionStateAsyncDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the request parameters are invalid, for example if the provided processDefinitionId or processDefinitionKey parameter is null. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateSuspensionStateAsyncOperationCall(ProcessInstanceSuspensionStateAsyncDto processInstanceSuspensionStateAsyncDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = processInstanceSuspensionStateAsyncDto;

        // create path and map variables
        String localVarPath = "/process-instance/suspended-async";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateSuspensionStateAsyncOperationValidateBeforeCall(ProcessInstanceSuspensionStateAsyncDto processInstanceSuspensionStateAsyncDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = updateSuspensionStateAsyncOperationCall(processInstanceSuspensionStateAsyncDto, _callback);
        return localVarCall;

    }

    /**
     * Activate/Suspend In Batch
     * Activates or suspends process instances asynchronously with a list of process instance ids, a process instance query, and/or a historical process instance query.
     * @param processInstanceSuspensionStateAsyncDto  (optional)
     * @return BatchDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the request parameters are invalid, for example if the provided processDefinitionId or processDefinitionKey parameter is null. </td><td>  -  </td></tr>
     </table>
     */
    public BatchDto updateSuspensionStateAsyncOperation(ProcessInstanceSuspensionStateAsyncDto processInstanceSuspensionStateAsyncDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = updateSuspensionStateAsyncOperationWithHttpInfo(processInstanceSuspensionStateAsyncDto);
        return localVarResp.getData();
    }

    /**
     * Activate/Suspend In Batch
     * Activates or suspends process instances asynchronously with a list of process instance ids, a process instance query, and/or a historical process instance query.
     * @param processInstanceSuspensionStateAsyncDto  (optional)
     * @return ApiResponse&lt;BatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the request parameters are invalid, for example if the provided processDefinitionId or processDefinitionKey parameter is null. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BatchDto> updateSuspensionStateAsyncOperationWithHttpInfo(ProcessInstanceSuspensionStateAsyncDto processInstanceSuspensionStateAsyncDto) throws ApiException {
        okhttp3.Call localVarCall = updateSuspensionStateAsyncOperationValidateBeforeCall(processInstanceSuspensionStateAsyncDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Activate/Suspend In Batch (asynchronously)
     * Activates or suspends process instances asynchronously with a list of process instance ids, a process instance query, and/or a historical process instance query.
     * @param processInstanceSuspensionStateAsyncDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the request parameters are invalid, for example if the provided processDefinitionId or processDefinitionKey parameter is null. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateSuspensionStateAsyncOperationAsync(ProcessInstanceSuspensionStateAsyncDto processInstanceSuspensionStateAsyncDto, final ApiCallback<BatchDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateSuspensionStateAsyncOperationValidateBeforeCall(processInstanceSuspensionStateAsyncDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateSuspensionStateById
     * @param id The id of the process instance to activate or suspend. (required)
     * @param suspensionStateDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateSuspensionStateByIdCall(String id, SuspensionStateDto suspensionStateDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = suspensionStateDto;

        // create path and map variables
        String localVarPath = "/process-instance/{id}/suspended"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateSuspensionStateByIdValidateBeforeCall(String id, SuspensionStateDto suspensionStateDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateSuspensionStateById(Async)");
        }
        

        okhttp3.Call localVarCall = updateSuspensionStateByIdCall(id, suspensionStateDto, _callback);
        return localVarCall;

    }

    /**
     * Activate/Suspend Process Instance By Id
     * Activates or suspends a given process instance by id.
     * @param id The id of the process instance to activate or suspend. (required)
     * @param suspensionStateDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public void updateSuspensionStateById(String id, SuspensionStateDto suspensionStateDto) throws ApiException {
        updateSuspensionStateByIdWithHttpInfo(id, suspensionStateDto);
    }

    /**
     * Activate/Suspend Process Instance By Id
     * Activates or suspends a given process instance by id.
     * @param id The id of the process instance to activate or suspend. (required)
     * @param suspensionStateDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateSuspensionStateByIdWithHttpInfo(String id, SuspensionStateDto suspensionStateDto) throws ApiException {
        okhttp3.Call localVarCall = updateSuspensionStateByIdValidateBeforeCall(id, suspensionStateDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Activate/Suspend Process Instance By Id (asynchronously)
     * Activates or suspends a given process instance by id.
     * @param id The id of the process instance to activate or suspend. (required)
     * @param suspensionStateDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateSuspensionStateByIdAsync(String id, SuspensionStateDto suspensionStateDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateSuspensionStateByIdValidateBeforeCall(id, suspensionStateDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
