/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.22.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.api;

import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.ProgressRequestBody;
import org.openapitools.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.openapitools.client.model.CountResultDto;
import org.openapitools.client.model.CreateFilterDto;
import org.openapitools.client.model.ExceptionDto;
import org.openapitools.client.model.FilterDto;
import org.openapitools.client.model.ResourceOptionsDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FilterApi {
    private ApiClient localVarApiClient;

    public FilterApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FilterApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for createFilter
     * @param createFilterDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Filter was invalid. See [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to create a new filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createFilterCall(CreateFilterDto createFilterDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = createFilterDto;

        // create path and map variables
        String localVarPath = "/filter/create";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createFilterValidateBeforeCall(CreateFilterDto createFilterDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = createFilterCall(createFilterDto, _callback);
        return localVarCall;

    }

    /**
     * Create Filter
     * Creates a new filter.
     * @param createFilterDto  (optional)
     * @return FilterDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Filter was invalid. See [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to create a new filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public FilterDto createFilter(CreateFilterDto createFilterDto) throws ApiException {
        ApiResponse<FilterDto> localVarResp = createFilterWithHttpInfo(createFilterDto);
        return localVarResp.getData();
    }

    /**
     * Create Filter
     * Creates a new filter.
     * @param createFilterDto  (optional)
     * @return ApiResponse&lt;FilterDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Filter was invalid. See [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to create a new filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FilterDto> createFilterWithHttpInfo(CreateFilterDto createFilterDto) throws ApiException {
        okhttp3.Call localVarCall = createFilterValidateBeforeCall(createFilterDto, null);
        Type localVarReturnType = new TypeToken<FilterDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create Filter (asynchronously)
     * Creates a new filter.
     * @param createFilterDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Filter was invalid. See [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to create a new filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createFilterAsync(CreateFilterDto createFilterDto, final ApiCallback<FilterDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = createFilterValidateBeforeCall(createFilterDto, _callback);
        Type localVarReturnType = new TypeToken<FilterDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteFilter
     * @param id The id of the filter to be deleted. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to delete this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter cannot be found. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteFilterCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/filter/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteFilterValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteFilter(Async)");
        }
        

        okhttp3.Call localVarCall = deleteFilterCall(id, _callback);
        return localVarCall;

    }

    /**
     * Delete Filter
     * Deletes a filter by id.
     * @param id The id of the filter to be deleted. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to delete this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter cannot be found. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public void deleteFilter(String id) throws ApiException {
        deleteFilterWithHttpInfo(id);
    }

    /**
     * Delete Filter
     * Deletes a filter by id.
     * @param id The id of the filter to be deleted. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to delete this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter cannot be found. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteFilterWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = deleteFilterValidateBeforeCall(id, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete Filter (asynchronously)
     * Deletes a filter by id.
     * @param id The id of the filter to be deleted. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to delete this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter cannot be found. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteFilterAsync(String id, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteFilterValidateBeforeCall(id, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for executeFilterCount
     * @param id The id of the filter to execute. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call executeFilterCountCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/filter/{id}/count"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call executeFilterCountValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling executeFilterCount(Async)");
        }
        

        okhttp3.Call localVarCall = executeFilterCountCall(id, _callback);
        return localVarCall;

    }

    /**
     * Execute Filter Count
     * Executes the saved query of the filter by id and returns the count.
     * @param id The id of the filter to execute. (required)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto executeFilterCount(String id) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = executeFilterCountWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Execute Filter Count
     * Executes the saved query of the filter by id and returns the count.
     * @param id The id of the filter to execute. (required)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> executeFilterCountWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = executeFilterCountValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Execute Filter Count (asynchronously)
     * Executes the saved query of the filter by id and returns the count.
     * @param id The id of the filter to execute. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call executeFilterCountAsync(String id, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = executeFilterCountValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for executeFilterList
     * @param id The id of the filter to execute. (required)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON array containing JSON objects corresponding to the matching entity interface in the engine. This depends on the saved query in the filter. Therefore it is not possible to specify a generic result format, i.e., if the resource type of the filter is Task the result will correspond to the Task interface in the engine. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call executeFilterListCall(String id, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/filter/{id}/list"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call executeFilterListValidateBeforeCall(String id, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling executeFilterList(Async)");
        }
        

        okhttp3.Call localVarCall = executeFilterListCall(id, firstResult, maxResults, _callback);
        return localVarCall;

    }

    /**
     * Execute Filter List
     * Executes the saved query of the filter by id and returns the result list.
     * @param id The id of the filter to execute. (required)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return List&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON array containing JSON objects corresponding to the matching entity interface in the engine. This depends on the saved query in the filter. Therefore it is not possible to specify a generic result format, i.e., if the resource type of the filter is Task the result will correspond to the Task interface in the engine. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public List<Object> executeFilterList(String id, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<Object>> localVarResp = executeFilterListWithHttpInfo(id, firstResult, maxResults);
        return localVarResp.getData();
    }

    /**
     * Execute Filter List
     * Executes the saved query of the filter by id and returns the result list.
     * @param id The id of the filter to execute. (required)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return ApiResponse&lt;List&lt;Object&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON array containing JSON objects corresponding to the matching entity interface in the engine. This depends on the saved query in the filter. Therefore it is not possible to specify a generic result format, i.e., if the resource type of the filter is Task the result will correspond to the Task interface in the engine. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Object>> executeFilterListWithHttpInfo(String id, Integer firstResult, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = executeFilterListValidateBeforeCall(id, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<Object>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Execute Filter List (asynchronously)
     * Executes the saved query of the filter by id and returns the result list.
     * @param id The id of the filter to execute. (required)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON array containing JSON objects corresponding to the matching entity interface in the engine. This depends on the saved query in the filter. Therefore it is not possible to specify a generic result format, i.e., if the resource type of the filter is Task the result will correspond to the Task interface in the engine. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call executeFilterListAsync(String id, Integer firstResult, Integer maxResults, final ApiCallback<List<Object>> _callback) throws ApiException {

        okhttp3.Call localVarCall = executeFilterListValidateBeforeCall(id, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<Object>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for executeFilterSingleResult
     * @param id The id of the filter to execute. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object corresponding to the matching entity interface in the engine. This depends on the saved query in the filter. Therefore it is not possible to specify a generic result format, i.e., if the resource type of the filter is Task the result will correspond to the Task interface in the engine. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> Request successful, but the result was empty. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The executed filter returned more than one single result. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call executeFilterSingleResultCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/filter/{id}/singleResult"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call executeFilterSingleResultValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling executeFilterSingleResult(Async)");
        }
        

        okhttp3.Call localVarCall = executeFilterSingleResultCall(id, _callback);
        return localVarCall;

    }

    /**
     * Execute Filter Single Result
     * Executes the saved query of the filter by id and returns the single result.
     * @param id The id of the filter to execute. (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object corresponding to the matching entity interface in the engine. This depends on the saved query in the filter. Therefore it is not possible to specify a generic result format, i.e., if the resource type of the filter is Task the result will correspond to the Task interface in the engine. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> Request successful, but the result was empty. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The executed filter returned more than one single result. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public Object executeFilterSingleResult(String id) throws ApiException {
        ApiResponse<Object> localVarResp = executeFilterSingleResultWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Execute Filter Single Result
     * Executes the saved query of the filter by id and returns the single result.
     * @param id The id of the filter to execute. (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object corresponding to the matching entity interface in the engine. This depends on the saved query in the filter. Therefore it is not possible to specify a generic result format, i.e., if the resource type of the filter is Task the result will correspond to the Task interface in the engine. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> Request successful, but the result was empty. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The executed filter returned more than one single result. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> executeFilterSingleResultWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = executeFilterSingleResultValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Execute Filter Single Result (asynchronously)
     * Executes the saved query of the filter by id and returns the single result.
     * @param id The id of the filter to execute. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object corresponding to the matching entity interface in the engine. This depends on the saved query in the filter. Therefore it is not possible to specify a generic result format, i.e., if the resource type of the filter is Task the result will correspond to the Task interface in the engine. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> Request successful, but the result was empty. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The executed filter returned more than one single result. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call executeFilterSingleResultAsync(String id, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = executeFilterSingleResultValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for filterResourceOptions
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call filterResourceOptionsCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/filter";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call filterResourceOptionsValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = filterResourceOptionsCall(_callback);
        return localVarCall;

    }

    /**
     * Filter Resource Options
     * The OPTIONS request allows you to check for the set of available operations  that the currently authenticated user can perform on the &#x60;/filter&#x60; resource. Whether the user can perform an operation or not may depend on various factors, including the users authorizations to interact with this resource and the internal configuration of the process engine.
     * @return ResourceOptionsDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public ResourceOptionsDto filterResourceOptions() throws ApiException {
        ApiResponse<ResourceOptionsDto> localVarResp = filterResourceOptionsWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Filter Resource Options
     * The OPTIONS request allows you to check for the set of available operations  that the currently authenticated user can perform on the &#x60;/filter&#x60; resource. Whether the user can perform an operation or not may depend on various factors, including the users authorizations to interact with this resource and the internal configuration of the process engine.
     * @return ApiResponse&lt;ResourceOptionsDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ResourceOptionsDto> filterResourceOptionsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = filterResourceOptionsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Filter Resource Options (asynchronously)
     * The OPTIONS request allows you to check for the set of available operations  that the currently authenticated user can perform on the &#x60;/filter&#x60; resource. Whether the user can perform an operation or not may depend on various factors, including the users authorizations to interact with this resource and the internal configuration of the process engine.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call filterResourceOptionsAsync(final ApiCallback<ResourceOptionsDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = filterResourceOptionsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for filterResourceOptionsSingle
     * @param id The id of the filter to be checked. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call filterResourceOptionsSingleCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/filter/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call filterResourceOptionsSingleValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling filterResourceOptionsSingle(Async)");
        }
        

        okhttp3.Call localVarCall = filterResourceOptionsSingleCall(id, _callback);
        return localVarCall;

    }

    /**
     * Filter Resource Options
     * The OPTIONS request allows you to check for the set of available operations  that the currently authenticated user can perform on the &#x60;/filter&#x60; resource. Whether the user can perform an operation or not may depend on various factors, including the users authorizations to interact with this resource and the internal configuration of the process engine.
     * @param id The id of the filter to be checked. (required)
     * @return ResourceOptionsDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public ResourceOptionsDto filterResourceOptionsSingle(String id) throws ApiException {
        ApiResponse<ResourceOptionsDto> localVarResp = filterResourceOptionsSingleWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Filter Resource Options
     * The OPTIONS request allows you to check for the set of available operations  that the currently authenticated user can perform on the &#x60;/filter&#x60; resource. Whether the user can perform an operation or not may depend on various factors, including the users authorizations to interact with this resource and the internal configuration of the process engine.
     * @param id The id of the filter to be checked. (required)
     * @return ApiResponse&lt;ResourceOptionsDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ResourceOptionsDto> filterResourceOptionsSingleWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = filterResourceOptionsSingleValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Filter Resource Options (asynchronously)
     * The OPTIONS request allows you to check for the set of available operations  that the currently authenticated user can perform on the &#x60;/filter&#x60; resource. Whether the user can perform an operation or not may depend on various factors, including the users authorizations to interact with this resource and the internal configuration of the process engine.
     * @param id The id of the filter to be checked. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call filterResourceOptionsSingleAsync(String id, final ApiCallback<ResourceOptionsDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = filterResourceOptionsSingleValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getFilterCount
     * @param filterId Filter by the id of the filter. (optional)
     * @param resourceType Filter by the resource type of the filter, e.g., &#x60;Task&#x60;. (optional)
     * @param name Filter by the name of the filter. (optional)
     * @param nameLike Filter by the name that the parameter is a substring of. (optional)
     * @param owner Filter by the user id of the owner of the filter. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60;parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFilterCountCall(String filterId, String resourceType, String name, String nameLike, String owner, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/filter/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (filterId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filterId", filterId));
        }

        if (resourceType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("resourceType", resourceType));
        }

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        if (nameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("nameLike", nameLike));
        }

        if (owner != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("owner", owner));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getFilterCountValidateBeforeCall(String filterId, String resourceType, String name, String nameLike, String owner, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getFilterCountCall(filterId, resourceType, name, nameLike, owner, _callback);
        return localVarCall;

    }

    /**
     * Get Filter Count
     * Retrieves the number of filters that fulfill a provided query. Corresponds to the size of the result set when using the  [Get Filters](https://docs.camunda.org/manual/7.22/reference/rest/filter/get-query/) method.
     * @param filterId Filter by the id of the filter. (optional)
     * @param resourceType Filter by the resource type of the filter, e.g., &#x60;Task&#x60;. (optional)
     * @param name Filter by the name of the filter. (optional)
     * @param nameLike Filter by the name that the parameter is a substring of. (optional)
     * @param owner Filter by the user id of the owner of the filter. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60;parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getFilterCount(String filterId, String resourceType, String name, String nameLike, String owner) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getFilterCountWithHttpInfo(filterId, resourceType, name, nameLike, owner);
        return localVarResp.getData();
    }

    /**
     * Get Filter Count
     * Retrieves the number of filters that fulfill a provided query. Corresponds to the size of the result set when using the  [Get Filters](https://docs.camunda.org/manual/7.22/reference/rest/filter/get-query/) method.
     * @param filterId Filter by the id of the filter. (optional)
     * @param resourceType Filter by the resource type of the filter, e.g., &#x60;Task&#x60;. (optional)
     * @param name Filter by the name of the filter. (optional)
     * @param nameLike Filter by the name that the parameter is a substring of. (optional)
     * @param owner Filter by the user id of the owner of the filter. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60;parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getFilterCountWithHttpInfo(String filterId, String resourceType, String name, String nameLike, String owner) throws ApiException {
        okhttp3.Call localVarCall = getFilterCountValidateBeforeCall(filterId, resourceType, name, nameLike, owner, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Filter Count (asynchronously)
     * Retrieves the number of filters that fulfill a provided query. Corresponds to the size of the result set when using the  [Get Filters](https://docs.camunda.org/manual/7.22/reference/rest/filter/get-query/) method.
     * @param filterId Filter by the id of the filter. (optional)
     * @param resourceType Filter by the resource type of the filter, e.g., &#x60;Task&#x60;. (optional)
     * @param name Filter by the name of the filter. (optional)
     * @param nameLike Filter by the name that the parameter is a substring of. (optional)
     * @param owner Filter by the user id of the owner of the filter. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60;parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFilterCountAsync(String filterId, String resourceType, String name, String nameLike, String owner, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getFilterCountValidateBeforeCall(filterId, resourceType, name, nameLike, owner, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getFilterList
     * @param filterId Filter by the id of the filter. (optional)
     * @param resourceType Filter by the resource type of the filter, e.g., &#x60;Task&#x60;. (optional)
     * @param name Filter by the name of the filter. (optional)
     * @param nameLike Filter by the name that the parameter is a substring of. (optional)
     * @param owner Filter by the user id of the owner of the filter. (optional)
     * @param itemCount If set to &#x60;true&#x60;, each filter result will contain an &#x60;itemCount&#x60; property with the number of items matched by the filter itself. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60; is specified. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFilterListCall(String filterId, String resourceType, String name, String nameLike, String owner, Boolean itemCount, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/filter";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (filterId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filterId", filterId));
        }

        if (resourceType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("resourceType", resourceType));
        }

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        if (nameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("nameLike", nameLike));
        }

        if (owner != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("owner", owner));
        }

        if (itemCount != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("itemCount", itemCount));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getFilterListValidateBeforeCall(String filterId, String resourceType, String name, String nameLike, String owner, Boolean itemCount, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getFilterListCall(filterId, resourceType, name, nameLike, owner, itemCount, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;

    }

    /**
     * Get Filters
     * Queries for a list of filters using a list of parameters. The size of the result set can be retrieved by using the [Get Filter Count](https://docs.camunda.org/manual/7.22/reference/rest/filter/get-query-count/) method.
     * @param filterId Filter by the id of the filter. (optional)
     * @param resourceType Filter by the resource type of the filter, e.g., &#x60;Task&#x60;. (optional)
     * @param name Filter by the name of the filter. (optional)
     * @param nameLike Filter by the name that the parameter is a substring of. (optional)
     * @param owner Filter by the user id of the owner of the filter. (optional)
     * @param itemCount If set to &#x60;true&#x60;, each filter result will contain an &#x60;itemCount&#x60; property with the number of items matched by the filter itself. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return List&lt;FilterDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60; is specified. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public List<FilterDto> getFilterList(String filterId, String resourceType, String name, String nameLike, String owner, Boolean itemCount, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<FilterDto>> localVarResp = getFilterListWithHttpInfo(filterId, resourceType, name, nameLike, owner, itemCount, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    /**
     * Get Filters
     * Queries for a list of filters using a list of parameters. The size of the result set can be retrieved by using the [Get Filter Count](https://docs.camunda.org/manual/7.22/reference/rest/filter/get-query-count/) method.
     * @param filterId Filter by the id of the filter. (optional)
     * @param resourceType Filter by the resource type of the filter, e.g., &#x60;Task&#x60;. (optional)
     * @param name Filter by the name of the filter. (optional)
     * @param nameLike Filter by the name that the parameter is a substring of. (optional)
     * @param owner Filter by the user id of the owner of the filter. (optional)
     * @param itemCount If set to &#x60;true&#x60;, each filter result will contain an &#x60;itemCount&#x60; property with the number of items matched by the filter itself. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return ApiResponse&lt;List&lt;FilterDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60; is specified. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<FilterDto>> getFilterListWithHttpInfo(String filterId, String resourceType, String name, String nameLike, String owner, Boolean itemCount, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = getFilterListValidateBeforeCall(filterId, resourceType, name, nameLike, owner, itemCount, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<FilterDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Filters (asynchronously)
     * Queries for a list of filters using a list of parameters. The size of the result set can be retrieved by using the [Get Filter Count](https://docs.camunda.org/manual/7.22/reference/rest/filter/get-query-count/) method.
     * @param filterId Filter by the id of the filter. (optional)
     * @param resourceType Filter by the resource type of the filter, e.g., &#x60;Task&#x60;. (optional)
     * @param name Filter by the name of the filter. (optional)
     * @param nameLike Filter by the name that the parameter is a substring of. (optional)
     * @param owner Filter by the user id of the owner of the filter. (optional)
     * @param itemCount If set to &#x60;true&#x60;, each filter result will contain an &#x60;itemCount&#x60; property with the number of items matched by the filter itself. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60; is specified. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFilterListAsync(String filterId, String resourceType, String name, String nameLike, String owner, Boolean itemCount, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback<List<FilterDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getFilterListValidateBeforeCall(filterId, resourceType, name, nameLike, owner, itemCount, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<FilterDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSingleFilter
     * @param id The id of the filter to be retrieved. (required)
     * @param itemCount If set to &#x60;true&#x60;, each filter result will contain an &#x60;itemCount&#x60; property with the number of items matched by the filter itself. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSingleFilterCall(String id, Boolean itemCount, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/filter/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (itemCount != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("itemCount", itemCount));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSingleFilterValidateBeforeCall(String id, Boolean itemCount, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSingleFilter(Async)");
        }
        

        okhttp3.Call localVarCall = getSingleFilterCall(id, itemCount, _callback);
        return localVarCall;

    }

    /**
     * Get Single Filter
     * Retrieves a single filter by id, according to the &#x60;Filter&#x60; interface in the engine.
     * @param id The id of the filter to be retrieved. (required)
     * @param itemCount If set to &#x60;true&#x60;, each filter result will contain an &#x60;itemCount&#x60; property with the number of items matched by the filter itself. (optional)
     * @return FilterDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public FilterDto getSingleFilter(String id, Boolean itemCount) throws ApiException {
        ApiResponse<FilterDto> localVarResp = getSingleFilterWithHttpInfo(id, itemCount);
        return localVarResp.getData();
    }

    /**
     * Get Single Filter
     * Retrieves a single filter by id, according to the &#x60;Filter&#x60; interface in the engine.
     * @param id The id of the filter to be retrieved. (required)
     * @param itemCount If set to &#x60;true&#x60;, each filter result will contain an &#x60;itemCount&#x60; property with the number of items matched by the filter itself. (optional)
     * @return ApiResponse&lt;FilterDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FilterDto> getSingleFilterWithHttpInfo(String id, Boolean itemCount) throws ApiException {
        okhttp3.Call localVarCall = getSingleFilterValidateBeforeCall(id, itemCount, null);
        Type localVarReturnType = new TypeToken<FilterDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Single Filter (asynchronously)
     * Retrieves a single filter by id, according to the &#x60;Filter&#x60; interface in the engine.
     * @param id The id of the filter to be retrieved. (required)
     * @param itemCount If set to &#x60;true&#x60;, each filter result will contain an &#x60;itemCount&#x60; property with the number of items matched by the filter itself. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSingleFilterAsync(String id, Boolean itemCount, final ApiCallback<FilterDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getSingleFilterValidateBeforeCall(id, itemCount, _callback);
        Type localVarReturnType = new TypeToken<FilterDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for postExecuteFilterCount
     * @param id The id of the filter to execute. (required)
     * @param body A JSON object which corresponds to the type of the saved query of the filter, i.e., if the resource type of the filter is Task the body should form a valid task query corresponding to the Task resource. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The extending query was invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call postExecuteFilterCountCall(String id, Object body, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/filter/{id}/count"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call postExecuteFilterCountValidateBeforeCall(String id, Object body, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling postExecuteFilterCount(Async)");
        }
        

        okhttp3.Call localVarCall = postExecuteFilterCountCall(id, body, _callback);
        return localVarCall;

    }

    /**
     * Execute Filter Count (POST)
     * Executes the saved query of the filter by id and returns the count. This method is slightly more powerful then the [Get Execute Filter Count](https://docs.camunda.org/manual/7.22/reference/rest/filter/get-execute-count/)  method because it allows to extend the saved query of the filter.
     * @param id The id of the filter to execute. (required)
     * @param body A JSON object which corresponds to the type of the saved query of the filter, i.e., if the resource type of the filter is Task the body should form a valid task query corresponding to the Task resource. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The extending query was invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto postExecuteFilterCount(String id, Object body) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = postExecuteFilterCountWithHttpInfo(id, body);
        return localVarResp.getData();
    }

    /**
     * Execute Filter Count (POST)
     * Executes the saved query of the filter by id and returns the count. This method is slightly more powerful then the [Get Execute Filter Count](https://docs.camunda.org/manual/7.22/reference/rest/filter/get-execute-count/)  method because it allows to extend the saved query of the filter.
     * @param id The id of the filter to execute. (required)
     * @param body A JSON object which corresponds to the type of the saved query of the filter, i.e., if the resource type of the filter is Task the body should form a valid task query corresponding to the Task resource. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The extending query was invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> postExecuteFilterCountWithHttpInfo(String id, Object body) throws ApiException {
        okhttp3.Call localVarCall = postExecuteFilterCountValidateBeforeCall(id, body, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Execute Filter Count (POST) (asynchronously)
     * Executes the saved query of the filter by id and returns the count. This method is slightly more powerful then the [Get Execute Filter Count](https://docs.camunda.org/manual/7.22/reference/rest/filter/get-execute-count/)  method because it allows to extend the saved query of the filter.
     * @param id The id of the filter to execute. (required)
     * @param body A JSON object which corresponds to the type of the saved query of the filter, i.e., if the resource type of the filter is Task the body should form a valid task query corresponding to the Task resource. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The extending query was invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call postExecuteFilterCountAsync(String id, Object body, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = postExecuteFilterCountValidateBeforeCall(id, body, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for postExecuteFilterList
     * @param id The id of the filter to execute. (required)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param body A JSON object which corresponds to the type of the saved query of the filter, i.e., if the resource type of the filter is Task the body should form a valid task query corresponding to the Task resource. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON array containing JSON objects corresponding to the matching entity interface in the engine. This depends on the saved query in the filter. Therefore it is not possible to specify a generic result format, i.e., if the resource type of the filter is Task the result will correspond to the Task interface in the engine. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The extending query was invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call postExecuteFilterListCall(String id, Integer firstResult, Integer maxResults, Object body, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/filter/{id}/list"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call postExecuteFilterListValidateBeforeCall(String id, Integer firstResult, Integer maxResults, Object body, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling postExecuteFilterList(Async)");
        }
        

        okhttp3.Call localVarCall = postExecuteFilterListCall(id, firstResult, maxResults, body, _callback);
        return localVarCall;

    }

    /**
     * Execute Filter List (POST)
     * Executes the saved query of the filter by id and returns the result list. This method is slightly more powerful then the  [Get Execute FilterList](https://docs.camunda.org/manual/7.22/reference/rest/filter/get-execute-list/) method because it allows to extend the saved query of the filter.
     * @param id The id of the filter to execute. (required)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param body A JSON object which corresponds to the type of the saved query of the filter, i.e., if the resource type of the filter is Task the body should form a valid task query corresponding to the Task resource. (optional)
     * @return List&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON array containing JSON objects corresponding to the matching entity interface in the engine. This depends on the saved query in the filter. Therefore it is not possible to specify a generic result format, i.e., if the resource type of the filter is Task the result will correspond to the Task interface in the engine. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The extending query was invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public List<Object> postExecuteFilterList(String id, Integer firstResult, Integer maxResults, Object body) throws ApiException {
        ApiResponse<List<Object>> localVarResp = postExecuteFilterListWithHttpInfo(id, firstResult, maxResults, body);
        return localVarResp.getData();
    }

    /**
     * Execute Filter List (POST)
     * Executes the saved query of the filter by id and returns the result list. This method is slightly more powerful then the  [Get Execute FilterList](https://docs.camunda.org/manual/7.22/reference/rest/filter/get-execute-list/) method because it allows to extend the saved query of the filter.
     * @param id The id of the filter to execute. (required)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param body A JSON object which corresponds to the type of the saved query of the filter, i.e., if the resource type of the filter is Task the body should form a valid task query corresponding to the Task resource. (optional)
     * @return ApiResponse&lt;List&lt;Object&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON array containing JSON objects corresponding to the matching entity interface in the engine. This depends on the saved query in the filter. Therefore it is not possible to specify a generic result format, i.e., if the resource type of the filter is Task the result will correspond to the Task interface in the engine. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The extending query was invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Object>> postExecuteFilterListWithHttpInfo(String id, Integer firstResult, Integer maxResults, Object body) throws ApiException {
        okhttp3.Call localVarCall = postExecuteFilterListValidateBeforeCall(id, firstResult, maxResults, body, null);
        Type localVarReturnType = new TypeToken<List<Object>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Execute Filter List (POST) (asynchronously)
     * Executes the saved query of the filter by id and returns the result list. This method is slightly more powerful then the  [Get Execute FilterList](https://docs.camunda.org/manual/7.22/reference/rest/filter/get-execute-list/) method because it allows to extend the saved query of the filter.
     * @param id The id of the filter to execute. (required)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param body A JSON object which corresponds to the type of the saved query of the filter, i.e., if the resource type of the filter is Task the body should form a valid task query corresponding to the Task resource. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON array containing JSON objects corresponding to the matching entity interface in the engine. This depends on the saved query in the filter. Therefore it is not possible to specify a generic result format, i.e., if the resource type of the filter is Task the result will correspond to the Task interface in the engine. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The extending query was invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call postExecuteFilterListAsync(String id, Integer firstResult, Integer maxResults, Object body, final ApiCallback<List<Object>> _callback) throws ApiException {

        okhttp3.Call localVarCall = postExecuteFilterListValidateBeforeCall(id, firstResult, maxResults, body, _callback);
        Type localVarReturnType = new TypeToken<List<Object>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for postExecuteFilterSingleResult
     * @param id The id of the filter to execute. (required)
     * @param body A JSON object which corresponds to the type of the saved query of the filter, i.e., if the resource type of the filter is Task the body should form a valid task query corresponding to the Task resource. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object corresponding to the corresponding entity interface in the engine. This depends on the saved query in the filter. Therefore it is not possible specify a generic result format, i.e., if the resource type of the filter is Task the result will correspond to the Task interface in the engine. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> Request successful, but the result was empty. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The executed filter returned more than one single result or the extending query was invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call postExecuteFilterSingleResultCall(String id, Object body, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/filter/{id}/singleResult"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call postExecuteFilterSingleResultValidateBeforeCall(String id, Object body, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling postExecuteFilterSingleResult(Async)");
        }
        

        okhttp3.Call localVarCall = postExecuteFilterSingleResultCall(id, body, _callback);
        return localVarCall;

    }

    /**
     * Execute Filter Single Result (POST)
     * Executes the saved query of the filter by id and returns the single result. This method is slightly more powerful then the [Get Execute Filter Single Result](https://docs.camunda.org/manual/7.22/reference/rest/filter/get-execute-single-result/) method because it allows to extend the saved query of the filter.
     * @param id The id of the filter to execute. (required)
     * @param body A JSON object which corresponds to the type of the saved query of the filter, i.e., if the resource type of the filter is Task the body should form a valid task query corresponding to the Task resource. (optional)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object corresponding to the corresponding entity interface in the engine. This depends on the saved query in the filter. Therefore it is not possible specify a generic result format, i.e., if the resource type of the filter is Task the result will correspond to the Task interface in the engine. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> Request successful, but the result was empty. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The executed filter returned more than one single result or the extending query was invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public Object postExecuteFilterSingleResult(String id, Object body) throws ApiException {
        ApiResponse<Object> localVarResp = postExecuteFilterSingleResultWithHttpInfo(id, body);
        return localVarResp.getData();
    }

    /**
     * Execute Filter Single Result (POST)
     * Executes the saved query of the filter by id and returns the single result. This method is slightly more powerful then the [Get Execute Filter Single Result](https://docs.camunda.org/manual/7.22/reference/rest/filter/get-execute-single-result/) method because it allows to extend the saved query of the filter.
     * @param id The id of the filter to execute. (required)
     * @param body A JSON object which corresponds to the type of the saved query of the filter, i.e., if the resource type of the filter is Task the body should form a valid task query corresponding to the Task resource. (optional)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object corresponding to the corresponding entity interface in the engine. This depends on the saved query in the filter. Therefore it is not possible specify a generic result format, i.e., if the resource type of the filter is Task the result will correspond to the Task interface in the engine. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> Request successful, but the result was empty. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The executed filter returned more than one single result or the extending query was invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> postExecuteFilterSingleResultWithHttpInfo(String id, Object body) throws ApiException {
        okhttp3.Call localVarCall = postExecuteFilterSingleResultValidateBeforeCall(id, body, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Execute Filter Single Result (POST) (asynchronously)
     * Executes the saved query of the filter by id and returns the single result. This method is slightly more powerful then the [Get Execute Filter Single Result](https://docs.camunda.org/manual/7.22/reference/rest/filter/get-execute-single-result/) method because it allows to extend the saved query of the filter.
     * @param id The id of the filter to execute. (required)
     * @param body A JSON object which corresponds to the type of the saved query of the filter, i.e., if the resource type of the filter is Task the body should form a valid task query corresponding to the Task resource. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. A JSON object corresponding to the corresponding entity interface in the engine. This depends on the saved query in the filter. Therefore it is not possible specify a generic result format, i.e., if the resource type of the filter is Task the result will correspond to the Task interface in the engine. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> Request successful, but the result was empty. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  The executed filter returned more than one single result or the extending query was invalid. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to read this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call postExecuteFilterSingleResultAsync(String id, Object body, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = postExecuteFilterSingleResultValidateBeforeCall(id, body, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateFilter
     * @param id The id of the filter to be updated. (required)
     * @param createFilterDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Filter was invalid. See [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to update this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter cannot be found. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateFilterCall(String id, CreateFilterDto createFilterDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = createFilterDto;

        // create path and map variables
        String localVarPath = "/filter/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateFilterValidateBeforeCall(String id, CreateFilterDto createFilterDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateFilter(Async)");
        }
        

        okhttp3.Call localVarCall = updateFilterCall(id, createFilterDto, _callback);
        return localVarCall;

    }

    /**
     * Update Filter
     * Updates an existing filter.
     * @param id The id of the filter to be updated. (required)
     * @param createFilterDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Filter was invalid. See [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to update this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter cannot be found. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public void updateFilter(String id, CreateFilterDto createFilterDto) throws ApiException {
        updateFilterWithHttpInfo(id, createFilterDto);
    }

    /**
     * Update Filter
     * Updates an existing filter.
     * @param id The id of the filter to be updated. (required)
     * @param createFilterDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Filter was invalid. See [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to update this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter cannot be found. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateFilterWithHttpInfo(String id, CreateFilterDto createFilterDto) throws ApiException {
        okhttp3.Call localVarCall = updateFilterValidateBeforeCall(id, createFilterDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Update Filter (asynchronously)
     * Updates an existing filter.
     * @param id The id of the filter to be updated. (required)
     * @param createFilterDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Filter was invalid. See [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 403 </td><td>  The authenticated user is unauthorized to update this filter. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Filter cannot be found. See the [Introduction](https://docs.camunda.org/manual/7.22/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateFilterAsync(String id, CreateFilterDto createFilterDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateFilterValidateBeforeCall(id, createFilterDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
