/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.plugin.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.variable.serializer.AbstractObjectValueSerializer;
import org.camunda.spin.spi.DataFormat;
import org.camunda.spin.spi.DataFormatMapper;
import org.camunda.spin.spi.DataFormatReader;
import org.camunda.spin.spi.DataFormatWriter;

public class SpinObjectValueSerializer
extends AbstractObjectValueSerializer {
    protected String name;
    protected DataFormat<?> dataFormat;

    public SpinObjectValueSerializer(String name, DataFormat<?> dataFormat) {
        super(dataFormat.getName());
        this.name = name;
        this.dataFormat = dataFormat;
    }

    public String getName() {
        return this.name;
    }

    protected boolean isSerializationTextBased() {
        return true;
    }

    protected String getTypeNameForDeserialized(Object deserializedObject) {
        return this.dataFormat.getMapper().getCanonicalTypeName(deserializedObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] serializeToByteArray(Object deserializedObject) throws Exception {
        DataFormatMapper mapper = this.dataFormat.getMapper();
        DataFormatWriter writer = this.dataFormat.getWriter();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)out, Context.getProcessEngineConfiguration().getDefaultCharset());
        BufferedWriter bufferedWriter = new BufferedWriter(outWriter);
        try {
            Object mappedObject = mapper.mapJavaToInternal(deserializedObject);
            writer.writeToWriter((Writer)bufferedWriter, mappedObject);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            IoUtil.closeSilently((Closeable)out);
            IoUtil.closeSilently((Closeable)outWriter);
            IoUtil.closeSilently((Closeable)bufferedWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object deserializeFromByteArray(byte[] bytes, String objectTypeName) throws Exception {
        DataFormatMapper mapper = this.dataFormat.getMapper();
        DataFormatReader reader = this.dataFormat.getReader();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        InputStreamReader inReader = new InputStreamReader((InputStream)bais, Context.getProcessEngineConfiguration().getDefaultCharset());
        BufferedReader bufferedReader = new BufferedReader(inReader);
        try {
            Object mappedObject = reader.readInput((Reader)bufferedReader);
            Object object = mapper.mapInternalToJava(mappedObject, objectTypeName);
            return object;
        }
        finally {
            IoUtil.closeSilently((Closeable)bais);
            IoUtil.closeSilently((Closeable)inReader);
            IoUtil.closeSilently((Closeable)bufferedReader);
        }
    }

    protected boolean canSerializeObject(Object value) {
        return this.dataFormat.getMapper().canMap(value);
    }
}

