/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.benchmark;

import com.codahale.metrics.Snapshot;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import org.caffinitas.ohc.OHCache;
import org.caffinitas.ohc.benchmark.MergeableTimer;

final class Shared {
    private static final double NANOS_PER_MILLI = 1000000.0;
    static OHCache<Long, byte[]> cache;
    static final AtomicBoolean fatal;
    static MergeableTimer[] timers;
    static final ConcurrentHashMap<String, GCStats> gcStats;

    Shared() {
    }

    static void clearStats() {
        Shared.timers[0] = new MergeableTimer();
        Shared.timers[1] = new MergeableTimer();
        gcStats.clear();
        cache.resetStatistics();
    }

    static void printStats(String title, boolean bucketHistogram) {
        if (bucketHistogram) {
            System.out.printf("%s%n     %s%n   Histogram:%n%s%n", title, cache.stats(), cache.getBucketHistogram());
        } else {
            System.out.printf("%s%n     %s%n", title, cache.stats());
        }
        for (Map.Entry<String, GCStats> gcStat : gcStats.entrySet()) {
            GCStats gs = gcStat.getValue();
            long count = gs.count.longValue();
            long duration = gs.duration.longValue();
            double runtimeAvg = (double)duration / (double)count;
            System.out.printf("     GC  %-15s : count: %8d    duration: %8dms (avg:%6.2fms)    cores: %d%n", gcStat.getKey(), count, duration, runtimeAvg, gs.cores);
        }
        Shared.dumpStats(timers[0], "Reads");
        Shared.dumpStats(timers[1], "Writes");
    }

    private static void dumpStats(MergeableTimer timer, String header) {
        Snapshot snap = timer.histogram.getSnapshot();
        System.out.printf("     %-10s: one/five/fifteen/mean:  %.0f/%.0f/%.0f/%.0f%n                 count:                  %10d %n                 min/max/mean/stddev:    %8.5f/%8.5f/%8.5f/%8.5f%n                 75/95/98/99/999/median: %8.5f/%8.5f/%8.5f/%8.5f/%8.5f/%8.5f%n", header, timer.meter.getOneMinuteRate(), timer.meter.getFiveMinuteRate(), timer.meter.getFifteenMinuteRate(), timer.meter.getMeanRate(), timer.meter.getCount(), (double)snap.getMin() / 1000000.0, (double)snap.getMax() / 1000000.0, snap.getMean() / 1000000.0, snap.getStdDev() / 1000000.0, snap.get75thPercentile() / 1000000.0, snap.get95thPercentile() / 1000000.0, snap.get98thPercentile() / 1000000.0, snap.get99thPercentile() / 1000000.0, snap.get999thPercentile() / 1000000.0, snap.getMedian() / 1000000.0);
    }

    static {
        fatal = new AtomicBoolean();
        timers = new MergeableTimer[]{new MergeableTimer(), new MergeableTimer()};
        gcStats = new ConcurrentHashMap();
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        NotificationListener gcListener = new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                GCStats ex;
                CompositeDataSupport userData = (CompositeDataSupport)notification.getUserData();
                String gcName = (String)userData.get("gcName");
                CompositeDataSupport gcInfo = (CompositeDataSupport)userData.get("gcInfo");
                Long duration = (Long)gcInfo.get("duration");
                GCStats stats = gcStats.get(gcName);
                if (stats == null && (ex = gcStats.putIfAbsent(gcName, stats = new GCStats())) != null) {
                    stats = ex;
                }
                stats.count.incrementAndGet();
                stats.duration.addAndGet(duration);
                Number gcThreadCount = (Number)gcInfo.get("GcThreadCount");
                if (gcThreadCount != null && gcThreadCount.intValue() > stats.cores) {
                    stats.cores = gcThreadCount.intValue();
                }
            }
        };
        try {
            for (ObjectInstance inst : mbeanServer.queryMBeans(ObjectName.getInstance("java.lang:type=GarbageCollector,name=*"), null)) {
                mbeanServer.addNotificationListener(inst.getObjectName(), gcListener, null, null);
            }
        }
        catch (InstanceNotFoundException | MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    static final class GCStats {
        final AtomicLong count = new AtomicLong();
        final AtomicLong duration = new AtomicLong();
        int cores;

        GCStats() {
        }
    }
}

