/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.bombe.analysis;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cadixdev.bombe.analysis.InheritanceProvider;
import org.cadixdev.bombe.analysis.InheritanceType;
import org.cadixdev.bombe.type.signature.FieldSignature;
import org.cadixdev.bombe.type.signature.MethodSignature;

public class ReflectionInheritanceProvider
implements InheritanceProvider {
    private final ClassLoader classLoader;

    public ReflectionInheritanceProvider(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Optional<InheritanceProvider.ClassInfo> provide(String klass) {
        try {
            return Optional.of(this.provide(Class.forName(klass.replace('/', '.'), false, this.classLoader)));
        }
        catch (ClassNotFoundException ex) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<InheritanceProvider.ClassInfo> provide(String klass, Object context) {
        if (context instanceof Class) {
            return Optional.of(this.provide((Class)context));
        }
        return this.provide(klass);
    }

    public InheritanceProvider.ClassInfo provide(Class<?> clazz) {
        return new ReflectionClassInfo(clazz).lazy();
    }

    private static class ReflectionClassInfo
    extends InheritanceProvider.ClassInfo.Abstract {
        private final Class<?> clazz;

        private ReflectionClassInfo(Class<?> clazz) {
            this.clazz = clazz;
        }

        private static String getInternalName(Class<?> clazz) {
            return clazz.getName().replace('.', '/');
        }

        @Override
        public String getName() {
            return ReflectionClassInfo.getInternalName(this.clazz);
        }

        @Override
        public boolean isInterface() {
            return this.clazz.isInterface();
        }

        @Override
        public String getSuperName() {
            Class<?> superClass = this.clazz.getSuperclass();
            return superClass != null ? ReflectionClassInfo.getInternalName(superClass) : "";
        }

        @Override
        public List<String> getInterfaces() {
            return Collections.unmodifiableList(Arrays.stream(this.clazz.getInterfaces()).map(ReflectionClassInfo::getInternalName).collect(Collectors.toList()));
        }

        @Override
        public Map<FieldSignature, InheritanceType> getFields() {
            return Collections.unmodifiableMap(Arrays.stream(this.clazz.getDeclaredFields()).collect(Collectors.toMap(FieldSignature::of, f -> InheritanceType.fromModifiers(f.getModifiers()))));
        }

        @Override
        public Map<String, InheritanceType> getFieldsByName() {
            return Collections.unmodifiableMap(Arrays.stream(this.clazz.getDeclaredFields()).collect(Collectors.toMap(Field::getName, f -> InheritanceType.fromModifiers(f.getModifiers()))));
        }

        @Override
        public Map<MethodSignature, InheritanceType> getMethods() {
            return Collections.unmodifiableMap(Arrays.stream(this.clazz.getDeclaredMethods()).collect(Collectors.toMap(MethodSignature::of, m -> InheritanceType.fromModifiers(m.getModifiers()))));
        }

        private void provideParent(InheritanceProvider provider, Class<?> parent, Collection<InheritanceProvider.ClassInfo> parents) {
            if (parent == null) {
                return;
            }
            InheritanceProvider.ClassInfo parentInfo = provider.provide(ReflectionClassInfo.getInternalName(parent), parent).orElse(null);
            if (parentInfo != null) {
                parentInfo.provideParents(provider, parents);
                parents.add(parentInfo);
            }
        }

        @Override
        public void provideParents(InheritanceProvider provider, Collection<InheritanceProvider.ClassInfo> parents) {
            this.provideParent(provider, this.clazz.getSuperclass(), parents);
            for (Class<?> iface : this.clazz.getInterfaces()) {
                this.provideParent(provider, iface, parents);
            }
        }
    }
}

