/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.extra.spring;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.cache2k.CacheManager;
import org.cache2k.annotation.NonNull;
import org.cache2k.extra.spring.SpringCache2kCache;
import org.cache2k.extra.spring.SpringLoadingCache2kCache;
import org.cache2k.operation.CacheControl;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.Assert;

public class SpringCache2kCacheManager
implements org.springframework.cache.CacheManager,
DisposableBean {
    public static final String DEFAULT_SPRING_CACHE_MANAGER_NAME = "springDefault";
    private final CacheManager manager;
    private final Map<String, SpringCache2kCache> name2cache = new ConcurrentHashMap<String, SpringCache2kCache>();
    private final Set<String> configuredCacheNames = new CopyOnWriteArraySet<String>();
    private boolean allowUnknownCache = true;
    private static final Function<Cache2kBuilder<?, ?>, Cache2kBuilder<?, ?>> DUMMY_DEFAULT = b -> b;
    private Function<Cache2kBuilder<?, ?>, Cache2kBuilder<?, ?>> defaultSetup = DUMMY_DEFAULT;

    public SpringCache2kCacheManager() {
        this(DEFAULT_SPRING_CACHE_MANAGER_NAME);
    }

    public SpringCache2kCacheManager(String name) {
        this(CacheManager.getInstance((String)name));
    }

    public SpringCache2kCacheManager(CacheManager manager) {
        this.manager = manager;
        manager.getConfiguredCacheNames().forEach(this.configuredCacheNames::add);
    }

    @NonNull
    public SpringCache2kCache getCache(String name) {
        return this.name2cache.computeIfAbsent(name, n -> {
            if (!this.allowUnknownCache && !this.configuredCacheNames.contains(n)) {
                return null;
            }
            return this.buildAndWrap(this.defaultSetup.apply(this.getDefaultBuilder()).name(n));
        });
    }

    public SpringCache2kCacheManager defaultSetup(Function<Cache2kBuilder<?, ?>, Cache2kBuilder<?, ?>> f) {
        if (this.defaultSetup != DUMMY_DEFAULT) {
            throw new IllegalStateException("Defaults already set");
        }
        if (!this.name2cache.isEmpty()) {
            throw new IllegalStateException("Defaults may only be set before the first cache is added");
        }
        this.defaultSetup = f;
        return this;
    }

    @SafeVarargs
    public final SpringCache2kCacheManager addCaches(Function<Cache2kBuilder<?, ?>, Cache2kBuilder<?, ?>> ... fs) {
        for (Function<Cache2kBuilder<?, ?>, Cache2kBuilder<?, ?>> f : fs) {
            this.addCache(f);
        }
        return this;
    }

    public SpringCache2kCacheManager addCache(Function<Cache2kBuilder<?, ?>, Cache2kBuilder<?, ?>> f) {
        this.buildAndAddCache(f.apply(this.defaultSetup.apply(this.getDefaultBuilder())));
        return this;
    }

    public SpringCache2kCacheManager addCache(String name, Function<Cache2kBuilder<?, ?>, Cache2kBuilder<?, ?>> f) {
        this.buildAndAddCache(f.apply(this.defaultSetup.apply(this.getDefaultBuilder()).name(name)));
        return this;
    }

    private void buildAndAddCache(Cache2kBuilder<?, ?> builder) {
        String name = builder.config().getName();
        Assert.notNull((Object)name, (String)"Name must be set via Cache2kBuilder.name()");
        Assert.isTrue((builder.getManager() == this.manager ? 1 : 0) != 0, (String)"Manager must be identical in builder.");
        this.configuredCacheNames.add(name);
        this.name2cache.compute(name, (name2, existingCache) -> {
            if (existingCache != null) {
                throw new IllegalStateException("Cache already configured");
            }
            return this.buildAndWrap(builder);
        });
    }

    public SpringCache2kCacheManager setDefaultCacheNames(String ... names) {
        return this.setDefaultCacheNames(Arrays.asList(names));
    }

    public SpringCache2kCacheManager setDefaultCacheNames(Collection<String> names) {
        for (String name : names) {
            this.addCache(b -> b.name(name));
        }
        this.allowUnknownCache = false;
        return this;
    }

    public Collection<String> getCacheNames() {
        HashSet<String> cacheNames = new HashSet<String>();
        for (Cache cache : this.manager.getActiveCaches()) {
            cacheNames.add(cache.getName());
        }
        cacheNames.addAll(this.configuredCacheNames);
        return Collections.unmodifiableSet(cacheNames);
    }

    public Collection<String> getConfiguredCacheNames() {
        return Collections.unmodifiableSet(this.configuredCacheNames);
    }

    public CacheManager getNativeCacheManager() {
        return this.manager;
    }

    public Map<String, SpringCache2kCache> getCacheMap() {
        return Collections.unmodifiableMap(this.name2cache);
    }

    public boolean isAllowUnknownCache() {
        return this.allowUnknownCache;
    }

    public void setAllowUnknownCache(boolean v) {
        this.allowUnknownCache = v;
    }

    private Cache2kBuilder<?, ?> getDefaultBuilder() {
        Cache2kBuilder b = Cache2kBuilder.forUnknownTypes();
        b.manager(this.manager);
        SpringCache2kCacheManager.springDefaults(b);
        return b;
    }

    private SpringCache2kCache buildAndWrap(Cache2kBuilder<?, ?> builder) {
        Cache nativeCache = builder.build();
        return CacheControl.of((Cache)nativeCache).isLoaderPresent() ? new SpringLoadingCache2kCache((Cache<Object, Object>)nativeCache) : new SpringCache2kCache((Cache<Object, Object>)nativeCache);
    }

    public void destroy() {
        this.manager.close();
        this.name2cache.clear();
    }

    public static void springDefaults(Cache2kBuilder<?, ?> builder) {
        builder.permitNullValues(true);
    }
}

