/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.xmlConfiguration.generic;

import java.util.HashMap;
import java.util.Map;
import org.cache2k.impl.xmlConfiguration.generic.ConfigurationException;
import org.cache2k.impl.xmlConfiguration.generic.ConfigurationTokenizer;
import org.cache2k.impl.xmlConfiguration.generic.ParsedConfiguration;
import org.cache2k.impl.xmlConfiguration.generic.VariableExpander;

public class StandardVariableExpander
implements VariableExpander {
    private final Map<String, VariableExpander.ValueAccessor> scope2resolver = new HashMap<String, VariableExpander.ValueAccessor>();
    private static final String PROPERTIES = "PROPERTIES";

    public StandardVariableExpander() {
        this.scope2resolver.put("env", new VariableExpander.ValueAccessor(){

            @Override
            public String get(VariableExpander.ExpanderContext ctx, String variable) {
                return System.getenv(variable);
            }
        });
        this.scope2resolver.put("sys", new VariableExpander.ValueAccessor(){

            @Override
            public String get(VariableExpander.ExpanderContext ctx, String variable) {
                return System.getProperty(variable);
            }
        });
        this.scope2resolver.put("top", new VariableExpander.ValueAccessor(){

            @Override
            public String get(VariableExpander.ExpanderContext ctx, String variable) {
                ConfigurationTokenizer.Property p = ctx.getTopLevelConfiguration().getPropertyByPath(variable);
                return StandardVariableExpander.this.checkAndReturnValue(p);
            }
        });
        this.scope2resolver.put("", new VariableExpander.ValueAccessor(){

            @Override
            public String get(VariableExpander.ExpanderContext ctx, String variable) {
                ConfigurationTokenizer.Property p = ctx.getCurrentConfiguration().getPropertyByPath(variable);
                return StandardVariableExpander.this.checkAndReturnValue(p);
            }
        });
        this.scope2resolver.put(PROPERTIES, new VariableExpander.ValueAccessor(){

            @Override
            public String get(VariableExpander.ExpanderContext ctx, String variable) {
                ParsedConfiguration pc = ctx.getTopLevelConfiguration().getSection("properties");
                if (pc == null) {
                    return null;
                }
                ConfigurationTokenizer.Property p = pc.getPropertyMap().get(variable);
                return StandardVariableExpander.this.checkAndReturnValue(p);
            }
        });
    }

    @Override
    public void expand(ParsedConfiguration cfg) {
        new Process(cfg, new HashMap<String, VariableExpander.ValueAccessor>(this.scope2resolver)).expand();
    }

    private String checkAndReturnValue(ConfigurationTokenizer.Property p) {
        if (p == null) {
            return null;
        }
        if (!p.isExpanded()) {
            throw new VariableExpander.NeedsExpansion();
        }
        return p.getValue();
    }

    private static class Process
    implements VariableExpander.ExpanderContext {
        private final Map<String, VariableExpander.ValueAccessor> scope2resolver;
        private final ParsedConfiguration top;
        private ParsedConfiguration current;
        private int forwardReference = 0;
        private ConfigurationTokenizer.Property lastTroublemaker;

        Process(ParsedConfiguration top, Map<String, VariableExpander.ValueAccessor> scope2resolver) {
            this.top = top;
            this.scope2resolver = scope2resolver;
        }

        private void expand() {
            do {
                int lastCounter = this.forwardReference;
                this.forwardReference = 0;
                this.recurse(this.top);
                if (lastCounter <= 0 || lastCounter != this.forwardReference) continue;
                throw new ConfigurationException("Cyclic reference", this.lastTroublemaker);
            } while (this.forwardReference > 0);
        }

        private void recurse(ParsedConfiguration cfg) {
            this.current = cfg;
            for (ConfigurationTokenizer.Property p : cfg.getPropertyMap().values()) {
                if (p.isExpanded()) continue;
                String v0 = p.getValue();
                try {
                    String v = this.expand(v0);
                    if (v0 != v) {
                        p.setValue(v);
                    }
                    p.setExpanded(true);
                }
                catch (VariableExpander.NeedsExpansion ex) {
                    ++this.forwardReference;
                    this.lastTroublemaker = p;
                }
            }
            for (ParsedConfiguration c2 : cfg.getSections()) {
                String context = c2.getPropertyContext();
                VariableExpander.ValueAccessor savedAccessor = null;
                if (context != null) {
                    savedAccessor = this.scope2resolver.get(context);
                    final ParsedConfiguration localScope = c2;
                    this.scope2resolver.put(context, new VariableExpander.ValueAccessor(){

                        @Override
                        public String get(VariableExpander.ExpanderContext ctx, String variable) {
                            return localScope.getStringPropertyByPath(variable);
                        }
                    });
                }
                this.recurse(c2);
                if (savedAccessor == null) continue;
                this.scope2resolver.put(context, savedAccessor);
            }
        }

        @Override
        public ParsedConfiguration getCurrentConfiguration() {
            return this.current;
        }

        @Override
        public ParsedConfiguration getTopLevelConfiguration() {
            return this.top;
        }

        private String expand(String s) {
            int idx = 0;
            while (true) {
                int endIdx;
                block9: {
                    String substitutionString;
                    block10: {
                        String scope;
                        if ((idx = s.indexOf("${", idx)) < 0) {
                            return s;
                        }
                        endIdx = s.indexOf(125, idx);
                        if (endIdx < 0) {
                            return s;
                        }
                        int scopeIdx = s.indexOf(46, idx);
                        if (scopeIdx >= 0) {
                            scope = s.substring(idx + 2, scopeIdx);
                        } else {
                            scope = StandardVariableExpander.PROPERTIES;
                            scopeIdx = idx + 1;
                        }
                        int defaultIdx = s.indexOf(":-", idx);
                        int varEndIdx = endIdx;
                        String defaultValue = null;
                        if (defaultIdx >= 0 && defaultIdx < endIdx) {
                            defaultValue = s.substring(defaultIdx + 2, endIdx);
                            varEndIdx = defaultIdx;
                        }
                        String varName = s.substring(scopeIdx + 1, varEndIdx);
                        VariableExpander.ValueAccessor r = this.scope2resolver.get(scope);
                        if (r == null) break block9;
                        substitutionString = r.get(this, varName);
                        if (substitutionString != null) break block10;
                        if (defaultValue == null) break block9;
                        substitutionString = defaultValue;
                    }
                    s = s.substring(0, idx) + substitutionString + s.substring(endIdx + 1);
                    endIdx = idx + substitutionString.length();
                }
                idx = endIdx;
            }
        }
    }
}

