/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.xmlConfiguration.generic;

import org.cache2k.impl.xmlConfiguration.generic.ConfigurationTokenizer;

public abstract class AbstractConfigurationTokenizer
implements ConfigurationTokenizer {
    private final String source;

    public AbstractConfigurationTokenizer(String source) {
        this.source = source;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    protected final ConfigurationTokenizer.Nest returnNest(String sectionName) {
        return new MyNest(this.getSource(), this.getLineNumber(), sectionName);
    }

    protected final ConfigurationTokenizer.Unnest returnUnnest() {
        return new MyUnnest(this.getSource(), this.getLineNumber());
    }

    protected final ConfigurationTokenizer.Property returnProperty(String name, String property) {
        return new MyProperty(this.getSource(), this.getLineNumber(), name, property);
    }

    private static class MyProperty
    extends MyItem
    implements ConfigurationTokenizer.Property {
        private final String name;
        private String value;
        private boolean expanded;

        MyProperty(String source, int lineNumber, String name, String value) {
            super(source, lineNumber);
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String v) {
            this.value = v;
        }

        @Override
        public boolean isExpanded() {
            return this.expanded;
        }

        @Override
        public void setExpanded(boolean v) {
            this.expanded = v;
        }

        public String toString() {
            return "Property{name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }

    private static class MyUnnest
    extends MyItem
    implements ConfigurationTokenizer.Unnest {
        MyUnnest(String source, int lineNumber) {
            super(source, lineNumber);
        }

        public String toString() {
            return "Unnest";
        }
    }

    private static class MyNest
    extends MyItem
    implements ConfigurationTokenizer.Nest {
        private final String sectionName;

        MyNest(String source, int lineNumber, String sectionName) {
            super(source, lineNumber);
            this.sectionName = sectionName;
        }

        @Override
        public String getSectionName() {
            return this.sectionName;
        }

        public String toString() {
            return "Nest{sectionName='" + this.sectionName + '\'' + '}';
        }
    }

    private static class MyItem
    implements ConfigurationTokenizer.Item {
        private final String source;
        private final int lineNumber;

        MyItem(String source, int lineNumber) {
            this.lineNumber = lineNumber;
            this.source = source;
        }

        @Override
        public String getSource() {
            return this.source;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

