/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.cache2k.core.CacheInternalError;
import org.cache2k.core.util.Log;
import org.cache2k.core.util.TunableConstants;

public final class TunableFactory {
    static Log log = Log.getLog(TunableFactory.class);
    public static final String DEFAULT_TUNING_GRAALVM_FILE_NAME = "/org/cache2k/default-tuning-graalvm-nativeimage.properties";
    public static final String DEFAULT_TUNING_FILE_NAME = "/org/cache2k/default-tuning.properties";
    public static final String CUSTOM_TUNING_FILE_NAME = "/org/cache2k/tuning.properties";
    public static final String TUNE_MARKER = "org.cache2k.tuning";
    private static Map<Class<?>, Object> map;
    private static Properties defaultProperties;
    private static Properties customProperties;

    private static boolean isGraalVMNativeImage() {
        return System.getProperty("org.graalvm.nativeimage.kind") != null;
    }

    private static void load() {
        map = new HashMap();
        customProperties = TunableFactory.loadFile(CUSTOM_TUNING_FILE_NAME);
        if (TunableFactory.isGraalVMNativeImage()) {
            defaultProperties = TunableFactory.loadFile(DEFAULT_TUNING_GRAALVM_FILE_NAME);
        }
        if (defaultProperties == null) {
            defaultProperties = TunableFactory.loadFile(DEFAULT_TUNING_FILE_NAME);
        }
    }

    static Properties loadFile(String fileName) {
        InputStream in = TunableConstants.class.getResourceAsStream(fileName);
        if (in != null) {
            try {
                Properties p = new Properties();
                p.load(in);
                in.close();
                return p;
            }
            catch (IOException ex) {
                throw new CacheInternalError("tuning properties not readable", ex);
            }
        }
        return null;
    }

    public static synchronized <T extends TunableConstants> T get(Properties p, Class<T> c) {
        Object cfg = TunableFactory.getDefault(c);
        if (p != null && p.containsKey(TUNE_MARKER) && p.containsKey(cfg.getClass().getName() + ".tuning")) {
            cfg = (TunableConstants)((TunableConstants)cfg).clone();
            TunableFactory.apply(p, cfg);
        }
        return cfg;
    }

    public static synchronized <T extends TunableConstants> T get(Class<T> c) {
        return TunableFactory.getDefault(c);
    }

    private static <T extends TunableConstants> T getDefault(Class<T> c) {
        TunableConstants cfg;
        if (map == null) {
            TunableFactory.load();
        }
        if ((cfg = (TunableConstants)map.get(c)) == null) {
            try {
                cfg = (TunableConstants)c.newInstance();
            }
            catch (Exception ex) {
                throw new CacheInternalError("cannot instantiate tunable constants", ex);
            }
            TunableFactory.apply(defaultProperties, cfg);
            TunableFactory.apply(customProperties, cfg);
            TunableFactory.apply(System.getProperties(), cfg);
            map.put(c, cfg);
        }
        return (T)cfg;
    }

    static void apply(Properties p, Object cfg) {
        if (p == null) {
            return;
        }
        String propName = null;
        try {
            for (Field f : cfg.getClass().getFields()) {
                propName = cfg.getClass().getName().replace('$', '.') + "." + f.getName();
                String o = p.getProperty(propName);
                if (o == null) continue;
                Class<?> fieldType = f.getType();
                if (fieldType == Boolean.TYPE) {
                    if ("off".equals(o = o.toLowerCase()) || "false".equals(o) || "disable".equals(o)) {
                        f.set(cfg, false);
                    } else {
                        f.set(cfg, true);
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug(propName + "=" + f.get(cfg));
                    continue;
                }
                if (fieldType == Integer.TYPE) {
                    f.set(cfg, Integer.valueOf(o));
                    if (!log.isDebugEnabled()) continue;
                    log.debug(propName + "=" + f.get(cfg));
                    continue;
                }
                if (fieldType == Long.TYPE) {
                    f.set(cfg, Long.valueOf(o));
                    if (!log.isDebugEnabled()) continue;
                    log.debug(propName + "=" + f.get(cfg));
                    continue;
                }
                if (fieldType == String.class) {
                    f.set(cfg, o);
                    if (!log.isDebugEnabled()) continue;
                    log.debug(propName + "=" + f.get(cfg));
                    continue;
                }
                if (fieldType == Class.class) {
                    Class<?> c = Class.forName(o);
                    f.set(cfg, c);
                    if (!log.isDebugEnabled()) continue;
                    log.debug(propName + "=" + c.getName());
                    continue;
                }
                throw new CacheInternalError("Unsupported field type. Tunable: " + propName + ", " + fieldType);
            }
        }
        catch (Exception ex) {
            if (propName != null) {
                throw new CacheInternalError("error applying tuning setup, property=" + propName, ex);
            }
            throw new CacheInternalError("error applying tuning setup", ex);
        }
    }
}

