/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.timing;

import org.cache2k.core.CacheClosedException;
import org.cache2k.core.Entry;
import org.cache2k.core.timing.TimerEventListener;
import org.cache2k.core.timing.TimerTask;

abstract class Tasks<K, V>
extends TimerTask {
    private Entry<K, V> entry;
    private TimerEventListener<K, V> target;

    Tasks() {
    }

    Tasks<K, V> to(TimerEventListener<K, V> target, Entry<K, V> e) {
        this.target = target;
        this.entry = e;
        return this;
    }

    @Override
    protected boolean cancel() {
        if (super.cancel()) {
            this.target = null;
            this.entry = null;
            return true;
        }
        return false;
    }

    protected TimerEventListener<K, V> getTarget() {
        return this.target;
    }

    protected Entry<K, V> getEntry() {
        return this.entry;
    }

    public abstract void fire();

    @Override
    protected final void action() {
        try {
            this.fire();
        }
        catch (CacheClosedException cacheClosedException) {
            // empty catch block
        }
    }

    static class RefreshExpireTimerTask<K, V>
    extends Tasks<K, V> {
        RefreshExpireTimerTask() {
        }

        @Override
        public void fire() {
            this.getTarget().timerEventProbationTerminated(this.getEntry(), this);
        }
    }

    static class ExpireTimerTask<K, V>
    extends Tasks<K, V> {
        ExpireTimerTask() {
        }

        @Override
        public void fire() {
            this.getTarget().timerEventExpireEntry(this.getEntry(), this);
        }
    }

    static class RefreshTimerTask<K, V>
    extends Tasks<K, V> {
        RefreshTimerTask() {
        }

        @Override
        public void fire() {
            this.getTarget().timerEventRefresh(this.getEntry(), this);
        }
    }
}

