/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.timing;

import org.cache2k.CacheEntry;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.core.CacheBuildContext;
import org.cache2k.core.CacheCloseContext;
import org.cache2k.core.Entry;
import org.cache2k.core.timing.StaticTiming;
import org.cache2k.expiry.ExpiryPolicy;
import org.cache2k.expiry.ValueWithExpiryTime;

class DynamicTiming<K, V>
extends StaticTiming<K, V> {
    private final ExpiryPolicy<K, V> expiryPolicy;

    DynamicTiming(CacheBuildContext<K, V> buildContext) {
        super(buildContext);
        this.expiryPolicy = DynamicTiming.constructPolicy(buildContext);
    }

    private static <K, V> ExpiryPolicy<K, V> constructPolicy(CacheBuildContext<K, V> buildContext) {
        Cache2kConfiguration<K, V> cfg = buildContext.getConfiguration();
        if (cfg.getValueType() != null && ValueWithExpiryTime.class.isAssignableFrom(cfg.getValueType().getType()) && cfg.getExpiryPolicy() == null) {
            return ENTRY_EXPIRY_CALCULATOR_FROM_VALUE;
        }
        return buildContext.createCustomization(cfg.getExpiryPolicy());
    }

    long calcNextRefreshTime(K key, V newObject, long now, CacheEntry<K, V> entry) {
        return DynamicTiming.calcNextRefreshTime(key, newObject, now, entry, this.expiryPolicy, this.expiryMillis, this.sharpExpiry);
    }

    @Override
    public long calculateNextRefreshTime(Entry<K, V> entry, V newValue, long loadTime) {
        if (entry.isDataAvailable() || entry.isExpiredState() || entry.getNextRefreshTime() == 5L) {
            return this.calcNextRefreshTime(entry.getKey(), newValue, loadTime, entry.getTempCacheEntry());
        }
        return this.calcNextRefreshTime(entry.getKey(), newValue, loadTime, null);
    }

    @Override
    public synchronized void close(CacheCloseContext closeContext) {
        super.cancelAll();
        closeContext.closeCustomization(this.expiryPolicy, "expiryPolicy");
    }
}

