/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.eviction;

import org.cache2k.Weigher;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.core.CacheBuildContext;
import org.cache2k.core.HeapCache;
import org.cache2k.core.HeapCacheListener;
import org.cache2k.core.SegmentedEviction;
import org.cache2k.core.eviction.ClockProPlusEviction;
import org.cache2k.core.eviction.Eviction;
import org.cache2k.core.eviction.HeapCacheForEviction;

public class EvictionFactory {
    public Eviction constructEviction(CacheBuildContext customizationContext, HeapCacheForEviction hc, HeapCacheListener l, Cache2kConfiguration config, int availableProcessors) {
        boolean strictEviction = config.isStrictEviction();
        boolean boostConcurrency = config.isBoostConcurrency();
        long maximumWeight = config.getMaximumWeight();
        long entryCapacity = config.getEntryCapacity();
        Weigher weigher = customizationContext.createCustomization(config.getWeigher());
        if (weigher != null) {
            if (maximumWeight <= 0L) {
                throw new IllegalArgumentException("maximumWeight > 0 expected. Weigher requires to set maximumWeight");
            }
            entryCapacity = -1L;
        } else {
            if (entryCapacity < 0L) {
                entryCapacity = 2000L;
            }
            if (entryCapacity == 0L) {
                throw new IllegalArgumentException("entryCapacity of 0 is not supported.");
            }
        }
        int segmentCountOverride = HeapCache.TUNABLE.segmentCountOverride;
        int segmentCount = EvictionFactory.determineSegmentCount(strictEviction, availableProcessors, boostConcurrency, entryCapacity, maximumWeight, segmentCountOverride);
        Eviction[] segments = new Eviction[segmentCount];
        long maxSize = EvictionFactory.determineMaxSize(entryCapacity, segmentCount);
        long maxWeight = EvictionFactory.determineMaxWeight(maximumWeight, segmentCount);
        for (int i = 0; i < segments.length; ++i) {
            ClockProPlusEviction ev = new ClockProPlusEviction(hc, l, maxSize, weigher, maxWeight, strictEviction);
            segments[i] = ev;
        }
        if (segmentCount == 1) {
            return segments[0];
        }
        return new SegmentedEviction(segments);
    }

    public static long determineMaxSize(long entryCapacity, int segmentCount) {
        if (entryCapacity < 0L) {
            return -1L;
        }
        if (entryCapacity == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        long maxSize = entryCapacity / (long)segmentCount;
        if (entryCapacity % (long)segmentCount > 0L) {
            ++maxSize;
        }
        return maxSize;
    }

    public static long determineMaxWeight(long maximumWeight, int segmentCount) {
        if (maximumWeight < 0L) {
            return -1L;
        }
        long maxWeight = maximumWeight / (long)segmentCount;
        if (maximumWeight == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        if (maximumWeight % (long)segmentCount > 0L) {
            ++maxWeight;
        }
        return maxWeight;
    }

    public static int determineSegmentCount(boolean strictEviction, int availableProcessors, boolean boostConcurrency, long entryCapacity, long maxWeight, int segmentCountOverride) {
        if (strictEviction) {
            return 1;
        }
        if (entryCapacity >= 0L && entryCapacity < 1000L) {
            return 1;
        }
        if (maxWeight >= 0L && maxWeight < 1000L) {
            return 1;
        }
        int segmentCount = 1;
        if (availableProcessors > 1) {
            segmentCount = 2;
            if (boostConcurrency) {
                segmentCount = 2 << 31 - Integer.numberOfLeadingZeros(availableProcessors);
            }
        }
        if (segmentCountOverride > 0) {
            segmentCount = 1 << 32 - Integer.numberOfLeadingZeros(segmentCountOverride - 1);
        } else {
            int maxSegments = availableProcessors * 2;
            segmentCount = Math.min(segmentCount, maxSegments);
        }
        return segmentCount;
    }
}

