/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.Raw;

public class ByteRawIndexer
extends ByteIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected BytePointer pointer;
    final long base;
    final long size;

    public ByteRawIndexer(BytePointer pointer) {
        this(pointer, new long[]{pointer.limit() - pointer.position()}, ONE_STRIDE);
    }

    public ByteRawIndexer(BytePointer pointer, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.pointer = pointer;
        this.base = pointer.address() + pointer.position();
        this.size = pointer.limit() - pointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    @Override
    public byte get(long i) {
        return RAW.getByte(this.base + ByteRawIndexer.checkIndex(i, this.size));
    }

    @Override
    public ByteIndexer get(long i, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.get(i * this.strides[0] + (long)n);
        }
        return this;
    }

    @Override
    public byte get(long i, long j) {
        return this.get(i * this.strides[0] + (long)((int)j));
    }

    @Override
    public ByteIndexer get(long i, long j, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.get(i * this.strides[0] + j * this.strides[1] + (long)n);
        }
        return this;
    }

    @Override
    public byte get(long i, long j, long k) {
        return this.get(i * this.strides[0] + j * this.strides[1] + k);
    }

    @Override
    public byte get(long ... indices) {
        return this.get(this.index(indices));
    }

    @Override
    public ByteIndexer get(long[] indices, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.get(this.index(indices) + (long)n);
        }
        return this;
    }

    @Override
    public ByteIndexer put(long i, byte b) {
        RAW.putByte(this.base + ByteRawIndexer.checkIndex(i, this.size), b);
        return this;
    }

    @Override
    public ByteIndexer put(long i, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + (long)n, b[offset + n]);
        }
        return this;
    }

    @Override
    public ByteIndexer put(long i, long j, byte b) {
        this.put(i * this.strides[0] + j, b);
        return this;
    }

    @Override
    public ByteIndexer put(long i, long j, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + j * this.strides[1] + (long)n, b[offset + n]);
        }
        return this;
    }

    @Override
    public ByteIndexer put(long i, long j, long k, byte b) {
        this.put(i * this.strides[0] + j * this.strides[1] + k, b);
        return this;
    }

    @Override
    public ByteIndexer put(long[] indices, byte b) {
        this.put(this.index(indices), b);
        return this;
    }

    @Override
    public ByteIndexer put(long[] indices, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(this.index(indices) + (long)n, b[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

