/*
 * Decompiled with CFR 0.152.
 */
package hdf.hdf5lib;

import hdf.hdf5lib.ArrayDescriptor;
import hdf.hdf5lib.HDFNativeData;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import java.lang.reflect.Array;
import java.util.Arrays;

public class HDFArray {
    private Object _theArray = null;
    private ArrayDescriptor _desc = null;
    private byte[] _barray = null;

    public HDFArray(Object anArray) throws HDF5JavaException {
        Class<?> tc;
        if (anArray == null) {
            HDF5JavaException hDF5JavaException = new HDF5JavaException("HDFArray: array is null?: ");
        }
        if (!(tc = anArray.getClass()).isArray()) {
            HDF5JavaException ex = new HDF5JavaException("HDFArray: not an array?: ");
            throw ex;
        }
        this._theArray = anArray;
        this._desc = new ArrayDescriptor(this._theArray);
        if (this._desc == null) {
            HDF5JavaException ex = new HDF5JavaException("HDFArray: internal error: array description failed?: ");
            throw ex;
        }
    }

    public byte[] emptyBytes() throws HDF5JavaException {
        byte[] b = null;
        b = ArrayDescriptor.dims == 1 && ArrayDescriptor.NT == 'B' ? (byte[])this._theArray : new byte[ArrayDescriptor.totalSize];
        if (b == null) {
            HDF5JavaException ex = new HDF5JavaException("HDFArray: emptyBytes: allocation failed");
            throw ex;
        }
        return b;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] byteify() throws HDF5JavaException {
        int i;
        if (this._barray != null) {
            return this._barray;
        }
        if (this._theArray == null) {
            HDF5JavaException ex = new HDF5JavaException("HDFArray: byteify not an array?: ");
            throw ex;
        }
        if (ArrayDescriptor.dims == 1) {
            if (ArrayDescriptor.NT == 'B') {
                this._barray = (byte[])this._theArray;
                return this._barray;
            }
            try {
                byte[] therow;
                this._barray = new byte[ArrayDescriptor.totalSize];
                if (ArrayDescriptor.NT == 'I') {
                    therow = HDFNativeData.intToByte(0, ArrayDescriptor.dimlen[1], (int[])this._theArray);
                } else if (ArrayDescriptor.NT == 'S') {
                    therow = HDFNativeData.shortToByte(0, ArrayDescriptor.dimlen[1], (short[])this._theArray);
                } else if (ArrayDescriptor.NT == 'F') {
                    therow = HDFNativeData.floatToByte(0, ArrayDescriptor.dimlen[1], (float[])this._theArray);
                } else if (ArrayDescriptor.NT == 'J') {
                    therow = HDFNativeData.longToByte(0, ArrayDescriptor.dimlen[1], (long[])this._theArray);
                } else if (ArrayDescriptor.NT == 'D') {
                    therow = HDFNativeData.doubleToByte(0, ArrayDescriptor.dimlen[1], (double[])this._theArray);
                } else {
                    if (ArrayDescriptor.NT != 'L') {
                        HDF5JavaException ex = new HDF5JavaException("HDFArray: unknown type of data?");
                        throw ex;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        therow = this.ByteObjToByte((Byte[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        therow = this.IntegerToByte((Integer[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        therow = this.ShortToByte((Short[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        therow = this.FloatObjToByte((Float[])this._theArray);
                    } else if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        therow = this.DoubleObjToByte((Double[])this._theArray);
                    } else {
                        if (!ArrayDescriptor.className.equals("java.lang.Long")) {
                            HDF5JavaException ex = new HDF5JavaException("HDFArray: unknown type of Object?");
                            throw ex;
                        }
                        therow = this.LongObjToByte((Long[])this._theArray);
                    }
                }
                System.arraycopy(therow, 0, this._barray, 0, ArrayDescriptor.dimlen[1] * ArrayDescriptor.NTsize);
                return this._barray;
            }
            catch (OutOfMemoryError err) {
                HDF5JavaException ex = new HDF5JavaException("HDFArray: byteify array too big?");
                throw ex;
            }
        }
        try {
            this._barray = new byte[ArrayDescriptor.totalSize];
        }
        catch (OutOfMemoryError err) {
            HDF5JavaException ex = new HDF5JavaException("HDFArray: byteify array too big?");
            throw ex;
        }
        Object oo = this._theArray;
        int n = 0;
        int index = 0;
        while (true) {
            if (n >= ArrayDescriptor.totalSize) {
                if (n < ArrayDescriptor.totalSize) {
                    throw new InternalError(new String("HDFArray::byteify: Panic didn't complete all input data: n=  " + n + " size = " + ArrayDescriptor.totalSize));
                }
                break;
            }
            oo = ArrayDescriptor.objs[0];
            index = n / ArrayDescriptor.bytetoindex[0];
            index %= ArrayDescriptor.dimlen[0];
            for (i = 0; i < ArrayDescriptor.dims; ++i) {
                index = n / ArrayDescriptor.bytetoindex[i];
                if ((index %= ArrayDescriptor.dimlen[i]) == ArrayDescriptor.currentindex[i]) {
                    oo = ArrayDescriptor.objs[i];
                    continue;
                }
                if (index > ArrayDescriptor.dimlen[i] - 1) {
                    throw new IndexOutOfBoundsException("HDFArray: byteify index OOB?");
                }
                oo = Array.get(oo, index);
                ArrayDescriptor.currentindex[i] = index;
                ArrayDescriptor.objs[i] = oo;
            }
            try {
                byte[] arow;
                if (ArrayDescriptor.NT == 'J') {
                    arow = HDFNativeData.longToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (long[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'I') {
                    arow = HDFNativeData.intToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (int[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'S') {
                    arow = HDFNativeData.shortToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (short[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'B') {
                    arow = (byte[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1];
                } else if (ArrayDescriptor.NT == 'F') {
                    arow = HDFNativeData.floatToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (float[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else if (ArrayDescriptor.NT == 'D') {
                    arow = HDFNativeData.doubleToByte(0, ArrayDescriptor.dimlen[ArrayDescriptor.dims], (double[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                } else {
                    if (ArrayDescriptor.NT != 'L') {
                        HDF5JavaException ex = new HDF5JavaException("HDFArray: byteify unknown type not implemented?");
                        throw ex;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        arow = this.ByteObjToByte((Byte[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        arow = this.IntegerToByte((Integer[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        arow = this.ShortToByte((Short[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        arow = this.FloatObjToByte((Float[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        arow = this.DoubleObjToByte((Double[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    } else {
                        if (!ArrayDescriptor.className.equals("java.lang.Long")) {
                            HDF5JavaException ex = new HDF5JavaException("HDFArray: byteify Object type not implemented?");
                            throw ex;
                        }
                        arow = this.LongObjToByte((Long[])ArrayDescriptor.objs[ArrayDescriptor.dims - 1]);
                    }
                }
                System.arraycopy(arow, 0, this._barray, n, ArrayDescriptor.dimlen[ArrayDescriptor.dims] * ArrayDescriptor.NTsize);
                n += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
            }
            catch (OutOfMemoryError err) {
                HDF5JavaException ex = new HDF5JavaException("HDFArray: byteify array too big?");
                throw ex;
            }
        }
        i = 0;
        while (i < ArrayDescriptor.dims) {
            if (ArrayDescriptor.currentindex[i] != ArrayDescriptor.dimlen[i] - 1) {
                throw new InternalError(new String("Panic didn't complete all data: currentindex[" + i + "] = " + ArrayDescriptor.currentindex[i] + " (should be " + (ArrayDescriptor.dimlen[i] - 1) + " ?)"));
            }
            ++i;
        }
        return this._barray;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Object arrayify(byte[] bytes) throws HDF5JavaException {
        if (this._theArray == null) {
            ex = new HDF5JavaException("arrayify: not an array?: ");
            throw ex;
        }
        if (Array.getLength(bytes) != ArrayDescriptor.totalSize) {
            ex = new HDF5JavaException("arrayify: array is wrong size?: ");
            throw ex;
        }
        this._barray = bytes;
        if (ArrayDescriptor.dims == 1) {
            try {
                if (ArrayDescriptor.NT == 'I') {
                    x = HDFNativeData.byteToInt(this._barray);
                    System.arraycopy(x, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'S') {
                    x = HDFNativeData.byteToShort(this._barray);
                    System.arraycopy(x, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'F') {
                    x = HDFNativeData.byteToFloat(this._barray);
                    System.arraycopy(x, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'J') {
                    x = HDFNativeData.byteToLong(this._barray);
                    System.arraycopy(x, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'D') {
                    x = HDFNativeData.byteToDouble(this._barray);
                    System.arraycopy(x, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'B') {
                    System.arraycopy(this._barray, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                    return this._theArray;
                }
                if (ArrayDescriptor.NT == 'L') {
                    if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                        I = this.ByteToByteObj(this._barray);
                        System.arraycopy(I, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                        I = this.ByteToInteger(this._barray);
                        System.arraycopy(I, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Short")) {
                        I = this.ByteToShort(this._barray);
                        System.arraycopy(I, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Float")) {
                        I = this.ByteToFloatObj(this._barray);
                        System.arraycopy(I, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Double")) {
                        I = this.ByteToDoubleObj(this._barray);
                        System.arraycopy(I, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    if (ArrayDescriptor.className.equals("java.lang.Long")) {
                        I = this.ByteToLongObj(this._barray);
                        System.arraycopy(I, 0, this._theArray, 0, ArrayDescriptor.dimlen[1]);
                        return this._theArray;
                    }
                    ex = new HDF5JavaException("arrayify:  Object type not implemented yet...");
                    throw ex;
                }
                ex = new HDF5JavaException("arrayify:  unknown type not implemented yet...");
                throw ex;
            }
            catch (OutOfMemoryError err) {
                ex = new HDF5JavaException("HDFArray: arrayify array too big?");
                throw ex;
            }
        }
        oo = this._theArray;
        n = 0;
        m = 0;
        index = 0;
        flattenedArray /* !! */  = null;
        switch (ArrayDescriptor.NT) {
            case 'J': {
                flattenedArray /* !! */  = (byte[])HDFNativeData.byteToLong(this._barray);
                break;
            }
            case 'S': {
                flattenedArray /* !! */  = (byte[])HDFNativeData.byteToShort(this._barray);
                break;
            }
            case 'I': {
                flattenedArray /* !! */  = (byte[])HDFNativeData.byteToInt(this._barray);
                break;
            }
            case 'F': {
                flattenedArray /* !! */  = (byte[])HDFNativeData.byteToFloat(this._barray);
                break;
            }
            case 'D': {
                flattenedArray /* !! */  = (byte[])HDFNativeData.byteToDouble(this._barray);
                break;
            }
            case 'B': {
                flattenedArray /* !! */  = this._barray;
                break;
            }
            case 'L': {
                if (!ArrayDescriptor.className.equals("java.lang.Byte")) ** GOTO lbl93
                flattenedArray /* !! */  = this.ByteToByteObj(this._barray);
                ** GOTO lbl110
lbl93:
                // 1 sources

                if (!ArrayDescriptor.className.equals("java.lang.Short")) ** GOTO lbl96
                flattenedArray /* !! */  = (byte[])this.ByteToShort(this._barray);
                ** GOTO lbl110
lbl96:
                // 1 sources

                if (!ArrayDescriptor.className.equals("java.lang.Integer")) ** GOTO lbl99
                flattenedArray /* !! */  = (byte[])this.ByteToInteger(this._barray);
                ** GOTO lbl110
lbl99:
                // 1 sources

                if (!ArrayDescriptor.className.equals("java.lang.Long")) ** GOTO lbl102
                flattenedArray /* !! */  = (byte[])this.ByteToLongObj(this._barray);
                ** GOTO lbl110
lbl102:
                // 1 sources

                if (!ArrayDescriptor.className.equals("java.lang.Float")) ** GOTO lbl105
                flattenedArray /* !! */  = (byte[])this.ByteToFloatObj(this._barray);
                ** GOTO lbl110
lbl105:
                // 1 sources

                if (ArrayDescriptor.className.equals("java.lang.Double")) {
                    flattenedArray /* !! */  = (byte[])this.ByteToDoubleObj(this._barray);
                } else {
                    ex = new HDF5JavaException("HDFArray: unsupported Object type: " + ArrayDescriptor.NT);
                    throw ex;
                }
            }
lbl110:
            // 7 sources

            default: {
                ex = new HDF5JavaException("HDFArray: unknown or unsupported type: " + ArrayDescriptor.NT);
                throw ex;
            }
        }
        while (n < ArrayDescriptor.totalSize) {
            oo = ArrayDescriptor.objs[0];
            index = n / ArrayDescriptor.bytetoindex[0];
            index %= ArrayDescriptor.dimlen[0];
            for (i = 0; i < ArrayDescriptor.dims; ++i) {
                index = n / ArrayDescriptor.bytetoindex[i];
                if ((index %= ArrayDescriptor.dimlen[i]) == ArrayDescriptor.currentindex[i]) {
                    oo = ArrayDescriptor.objs[i];
                    continue;
                }
                if (index > ArrayDescriptor.dimlen[i] - 1) {
                    System.out.println("out of bounds?");
                    return null;
                }
                oo = Array.get(oo, index);
                ArrayDescriptor.currentindex[i] = index;
                ArrayDescriptor.objs[i] = oo;
            }
            try {
                arow /* !! */  = null;
                mm = m + ArrayDescriptor.dimlen[ArrayDescriptor.dims];
                switch (ArrayDescriptor.NT) {
                    case 'B': {
                        arow /* !! */  = Arrays.copyOfRange(flattenedArray /* !! */ , m, mm);
                        break;
                    }
                    case 'S': {
                        arow /* !! */  = (byte[])Arrays.copyOfRange((short[])flattenedArray /* !! */ , m, mm);
                        break;
                    }
                    case 'I': {
                        arow /* !! */  = (byte[])Arrays.copyOfRange((int[])flattenedArray /* !! */ , m, mm);
                        break;
                    }
                    case 'J': {
                        arow /* !! */  = (byte[])Arrays.copyOfRange((long[])flattenedArray /* !! */ , m, mm);
                        break;
                    }
                    case 'F': {
                        arow /* !! */  = (byte[])Arrays.copyOfRange((float[])flattenedArray /* !! */ , m, mm);
                        break;
                    }
                    case 'D': {
                        arow /* !! */  = (byte[])Arrays.copyOfRange((double[])flattenedArray /* !! */ , m, mm);
                        break;
                    }
                    case 'L': {
                        if (ArrayDescriptor.className.equals("java.lang.Byte")) {
                            arow /* !! */  = Arrays.copyOfRange((Byte[])flattenedArray /* !! */ , m, mm);
                            break;
                        }
                        if (ArrayDescriptor.className.equals("java.lang.Short")) {
                            arow /* !! */  = (byte[])Arrays.copyOfRange((Short[])flattenedArray /* !! */ , m, mm);
                            break;
                        }
                        if (ArrayDescriptor.className.equals("java.lang.Integer")) {
                            arow /* !! */  = (byte[])Arrays.copyOfRange((Integer[])flattenedArray /* !! */ , m, mm);
                            break;
                        }
                        if (ArrayDescriptor.className.equals("java.lang.Long")) {
                            arow /* !! */  = (byte[])Arrays.copyOfRange((Long[])flattenedArray /* !! */ , m, mm);
                            break;
                        }
                        if (ArrayDescriptor.className.equals("java.lang.Float")) {
                            arow /* !! */  = (byte[])Arrays.copyOfRange((Float[])flattenedArray /* !! */ , m, mm);
                            break;
                        }
                        if (ArrayDescriptor.className.equals("java.lang.Double")) {
                            arow /* !! */  = (byte[])Arrays.copyOfRange((Double[])flattenedArray /* !! */ , m, mm);
                            break;
                        }
                        ex = new HDF5JavaException("HDFArray: unsupported Object type: " + ArrayDescriptor.NT);
                        throw ex;
                    }
                }
                Array.set(ArrayDescriptor.objs[ArrayDescriptor.dims - 2], ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1], arow /* !! */ );
                n += ArrayDescriptor.bytetoindex[ArrayDescriptor.dims - 1];
                v0 = ArrayDescriptor.dims - 1;
                ArrayDescriptor.currentindex[v0] = ArrayDescriptor.currentindex[v0] + 1;
                m = mm;
            }
            catch (OutOfMemoryError err) {
                ex = new HDF5JavaException("HDFArray: arrayify array too big?");
                throw ex;
            }
        }
        if (n < ArrayDescriptor.totalSize) {
            throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all input data: n=  " + n + " size = " + ArrayDescriptor.totalSize));
        }
        for (i = 0; i <= ArrayDescriptor.dims - 2; ++i) {
            if (ArrayDescriptor.currentindex[i] == ArrayDescriptor.dimlen[i] - 1) continue;
            throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all data: currentindex[" + i + "] = " + ArrayDescriptor.currentindex[i] + " (should be " + (ArrayDescriptor.dimlen[i] - 1) + "?"));
        }
        if (ArrayDescriptor.currentindex[ArrayDescriptor.dims - 1] != ArrayDescriptor.dimlen[ArrayDescriptor.dims - 1]) {
            throw new InternalError(new String("HDFArray::arrayify Panic didn't complete all data: currentindex[" + i + "] = " + ArrayDescriptor.currentindex[i] + " (should be " + ArrayDescriptor.dimlen[i] + "?"));
        }
        return this._theArray;
    }

    private byte[] IntegerToByte(Integer[] in) {
        int nelems = Array.getLength(in);
        int[] out = new int[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i];
        }
        return HDFNativeData.intToByte(0, nelems, out);
    }

    private Integer[] ByteToInteger(byte[] bin) {
        int[] in = HDFNativeData.byteToInt(bin);
        int nelems = Array.getLength(in);
        Integer[] out = new Integer[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    private Integer[] ByteToInteger(int start, int len, byte[] bin) {
        int[] in = HDFNativeData.byteToInt(start, len, bin);
        int nelems = Array.getLength(in);
        Integer[] out = new Integer[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    private byte[] ShortToByte(Short[] in) {
        int nelems = Array.getLength(in);
        short[] out = new short[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i];
        }
        return HDFNativeData.shortToByte(0, nelems, out);
    }

    private Short[] ByteToShort(byte[] bin) {
        short[] in = HDFNativeData.byteToShort(bin);
        int nelems = Array.getLength(in);
        Short[] out = new Short[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    private Short[] ByteToShort(int start, int len, byte[] bin) {
        short[] in = HDFNativeData.byteToShort(start, len, bin);
        int nelems = Array.getLength(in);
        Short[] out = new Short[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    private byte[] ByteObjToByte(Byte[] in) {
        int nelems = Array.getLength(in);
        byte[] out = new byte[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    private Byte[] ByteToByteObj(byte[] bin) {
        int nelems = Array.getLength(bin);
        Byte[] out = new Byte[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = bin[i];
        }
        return out;
    }

    private Byte[] ByteToByteObj(int start, int len, byte[] bin) {
        Byte[] out = new Byte[len];
        for (int i = 0; i < len; ++i) {
            out[i] = bin[i];
        }
        return out;
    }

    private byte[] FloatObjToByte(Float[] in) {
        int nelems = Array.getLength(in);
        float[] out = new float[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i].floatValue();
        }
        return HDFNativeData.floatToByte(0, nelems, out);
    }

    private Float[] ByteToFloatObj(byte[] bin) {
        float[] in = HDFNativeData.byteToFloat(bin);
        int nelems = Array.getLength(in);
        Float[] out = new Float[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = Float.valueOf(in[i]);
        }
        return out;
    }

    private Float[] ByteToFloatObj(int start, int len, byte[] bin) {
        float[] in = HDFNativeData.byteToFloat(start, len, bin);
        int nelems = Array.getLength(in);
        Float[] out = new Float[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = Float.valueOf(in[i]);
        }
        return out;
    }

    private byte[] DoubleObjToByte(Double[] in) {
        int nelems = Array.getLength(in);
        double[] out = new double[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i];
        }
        return HDFNativeData.doubleToByte(0, nelems, out);
    }

    private Double[] ByteToDoubleObj(byte[] bin) {
        double[] in = HDFNativeData.byteToDouble(bin);
        int nelems = Array.getLength(in);
        Double[] out = new Double[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    private Double[] ByteToDoubleObj(int start, int len, byte[] bin) {
        double[] in = HDFNativeData.byteToDouble(start, len, bin);
        int nelems = Array.getLength(in);
        Double[] out = new Double[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    private byte[] LongObjToByte(Long[] in) {
        int nelems = Array.getLength(in);
        long[] out = new long[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i];
        }
        return HDFNativeData.longToByte(0, nelems, out);
    }

    private Long[] ByteToLongObj(byte[] bin) {
        long[] in = HDFNativeData.byteToLong(bin);
        int nelems = Array.getLength(in);
        Long[] out = new Long[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    private Long[] ByteToLongObj(int start, int len, byte[] bin) {
        long[] in = HDFNativeData.byteToLong(start, len, bin);
        int nelems = Array.getLength(in);
        Long[] out = new Long[nelems];
        for (int i = 0; i < nelems; ++i) {
            out[i] = in[i];
        }
        return out;
    }
}

