/*
 * Decompiled with CFR 0.152.
 */
package hdf.hdf5lib;

import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.HDFArray;
import hdf.hdf5lib.callbacks.H5A_iterate_cb;
import hdf.hdf5lib.callbacks.H5A_iterate_t;
import hdf.hdf5lib.callbacks.H5D_iterate_cb;
import hdf.hdf5lib.callbacks.H5D_iterate_t;
import hdf.hdf5lib.callbacks.H5E_walk_cb;
import hdf.hdf5lib.callbacks.H5E_walk_t;
import hdf.hdf5lib.callbacks.H5L_iterate_opdata_t;
import hdf.hdf5lib.callbacks.H5L_iterate_t;
import hdf.hdf5lib.callbacks.H5O_iterate_opdata_t;
import hdf.hdf5lib.callbacks.H5O_iterate_t;
import hdf.hdf5lib.callbacks.H5P_iterate_cb;
import hdf.hdf5lib.callbacks.H5P_iterate_t;
import hdf.hdf5lib.exceptions.HDF5Exception;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import hdf.hdf5lib.exceptions.HDF5LibraryException;
import hdf.hdf5lib.structs.H5AC_cache_config_t;
import hdf.hdf5lib.structs.H5A_info_t;
import hdf.hdf5lib.structs.H5FD_hdfs_fapl_t;
import hdf.hdf5lib.structs.H5FD_ros3_fapl_t;
import hdf.hdf5lib.structs.H5F_info2_t;
import hdf.hdf5lib.structs.H5G_info_t;
import hdf.hdf5lib.structs.H5L_info_t;
import hdf.hdf5lib.structs.H5O_info_t;
import hdf.hdf5lib.structs.H5O_native_info_t;
import hdf.hdf5lib.structs.H5O_token_t;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H5
implements Serializable {
    private static final long serialVersionUID = 6129888282117053288L;
    private static final Logger log = LoggerFactory.getLogger(H5.class);
    public static final int[] LIB_VERSION = new int[]{1, 14, 1};
    public static final String H5PATH_PROPERTY_KEY = "hdf.hdf5lib.H5.hdf5lib";
    public static final String H5_LIBRARY_NAME_PROPERTY_KEY = "hdf.hdf5lib.H5.loadLibraryName";
    private static String s_libraryName;
    private static boolean isLibraryLoaded;
    private static final boolean IS_CRITICAL_PINNING = true;
    private static final LinkedHashSet<Long> OPEN_IDS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadH5Lib() {
        String mappedName;
        block20: {
            String filename;
            block22: {
                if (isLibraryLoaded) {
                    return;
                }
                s_libraryName = System.getProperty(H5_LIBRARY_NAME_PROPERTY_KEY, null);
                mappedName = null;
                if (s_libraryName != null && s_libraryName.length() > 0) {
                    try {
                        mappedName = System.mapLibraryName(s_libraryName);
                        System.loadLibrary(s_libraryName);
                        isLibraryLoaded = true;
                    }
                    catch (Throwable err) {
                        try {
                            err.printStackTrace();
                            isLibraryLoaded = false;
                        }
                        catch (Throwable throwable) {
                            log.info("HDF5 library: " + s_libraryName);
                            log.debug(" resolved to: " + mappedName + "; ");
                            log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded from system property");
                            throw throwable;
                        }
                        log.info("HDF5 library: " + s_libraryName);
                        log.debug(" resolved to: " + mappedName + "; ");
                        log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded from system property");
                    }
                    log.info("HDF5 library: " + s_libraryName);
                    log.debug(" resolved to: " + mappedName + "; ");
                    log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded from system property");
                }
                if (isLibraryLoaded || (filename = System.getProperty(H5PATH_PROPERTY_KEY, null)) == null || filename.length() <= 0) break block20;
                File h5dll = new File(filename);
                if (!h5dll.exists() || !h5dll.canRead() || !h5dll.isFile()) break block22;
                try {
                    System.load(filename);
                    isLibraryLoaded = true;
                }
                catch (Throwable err) {
                    try {
                        err.printStackTrace();
                        isLibraryLoaded = false;
                    }
                    catch (Throwable throwable) {
                        log.info("HDF5 library: ");
                        log.debug(filename);
                        log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded.");
                        throw throwable;
                    }
                    log.info("HDF5 library: ");
                    log.debug(filename);
                    log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded.");
                    break block20;
                }
                log.info("HDF5 library: ");
                log.debug(filename);
                log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded.");
                break block20;
            }
            isLibraryLoaded = false;
            throw new UnsatisfiedLinkError("Invalid HDF5 library, " + filename);
        }
        if (!isLibraryLoaded) {
            try {
                s_libraryName = "hdf5_java";
                mappedName = System.mapLibraryName(s_libraryName);
                System.loadLibrary("hdf5_java");
                isLibraryLoaded = true;
            }
            catch (Throwable err) {
                try {
                    err.printStackTrace();
                    isLibraryLoaded = false;
                }
                catch (Throwable throwable) {
                    log.info("HDF5 library: " + s_libraryName);
                    log.debug(" resolved to: " + mappedName + "; ");
                    log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
                    throw throwable;
                }
                log.info("HDF5 library: " + s_libraryName);
                log.debug(" resolved to: " + mappedName + "; ");
                log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
            }
            log.info("HDF5 library: " + s_libraryName);
            log.debug(" resolved to: " + mappedName + "; ");
            log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
        }
        try {
            H5.H5dont_atexit();
        }
        catch (HDF5LibraryException e) {
            System.exit(1);
        }
        if (!log.isDebugEnabled()) {
            H5.H5error_off();
        }
        Integer majnum = Integer.getInteger("hdf.hdf5lib.H5.hdf5maj", null);
        Integer minnum = Integer.getInteger("hdf.hdf5lib.H5.hdf5min", null);
        Integer relnum = Integer.getInteger("hdf.hdf5lib.H5.hdf5rel", null);
        if (majnum != null && minnum != null && relnum != null) {
            H5.H5check_version(majnum, minnum, relnum);
        }
    }

    public static final int getOpenIDCount() {
        return OPEN_IDS.size();
    }

    public static final Collection<Long> getOpenIDs() {
        return OPEN_IDS;
    }

    public static synchronized native int H5check_version(int var0, int var1, int var2);

    public static synchronized native int H5close() throws HDF5LibraryException;

    public static synchronized native int H5open() throws HDF5LibraryException;

    private static synchronized native int H5dont_atexit() throws HDF5LibraryException;

    public static synchronized native int H5error_off();

    public static synchronized native void H5error_on();

    public static synchronized native int H5garbage_collect() throws HDF5LibraryException;

    public static synchronized native int H5get_libversion(int[] var0) throws HDF5LibraryException;

    public static synchronized native int H5set_free_list_limits(int var0, int var1, int var2, int var3, int var4, int var5) throws HDF5LibraryException;

    public static synchronized native void H5export_dataset(String var0, long var1, String var3, int var4) throws HDF5LibraryException;

    public static synchronized native void H5export_attribute(String var0, long var1, String var3, int var4) throws HDF5LibraryException;

    private static synchronized native boolean H5is_library_threadsafe();

    public static int H5Aclose(long attr_id) throws HDF5LibraryException {
        if (attr_id < 0L) {
            return 0;
        }
        log.trace("OPEN_IDS: H5Aclose remove {}", (Object)attr_id);
        OPEN_IDS.remove(attr_id);
        log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        return H5._H5Aclose(attr_id);
    }

    private static synchronized native int _H5Aclose(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Acopy(long var0, long var2) throws HDF5LibraryException;

    public static long H5Acreate(long loc_id, String attr_name, long type_id, long space_id, long acpl_id, long aapl_id) throws HDF5LibraryException, NullPointerException {
        long id = H5._H5Acreate2(loc_id, attr_name, type_id, space_id, acpl_id, aapl_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5A create add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Acreate2(long var0, String var2, long var3, long var5, long var7, long var9) throws HDF5LibraryException, NullPointerException;

    public static long H5Acreate_by_name(long loc_id, String obj_name, String attr_name, long type_id, long space_id, long acpl_id, long aapl_id, long lapl_id) throws HDF5LibraryException, NullPointerException {
        long id = H5._H5Acreate_by_name(loc_id, obj_name, attr_name, type_id, space_id, acpl_id, aapl_id, lapl_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Acreate_by_name add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Acreate_by_name(long var0, String var2, String var3, long var4, long var6, long var8, long var10, long var12) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Adelete(long var0, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Adelete_by_idx(long var0, String var2, int var3, int var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Adelete_by_name(long var0, String var2, String var3, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Aexists(long var0, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Aexists_by_name(long var0, String var2, String var3, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5A_info_t H5Aget_info(long var0) throws HDF5LibraryException;

    public static synchronized native H5A_info_t H5Aget_info_by_idx(long var0, String var2, int var3, int var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5A_info_t H5Aget_info_by_name(long var0, String var2, String var3, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Aget_name(long var0) throws HDF5LibraryException;

    public static synchronized native String H5Aget_name_by_idx(long var0, String var2, int var3, int var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static long H5Aget_space(long attr_id) throws HDF5LibraryException {
        long id = H5._H5Aget_space(attr_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Aget_space add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Aget_space(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Aget_storage_size(long var0) throws HDF5LibraryException;

    public static long H5Aget_type(long attr_id) throws HDF5LibraryException {
        long id = H5._H5Aget_type(attr_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Aget_type add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Aget_type(long var0) throws HDF5LibraryException;

    public static long H5Aopen(long obj_id, String attr_name, long aapl_id) throws HDF5LibraryException, NullPointerException {
        long id = H5._H5Aopen(obj_id, attr_name, aapl_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Aopen add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Aopen(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static long H5Aopen_by_idx(long loc_id, String obj_name, int idx_type, int order, long n, long aapl_id, long lapl_id) throws HDF5LibraryException, NullPointerException {
        long id = H5._H5Aopen_by_idx(loc_id, obj_name, idx_type, order, n, aapl_id, lapl_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Aopen_by_idx add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Aopen_by_idx(long var0, String var2, int var3, int var4, long var5, long var7, long var9) throws HDF5LibraryException, NullPointerException;

    public static long H5Aopen_by_name(long loc_id, String obj_name, String attr_name, long aapl_id, long lapl_id) throws HDF5LibraryException, NullPointerException {
        long id = H5._H5Aopen_by_name(loc_id, obj_name, attr_name, aapl_id, lapl_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Aopen_by_name add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Aopen_by_name(long var0, String var2, String var3, long var4, long var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Aread(long var0, long var2, byte[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Aread(long attr_id, long mem_type_id, byte[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Aread(attr_id, mem_type_id, buf, true);
    }

    public static synchronized int H5Aread(long attr_id, long mem_type_id, Object obj) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        return H5.H5Aread(attr_id, mem_type_id, obj, true);
    }

    public static synchronized int H5Aread(long attr_id, long mem_type_id, Object obj, boolean isCriticalPinning) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        int status = -1;
        boolean is1D = false;
        Class<?> dataClass = obj.getClass();
        if (!dataClass.isArray()) {
            throw new HDF5JavaException("H5Aread: data is not an array");
        }
        String cname = dataClass.getName();
        is1D = cname.lastIndexOf(91) == cname.indexOf(91);
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        log.trace("H5Aread: cname={} is1D={} dname={}", new Object[]{cname, is1D, Character.valueOf(dname)});
        if (is1D && dname == 'B') {
            log.trace("H5Aread_dname_B");
            status = H5.H5Aread(attr_id, mem_type_id, (byte[])obj, isCriticalPinning);
        } else if (is1D && dname == 'S') {
            log.trace("H5Aread_dname_S");
            status = H5.H5Aread_short(attr_id, mem_type_id, (short[])obj, isCriticalPinning);
        } else if (is1D && dname == 'I') {
            log.trace("H5Aread_dname_I");
            status = H5.H5Aread_int(attr_id, mem_type_id, (int[])obj, isCriticalPinning);
        } else if (is1D && dname == 'J') {
            log.trace("H5Aread_dname_J");
            status = H5.H5Aread_long(attr_id, mem_type_id, (long[])obj, isCriticalPinning);
        } else if (is1D && dname == 'F') {
            log.trace("H5Aread_dname_F");
            status = H5.H5Aread_float(attr_id, mem_type_id, (float[])obj, isCriticalPinning);
        } else if (is1D && dname == 'D') {
            log.trace("H5Aread_dname_D");
            status = H5.H5Aread_double(attr_id, mem_type_id, (double[])obj, isCriticalPinning);
        } else if (H5.H5Tdetect_class(mem_type_id, HDF5Constants.H5T_REFERENCE) && is1D && dataClass.getComponentType() == String.class || H5.H5Tequal(mem_type_id, HDF5Constants.H5T_STD_REF_DSETREG)) {
            log.trace("H5Aread_reg_ref");
            status = H5.H5Aread_reg_ref(attr_id, mem_type_id, (String[])obj);
        } else if (is1D && dataClass.getComponentType() == String.class) {
            log.trace("H5Aread_string type");
            status = H5.H5Aread_string(attr_id, mem_type_id, (String[])obj);
        } else if (H5.H5Tget_class(mem_type_id) == HDF5Constants.H5T_VLEN) {
            log.trace("H5AreadVL type");
            status = H5.H5AreadVL(attr_id, mem_type_id, (Object[])obj);
        } else {
            HDFArray theArray = new HDFArray(obj);
            byte[] buf = theArray.emptyBytes();
            log.trace("H5Aread_else");
            status = H5.H5Aread(attr_id, mem_type_id, buf, isCriticalPinning);
            if (status >= 0) {
                obj = theArray.arrayify(buf);
            }
            buf = null;
            theArray = null;
        }
        return status;
    }

    public static synchronized native int H5Aread_double(long var0, long var2, double[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Aread_double(long attr_id, long mem_type_id, double[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Aread_double(attr_id, mem_type_id, buf, true);
    }

    public static synchronized native int H5Aread_float(long var0, long var2, float[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Aread_float(long attr_id, long mem_type_id, float[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Aread_float(attr_id, mem_type_id, buf, true);
    }

    public static synchronized native int H5Aread_int(long var0, long var2, int[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Aread_int(long attr_id, long mem_type_id, int[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Aread_int(attr_id, mem_type_id, buf, true);
    }

    public static synchronized native int H5Aread_long(long var0, long var2, long[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Aread_long(long attr_id, long mem_type_id, long[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Aread_long(attr_id, mem_type_id, buf, true);
    }

    public static synchronized native int H5Aread_reg_ref(long var0, long var2, String[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Aread_short(long var0, long var2, short[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Aread_short(long attr_id, long mem_type_id, short[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Aread_short(attr_id, mem_type_id, buf, true);
    }

    public static synchronized native int H5AreadVL(long var0, long var2, Object[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Aread_string(long var0, long var2, String[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Aread_VLStrings(long var0, long var2, Object[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5AreadComplex(long var0, long var2, String[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Arename(long var0, String var2, String var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Arename_by_name(long var0, String var2, String var3, String var4, long var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Awrite(long var0, long var2, byte[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Awrite(long attr_id, long mem_type_id, byte[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Awrite(attr_id, mem_type_id, buf, true);
    }

    public static synchronized int H5Awrite(long attr_id, long mem_type_id, Object obj) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        return H5.H5Awrite(attr_id, mem_type_id, obj, true);
    }

    public static synchronized int H5Awrite(long attr_id, long mem_type_id, Object obj, boolean isCriticalPinning) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        int status = -1;
        boolean is1D = false;
        Class<?> dataClass = obj.getClass();
        if (!dataClass.isArray()) {
            throw new HDF5JavaException("H5Dwrite: data is not an array");
        }
        String cname = dataClass.getName();
        is1D = cname.lastIndexOf(91) == cname.indexOf(91);
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        if (is1D && dname == 'B') {
            status = H5.H5Awrite(attr_id, mem_type_id, (byte[])obj, isCriticalPinning);
        } else if (is1D && dname == 'S') {
            status = H5.H5Awrite_short(attr_id, mem_type_id, (short[])obj, isCriticalPinning);
        } else if (is1D && dname == 'I') {
            status = H5.H5Awrite_int(attr_id, mem_type_id, (int[])obj, isCriticalPinning);
        } else if (is1D && dname == 'J') {
            status = H5.H5Awrite_long(attr_id, mem_type_id, (long[])obj, isCriticalPinning);
        } else if (is1D && dname == 'F') {
            status = H5.H5Awrite_float(attr_id, mem_type_id, (float[])obj, isCriticalPinning);
        } else if (is1D && dname == 'D') {
            status = H5.H5Awrite_double(attr_id, mem_type_id, (double[])obj, isCriticalPinning);
        } else if (is1D && dataClass.getComponentType() == String.class) {
            log.trace("H5Dwrite_string type");
            status = H5.H5Awrite_string(attr_id, mem_type_id, (String[])obj);
        } else if (H5.H5Tget_class(mem_type_id) == HDF5Constants.H5T_VLEN) {
            log.trace("H5AwriteVL type");
            status = H5.H5AwriteVL(attr_id, mem_type_id, (Object[])obj);
        } else {
            HDFArray theArray = new HDFArray(obj);
            byte[] buf = theArray.byteify();
            status = H5.H5Awrite(attr_id, mem_type_id, buf);
            buf = null;
            theArray = null;
        }
        return status;
    }

    public static synchronized native int H5Awrite_double(long var0, long var2, double[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Awrite_double(long attr_id, long mem_type_id, double[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Awrite_double(attr_id, mem_type_id, buf, true);
    }

    public static synchronized native int H5Awrite_float(long var0, long var2, float[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Awrite_float(long attr_id, long mem_type_id, float[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Awrite_float(attr_id, mem_type_id, buf, true);
    }

    public static synchronized native int H5Awrite_int(long var0, long var2, int[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Awrite_int(long attr_id, long mem_type_id, int[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Awrite_int(attr_id, mem_type_id, buf, true);
    }

    public static synchronized native int H5Awrite_long(long var0, long var2, long[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Awrite_long(long attr_id, long mem_type_id, long[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Awrite_long(attr_id, mem_type_id, buf, true);
    }

    public static synchronized native int H5Awrite_short(long var0, long var2, short[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Awrite_short(long attr_id, long mem_type_id, short[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Awrite_short(attr_id, mem_type_id, buf, true);
    }

    public static synchronized native int H5Awrite_string(long var0, long var2, String[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5AwriteVL(long var0, long var2, Object[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Awrite_VLStrings(long var0, long var2, Object[] var4) throws HDF5LibraryException, NullPointerException;

    public static long H5Aget_create_plist(long attr_id) throws HDF5LibraryException {
        long id = H5._H5Aget_create_plist(attr_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Aget_create_plist add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Aget_create_plist(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Aiterate(long var0, int var2, int var3, long var4, H5A_iterate_cb var6, H5A_iterate_t var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Aiterate_by_name(long var0, String var2, int var3, int var4, long var5, H5A_iterate_cb var7, H5A_iterate_t var8, long var9) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dcopy(long var0, long var2) throws HDF5LibraryException;

    public static int H5Dclose(long dataset_id) throws HDF5LibraryException {
        if (dataset_id < 0L) {
            return 0;
        }
        log.trace("OPEN_IDS: H5Dclose remove {}", (Object)dataset_id);
        OPEN_IDS.remove(dataset_id);
        log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        return H5._H5Dclose(dataset_id);
    }

    private static synchronized native int _H5Dclose(long var0) throws HDF5LibraryException;

    public static long H5Dcreate(long loc_id, String name, long type_id, long space_id, long lcpl_id, long dcpl_id, long dapl_id) throws HDF5LibraryException, NullPointerException {
        long id = H5._H5Dcreate2(loc_id, name, type_id, space_id, lcpl_id, dcpl_id, dapl_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Dcreate add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Dcreate2(long var0, String var2, long var3, long var5, long var7, long var9, long var11) throws HDF5LibraryException, NullPointerException;

    public static long H5Dcreate_anon(long loc_id, long type_id, long space_id, long dcpl_id, long dapl_id) throws HDF5LibraryException {
        long id = H5._H5Dcreate_anon(loc_id, type_id, space_id, dcpl_id, dapl_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Dcreate_anon add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Dcreate_anon(long var0, long var2, long var4, long var6, long var8) throws HDF5LibraryException;

    public static synchronized native void H5Dfill(byte[] var0, long var1, byte[] var3, long var4, long var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Dget_access_plist(long var0) throws HDF5LibraryException;

    public static long H5Dget_create_plist(long dataset_id) throws HDF5LibraryException {
        long id = H5._H5Dget_create_plist(dataset_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Dget_create_plist add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Dget_create_plist(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Dget_offset(long var0) throws HDF5LibraryException;

    public static long H5Dget_space(long dataset_id) throws HDF5LibraryException {
        long id = H5._H5Dget_space(dataset_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Dget_space add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Dget_space(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Dget_space_status(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Dget_storage_size(long var0) throws HDF5LibraryException, IllegalArgumentException;

    public static long H5Dget_type(long dataset_id) throws HDF5LibraryException {
        long id = H5._H5Dget_type(dataset_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Dget_type add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Dget_type(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Diterate(byte[] var0, long var1, long var3, H5D_iterate_cb var5, H5D_iterate_t var6) throws HDF5LibraryException, NullPointerException;

    public static long H5Dopen(long loc_id, String name, long dapl_id) throws HDF5LibraryException, NullPointerException {
        long id = H5._H5Dopen2(loc_id, name, dapl_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Dopen add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Dopen2(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dread(long var0, long var2, long var4, long var6, long var8, byte[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread(long dataset_id, long mem_type_id, long mem_space_id, long file_space_id, long xfer_plist_id, byte[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized int H5Dread(long dataset_id, long mem_type_id, long mem_space_id, long file_space_id, long xfer_plist_id, Object obj) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        return H5.H5Dread(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, obj, true);
    }

    public static synchronized int H5Dread(long dataset_id, long mem_type_id, long mem_space_id, long file_space_id, long xfer_plist_id, Object obj, boolean isCriticalPinning) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        int status = -1;
        boolean is1D = false;
        Class<?> dataClass = obj.getClass();
        if (!dataClass.isArray()) {
            throw new HDF5JavaException("H5Dread: data is not an array");
        }
        String cname = dataClass.getName();
        is1D = cname.lastIndexOf(91) == cname.indexOf(91);
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        log.trace("H5Dread: cname={} is1D={} dname={}", new Object[]{cname, is1D, Character.valueOf(dname)});
        if (is1D && dname == 'B') {
            log.trace("H5Dread_dname_B");
            status = H5.H5Dread(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (byte[])obj, isCriticalPinning);
        } else if (is1D && dname == 'S') {
            log.trace("H5Dread_dname_S");
            status = H5.H5Dread_short(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (short[])obj, isCriticalPinning);
        } else if (is1D && dname == 'I') {
            log.trace("H5Dread_dname_I");
            status = H5.H5Dread_int(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (int[])obj, isCriticalPinning);
        } else if (is1D && dname == 'J') {
            log.trace("H5Dread_dname_J");
            status = H5.H5Dread_long(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (long[])obj, isCriticalPinning);
        } else if (is1D && dname == 'F') {
            log.trace("H5Dread_dname_F");
            status = H5.H5Dread_float(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (float[])obj, isCriticalPinning);
        } else if (is1D && dname == 'D') {
            log.trace("H5Dread_dname_D");
            status = H5.H5Dread_double(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (double[])obj, isCriticalPinning);
        } else if (H5.H5Tdetect_class(mem_type_id, HDF5Constants.H5T_REFERENCE) && is1D && dataClass.getComponentType() == String.class || H5.H5Tequal(mem_type_id, HDF5Constants.H5T_STD_REF_DSETREG)) {
            log.trace("H5Dread_reg_ref");
            status = H5.H5Dread_reg_ref(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (String[])obj);
        } else if (is1D && dataClass.getComponentType() == String.class) {
            log.trace("H5Dread_string type");
            status = H5.H5Dread_string(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (String[])obj);
        } else if (H5.H5Tget_class(mem_type_id) == HDF5Constants.H5T_VLEN) {
            log.trace("H5DreadVL type");
            status = H5.H5DreadVL(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (Object[])obj);
        } else {
            HDFArray theArray = new HDFArray(obj);
            byte[] buf = theArray.emptyBytes();
            log.trace("H5Dread_else");
            status = H5.H5Dread(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, isCriticalPinning);
            if (status >= 0) {
                obj = theArray.arrayify(buf);
            }
            buf = null;
            theArray = null;
        }
        return status;
    }

    public static synchronized native int H5Dread_double(long var0, long var2, long var4, long var6, long var8, double[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_double(long dataset_id, long mem_type_id, long mem_space_id, long file_space_id, long xfer_plist_id, double[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_double(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5Dread_float(long var0, long var2, long var4, long var6, long var8, float[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_float(long dataset_id, long mem_type_id, long mem_space_id, long file_space_id, long xfer_plist_id, float[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_float(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5Dread_int(long var0, long var2, long var4, long var6, long var8, int[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_int(long dataset_id, long mem_type_id, long mem_space_id, long file_space_id, long xfer_plist_id, int[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_int(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5Dread_long(long var0, long var2, long var4, long var6, long var8, long[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_long(long dataset_id, long mem_type_id, long mem_space_id, long file_space_id, long xfer_plist_id, long[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_long(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5Dread_reg_ref(long var0, long var2, long var4, long var6, long var8, String[] var10) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dread_short(long var0, long var2, long var4, long var6, long var8, short[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_short(long dataset_id, long mem_type_id, long mem_space_id, long file_space_id, long xfer_plist_id, short[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_short(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5DreadVL(long var0, long var2, long var4, long var6, long var8, Object[] var10) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dread_string(long var0, long var2, long var4, long var6, long var8, String[] var10) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dread_VLStrings(long var0, long var2, long var4, long var6, long var8, Object[] var10) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Dset_extent(long var0, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Dvlen_get_buf_size(long var0, long var2, long var4) throws HDF5LibraryException;

    @Deprecated
    public static synchronized native int H5Dvlen_reclaim(long var0, long var2, long var4, byte[] var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dwrite(long var0, long var2, long var4, long var6, long var8, byte[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite(long dataset_id, long mem_type_id, long mem_space_id, long file_space_id, long xfer_plist_id, byte[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized int H5Dwrite(long dataset_id, long mem_type_id, long mem_space_id, long file_space_id, long xfer_plist_id, Object obj) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, obj, true);
    }

    public static synchronized int H5Dwrite(long dataset_id, long mem_type_id, long mem_space_id, long file_space_id, long xfer_plist_id, Object obj, boolean isCriticalPinning) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        int status = -1;
        boolean is1D = false;
        Class<?> dataClass = obj.getClass();
        if (!dataClass.isArray()) {
            throw new HDF5JavaException("H5Dwrite: data is not an array");
        }
        String cname = dataClass.getName();
        is1D = cname.lastIndexOf(91) == cname.indexOf(91);
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        if (is1D && dname == 'B') {
            status = H5.H5Dwrite(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (byte[])obj, isCriticalPinning);
        } else if (is1D && dname == 'S') {
            status = H5.H5Dwrite_short(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (short[])obj, isCriticalPinning);
        } else if (is1D && dname == 'I') {
            status = H5.H5Dwrite_int(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (int[])obj, isCriticalPinning);
        } else if (is1D && dname == 'J') {
            status = H5.H5Dwrite_long(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (long[])obj, isCriticalPinning);
        } else if (is1D && dname == 'F') {
            status = H5.H5Dwrite_float(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (float[])obj, isCriticalPinning);
        } else if (is1D && dname == 'D') {
            status = H5.H5Dwrite_double(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (double[])obj, isCriticalPinning);
        } else if (is1D && dataClass.getComponentType() == String.class) {
            log.trace("H5Dwrite_string type");
            status = H5.H5Dwrite_string(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (String[])obj);
        } else if (H5.H5Tget_class(mem_type_id) == HDF5Constants.H5T_VLEN) {
            log.trace("H5DwriteVL type");
            status = H5.H5DwriteVL(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (Object[])obj);
        } else {
            HDFArray theArray = new HDFArray(obj);
            byte[] buf = theArray.byteify();
            status = H5.H5Dwrite(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, isCriticalPinning);
            buf = null;
            theArray = null;
        }
        return status;
    }

    public static synchronized native int H5Dwrite_double(long var0, long var2, long var4, long var6, long var8, double[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_double(long dataset_id, long mem_type_id, long mem_space_id, long file_space_id, long xfer_plist_id, double[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_double(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5Dwrite_float(long var0, long var2, long var4, long var6, long var8, float[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_float(long dataset_id, long mem_type_id, long mem_space_id, long file_space_id, long xfer_plist_id, float[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_float(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5Dwrite_int(long var0, long var2, long var4, long var6, long var8, int[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_int(long dataset_id, long mem_type_id, long mem_space_id, long file_space_id, long xfer_plist_id, int[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_int(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5Dwrite_long(long var0, long var2, long var4, long var6, long var8, long[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_long(long dataset_id, long mem_type_id, long mem_space_id, long file_space_id, long xfer_plist_id, long[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_long(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5Dwrite_short(long var0, long var2, long var4, long var6, long var8, short[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_short(long dataset_id, long mem_type_id, long mem_space_id, long file_space_id, long xfer_plist_id, short[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_short(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5Dwrite_string(long var0, long var2, long var4, long var6, long var8, String[] var10) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5DwriteVL(long var0, long var2, long var4, long var6, long var8, Object[] var10) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dwrite_VLStrings(long var0, long var2, long var4, long var6, long var8, Object[] var10) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Dflush(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Drefresh(long var0) throws HDF5LibraryException;

    public static synchronized native boolean H5Eauto_is_v2(long var0) throws HDF5LibraryException;

    public static int H5Eclear() throws HDF5LibraryException {
        H5.H5Eclear2(HDF5Constants.H5E_DEFAULT);
        return 0;
    }

    public static void H5Eclear(long stack_id) throws HDF5LibraryException {
        H5.H5Eclear2(stack_id);
    }

    public static synchronized native void H5Eclear2(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Eclose_msg(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Eclose_stack(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Ecreate_msg(long var0, int var2, String var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Ecreate_stack() throws HDF5LibraryException;

    public static synchronized native String H5Eget_class_name(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Eget_current_stack() throws HDF5LibraryException;

    public static synchronized native void H5Eset_current_stack(long var0) throws HDF5LibraryException;

    public static synchronized native String H5Eget_msg(long var0, int[] var2) throws HDF5LibraryException;

    public static synchronized native long H5Eget_num(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Eprint2(long var0, Object var2) throws HDF5LibraryException;

    public static synchronized native void H5Epop(long var0, long var2) throws HDF5LibraryException;

    public static void H5Epush(long stack_id, String file, String func, int line, long cls_id, long maj_id, long min_id, String msg) throws HDF5LibraryException, NullPointerException {
        H5.H5Epush2(stack_id, file, func, line, cls_id, maj_id, min_id, msg);
    }

    public static synchronized native void H5Epush2(long var0, String var2, String var3, int var4, long var5, long var7, long var9, String var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Eregister_class(String var0, String var1, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Eunregister_class(long var0) throws HDF5LibraryException;

    public static void H5Ewalk(long stack_id, long direction, H5E_walk_cb func, H5E_walk_t client_data) throws HDF5LibraryException, NullPointerException {
        H5.H5Ewalk2(stack_id, direction, func, client_data);
    }

    public static synchronized native void H5Ewalk2(long var0, long var2, H5E_walk_cb var4, H5E_walk_t var5) throws HDF5LibraryException, NullPointerException;

    public static int H5Fclose(long file_id) throws HDF5LibraryException {
        if (file_id < 0L) {
            return 0;
        }
        log.trace("OPEN_IDS: H5Fclose remove {}", (Object)file_id);
        OPEN_IDS.remove(file_id);
        log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        return H5._H5Fclose(file_id);
    }

    private static synchronized native int _H5Fclose(long var0) throws HDF5LibraryException;

    public static long H5Fopen(String name, int flags, long access_id) throws HDF5LibraryException, NullPointerException {
        long id = H5._H5Fopen(name, flags, access_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Fopen add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Fopen(String var0, int var1, long var2) throws HDF5LibraryException, NullPointerException;

    public static long H5Freopen(long file_id) throws HDF5LibraryException {
        long id = H5._H5Freopen(file_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Freopen add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Freopen(long var0) throws HDF5LibraryException;

    public static long H5Fcreate(String name, int flags, long create_id, long access_id) throws HDF5LibraryException, NullPointerException {
        long id = H5._H5Fcreate(name, flags, create_id, access_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Fcreate add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Fcreate(String var0, int var1, long var2, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Fflush(long var0, int var2) throws HDF5LibraryException;

    public static long H5Fget_access_plist(long file_id) throws HDF5LibraryException {
        long id = H5._H5Fget_access_plist(file_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Fget_access_plist add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Fget_access_plist(long var0) throws HDF5LibraryException;

    public static long H5Fget_create_plist(long file_id) throws HDF5LibraryException {
        long id = H5._H5Fget_create_plist(file_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Fget_create_plist add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Fget_create_plist(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Fget_filesize(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Fget_freespace(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Fget_intent(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Fget_fileno(long var0) throws HDF5LibraryException;

    public static synchronized native double H5Fget_mdc_hit_rate(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Fget_mdc_size(long var0, long[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native String H5Fget_name(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Fget_obj_count(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native long H5Fget_obj_ids(long var0, int var2, long var3, long[] var5) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native boolean H5Fis_hdf5(String var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Fis_accessible(String var0, long var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Fmount(long var0, String var2, long var3, long var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Funmount(long var0, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Freset_mdc_hit_rate_stats(long var0) throws HDF5LibraryException;

    public static synchronized native H5F_info2_t H5Fget_info(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Fclear_elink_file_cache(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Fstart_swmr_write(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Fstart_mdc_logging(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Fstop_mdc_logging(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Fget_mdc_logging_status(long var0, boolean[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Fget_dset_no_attrs_hint(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Fset_dset_no_attrs_hint(long var0, boolean var2) throws HDF5LibraryException;

    public static synchronized native void H5Fset_libver_bounds(long var0, int var2, int var3) throws HDF5LibraryException;

    public static int H5Gclose(long group_id) throws HDF5LibraryException {
        if (group_id < 0L) {
            return 0;
        }
        log.trace("OPEN_IDS: H5Gclose remove {}", (Object)group_id);
        OPEN_IDS.remove(group_id);
        log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        return H5._H5Gclose(group_id);
    }

    private static synchronized native int _H5Gclose(long var0) throws HDF5LibraryException;

    public static long H5Gcreate(long loc_id, String name, long lcpl_id, long gcpl_id, long gapl_id) throws HDF5LibraryException, NullPointerException {
        long id = H5._H5Gcreate2(loc_id, name, lcpl_id, gcpl_id, gapl_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Gcreate add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Gcreate2(long var0, String var2, long var3, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static long H5Gcreate_anon(long loc_id, long gcpl_id, long gapl_id) throws HDF5LibraryException {
        long id = H5._H5Gcreate_anon(loc_id, gcpl_id, gapl_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Gcreate_anon add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Gcreate_anon(long var0, long var2, long var4) throws HDF5LibraryException;

    public static synchronized native long H5Gget_create_plist(long var0) throws HDF5LibraryException;

    public static synchronized native H5G_info_t H5Gget_info(long var0) throws HDF5LibraryException;

    public static synchronized native H5G_info_t H5Gget_info_by_idx(long var0, String var2, int var3, int var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5G_info_t H5Gget_info_by_name(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Gget_obj_info_all(long loc_id, String name, String[] objNames, int[] objTypes, H5O_token_t[] tokens) throws HDF5LibraryException, NullPointerException {
        if (objNames == null) {
            throw new NullPointerException("H5Gget_obj_info_all(): name array is null");
        }
        return H5.H5Gget_obj_info_all(loc_id, name, objNames, objTypes, null, null, tokens, HDF5Constants.H5_INDEX_NAME);
    }

    public static synchronized int H5Gget_obj_info_all(long loc_id, String name, String[] objNames, int[] objTypes, int[] ltype, H5O_token_t[] tokens, int indx_type) throws HDF5LibraryException, NullPointerException {
        return H5.H5Gget_obj_info_full(loc_id, name, objNames, objTypes, ltype, null, tokens, indx_type, -1);
    }

    public static synchronized int H5Gget_obj_info_all(long loc_id, String name, String[] objNames, int[] objTypes, int[] ltype, long[] fno, H5O_token_t[] tokens, int indx_type) throws HDF5LibraryException, NullPointerException {
        return H5.H5Gget_obj_info_full(loc_id, name, objNames, objTypes, ltype, fno, tokens, indx_type, -1);
    }

    public static synchronized int H5Gget_obj_info_full(long loc_id, String name, String[] objNames, int[] objTypes, int[] ltype, long[] fno, H5O_token_t[] tokens, int indx_type, int indx_order) throws HDF5LibraryException, NullPointerException {
        if (objNames == null) {
            throw new NullPointerException("H5Gget_obj_info_full(): name array is null");
        }
        if (objTypes == null) {
            throw new NullPointerException("H5Gget_obj_info_full(): object type array is null");
        }
        if (objNames.length == 0) {
            throw new HDF5LibraryException("H5Gget_obj_info_full(): array size is zero");
        }
        if (objNames.length != objTypes.length) {
            throw new HDF5LibraryException("H5Gget_obj_info_full(): name and type array sizes are different");
        }
        if (ltype == null) {
            ltype = new int[objTypes.length];
        }
        if (fno == null) {
            fno = new long[tokens.length];
        }
        if (indx_type < 0) {
            indx_type = HDF5Constants.H5_INDEX_NAME;
        }
        if (indx_order < 0) {
            indx_order = HDF5Constants.H5_ITER_INC;
        }
        log.trace("H5Gget_obj_info_full: objNames_len={}", (Object)objNames.length);
        int status = H5.H5Gget_obj_info_full(loc_id, name, objNames, objTypes, ltype, fno, tokens, objNames.length, indx_type, indx_order);
        for (int indx = 0; indx < objNames.length; ++indx) {
            log.trace("H5Gget_obj_info_full: objNames={}", (Object)objNames[indx]);
        }
        return status;
    }

    private static synchronized native int H5Gget_obj_info_full(long var0, String var2, String[] var3, int[] var4, int[] var5, long[] var6, H5O_token_t[] var7, int var8, int var9, int var10) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Gget_obj_info_idx(long loc_id, String name, int idx, String[] oname, int[] type) throws HDF5LibraryException, NullPointerException {
        String[] n = new String[]{new String("")};
        oname[0] = H5.H5Lget_name_by_idx(loc_id, name, HDF5Constants.H5_INDEX_NAME, HDF5Constants.H5_ITER_INC, idx, HDF5Constants.H5P_DEFAULT);
        H5L_info_t info = H5.H5Lget_info_by_idx(loc_id, name, HDF5Constants.H5_INDEX_NAME, HDF5Constants.H5_ITER_INC, idx, HDF5Constants.H5P_DEFAULT);
        type[0] = info.type;
        return 0;
    }

    public static synchronized int H5Gget_obj_info_max(long loc_id, String[] objNames, int[] objTypes, int[] lnkTypes, H5O_token_t[] objToken, long objMax) throws HDF5LibraryException, NullPointerException {
        if (objNames == null) {
            throw new NullPointerException("H5Gget_obj_info_max(): name array is null");
        }
        if (objTypes == null) {
            throw new NullPointerException("H5Gget_obj_info_max(): object type array is null");
        }
        if (lnkTypes == null) {
            throw new NullPointerException("H5Gget_obj_info_max(): link type array is null");
        }
        if (objNames.length <= 0) {
            throw new HDF5LibraryException("H5Gget_obj_info_max(): array size is zero");
        }
        if (objMax <= 0L) {
            throw new HDF5LibraryException("H5Gget_obj_info_max(): maximum array size is zero");
        }
        if (objNames.length != objTypes.length) {
            throw new HDF5LibraryException("H5Gget_obj_info_max(): name and type array sizes are different");
        }
        return H5.H5Gget_obj_info_max(loc_id, objNames, objTypes, lnkTypes, objToken, objMax, objNames.length);
    }

    private static synchronized native int H5Gget_obj_info_max(long var0, String[] var2, int[] var3, int[] var4, H5O_token_t[] var5, long var6, int var8) throws HDF5LibraryException, NullPointerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized long H5Gn_members(long loc_id, String name) throws HDF5LibraryException, NullPointerException {
        long grp_id = H5.H5Gopen(loc_id, name, HDF5Constants.H5P_DEFAULT);
        long n = -1L;
        try {
            H5G_info_t info = H5.H5Gget_info(grp_id);
            n = info.nlinks;
        }
        finally {
            H5.H5Gclose(grp_id);
        }
        return n;
    }

    public static long H5Gopen(long loc_id, String name, long gapl_id) throws HDF5LibraryException, NullPointerException {
        long id = H5._H5Gopen2(loc_id, name, gapl_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Gopen add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Gopen2(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Gflush(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Grefresh(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Iget_file_id(long var0) throws HDF5LibraryException;

    @Deprecated
    public static synchronized native long H5Iget_name_long(long var0, String[] var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Iget_name(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Iget_ref(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Idec_ref(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Iinc_ref(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Iget_type(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Iget_type_ref(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Idec_type_ref(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Iinc_type_ref(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Inmembers(long var0) throws HDF5LibraryException;

    public static synchronized native boolean H5Iis_valid(long var0) throws HDF5LibraryException;

    public static synchronized native boolean H5Itype_exists(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Iclear_type(int var0, boolean var1) throws HDF5LibraryException;

    public static synchronized native void H5Idestroy_type(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Lcopy(long var0, String var2, long var3, String var5, long var6, long var8) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Lcreate_external(String var0, String var1, long var2, String var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Lcreate_hard(long var0, String var2, long var3, String var5, long var6, long var8) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Lcreate_soft(String var0, long var1, String var3, long var4, long var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Ldelete(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Ldelete_by_idx(long var0, String var2, int var3, int var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Lexists(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5L_info_t H5Lget_info(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5L_info_t H5Lget_info_by_idx(long var0, String var2, int var3, int var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Lget_name_by_idx(long var0, String var2, int var3, int var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Lget_value(long var0, String var2, String[] var3, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Lget_value_by_idx(long var0, String var2, int var3, int var4, long var5, String[] var7, long var8) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Literate(long var0, int var2, int var3, long var4, H5L_iterate_t var6, H5L_iterate_opdata_t var7) throws HDF5LibraryException;

    public static synchronized native int H5Literate_by_name(long var0, String var2, int var3, int var4, long var5, H5L_iterate_t var7, H5L_iterate_opdata_t var8, long var9) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Lmove(long var0, String var2, long var3, String var5, long var6, long var8) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Lvisit(long var0, int var2, int var3, H5L_iterate_t var4, H5L_iterate_opdata_t var5) throws HDF5LibraryException;

    public static synchronized native int H5Lvisit_by_name(long var0, String var2, int var3, int var4, H5L_iterate_t var5, H5L_iterate_opdata_t var6, long var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Lis_registered(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Lunregister(int var0) throws HDF5LibraryException;

    public static int H5Oclose(long object_id) throws HDF5LibraryException {
        if (object_id < 0L) {
            return 0;
        }
        log.trace("OPEN_IDS: H5Oclose remove {}", (Object)object_id);
        OPEN_IDS.remove(object_id);
        log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        return H5._H5Oclose(object_id);
    }

    private static synchronized native int _H5Oclose(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Ocopy(long var0, String var2, long var3, String var5, long var6, long var8) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Oget_comment(long var0) throws HDF5LibraryException, IllegalArgumentException;

    @Deprecated
    public static synchronized native void H5Oset_comment(long var0, String var2) throws HDF5LibraryException;

    public static synchronized native String H5Oget_comment_by_name(long var0, String var2, long var3) throws HDF5LibraryException, IllegalArgumentException, NullPointerException;

    @Deprecated
    public static synchronized native void H5Oset_comment_by_name(long var0, String var2, String var3, long var4) throws HDF5LibraryException, NullPointerException;

    public static H5O_info_t H5Oget_info(long loc_id) throws HDF5LibraryException, NullPointerException {
        return H5.H5Oget_info(loc_id, HDF5Constants.H5O_INFO_ALL);
    }

    public static synchronized native H5O_info_t H5Oget_info(long var0, int var2) throws HDF5LibraryException, NullPointerException;

    public static H5O_info_t H5Oget_info_by_idx(long loc_id, String group_name, int idx_type, int order, long n, long lapl_id) throws HDF5LibraryException, NullPointerException {
        return H5.H5Oget_info_by_idx(loc_id, group_name, idx_type, order, n, HDF5Constants.H5O_INFO_ALL, lapl_id);
    }

    public static synchronized native H5O_info_t H5Oget_info_by_idx(long var0, String var2, int var3, int var4, long var5, int var7, long var8) throws HDF5LibraryException, NullPointerException;

    public static H5O_info_t H5Oget_info_by_name(long loc_id, String name, long lapl_id) throws HDF5LibraryException, NullPointerException {
        return H5.H5Oget_info_by_name(loc_id, name, HDF5Constants.H5O_INFO_ALL, lapl_id);
    }

    public static synchronized native H5O_info_t H5Oget_info_by_name(long var0, String var2, int var3, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Olink(long var0, long var2, String var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static long H5Oopen(long loc_id, String name, long lapl_id) throws HDF5LibraryException, NullPointerException {
        long id = H5._H5Oopen(loc_id, name, lapl_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Oopen add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Oopen(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static int H5Ovisit(long obj_id, int idx_type, int order, H5O_iterate_t op, H5O_iterate_opdata_t op_data) throws HDF5LibraryException, NullPointerException {
        return H5.H5Ovisit(obj_id, idx_type, order, op, op_data, HDF5Constants.H5O_INFO_ALL);
    }

    public static synchronized native int H5Ovisit(long var0, int var2, int var3, H5O_iterate_t var4, H5O_iterate_opdata_t var5, int var6) throws HDF5LibraryException, NullPointerException;

    public static int H5Ovisit_by_name(long loc_id, String obj_name, int idx_type, int order, H5O_iterate_t op, H5O_iterate_opdata_t op_data, long lapl_id) throws HDF5LibraryException, NullPointerException {
        return H5.H5Ovisit_by_name(loc_id, obj_name, idx_type, order, op, op_data, HDF5Constants.H5O_INFO_ALL, lapl_id);
    }

    public static synchronized native int H5Ovisit_by_name(long var0, String var2, int var3, int var4, H5O_iterate_t var5, H5O_iterate_opdata_t var6, int var7, long var8) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Oexists_by_name(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Odecr_refcount(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Oincr_refcount(long var0) throws HDF5LibraryException;

    public static long H5Oopen_by_token(long loc_id, H5O_token_t token) throws HDF5LibraryException {
        long id = H5._H5Oopen_by_token(loc_id, token);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Oopen_by_token add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Oopen_by_token(long var0, H5O_token_t var2) throws HDF5LibraryException, NullPointerException;

    public static long H5Oopen_by_idx(long loc_id, String group_name, int idx_type, int order, long n, long lapl_id) throws HDF5LibraryException, NullPointerException {
        long id = H5._H5Oopen_by_idx(loc_id, group_name, idx_type, order, n, lapl_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Oopen_by_idx add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Oopen_by_idx(long var0, String var2, int var3, int var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Oflush(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Orefresh(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Odisable_mdc_flushes(long var0);

    public static synchronized native void H5Oenable_mdc_flushes(long var0);

    public static synchronized native boolean H5Oare_mdc_flushes_disabled(long var0);

    public static H5O_native_info_t H5Oget_native_info(long loc_id) throws HDF5LibraryException, NullPointerException {
        return H5.H5Oget_native_info(loc_id, HDF5Constants.H5O_NATIVE_INFO_ALL);
    }

    public static synchronized native H5O_native_info_t H5Oget_native_info(long var0, int var2) throws HDF5LibraryException, NullPointerException;

    public static H5O_native_info_t H5Oget_native_info_by_idx(long loc_id, String group_name, int idx_type, int order, long n, long lapl_id) throws HDF5LibraryException, NullPointerException {
        return H5.H5Oget_native_info_by_idx(loc_id, group_name, idx_type, order, n, HDF5Constants.H5O_NATIVE_INFO_ALL, lapl_id);
    }

    public static synchronized native H5O_native_info_t H5Oget_native_info_by_idx(long var0, String var2, int var3, int var4, long var5, int var7, long var8) throws HDF5LibraryException, NullPointerException;

    public static H5O_native_info_t H5Oget_native_info_by_name(long loc_id, String name, long lapl_id) throws HDF5LibraryException, NullPointerException {
        return H5.H5Oget_native_info_by_name(loc_id, name, HDF5Constants.H5O_NATIVE_INFO_ALL, lapl_id);
    }

    public static synchronized native H5O_native_info_t H5Oget_native_info_by_name(long var0, String var2, int var3, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Pget_class_name(long var0) throws HDF5LibraryException;

    public static long H5Pcreate(long type) throws HDF5LibraryException {
        long id = H5._H5Pcreate(type);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Pcreate add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Pcreate(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pget(long var0, String var2) throws HDF5LibraryException;

    public static synchronized native int H5Pset(long var0, String var2, int var3) throws HDF5LibraryException;

    public static synchronized native boolean H5Pexist(long var0, String var2) throws HDF5LibraryException;

    public static synchronized native long H5Pget_size(long var0, String var2) throws HDF5LibraryException;

    public static synchronized native long H5Pget_nprops(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Pget_class(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Pget_class_parent(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pequal(long var0, long var2) throws HDF5LibraryException;

    public static boolean H5P_equal(long plid1, long plid2) throws HDF5LibraryException {
        return H5.H5Pequal(plid1, plid2) == 1;
    }

    public static synchronized native int H5Pisa_class(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Pcopy_prop(long var0, long var2, String var4) throws HDF5LibraryException;

    public static synchronized native int H5Premove(long var0, String var2) throws HDF5LibraryException;

    public static synchronized native int H5Punregister(long var0, String var2) throws HDF5LibraryException;

    public static int H5Pclose_class(long plid) throws HDF5LibraryException {
        if (plid < 0L) {
            return 0;
        }
        log.trace("OPEN_IDS: H5Pclose_class remove {}", (Object)plid);
        OPEN_IDS.remove(plid);
        log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        return H5._H5Pclose_class(plid);
    }

    private static synchronized native int _H5Pclose_class(long var0) throws HDF5LibraryException;

    public static int H5Pclose(long plist) throws HDF5LibraryException {
        if (plist < 0L) {
            return 0;
        }
        log.trace("OPEN_IDS: H5Pclose remove {}", (Object)plist);
        OPEN_IDS.remove(plist);
        log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        return H5._H5Pclose(plist);
    }

    private static synchronized native int _H5Pclose(long var0) throws HDF5LibraryException;

    public static long H5Pcopy(long plist) throws HDF5LibraryException {
        long id = H5._H5Pcopy(plist);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Pcopy add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Pcopy(long var0) throws HDF5LibraryException;

    public static long H5Pcreate_class_nocb(long parent_class, String name) throws HDF5LibraryException {
        long id = H5._H5Pcreate_class_nocb(parent_class, name);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Pcreate_class_nocb add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Pcreate_class_nocb(long var0, String var2) throws HDF5LibraryException;

    public static synchronized native void H5Pregister2_nocb(long var0, String var2, long var3, byte[] var5) throws HDF5LibraryException;

    public static synchronized native void H5Pinsert2_nocb(long var0, String var2, long var3, byte[] var5) throws HDF5LibraryException;

    public static synchronized native int H5Piterate(long var0, int[] var2, H5P_iterate_cb var3, H5P_iterate_t var4) throws HDF5LibraryException;

    public static synchronized native int H5Pget_attr_phase_change(long var0, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Pset_attr_phase_change(long var0, int var2, int var3) throws HDF5LibraryException;

    public static synchronized native int H5Pget_attr_creation_order(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_attr_creation_order(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native boolean H5Pget_obj_track_times(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_obj_track_times(long var0, boolean var2) throws HDF5LibraryException;

    public static synchronized native int H5Pmodify_filter(long var0, long var2, int var4, long var5, int[] var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_filter(long var0, int var2, int var3, long var4, int[] var6) throws HDF5LibraryException;

    public static synchronized native int H5Pget_nfilters(long var0) throws HDF5LibraryException;

    public static int H5Pget_filter(long plist, int filter_number, int[] flags, long[] cd_nelmts, int[] cd_values, long namelen, String[] name, int[] filter_config) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException {
        return H5.H5Pget_filter2(plist, filter_number, flags, cd_nelmts, cd_values, namelen, name, filter_config);
    }

    private static synchronized native int H5Pget_filter2(long var0, int var2, int[] var3, long[] var4, int[] var5, long var6, String[] var8, int[] var9) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException;

    public static int H5Pget_filter_by_id(long plist_id, long filter_id, int[] flags, long[] cd_nelmts, int[] cd_values, long namelen, String[] name, int[] filter_config) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException {
        return H5.H5Pget_filter_by_id2(plist_id, filter_id, flags, cd_nelmts, cd_values, namelen, name, filter_config);
    }

    public static synchronized native int H5Pget_filter_by_id2(long var0, long var2, int[] var4, long[] var5, int[] var6, long var7, String[] var9, int[] var10) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Pall_filters_avail(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Premove_filter(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Pset_deflate(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pset_fletcher32(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_userblock(long var0, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_userblock(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_sizes(long var0, long[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_sizes(long var0, int var2, int var3) throws HDF5LibraryException;

    public static synchronized native int H5Pget_sym_k(long var0, int[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_sym_k(long var0, int var2, int var3) throws HDF5LibraryException;

    public static synchronized native int H5Pget_istore_k(long var0, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_istore_k(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_shared_mesg_nindexes(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_shared_mesg_nindexes(long var0, int var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_shared_mesg_index(long var0, int var2, int[] var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_shared_mesg_index(long var0, int var2, int var3, int var4) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_shared_mesg_phase_change(long var0, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_shared_mesg_phase_change(long var0, int var2, int var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native void H5Pset_file_space_strategy(long var0, int var2, boolean var3, long var4) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_file_space_strategy(long var0, boolean[] var2, long[] var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native boolean H5Pget_file_space_strategy_persist(long var0) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native long H5Pget_file_space_strategy_threshold(long var0) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native void H5Pset_file_space_page_size(long var0, long var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native long H5Pget_file_space_page_size(long var0) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_alignment(long var0, long[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_alignment(long var0, long var2, long var4) throws HDF5LibraryException;

    public static synchronized native long H5Pget_driver(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Pget_family_offset(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_family_offset(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_cache(long var0, int[] var2, long[] var3, long[] var4, double[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_cache(long var0, int var2, long var3, long var5, double var7) throws HDF5LibraryException;

    public static synchronized native H5AC_cache_config_t H5Pget_mdc_config(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_mdc_config(long var0, H5AC_cache_config_t var2) throws HDF5LibraryException;

    public static synchronized native boolean H5Pget_gc_references(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_gc_references(long var0, boolean var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_fclose_degree(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fclose_degree(long var0, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Pget_meta_block_size(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_meta_block_size(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native long H5Pget_sieve_buf_size(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_sieve_buf_size(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native long H5Pget_small_data_block_size(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_small_data_block_size(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_libver_bounds(long var0, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_libver_bounds(long var0, int var2, int var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_elink_file_cache_size(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_elink_file_cache_size(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native void H5Pset_mdc_log_options(long var0, boolean var2, String var3, boolean var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Pget_mdc_log_options(long var0, boolean[] var2) throws HDF5LibraryException;

    public static synchronized native long H5Pget_metadata_read_attempts(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_metadata_read_attempts(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native boolean H5Pget_evict_on_close(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_evict_on_close(long var0, boolean var2) throws HDF5LibraryException;

    public static synchronized native boolean H5Pget_use_file_locking(long var0) throws HDF5LibraryException;

    public static synchronized native boolean H5Pget_ignore_disabled_file_locking(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_file_locking(long var0, boolean var2, boolean var3) throws HDF5LibraryException;

    public static synchronized native int H5Pget_layout(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_layout(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_chunk(long var0, int var2, long[] var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_chunk(long var0, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized int H5Pset_chunk(long plist, int ndims, long[] dim) throws HDF5Exception, NullPointerException, IllegalArgumentException {
        if (dim == null) {
            return -1;
        }
        HDFArray theArray = new HDFArray(dim);
        byte[] thedims = theArray.byteify();
        int retVal = H5.H5Pset_chunk(plist, ndims, thedims);
        thedims = null;
        theArray = null;
        return retVal;
    }

    public static synchronized native void H5Pset_virtual(long var0, long var2, String var4, String var5, long var6) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native long H5Pget_virtual_count(long var0) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native long H5Pget_virtual_vspace(long var0, long var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native long H5Pget_virtual_srcspace(long var0, long var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native String H5Pget_virtual_filename(long var0, long var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native String H5Pget_virtual_dsetname(long var0, long var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_external(long var0, int var2, long var3, String[] var5, long[] var6) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_external(long var0, String var2, long var3, long var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_external_count(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_szip(long var0, int var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_shuffle(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_nbit(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_scaleoffset(long var0, int var2, int var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_fill_value(long var0, long var2, byte[] var4) throws HDF5Exception;

    public static synchronized int H5Pget_fill_value(long plist_id, long type_id, Object obj) throws HDF5Exception {
        HDFArray theArray = new HDFArray(obj);
        byte[] buf = theArray.emptyBytes();
        int status = H5.H5Pget_fill_value(plist_id, type_id, buf);
        if (status >= 0) {
            obj = theArray.arrayify(buf);
        }
        return status;
    }

    public static synchronized native int H5Pset_fill_value(long var0, long var2, byte[] var4) throws HDF5Exception;

    public static synchronized int H5Pset_fill_value(long plist_id, long type_id, Object obj) throws HDF5Exception {
        HDFArray theArray = new HDFArray(obj);
        byte[] buf = theArray.byteify();
        int retVal = H5.H5Pset_fill_value(plist_id, type_id, buf);
        buf = null;
        theArray = null;
        return retVal;
    }

    public static synchronized native int H5Pfill_value_defined(long var0, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_alloc_time(long var0, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_alloc_time(long var0, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_fill_time(long var0, int[] var2) throws HDF5LibraryException;

    public static synchronized native int H5Pset_fill_time(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native void H5Pset_chunk_opts(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_chunk_opts(long var0) throws HDF5LibraryException;

    public static synchronized native boolean H5Pget_dset_no_attrs_hint(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_dset_no_attrs_hint(long var0, boolean var2) throws HDF5LibraryException;

    public static synchronized native void H5Pget_chunk_cache(long var0, long[] var2, long[] var3, double[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Pset_chunk_cache(long var0, long var2, long var4, double var6) throws HDF5LibraryException;

    public static synchronized native void H5Pset_virtual_view(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_virtual_view(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_virtual_printf_gap(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native long H5Pget_virtual_printf_gap(long var0) throws HDF5LibraryException;

    public static synchronized native String H5Pget_virtual_prefix(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_virtual_prefix(long var0, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Pget_efile_prefix(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_efile_prefix(long var0, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Pget_data_transform(long var0, String[] var2, long var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pset_data_transform(long var0, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_buffer(long var0, byte[] var2, byte[] var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native long H5Pget_buffer_size(long var0) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native void H5Pset_buffer_size(long var0, long var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_edc_check(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_edc_check(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_btree_ratios(long var0, double[] var2, double[] var3, double[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_btree_ratios(long var0, double var2, double var4, double var6) throws HDF5LibraryException;

    public static synchronized native int H5Pget_hyper_vector_size(long var0, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_hyper_vector_size(long var0, long var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Pget_create_intermediate_group(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_create_intermediate_group(long var0, boolean var2) throws HDF5LibraryException;

    public static synchronized native long H5Pget_local_heap_size_hint(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_local_heap_size_hint(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_link_phase_change(long var0, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_link_phase_change(long var0, int var2, int var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_est_link_info(long var0, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_est_link_info(long var0, int var2, int var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_link_creation_order(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_link_creation_order(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_char_encoding(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_char_encoding(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native long H5Pget_nlinks(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_nlinks(long var0, long var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native long H5Pget_elink_prefix(long var0, String[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_elink_prefix(long var0, String var2) throws HDF5LibraryException, NullPointerException;

    public static long H5Pget_elink_fapl(long lapl_id) throws HDF5LibraryException {
        long id = H5._H5Pget_elink_fapl(lapl_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Pget_elink_fapl add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Pget_elink_fapl(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_elink_fapl(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_elink_acc_flags(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_elink_acc_flags(long var0, int var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_copy_object(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_copy_object(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native void H5Pget_fapl_core(long var0, long[] var2, boolean[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_core(long var0, long var2, boolean var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_fapl_direct(long var0, long[] var2) throws HDF5LibraryException;

    public static synchronized native int H5Pset_fapl_direct(long var0, long var2, long var4, long var6) throws HDF5LibraryException;

    public static synchronized native int H5Pget_fapl_family(long var0, long[] var2, long[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_family(long var0, long var2, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_hdfs(long var0, H5FD_hdfs_fapl_t var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5FD_hdfs_fapl_t H5Pget_fapl_hdfs(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Pget_fapl_multi(long var0, int[] var2, long[] var3, String[] var4, long[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Pset_fapl_multi(long var0, int[] var2, long[] var3, String[] var4, long[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Pset_fapl_log(long var0, String var2, long var3, long var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_sec2(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Pset_fapl_split(long var0, String var2, long var3, String var5, long var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_stdio(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_windows(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_ros3(long var0, H5FD_ros3_fapl_t var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5FD_ros3_fapl_t H5Pget_fapl_ros3(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5PLset_loading_state(int var0) throws HDF5LibraryException;

    public static synchronized native int H5PLget_loading_state() throws HDF5LibraryException;

    public static synchronized native void H5PLappend(String var0) throws HDF5LibraryException;

    public static synchronized native void H5PLprepend(String var0) throws HDF5LibraryException;

    public static synchronized native void H5PLreplace(String var0, int var1) throws HDF5LibraryException;

    public static synchronized native void H5PLinsert(String var0, int var1) throws HDF5LibraryException;

    public static synchronized native void H5PLremove(int var0) throws HDF5LibraryException;

    public static synchronized native String H5PLget(int var0) throws HDF5LibraryException;

    public static synchronized native int H5PLsize() throws HDF5LibraryException;

    private static synchronized native int H5Rcreate(byte[] var0, long var1, String var3, int var4, long var5) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized byte[] H5Rcreate(long loc_id, String name, int ref_type, long space_id) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        int ref_size = 8;
        if (ref_type == HDF5Constants.H5R_DATASET_REGION) {
            ref_size = 12;
        }
        byte[] rbuf = new byte[ref_size];
        H5.H5Rcreate(rbuf, loc_id, name, ref_type, space_id);
        return rbuf;
    }

    public static long H5Rdereference(long dataset, long access_list, int ref_type, byte[] ref) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        long id = H5._H5Rdereference(dataset, access_list, ref_type, ref);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Rdereference add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Rdereference(long var0, long var2, int var4, byte[] var5) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native long H5Rget_name(long var0, int var2, byte[] var3, String[] var4, long var5) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native String H5Rget_name_string(long var0, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Rget_obj_type(long var0, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    private static synchronized native int H5Rget_obj_type2(long var0, int var2, byte[] var3, int[] var4) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static long H5Rget_region(long loc_id, int ref_type, byte[] ref) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        long id = H5._H5Rget_region(loc_id, ref_type, ref);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Rget_region add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Rget_region(long var0, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native byte[] H5Rcreate_object(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native byte[] H5Rcreate_region(long var0, String var2, long var3, long var5) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native byte[] H5Rcreate_attr(long var0, String var2, String var3, long var4) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native void H5Rdestroy(byte[] var0) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Rget_type(byte[] var0) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native boolean H5Requal(byte[] var0, byte[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native byte[] H5Rcopy(byte[] var0) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static long H5Ropen_object(byte[] ref_ptr, long rapl_id, long oapl_id) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        long id = H5._H5Ropen_object(ref_ptr, rapl_id, oapl_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Ropen_object add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Ropen_object(byte[] var0, long var1, long var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static long H5Ropen_region(byte[] ref_ptr, long rapl_id, long oapl_id) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        long id = H5._H5Ropen_region(ref_ptr, rapl_id, oapl_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Ropen_region add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Ropen_region(byte[] var0, long var1, long var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static long H5Ropen_attr(byte[] ref_ptr, long rapl_id, long aapl_id) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        long id = H5._H5Ropen_attr(ref_ptr, rapl_id, aapl_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Ropen_attr add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Ropen_attr(byte[] var0, long var1, long var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Rget_obj_type3(byte[] var0, long var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native String H5Rget_file_name(byte[] var0) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native String H5Rget_obj_name(byte[] var0, long var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native String H5Rget_attr_name(byte[] var0) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static long H5Screate(int type) throws HDF5LibraryException {
        long id = H5._H5Screate(type);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Screate add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Screate(int var0) throws HDF5LibraryException;

    public static long H5Screate_simple(int rank, long[] dims, long[] maxdims) throws HDF5Exception, NullPointerException {
        long id = H5._H5Screate_simple(rank, dims, maxdims);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Screate_simple add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Screate_simple(int var0, long[] var1, long[] var2) throws HDF5Exception, NullPointerException;

    public static synchronized native long H5Sset_extent_simple(long var0, int var2, long[] var3, long[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized long H5Sset_extent_simple(long space_id, int rank, byte[] current_size, byte[] maximum_size) throws HDF5LibraryException, NullPointerException {
        ByteBuffer csbb = ByteBuffer.wrap(current_size);
        long[] lacs = csbb.asLongBuffer().array();
        ByteBuffer maxsbb = ByteBuffer.wrap(maximum_size);
        long[] lamaxs = maxsbb.asLongBuffer().array();
        return H5.H5Sset_extent_simple(space_id, rank, lacs, lamaxs);
    }

    public static long H5Scopy(long space_id) throws HDF5LibraryException {
        long id = H5._H5Scopy(space_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Scopy add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Scopy(long var0) throws HDF5LibraryException;

    public static int H5Sclose(long space_id) throws HDF5LibraryException {
        if (space_id < 0L) {
            return 0;
        }
        log.trace("OPEN_IDS: H5Sclose remove {}", (Object)space_id);
        OPEN_IDS.remove(space_id);
        log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        return H5._H5Sclose(space_id);
    }

    private static synchronized native int _H5Sclose(long var0) throws HDF5LibraryException;

    public static synchronized native byte[] H5Sencode(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Sdecode(byte[] var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Sget_simple_extent_npoints(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_simple_extent_ndims(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_simple_extent_dims(long var0, long[] var2, long[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Sis_simple(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_simple_extent_type(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Sset_extent_none(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Sextent_copy(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native boolean H5Sextent_equal(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Sget_select_type(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Sget_select_npoints(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Sselect_copy(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native boolean H5Sselect_valid(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Sselect_adjust(long var0, long[][] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Sget_select_bounds(long var0, long[] var2, long[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Sselect_shape_same(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native boolean H5Sselect_intersect_block(long var0, long[] var2, long[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Soffset_simple(long var0, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Soffset_simple(long space_id, long[] offset) throws HDF5Exception, NullPointerException {
        if (offset == null) {
            return -1;
        }
        HDFArray theArray = new HDFArray(offset);
        byte[] theArr = theArray.byteify();
        int retVal = H5.H5Soffset_simple(space_id, theArr);
        theArr = null;
        theArray = null;
        return retVal;
    }

    public static synchronized native int H5Sselect_all(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Sselect_none(long var0) throws HDF5LibraryException;

    private static synchronized native int H5Sselect_elements(long var0, int var2, int var3, byte[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Sselect_elements(long space_id, int op, int num_elements, long[][] coord2D) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        if (coord2D == null) {
            return -1;
        }
        HDFArray theArray = new HDFArray(coord2D);
        byte[] coord = theArray.byteify();
        int retVal = H5.H5Sselect_elements(space_id, op, num_elements, coord);
        coord = null;
        theArray = null;
        return retVal;
    }

    public static synchronized native long H5Sget_select_elem_npoints(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_select_elem_pointlist(long var0, long var2, long var4, long[] var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Sselect_hyperslab(long space_id, int op, byte[] start, byte[] stride, byte[] count, byte[] block) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        ByteBuffer startbb = ByteBuffer.wrap(start);
        long[] lastart = startbb.asLongBuffer().array();
        ByteBuffer stridebb = ByteBuffer.wrap(stride);
        long[] lastride = stridebb.asLongBuffer().array();
        ByteBuffer countbb = ByteBuffer.wrap(count);
        long[] lacount = countbb.asLongBuffer().array();
        ByteBuffer blockbb = ByteBuffer.wrap(block);
        long[] lablock = blockbb.asLongBuffer().array();
        return H5.H5Sselect_hyperslab(space_id, op, lastart, lastride, lacount, lablock);
    }

    public static synchronized native int H5Sselect_hyperslab(long var0, int var2, long[] var3, long[] var4, long[] var5, long[] var6) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native long H5Scombine_hyperslab(long var0, int var2, long[] var3, long[] var4, long[] var5, long[] var6) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native void H5Smodify_select(long var0, int var2, long var3) throws HDF5LibraryException;

    public static synchronized native long H5Scombine_select(long var0, int var2, long var3) throws HDF5LibraryException;

    public static synchronized native boolean H5Sis_regular_hyperslab(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Sget_regular_hyperslab(long var0, long[] var2, long[] var3, long[] var4, long[] var5) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native long H5Sget_select_hyper_nblocks(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_select_hyper_blocklist(long var0, long var2, long var4, long[] var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Sselect_project_intersection(long var0, long var2, long var4) throws HDF5LibraryException;

    public static long H5Tarray_create(long base_id, int ndims, long[] dim) throws HDF5LibraryException, NullPointerException {
        long id = H5._H5Tarray_create2(base_id, ndims, dim);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Tarray_create add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Tarray_create2(long var0, int var2, long[] var3) throws HDF5LibraryException, NullPointerException;

    public static int H5Tclose(long type_id) throws HDF5LibraryException {
        if (type_id < 0L) {
            return 0;
        }
        log.trace("OPEN_IDS: H5Tclose remove {}", (Object)type_id);
        OPEN_IDS.remove(type_id);
        log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        return H5._H5Tclose(type_id);
    }

    private static synchronized native int _H5Tclose(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Tcommit(long var0, String var2, long var3, long var5, long var7, long var9) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Tcommit_anon(long var0, long var2, long var4, long var6) throws HDF5LibraryException;

    public static synchronized native boolean H5Tcommitted(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Tcompiler_conv(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native void H5Tconvert(long var0, long var2, long var4, byte[] var6, byte[] var7, long var8) throws HDF5LibraryException, NullPointerException;

    public static long H5Tcopy(long type_id) throws HDF5LibraryException {
        long id = H5._H5Tcopy(type_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Tcopy add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Tcopy(long var0) throws HDF5LibraryException;

    public static long H5Tcreate(int tclass, long size) throws HDF5LibraryException {
        long id = H5._H5Tcreate(tclass, size);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Tcreate add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Tcreate(int var0, long var1) throws HDF5LibraryException;

    public static long H5Tdecode(byte[] buf) throws HDF5LibraryException, NullPointerException {
        long id = H5._H5Tdecode(buf);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Tdecode add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Tdecode(byte[] var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Tdetect_class(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Tencode(long var0, byte[] var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static long H5Tenum_create(long base_id) throws HDF5LibraryException {
        long id = H5._H5Tenum_create(base_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Tenum_create add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Tenum_create(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Tenum_insert(long var0, String var2, byte[] var3) throws HDF5LibraryException, NullPointerException;

    public static int H5Tenum_insert(long type, String name, int[] value) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tenum_insert_int(type, name, value);
    }

    public static int H5Tenum_insert(long type, String name, int value) throws HDF5LibraryException, NullPointerException {
        int[] val = new int[]{value};
        return H5.H5Tenum_insert_int(type, name, val);
    }

    private static synchronized native int H5Tenum_insert_int(long var0, String var2, int[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Tenum_nameof(long var0, byte[] var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static int H5Tenum_nameof(long type, int[] value, String[] name, int size) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tenum_nameof_int(type, value, name, size);
    }

    private static synchronized native int H5Tenum_nameof_int(long var0, int[] var2, String[] var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Tenum_valueof(long var0, String var2, byte[] var3) throws HDF5LibraryException, NullPointerException;

    public static int H5Tenum_valueof(long type, String name, int[] value) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tenum_valueof_int(type, name, value);
    }

    private static synchronized native int H5Tenum_valueof_int(long var0, String var2, int[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Tequal(long var0, long var2) throws HDF5LibraryException;

    public static int H5Tget_array_dims(long type_id, long[] dims) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tget_array_dims2(type_id, dims);
    }

    public static synchronized native int H5Tget_array_dims2(long var0, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tget_array_ndims(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tget_class(long var0) throws HDF5LibraryException;

    public static String H5Tget_class_name(long class_id) {
        String retValue = null;
        retValue = (long)HDF5Constants.H5T_INTEGER == class_id ? "H5T_INTEGER" : ((long)HDF5Constants.H5T_FLOAT == class_id ? "H5T_FLOAT" : ((long)HDF5Constants.H5T_TIME == class_id ? "H5T_TIME" : ((long)HDF5Constants.H5T_STRING == class_id ? "H5T_STRING" : ((long)HDF5Constants.H5T_BITFIELD == class_id ? "H5T_BITFIELD" : ((long)HDF5Constants.H5T_OPAQUE == class_id ? "H5T_OPAQUE" : ((long)HDF5Constants.H5T_COMPOUND == class_id ? "H5T_COMPOUND" : ((long)HDF5Constants.H5T_REFERENCE == class_id ? "H5T_REFERENCE" : ((long)HDF5Constants.H5T_ENUM == class_id ? "H5T_ENUM" : ((long)HDF5Constants.H5T_VLEN == class_id ? "H5T_VLEN" : ((long)HDF5Constants.H5T_ARRAY == class_id ? "H5T_ARRAY" : "H5T_NO_CLASS"))))))))));
        return retValue;
    }

    public static long H5Tget_create_plist(long type_id) throws HDF5LibraryException {
        long id = H5._H5Tget_create_plist(type_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: _H5Tget_create_plist add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Tget_create_plist(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tget_cset(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_cset(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_ebias(long var0) throws HDF5LibraryException;

    public static int H5Tset_ebias(long type_id, int ebias) throws HDF5LibraryException {
        H5.H5Tset_ebias(type_id, (long)ebias);
        return 0;
    }

    public static synchronized native long H5Tget_ebias_long(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Tset_ebias(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native void H5Tget_fields(long var0, long[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static int H5Tget_fields(long type_id, int[] fields) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        return H5.H5Tget_fields_int(type_id, fields);
    }

    private static synchronized native int H5Tget_fields_int(long var0, int[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native void H5Tset_fields(long var0, long var2, long var4, long var6, long var8, long var10) throws HDF5LibraryException;

    public static int H5Tset_fields(long type_id, int spos, int epos, int esize, int mpos, int msize) throws HDF5LibraryException {
        H5.H5Tset_fields(type_id, (long)spos, (long)epos, (long)esize, (long)mpos, (long)msize);
        return 0;
    }

    public static synchronized native int H5Tget_inpad(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_inpad(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_member_class(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_member_index(long var0, String var2) throws HDF5LibraryException;

    public static synchronized native String H5Tget_member_name(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native long H5Tget_member_offset(long var0, int var2);

    public static long H5Tget_member_type(long type_id, int field_idx) throws HDF5LibraryException {
        long id = H5._H5Tget_member_type(type_id, field_idx);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Tget_member_type add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Tget_member_type(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native void H5Tget_member_value(long var0, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException;

    public static int H5Tget_member_value(long type_id, int membno, int[] value) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tget_member_value_int(type_id, membno, value);
    }

    private static synchronized native int H5Tget_member_value_int(long var0, int var2, int[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized long H5Tget_native_type(long type_id) throws HDF5LibraryException {
        return H5.H5Tget_native_type(type_id, HDF5Constants.H5T_DIR_ASCEND);
    }

    public static long H5Tget_native_type(long type_id, int direction) throws HDF5LibraryException {
        long id = H5._H5Tget_native_type(type_id, direction);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Tget_native_type add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Tget_native_type(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_nmembers(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tget_norm(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_norm(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_offset(long var0) throws HDF5LibraryException;

    public static int H5Tset_offset(long type_id, int offset) throws HDF5LibraryException {
        H5.H5Tset_offset(type_id, (long)offset);
        return 0;
    }

    public static synchronized native void H5Tset_offset(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_order(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_order(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_pad(long var0, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tset_pad(long var0, int var2, int var3) throws HDF5LibraryException;

    public static synchronized native int H5Tget_precision(long var0) throws HDF5LibraryException;

    public static int H5Tset_precision(long type_id, int precision) throws HDF5LibraryException {
        H5.H5Tset_precision(type_id, (long)precision);
        return 0;
    }

    public static synchronized native long H5Tget_precision_long(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Tset_precision(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_sign(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_sign(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native long H5Tget_size(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_size(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_strpad(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_strpad(long var0, int var2) throws HDF5LibraryException;

    public static long H5Tget_super(long type) throws HDF5LibraryException {
        long id = H5._H5Tget_super(type);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Tget_super add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Tget_super(long var0) throws HDF5LibraryException;

    public static synchronized native String H5Tget_tag(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_tag(long var0, String var2) throws HDF5LibraryException;

    public static synchronized native int H5Tinsert(long var0, String var2, long var3, long var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Tis_variable_str(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tlock(long var0) throws HDF5LibraryException;

    public static long H5Topen(long loc_id, String name, long tapl_id) throws HDF5LibraryException, NullPointerException {
        long id = H5._H5Topen2(loc_id, name, tapl_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Topen add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Topen2(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tpack(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Treclaim(long var0, long var2, long var4, byte[] var6) throws HDF5LibraryException, NullPointerException;

    public static long H5Tvlen_create(long base_id) throws HDF5LibraryException {
        long id = H5._H5Tvlen_create(base_id);
        if (id > 0L) {
            log.trace("OPEN_IDS: H5Tvlen_create add {}", (Object)id);
            OPEN_IDS.add(id);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return id;
    }

    private static synchronized native long _H5Tvlen_create(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Tflush(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Trefresh(long var0) throws HDF5LibraryException;

    public static synchronized native long H5VLregister_connector_by_name(String var0, long var1) throws HDF5LibraryException;

    public static synchronized native long H5VLregister_connector_by_value(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native boolean H5VLis_connector_registered_by_name(String var0) throws HDF5LibraryException;

    public static synchronized native boolean H5VLis_connector_registered_by_value(int var0) throws HDF5LibraryException;

    public static synchronized native long H5VLget_connector_id(long var0) throws HDF5LibraryException;

    public static synchronized native long H5VLget_connector_id_by_name(String var0) throws HDF5LibraryException;

    public static synchronized native long H5VLget_connector_id_by_value(int var0) throws HDF5LibraryException;

    public static synchronized native String H5VLget_connector_name(long var0) throws HDF5LibraryException;

    public static synchronized native void H5VLclose(long var0) throws HDF5LibraryException;

    public static synchronized native void H5VLunregister_connector(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Zfilter_avail(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Zget_filter_info(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Zunregister(int var0) throws HDF5LibraryException;

    static {
        isLibraryLoaded = false;
        OPEN_IDS = new LinkedHashSet();
        H5.loadH5Lib();
    }
}

