// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.avutil;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.ffmpeg.global.avutil.*;


/**
 * May be set as default_val for AV_OPT_TYPE_FLAG_ARRAY options.
 */
@Properties(inherit = org.bytedeco.ffmpeg.presets.avutil.class)
public class AVOptionArrayDef extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AVOptionArrayDef() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AVOptionArrayDef(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AVOptionArrayDef(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AVOptionArrayDef position(long position) {
        return (AVOptionArrayDef)super.position(position);
    }
    @Override public AVOptionArrayDef getPointer(long i) {
        return new AVOptionArrayDef((Pointer)this).offsetAddress(i);
    }

    /**
     * Native access only.
     *
     * Default value of the option, as would be serialized by av_opt_get() (i.e.
     * using the value of sep as the separator).
     */
    public native @Cast("const char*") BytePointer def(); public native AVOptionArrayDef def(BytePointer setter);

    /**
     * Minimum number of elements in the array. When this field is non-zero, def
     * must be non-NULL and contain at least this number of elements.
     */
    public native @Cast("unsigned") int size_min(); public native AVOptionArrayDef size_min(int setter);
    /**
     * Maximum number of elements in the array, 0 when unlimited.
     */
    public native @Cast("unsigned") int size_max(); public native AVOptionArrayDef size_max(int setter);

    /**
     * Separator between array elements in string representations of this
     * option, used by av_opt_set() and av_opt_get(). It must be a printable
     * ASCII character, excluding alphanumeric and the backslash. A comma is
     * used when sep=0.
     *
     * The separator and the backslash must be backslash-escaped in order to
     * appear in string representations of the option value.
     */
    public native @Cast("char") byte sep(); public native AVOptionArrayDef sep(byte setter);
}
