// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.avutil;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.ffmpeg.global.avutil.*;


/**
 * This structure describes optional metadata relevant to a downmix procedure.
 *
 * All fields are set by the decoder to the value indicated in the audio
 * bitstream (if present), or to a "sane" default otherwise.
 */
@Properties(inherit = org.bytedeco.ffmpeg.presets.avutil.class)
public class AVDownmixInfo extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AVDownmixInfo() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AVDownmixInfo(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AVDownmixInfo(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AVDownmixInfo position(long position) {
        return (AVDownmixInfo)super.position(position);
    }
    @Override public AVDownmixInfo getPointer(long i) {
        return new AVDownmixInfo((Pointer)this).offsetAddress(i);
    }

    /**
     * Type of downmix preferred by the mastering engineer.
     */
    public native @Cast("AVDownmixType") int preferred_downmix_type(); public native AVDownmixInfo preferred_downmix_type(int setter);

    /**
     * Absolute scale factor representing the nominal level of the center
     * channel during a regular downmix.
     */
    public native double center_mix_level(); public native AVDownmixInfo center_mix_level(double setter);

    /**
     * Absolute scale factor representing the nominal level of the center
     * channel during an Lt/Rt compatible downmix.
     */
    public native double center_mix_level_ltrt(); public native AVDownmixInfo center_mix_level_ltrt(double setter);

    /**
     * Absolute scale factor representing the nominal level of the surround
     * channels during a regular downmix.
     */
    public native double surround_mix_level(); public native AVDownmixInfo surround_mix_level(double setter);

    /**
     * Absolute scale factor representing the nominal level of the surround
     * channels during an Lt/Rt compatible downmix.
     */
    public native double surround_mix_level_ltrt(); public native AVDownmixInfo surround_mix_level_ltrt(double setter);

    /**
     * Absolute scale factor representing the level at which the LFE data is
     * mixed into L/R channels during downmixing.
     */
    public native double lfe_mix_level(); public native AVDownmixInfo lfe_mix_level(double setter);
}
