// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.avutil;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.ffmpeg.global.avutil.*;


/**
 * \}
 */

/**
 * An AVChannelCustom defines a single channel within a custom order layout
 *
 * Unlike most structures in FFmpeg, sizeof(AVChannelCustom) is a part of the
 * public ABI.
 *
 * No new fields may be added to it without a major version bump.
 */
@Properties(inherit = org.bytedeco.ffmpeg.presets.avutil.class)
public class AVChannelCustom extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AVChannelCustom() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AVChannelCustom(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AVChannelCustom(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AVChannelCustom position(long position) {
        return (AVChannelCustom)super.position(position);
    }
    @Override public AVChannelCustom getPointer(long i) {
        return new AVChannelCustom((Pointer)this).offsetAddress(i);
    }

    public native @Cast("AVChannel") int id(); public native AVChannelCustom id(int setter);
    public native @Cast("char") byte name(int i); public native AVChannelCustom name(int i, byte setter);
    @MemberGetter public native @Cast("char*") BytePointer name();
    public native Pointer opaque(); public native AVChannelCustom opaque(Pointer setter);
}
