// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.avformat;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.ffmpeg.avutil.*;
import static org.bytedeco.ffmpeg.global.avutil.*;
import org.bytedeco.ffmpeg.swresample.*;
import static org.bytedeco.ffmpeg.global.swresample.*;
import org.bytedeco.ffmpeg.avcodec.*;
import static org.bytedeco.ffmpeg.global.avcodec.*;

import static org.bytedeco.ffmpeg.global.avformat.*;


@Properties(inherit = org.bytedeco.ffmpeg.presets.avformat.class)
public class AVStreamGroup extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AVStreamGroup() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AVStreamGroup(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AVStreamGroup(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AVStreamGroup position(long position) {
        return (AVStreamGroup)super.position(position);
    }
    @Override public AVStreamGroup getPointer(long i) {
        return new AVStreamGroup((Pointer)this).offsetAddress(i);
    }

    /**
     * A class for \ref avoptions. Set by avformat_stream_group_create().
     */
    public native @Const AVClass av_class(); public native AVStreamGroup av_class(AVClass setter);

    public native Pointer priv_data(); public native AVStreamGroup priv_data(Pointer setter);

    /**
     * Group index in AVFormatContext.
     */
    public native @Cast("unsigned int") int index(); public native AVStreamGroup index(int setter);

    /**
     * Group type-specific group ID.
     *
     * decoding: set by libavformat
     * encoding: may set by the user
     */
    public native @Cast("int64_t") long id(); public native AVStreamGroup id(long setter);

    /**
     * Group type
     *
     * decoding: set by libavformat on group creation
     * encoding: set by avformat_stream_group_create()
     */
    public native @Cast("AVStreamGroupParamsType") int type(); public native AVStreamGroup type(int setter);

    /**
     * Group type-specific parameters
     */
        @Name("params.iamf_audio_element") public native AVIAMFAudioElement params_iamf_audio_element(); public native AVStreamGroup params_iamf_audio_element(AVIAMFAudioElement setter);
        @Name("params.iamf_mix_presentation") public native AVIAMFMixPresentation params_iamf_mix_presentation(); public native AVStreamGroup params_iamf_mix_presentation(AVIAMFMixPresentation setter);
        @Name("params.tile_grid") public native AVStreamGroupTileGrid params_tile_grid(); public native AVStreamGroup params_tile_grid(AVStreamGroupTileGrid setter);
        @Name("params.lcevc") public native AVStreamGroupLCEVC params_lcevc(); public native AVStreamGroup params_lcevc(AVStreamGroupLCEVC setter);

    /**
     * Metadata that applies to the whole group.
     *
     * - demuxing: set by libavformat on group creation
     * - muxing: may be set by the caller before avformat_write_header()
     *
     * Freed by libavformat in avformat_free_context().
     */
    public native AVDictionary metadata(); public native AVStreamGroup metadata(AVDictionary setter);

    /**
     * Number of elements in AVStreamGroup.streams.
     *
     * Set by avformat_stream_group_add_stream() must not be modified by any other code.
     */
    public native @Cast("unsigned int") int nb_streams(); public native AVStreamGroup nb_streams(int setter);

    /**
     * A list of streams in the group. New entries are created with
     * avformat_stream_group_add_stream().
     *
     * - demuxing: entries are created by libavformat on group creation.
     *             If AVFMTCTX_NOHEADER is set in ctx_flags, then new entries may also
     *             appear in av_read_frame().
     * - muxing: entries are created by the user before avformat_write_header().
     *
     * Freed by libavformat in avformat_free_context().
     */
    public native AVStream streams(int i); public native AVStreamGroup streams(int i, AVStream setter);
    public native @Cast("AVStream**") PointerPointer streams(); public native AVStreamGroup streams(PointerPointer setter);

    /**
     * Stream group disposition - a combination of AV_DISPOSITION_* flags.
     * This field currently applies to all defined AVStreamGroupParamsType.
     *
     * - demuxing: set by libavformat when creating the group or in
     *             avformat_find_stream_info().
     * - muxing: may be set by the caller before avformat_write_header().
     */
    public native int disposition(); public native AVStreamGroup disposition(int setter);
}
