// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.avfilter;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.ffmpeg.avutil.*;
import static org.bytedeco.ffmpeg.global.avutil.*;
import org.bytedeco.ffmpeg.swresample.*;
import static org.bytedeco.ffmpeg.global.swresample.*;
import org.bytedeco.ffmpeg.avcodec.*;
import static org.bytedeco.ffmpeg.global.avcodec.*;
import org.bytedeco.ffmpeg.avformat.*;
import static org.bytedeco.ffmpeg.global.avformat.*;
import org.bytedeco.ffmpeg.postproc.*;
import static org.bytedeco.ffmpeg.global.postproc.*;
import org.bytedeco.ffmpeg.swscale.*;
import static org.bytedeco.ffmpeg.global.swscale.*;

import static org.bytedeco.ffmpeg.global.avfilter.*;


/**
 * A link between two filters. This contains pointers to the source and
 * destination filters between which this link exists, and the indexes of
 * the pads involved. In addition, this link also contains the parameters
 * which have been negotiated and agreed upon between the filter, such as
 * image dimensions, format, etc.
 *
 * Applications must not normally access the link structure directly.
 * Use the buffersrc and buffersink API instead.
 * In the future, access to the header may be reserved for filters
 * implementation.
 */
@Properties(inherit = org.bytedeco.ffmpeg.presets.avfilter.class)
public class AVFilterLink extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AVFilterLink() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AVFilterLink(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AVFilterLink(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AVFilterLink position(long position) {
        return (AVFilterLink)super.position(position);
    }
    @Override public AVFilterLink getPointer(long i) {
        return new AVFilterLink((Pointer)this).offsetAddress(i);
    }

    /** source filter */
    public native AVFilterContext src(); public native AVFilterLink src(AVFilterContext setter);
    /** output pad on the source filter */
    public native AVFilterPad srcpad(); public native AVFilterLink srcpad(AVFilterPad setter);

    /** dest filter */
    public native AVFilterContext dst(); public native AVFilterLink dst(AVFilterContext setter);
    /** input pad on the dest filter */
    public native AVFilterPad dstpad(); public native AVFilterLink dstpad(AVFilterPad setter);

    /** filter media type */
    public native @Cast("AVMediaType") int type(); public native AVFilterLink type(int setter);

    /** agreed upon media format */
    public native int format(); public native AVFilterLink format(int setter);

    /* These parameters apply only to video */
    /** agreed upon image width */
    public native int w(); public native AVFilterLink w(int setter);
    /** agreed upon image height */
    public native int h(); public native AVFilterLink h(int setter);
    /** agreed upon sample aspect ratio */
    public native @ByRef AVRational sample_aspect_ratio(); public native AVFilterLink sample_aspect_ratio(AVRational setter);
    /**
     * For non-YUV links, these are respectively set to fallback values (as
     * appropriate for that colorspace).
     *
     * Note: This includes grayscale formats, as these are currently treated
     * as forced full range always.
     */
    /** agreed upon YUV color space */
    public native @Cast("AVColorSpace") int colorspace(); public native AVFilterLink colorspace(int setter);
    /** agreed upon YUV color range */
    public native @Cast("AVColorRange") int color_range(); public native AVFilterLink color_range(int setter);

    /* These parameters apply only to audio */
    /** samples per second */
    public native int sample_rate(); public native AVFilterLink sample_rate(int setter);
    /** channel layout of current buffer (see libavutil/channel_layout.h) */
    public native @ByRef AVChannelLayout ch_layout(); public native AVFilterLink ch_layout(AVChannelLayout setter);

    /**
     * Define the time base used by the PTS of the frames/samples
     * which will pass through this link.
     * During the configuration stage, each filter is supposed to
     * change only the output timebase, while the timebase of the
     * input link is assumed to be an unchangeable property.
     */
    public native @ByRef AVRational time_base(); public native AVFilterLink time_base(AVRational setter);

    /*****************************************************************
     * All fields below this line are not part of the public API. They
     * may not be used outside of libavfilter and can be changed and
     * removed at will.
     * New public fields should be added right above.
     *****************************************************************
     */

    /**
     * Lists of supported formats / etc. supported by the input filter.
     */
    public native @ByRef AVFilterFormatsConfig incfg(); public native AVFilterLink incfg(AVFilterFormatsConfig setter);

    /**
     * Lists of supported formats / etc. supported by the output filter.
     */
    public native @ByRef AVFilterFormatsConfig outcfg(); public native AVFilterLink outcfg(AVFilterFormatsConfig setter);
}
