/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event.annotation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventTopicSubscriber;
import org.bushe.swing.event.annotation.AbstractProxySubscriber;
import org.bushe.swing.event.annotation.ReferenceStrength;

public class ProxyTopicSubscriber
extends AbstractProxySubscriber
implements EventTopicSubscriber {
    private String topic;

    public ProxyTopicSubscriber(Object proxiedSubscriber, Method subscriptionMethod, ReferenceStrength referenceStrength, EventService es, String topic) {
        this(proxiedSubscriber, subscriptionMethod, referenceStrength, 0, es, topic);
    }

    public ProxyTopicSubscriber(Object proxiedSubscriber, Method subscriptionMethod, ReferenceStrength referenceStrength, int priority, EventService es, String topic) {
        super(proxiedSubscriber, subscriptionMethod, referenceStrength, priority, es);
        this.topic = topic;
        Class<?>[] params = subscriptionMethod.getParameterTypes();
        if (params == null || params.length != 2 || !String.class.equals(params[0]) || params[1].isPrimitive()) {
            throw new IllegalArgumentException("The subscriptionMethod must have the two parameters, the first one must be a String and the second a non-primitive (Object or derivative).");
        }
    }

    public void onEvent(String topic, Object data) {
        Object[] args = new Object[]{topic, data};
        Object obj = null;
        Method subscriptionMethod = null;
        try {
            obj = this.getProxiedSubscriber();
            if (obj == null) {
                return;
            }
            subscriptionMethod = this.getSubscriptionMethod();
            subscriptionMethod.invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            String message = "IllegalAccessException when invoking annotated method from EventService publication.  Topic:" + topic + ", data:" + data + ", subscriber:" + this.getProxiedSubscriber() + ", subscription Method=" + this.getSubscriptionMethod();
            this.retryReflectiveCallUsingAccessibleObject(args, subscriptionMethod, obj, e, message);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("InvocationTargetException when invoking annotated method from EventService publication.  Topic:" + topic + ", data:" + data + ", subscriber:" + this.getProxiedSubscriber() + ", subscription Method=" + this.getSubscriptionMethod(), e);
        }
    }

    protected void unsubscribe(String topic) {
        this.getEventService().unsubscribe(topic, (EventTopicSubscriber)this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProxyTopicSubscriber) {
            if (!super.equals(obj)) {
                return false;
            }
            ProxyTopicSubscriber proxyTopicSubscriber = (ProxyTopicSubscriber)obj;
            if (this.topic != proxyTopicSubscriber.topic) {
                if (this.topic == null) {
                    return false;
                }
                if (!this.topic.equals(proxyTopicSubscriber.topic)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "ProxyTopicSubscriber{topic='" + this.topic + '\'' + "realSubscriber=" + this.getProxiedSubscriber() + ", subscriptionMethod=" + this.getSubscriptionMethod() + ", referenceStrength=" + (Object)((Object)this.getReferenceStrength()) + ", eventService=" + this.getEventService() + '}';
    }
}

