/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event;

import java.util.HashMap;
import java.util.Map;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventServiceExistsException;
import org.bushe.swing.event.SwingEventService;

public class EventServiceLocator {
    public static final String SERVICE_NAME_EVENT_BUS = "EventBus";
    public static final String SERVICE_NAME_SWING_EVENT_SERVICE = "SwingEventService";
    public static final String EVENT_BUS_CLASS = "org.bushe.swing.event.eventBusClass";
    public static final String SWING_EVENT_SERVICE_CLASS = "org.bushe.swing.event.swingEventServiceClass";
    private static EventService EVENT_BUS_SERVICE;
    private static EventService SWING_EVENT_SERVICE;
    private static final Map EVENT_SERVICES;

    public static synchronized EventService getEventBusService() {
        if (EVENT_BUS_SERVICE == null) {
            EVENT_BUS_SERVICE = EventServiceLocator.getEventService(EVENT_BUS_CLASS, EventServiceLocator.getSwingEventService());
            EVENT_SERVICES.put(SERVICE_NAME_EVENT_BUS, EVENT_BUS_SERVICE);
        }
        return EVENT_BUS_SERVICE;
    }

    public static synchronized EventService getSwingEventService() {
        if (SWING_EVENT_SERVICE == null) {
            SWING_EVENT_SERVICE = EventServiceLocator.getEventService(SWING_EVENT_SERVICE_CLASS, new SwingEventService());
            EVENT_SERVICES.put(SERVICE_NAME_SWING_EVENT_SERVICE, SWING_EVENT_SERVICE);
        }
        return SWING_EVENT_SERVICE;
    }

    public static synchronized EventService getEventService(String serviceName) {
        EventService es = (EventService)EVENT_SERVICES.get(serviceName);
        if (es == null) {
            if (SERVICE_NAME_EVENT_BUS.equals(serviceName)) {
                es = EventServiceLocator.getEventBusService();
            } else if (SERVICE_NAME_SWING_EVENT_SERVICE.equals(serviceName)) {
                es = EventServiceLocator.getSwingEventService();
            }
        }
        return es;
    }

    public static synchronized void setEventService(String serviceName, EventService es) throws EventServiceExistsException {
        if (EVENT_SERVICES.get(serviceName) != null && es != null) {
            throw new EventServiceExistsException("An event service by the name " + serviceName + "already exists.  Perhaps multiple threads tried to create a service about the same time?");
        }
        EVENT_SERVICES.put(serviceName, es);
        if (SERVICE_NAME_EVENT_BUS.equals(serviceName)) {
            EVENT_BUS_SERVICE = es;
        } else if (SERVICE_NAME_SWING_EVENT_SERVICE.equals(serviceName)) {
            SWING_EVENT_SERVICE = es;
        }
    }

    static synchronized void clearAll() {
        EVENT_SERVICES.clear();
        EVENT_BUS_SERVICE = null;
        SWING_EVENT_SERVICE = null;
    }

    private static synchronized EventService getEventService(String eventServiceClassPropertyName, EventService defaultService) {
        EventService result;
        String eventServiceClassName = System.getProperty(eventServiceClassPropertyName);
        if (eventServiceClassName != null) {
            Object service;
            Class<?> sesClass;
            try {
                sesClass = Class.forName(eventServiceClassName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not find class specified in the property " + eventServiceClassPropertyName + ".  Class=" + eventServiceClassName, e);
            }
            try {
                service = sesClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException("InstantiationException creating instance of class set from Java property" + eventServiceClassPropertyName + ".  Class=" + eventServiceClassName, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("IllegalAccessException creating instance of class set from Java property" + eventServiceClassPropertyName + ".  Class=" + eventServiceClassName, e);
            }
            try {
                result = (EventService)service;
            }
            catch (ClassCastException ex) {
                throw new RuntimeException("ClassCastException casting to " + EventService.class + " from instance of class set from Java property" + eventServiceClassPropertyName + ".  Class=" + eventServiceClassName, ex);
            }
        }
        result = defaultService;
        return result;
    }

    static {
        EVENT_SERVICES = new HashMap();
    }
}

