/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event;

import java.lang.reflect.Type;
import java.util.List;
import java.util.regex.Pattern;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventServiceLocator;
import org.bushe.swing.event.EventSubscriber;
import org.bushe.swing.event.EventTopicSubscriber;
import org.bushe.swing.event.VetoEventListener;
import org.bushe.swing.event.VetoTopicEventListener;

public class EventBus {
    public static EventService getGlobalEventService() {
        return EventServiceLocator.getEventBusService();
    }

    public static void publish(Object event) {
        if (event == null) {
            throw new IllegalArgumentException("Can't publish null.");
        }
        EventServiceLocator.getEventBusService().publish(event);
    }

    public static void publish(String topic, Object o) {
        if (topic == null) {
            throw new IllegalArgumentException("Can't publish to null topic.");
        }
        EventServiceLocator.getEventBusService().publish(topic, o);
    }

    public static void publish(Type genericType, Object o) {
        if (genericType == null) {
            throw new IllegalArgumentException("Can't publish to null type.");
        }
        EventServiceLocator.getEventBusService().publish(genericType, o);
    }

    public static boolean subscribe(Class eventClass, EventSubscriber subscriber) {
        return EventServiceLocator.getEventBusService().subscribe(eventClass, subscriber);
    }

    public static boolean subscribe(Type genericType, EventSubscriber subscriber) {
        return EventServiceLocator.getEventBusService().subscribe(genericType, subscriber);
    }

    public static boolean subscribeExactly(Class eventClass, EventSubscriber subscriber) {
        return EventServiceLocator.getEventBusService().subscribeExactly(eventClass, subscriber);
    }

    public static boolean subscribe(String topic, EventTopicSubscriber subscriber) {
        return EventServiceLocator.getEventBusService().subscribe(topic, subscriber);
    }

    public static boolean subscribe(Pattern topicPattern, EventTopicSubscriber subscriber) {
        return EventServiceLocator.getEventBusService().subscribe(topicPattern, subscriber);
    }

    public static boolean subscribeStrongly(Class eventClass, EventSubscriber subscriber) {
        return EventServiceLocator.getEventBusService().subscribeStrongly(eventClass, subscriber);
    }

    public static boolean subscribeExactlyStrongly(Class eventClass, EventSubscriber subscriber) {
        return EventServiceLocator.getEventBusService().subscribeExactlyStrongly(eventClass, subscriber);
    }

    public static boolean subscribeStrongly(String topic, EventTopicSubscriber subscriber) {
        return EventServiceLocator.getEventBusService().subscribeStrongly(topic, subscriber);
    }

    public static boolean subscribeStrongly(Pattern topicPattern, EventTopicSubscriber subscriber) {
        return EventServiceLocator.getEventBusService().subscribeStrongly(topicPattern, subscriber);
    }

    public static boolean unsubscribe(Class eventClass, EventSubscriber subscriber) {
        return EventServiceLocator.getEventBusService().unsubscribe(eventClass, subscriber);
    }

    public static boolean unsubscribeExactly(Class eventClass, EventSubscriber subscriber) {
        return EventServiceLocator.getEventBusService().unsubscribeExactly(eventClass, subscriber);
    }

    public static boolean unsubscribe(String topic, EventTopicSubscriber subscriber) {
        return EventServiceLocator.getEventBusService().unsubscribe(topic, subscriber);
    }

    public static boolean unsubscribe(Pattern topicPattern, EventTopicSubscriber subscriber) {
        return EventServiceLocator.getEventBusService().unsubscribe(topicPattern, subscriber);
    }

    public static boolean unsubscribe(Class eventClass, Object object) {
        return EventServiceLocator.getEventBusService().unsubscribe(eventClass, object);
    }

    public static boolean unsubscribeExactly(Class eventClass, Object subscriber) {
        return EventServiceLocator.getEventBusService().unsubscribeExactly(eventClass, subscriber);
    }

    public static boolean unsubscribe(String topic, Object subscriber) {
        return EventServiceLocator.getEventBusService().unsubscribe(topic, subscriber);
    }

    public static boolean unsubscribe(Pattern topicPattern, Object subscriber) {
        return EventServiceLocator.getEventBusService().unsubscribe(topicPattern, subscriber);
    }

    public static boolean subscribeVetoListener(Class eventClass, VetoEventListener vetoListener) {
        return EventServiceLocator.getEventBusService().subscribeVetoListener(eventClass, vetoListener);
    }

    public static boolean subscribeVetoListenerExactly(Class eventClass, VetoEventListener vetoListener) {
        return EventServiceLocator.getEventBusService().subscribeVetoListenerExactly(eventClass, vetoListener);
    }

    public static boolean subscribeVetoListener(String topic, VetoTopicEventListener vetoListener) {
        return EventServiceLocator.getEventBusService().subscribeVetoListener(topic, vetoListener);
    }

    public static boolean subscribeVetoListener(Pattern topicPattern, VetoTopicEventListener vetoListener) {
        return EventServiceLocator.getEventBusService().subscribeVetoListener(topicPattern, vetoListener);
    }

    public static boolean subscribeVetoListenerStrongly(Class eventClass, VetoEventListener vetoListener) {
        return EventServiceLocator.getEventBusService().subscribeVetoListenerStrongly(eventClass, vetoListener);
    }

    public static boolean subscribeVetoListenerExactlyStrongly(Class eventClass, VetoEventListener vetoListener) {
        return EventServiceLocator.getEventBusService().subscribeVetoListenerExactlyStrongly(eventClass, vetoListener);
    }

    public static boolean subscribeVetoListenerStrongly(String topic, VetoTopicEventListener vetoListener) {
        return EventServiceLocator.getEventBusService().subscribeVetoListenerStrongly(topic, vetoListener);
    }

    public static boolean subscribeVetoListenerStrongly(Pattern topicPattern, VetoTopicEventListener vetoListener) {
        return EventServiceLocator.getEventBusService().subscribeVetoListenerStrongly(topicPattern, vetoListener);
    }

    public static boolean unsubscribeVetoListener(Class eventClass, VetoEventListener vetoListener) {
        return EventServiceLocator.getEventBusService().unsubscribeVetoListener(eventClass, vetoListener);
    }

    public static boolean unsubscribeVetoListenerExactly(Class eventClass, VetoEventListener vetoListener) {
        return EventServiceLocator.getEventBusService().unsubscribeVetoListenerExactly(eventClass, vetoListener);
    }

    public static boolean unsubscribeVetoListener(String topic, VetoTopicEventListener vetoListener) {
        return EventServiceLocator.getEventBusService().unsubscribeVetoListener(topic, vetoListener);
    }

    public static boolean unsubscribeVetoListener(Pattern topicPattern, VetoTopicEventListener vetoListener) {
        return EventServiceLocator.getEventBusService().unsubscribeVetoListener(topicPattern, vetoListener);
    }

    public static List getSubscribers(Class eventClass) {
        return EventServiceLocator.getEventBusService().getSubscribers(eventClass);
    }

    public static List getSubscribersToClass(Class eventClass) {
        return EventServiceLocator.getEventBusService().getSubscribersToClass(eventClass);
    }

    public static List getSubscribersToExactClass(Class eventClass) {
        return EventServiceLocator.getEventBusService().getSubscribersToExactClass(eventClass);
    }

    public static List getSubscribers(Type type) {
        return EventServiceLocator.getEventBusService().getSubscribers(type);
    }

    public static List getSubscribers(String topic) {
        return EventServiceLocator.getEventBusService().getSubscribers(topic);
    }

    public static List getSubscribersToTopic(String topic) {
        return EventServiceLocator.getEventBusService().getSubscribersToTopic(topic);
    }

    public static List getSubscribersByPattern(String topic) {
        return EventServiceLocator.getEventBusService().getSubscribersByPattern(topic);
    }

    public static List getVetoSubscribers(Class eventClass) {
        return EventServiceLocator.getEventBusService().getVetoSubscribers(eventClass);
    }

    public static List getVetoSubscribersToExactClass(Class eventClass) {
        return EventServiceLocator.getEventBusService().getVetoSubscribersToExactClass(eventClass);
    }

    public static List getVetoSubscribers(String topic) {
        return EventServiceLocator.getEventBusService().getVetoSubscribers(topic);
    }

    public static List getVetoSubscribersToClass(Class eventClass) {
        return EventServiceLocator.getEventBusService().getVetoSubscribersToClass(eventClass);
    }

    public static List getVetoSubscribers(Pattern pattern) {
        return EventServiceLocator.getEventBusService().getVetoSubscribers(pattern);
    }

    public static void clearAllSubscribers() {
        EventServiceLocator.getEventBusService().clearAllSubscribers();
    }

    public static void setDefaultCacheSizePerClassOrTopic(int defaultCacheSizePerClassOrTopic) {
        EventServiceLocator.getEventBusService().setDefaultCacheSizePerClassOrTopic(defaultCacheSizePerClassOrTopic);
    }

    public static int getDefaultCacheSizePerClassOrTopic() {
        return EventServiceLocator.getEventBusService().getDefaultCacheSizePerClassOrTopic();
    }

    public static void setCacheSizeForEventClass(Class eventClass, int cacheSize) {
        EventServiceLocator.getEventBusService().setCacheSizeForEventClass(eventClass, cacheSize);
    }

    public static int getCacheSizeForEventClass(Class eventClass) {
        return EventServiceLocator.getEventBusService().getCacheSizeForEventClass(eventClass);
    }

    public static void setCacheSizeForTopic(String topicName, int cacheSize) {
        EventServiceLocator.getEventBusService().setCacheSizeForTopic(topicName, cacheSize);
    }

    public static void setCacheSizeForTopic(Pattern pattern, int cacheSize) {
        EventServiceLocator.getEventBusService().setCacheSizeForTopic(pattern, cacheSize);
    }

    public static int getCacheSizeForTopic(String topic) {
        return EventServiceLocator.getEventBusService().getCacheSizeForTopic(topic);
    }

    public static Object getLastEvent(Class eventClass) {
        return EventServiceLocator.getEventBusService().getLastEvent(eventClass);
    }

    public static List getCachedEvents(Class eventClass) {
        return EventServiceLocator.getEventBusService().getCachedEvents(eventClass);
    }

    public static Object getLastTopicData(String topic) {
        return EventServiceLocator.getEventBusService().getLastTopicData(topic);
    }

    public static List getCachedTopicData(String topic) {
        return EventServiceLocator.getEventBusService().getCachedTopicData(topic);
    }

    public static void clearCache(Class eventClass) {
        EventServiceLocator.getEventBusService().clearCache(eventClass);
    }

    public static void clearCache(String topic) {
        EventServiceLocator.getEventBusService().clearCache(topic);
    }

    public static void clearCache(Pattern pattern) {
        EventServiceLocator.getEventBusService().clearCache(pattern);
    }

    public static void clearCache() {
        EventServiceLocator.getEventBusService().clearCache();
    }
}

